/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.criteriaapi.CriteriaUpdate;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.schema30.Product;
import com.sun.ts.tests.jpa.common.schema30.SoftwareProduct;
import com.sun.ts.tests.jpa.common.schema30.Util;
import java.util.ArrayList;
import java.util.Properties;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;

public class Client
extends Util {
    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createProductData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void fromClassGetRootSetStringObjectTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = true;
        boolean pass3 = true;
        boolean pass4 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaUpdate cd = cbuilder.createCriteriaUpdate(Product.class);
        Root root = cd.from(Product.class);
        if (root != null) {
            TestUtil.logTrace((String)"Obtained Non-null root");
            if (root.equals(cd.getRoot())) {
                TestUtil.logTrace((String)"Obtained expected root");
                cd.set("quantity", (Object)0);
                int actual = this.getEntityManager().createQuery(cd).executeUpdate();
                if (actual == this.productRef.length + this.softwareRef.length + this.hardwareRef.length) {
                    Product pp;
                    pass1 = true;
                    TestUtil.logTrace((String)("Received expected number deleted:" + actual));
                    this.clearCache();
                    for (Product product : this.productRef) {
                        pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                        if (pp.getQuantity() == 0) continue;
                        TestUtil.logErr((String)("Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity()));
                        pass2 = false;
                    }
                    for (Product product : this.softwareRef) {
                        pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                        if (pp.getQuantity() == 0) continue;
                        TestUtil.logErr((String)("Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity()));
                        pass3 = false;
                    }
                    for (Product product : this.hardwareRef) {
                        pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                        if (pp.getQuantity() == 0) continue;
                        TestUtil.logErr((String)("Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity()));
                        pass4 = false;
                    }
                } else {
                    TestUtil.logErr((String)("Expected:" + this.productRef.length + this.softwareRef.length + this.hardwareRef.length + ", actual:" + actual));
                }
            } else {
                TestUtil.logErr((String)"Failed to get expected root");
                TestUtil.logErr((String)("Expected:" + cd.getRoot() + ", actual:" + root));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new EETest.Fault("fromClassGetRootSetStringObjectTest failed");
        }
    }

    public void fromEntityTypeSetStringObjectTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = true;
        boolean pass3 = true;
        boolean pass4 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaUpdate cd = cbuilder.createCriteriaUpdate(Product.class);
        Metamodel mm = this.getEntityManager().getMetamodel();
        EntityType Product_ = mm.entity(Product.class);
        Root root = cd.from(Product_);
        if (root != null) {
            TestUtil.logTrace((String)"Obtained Non-null root");
            cd.set("quantity", (Object)0);
            int actual = this.getEntityManager().createQuery(cd).executeUpdate();
            if (actual == this.productRef.length + this.softwareRef.length + this.hardwareRef.length) {
                Product pp;
                pass1 = true;
                TestUtil.logTrace((String)("Received expected number deleted:" + actual));
                this.clearCache();
                for (Product product : this.productRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (pp.getQuantity() == 0) continue;
                    TestUtil.logErr((String)("Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity()));
                    pass2 = false;
                }
                for (Product product : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (pp.getQuantity() == 0) continue;
                    TestUtil.logErr((String)("Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity()));
                    pass3 = false;
                }
                for (Product product : this.hardwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (pp.getQuantity() == 0) continue;
                    TestUtil.logErr((String)("Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity()));
                    pass4 = false;
                }
            } else {
                TestUtil.logErr((String)("Expected:" + this.productRef.length + this.softwareRef.length + this.hardwareRef.length + ", actual:" + actual));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new EETest.Fault("fromEntityTypeSetStringObjectTest failed");
        }
    }

    public void whereExpressionTest() throws EETest.Fault {
        boolean pass2 = false;
        boolean pass3 = true;
        boolean pass4 = true;
        boolean pass5 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaUpdate cd = cbuilder.createCriteriaUpdate(Product.class);
        Root root = cd.from(Product.class);
        if (root != null) {
            TestUtil.logTrace((String)"Obtained Non-null root");
            EntityType product_ = root.getModel();
            cd.set(product_.getSingularAttribute("quantity", Integer.class), (Object)0);
            Path exp = root.get("id");
            ArrayList<String> col = new ArrayList<String>();
            col.add("1");
            col.add("2");
            col.add("3");
            cd.where((Expression)exp.in(col));
            int actual = this.getEntityManager().createQuery(cd).executeUpdate();
            if (actual == col.size()) {
                Product pp;
                TestUtil.logTrace((String)("Received expected number of updates:" + actual));
                pass2 = true;
                this.clearCache();
                for (Product product : this.productRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (product.getId().equals("1") || product.getId().equals("2") || product.getId().equals("3")) {
                        if (pp.getQuantity() != 0) {
                            TestUtil.logErr((String)("Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity()));
                            pass3 = false;
                            continue;
                        }
                        TestUtil.logTrace((String)("Product:" + product.getId() + " update was successfully"));
                        continue;
                    }
                    if (pp.getQuantity() != product.getQuantity()) {
                        TestUtil.logErr((String)("Product:" + product.getId() + " quantity does not equal original value:" + product.getQuantity()));
                        pass3 = false;
                        continue;
                    }
                    TestUtil.logTrace((String)("Product:" + pp.getId() + " quantity matches original value" + product.getQuantity()));
                }
                for (Product product : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (pp.getQuantity() != product.getQuantity()) {
                        TestUtil.logErr((String)("Expected product:" + product.getId() + " to have quantity of " + product.getQuantity() + ", actual:" + pp.getQuantity()));
                        pass4 = false;
                        continue;
                    }
                    TestUtil.logTrace((String)("Received expected software quantity:" + pp.getQuantity()));
                }
                for (Product product : this.hardwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (pp.getQuantity() != product.getQuantity()) {
                        TestUtil.logErr((String)("Expected product:" + product.getId() + " to have quantity of " + product.getQuantity() + ", actual:" + pp.getQuantity()));
                        pass5 = false;
                        continue;
                    }
                    TestUtil.logTrace((String)("Received expected hardware quantity:" + pp.getQuantity()));
                }
            } else {
                TestUtil.logErr((String)("Expected:" + col.size() + ", actual:" + actual));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!(pass2 && pass3 && pass4 && pass5)) {
            throw new EETest.Fault("whereExpressionTest failed");
        }
    }

    public void wherePredicateArrayTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = true;
        boolean pass3 = true;
        boolean pass4 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaUpdate cd = cbuilder.createCriteriaUpdate(Product.class);
        Root root = cd.from(Product.class);
        if (root != null) {
            TestUtil.logTrace((String)"Obtained Non-null root");
            EntityType product_ = root.getModel();
            cd.set(product_.getSingularAttribute("quantity", Integer.class), (Object)0);
            Predicate[] predArray = new Predicate[]{cbuilder.equal((Expression)root.get("id"), (Object)"2")};
            cd.where(predArray);
            int actual = this.getEntityManager().createQuery(cd).executeUpdate();
            if (actual == predArray.length) {
                Product pp;
                TestUtil.logTrace((String)("Received expected number of updates:" + actual));
                pass1 = true;
                this.clearCache();
                for (Product product : this.productRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (product.getId().equals("2")) {
                        if (pp.getQuantity() != 0) {
                            TestUtil.logErr((String)("Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity()));
                            pass2 = false;
                            continue;
                        }
                        TestUtil.logTrace((String)("Product:" + product.getId() + " update was successfully"));
                        continue;
                    }
                    if (pp.getQuantity() != product.getQuantity()) {
                        TestUtil.logErr((String)("Product:" + product.getId() + " quantity does not equal original value:" + product.getQuantity()));
                        pass2 = false;
                        continue;
                    }
                    TestUtil.logTrace((String)("Product:" + pp.getId() + " quantity matches original value" + product.getQuantity()));
                }
                for (Product product : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (pp.getQuantity() != product.getQuantity()) {
                        TestUtil.logErr((String)("Expected product:" + product.getId() + " to have quantity of " + product.getQuantity() + ", actual:" + pp.getQuantity()));
                        pass3 = false;
                        continue;
                    }
                    TestUtil.logTrace((String)("Received expected software quantity:" + pp.getQuantity()));
                }
                for (Product product : this.hardwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (pp.getQuantity() != product.getQuantity()) {
                        TestUtil.logErr((String)("Expected product:" + product.getId() + " to have quantity of " + product.getQuantity() + ", actual:" + pp.getQuantity()));
                        pass4 = false;
                        continue;
                    }
                    TestUtil.logTrace((String)("Received expected hardware quantity:" + pp.getQuantity()));
                }
            } else {
                TestUtil.logErr((String)("Expected updates:" + predArray.length + ", actual:" + actual));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new EETest.Fault("wherePredicateArrayTest failed");
        }
    }

    public void setSingularAttributeObjectTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = true;
        boolean pass3 = true;
        boolean pass4 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaUpdate cd = cbuilder.createCriteriaUpdate(Product.class);
        Root root = cd.from(Product.class);
        if (root != null) {
            TestUtil.logTrace((String)"Obtained Non-null root");
            if (root.getModel().getName().equals(cd.getRoot().getModel().getName())) {
                TestUtil.logTrace((String)"Obtained expected root");
                EntityType product_ = root.getModel();
                cd.set(product_.getSingularAttribute("quantity", Integer.class), (Object)0);
                int actual = this.getEntityManager().createQuery(cd).executeUpdate();
                if (actual == this.productRef.length + this.softwareRef.length + this.hardwareRef.length) {
                    Product pp;
                    pass1 = true;
                    TestUtil.logTrace((String)("Received expected number of updates:" + actual));
                    this.clearCache();
                    for (Product product : this.productRef) {
                        pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                        if (pp.getQuantity() == 0) continue;
                        TestUtil.logErr((String)("Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity()));
                        pass2 = false;
                    }
                    for (Product product : this.softwareRef) {
                        pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                        if (pp.getQuantity() == 0) continue;
                        TestUtil.logErr((String)("Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity()));
                        pass3 = false;
                    }
                    for (Product product : this.hardwareRef) {
                        pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                        if (pp.getQuantity() == 0) continue;
                        TestUtil.logErr((String)("Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity()));
                        pass4 = false;
                    }
                } else {
                    TestUtil.logErr((String)("Expected:" + this.productRef.length + this.softwareRef.length + this.hardwareRef.length + ", actual:" + actual));
                }
            } else {
                TestUtil.logErr((String)"Failed to get expected root");
                TestUtil.logErr((String)("Expected:" + cd.getRoot().getModel().getName() + ", actual:" + root.getModel().getName()));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new EETest.Fault("setSingularAttributeObjectTest failed");
        }
    }

    public void setSingularAttributeExpressionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = true;
        boolean pass3 = true;
        boolean pass4 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaUpdate cd = cbuilder.createCriteriaUpdate(Product.class);
        Root root = cd.from(Product.class);
        if (root != null) {
            TestUtil.logTrace((String)"Obtained Non-null root");
            if (root.getModel().getName().equals(cd.getRoot().getModel().getName())) {
                TestUtil.logTrace((String)"Obtained expected root");
                EntityType product_ = root.getModel();
                Expression exp = cbuilder.prod((Expression)root.get(product_.getSingularAttribute("quantity", Integer.class)), (Number)0);
                cd.set(product_.getSingularAttribute("quantity", Integer.class), exp);
                int actual = this.getEntityManager().createQuery(cd).executeUpdate();
                if (actual == this.productRef.length + this.softwareRef.length + this.hardwareRef.length) {
                    Product pp;
                    pass1 = true;
                    TestUtil.logTrace((String)("Received expected number of updates:" + actual));
                    this.clearCache();
                    for (Product product : this.productRef) {
                        pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                        if (pp.getQuantity() == 0) continue;
                        TestUtil.logErr((String)("Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity()));
                        pass2 = false;
                    }
                    for (Product product : this.softwareRef) {
                        pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                        if (pp.getQuantity() == 0) continue;
                        TestUtil.logErr((String)("Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity()));
                        pass3 = false;
                    }
                    for (Product product : this.hardwareRef) {
                        pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                        if (pp.getQuantity() == 0) continue;
                        TestUtil.logErr((String)("Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity()));
                        pass4 = false;
                    }
                } else {
                    TestUtil.logErr((String)("Expected:" + this.productRef.length + this.softwareRef.length + this.hardwareRef.length + ", actual:" + actual));
                }
            } else {
                TestUtil.logErr((String)"Failed to get expected root");
                TestUtil.logErr((String)("Expected:" + cd.getRoot().getModel().getName() + ", actual:" + root.getModel().getName()));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new EETest.Fault("setSingularAttributeExpressionTest failed");
        }
    }

    public void setPathObjectTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = true;
        boolean pass3 = true;
        boolean pass4 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaUpdate cd = cbuilder.createCriteriaUpdate(Product.class);
        Root root = cd.from(Product.class);
        if (root != null) {
            TestUtil.logTrace((String)"Obtained Non-null root");
            if (root.getModel().getName().equals(cd.getRoot().getModel().getName())) {
                TestUtil.logTrace((String)"Obtained expected root");
                cd.set(root.get("quantity"), (Object)0);
                int actual = this.getEntityManager().createQuery(cd).executeUpdate();
                if (actual == this.productRef.length + this.softwareRef.length + this.hardwareRef.length) {
                    Product pp;
                    pass1 = true;
                    TestUtil.logTrace((String)("Received expected number of updates:" + actual));
                    this.clearCache();
                    for (Product product : this.productRef) {
                        pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                        if (pp.getQuantity() == 0) continue;
                        TestUtil.logErr((String)("Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity()));
                        pass2 = false;
                    }
                    for (Product product : this.softwareRef) {
                        pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                        if (pp.getQuantity() == 0) continue;
                        TestUtil.logErr((String)("Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity()));
                        pass3 = false;
                    }
                    for (Product product : this.hardwareRef) {
                        pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                        if (pp.getQuantity() == 0) continue;
                        TestUtil.logErr((String)("Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity()));
                        pass4 = false;
                    }
                } else {
                    TestUtil.logErr((String)("Expected:" + this.productRef.length + this.softwareRef.length + this.hardwareRef.length + ", actual:" + actual));
                }
            } else {
                TestUtil.logErr((String)"Failed to get expected root");
                TestUtil.logErr((String)("Expected:" + cd.getRoot().getModel().getName() + ", actual:" + root.getModel().getName()));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new EETest.Fault("setPathObjectTest failed");
        }
    }

    public void setPathExpressionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = true;
        boolean pass3 = true;
        boolean pass4 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaUpdate cd = cbuilder.createCriteriaUpdate(Product.class);
        Root root = cd.from(Product.class);
        if (root != null) {
            TestUtil.logTrace((String)"Obtained Non-null root");
            EntityType product_ = root.getModel();
            Expression exp = cbuilder.prod((Expression)root.get(product_.getSingularAttribute("quantity", Integer.class)), (Number)0);
            cd.set(root.get("quantity"), exp);
            int actual = this.getEntityManager().createQuery(cd).executeUpdate();
            if (actual == this.productRef.length + this.softwareRef.length + this.hardwareRef.length) {
                Product pp;
                pass1 = true;
                TestUtil.logTrace((String)("Received expected number of updates:" + actual));
                this.clearCache();
                for (Product product : this.productRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (pp.getQuantity() == 0) continue;
                    TestUtil.logErr((String)("Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity()));
                    pass2 = false;
                }
                for (Product product : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (pp.getQuantity() == 0) continue;
                    TestUtil.logErr((String)("Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity()));
                    pass3 = false;
                }
                for (Product product : this.hardwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (pp.getQuantity() == 0) continue;
                    TestUtil.logErr((String)("Expected product:" + product.getId() + " to have quantity of 0, actual:" + pp.getQuantity()));
                    pass4 = false;
                }
            } else {
                TestUtil.logErr((String)("Expected:" + this.productRef.length + this.softwareRef.length + this.hardwareRef.length + ", actual:" + actual));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new EETest.Fault("setPathExpressionTest failed");
        }
    }

    public void subquery() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaUpdate cu = cbuilder.createCriteriaUpdate(Product.class);
        if (cu != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root product = cu.from(Product.class);
            EntityType product_ = product.getModel();
            Expression exp = cbuilder.prod((Expression)product.get(product_.getSingularAttribute("quantity", Integer.class)), (Number)0);
            cu.set(product.get("quantity"), exp);
            EntityType Product_ = product.getModel();
            Subquery sq = cu.subquery(Product.class);
            Root hardProd = sq.from(Product.class);
            sq.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("id", String.class)), (Object)"1")).select((Expression)hardProd);
            cu.where((Expression)cbuilder.exists(sq));
            int actual = this.getEntityManager().createQuery(cu).executeUpdate();
            if (actual == 1) {
                TestUtil.logTrace((String)("Received expected number of updates:" + actual));
                this.clearCache();
                Product pp = (Product)this.getEntityManager().find(Product.class, (Object)"1");
                if (pp.getQuantity() != 0) {
                    TestUtil.logErr((String)("Expected product:1 to have quantity of 0, actual:" + pp.getQuantity()));
                } else {
                    pass = true;
                }
            } else {
                TestUtil.logErr((String)("Expected:1, actual:" + actual));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("exists test failed");
        }
    }

    public void modifiedQueryTest() throws EETest.Fault {
        int passModifiedCount1 = 0;
        int passUnModifiedCount1 = 0;
        int passModifiedCount2 = 0;
        int passUnModifiedCount2 = 0;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        TestUtil.logMsg((String)"Testing initial query");
        CriteriaUpdate cd = cbuilder.createCriteriaUpdate(SoftwareProduct.class);
        Root softwareproduct = cd.from(SoftwareProduct.class);
        if (softwareproduct != null) {
            Product pp;
            EntityType softwareproduct_ = softwareproduct.getModel();
            cd.set(softwareproduct.get(softwareproduct_.getSingularAttribute("quantity", Integer.class)), (Object)0);
            cd.where((Expression)cbuilder.lt((Expression)softwareproduct.get(softwareproduct_.getSingularAttribute("quantity", Integer.class)), (Number)35));
            Query q = this.getEntityManager().createQuery(cd);
            TestUtil.logMsg((String)"Modify CriteriaUpdate object");
            cd.where((Expression)cbuilder.lt((Expression)softwareproduct.get(softwareproduct_.getSingularAttribute("quantity", Integer.class)), (Number)500));
            int actual = q.executeUpdate();
            if (actual == 4) {
                TestUtil.logTrace((String)("Received expected number of updates:" + actual));
                this.clearCache();
                for (SoftwareProduct p : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(SoftwareProduct.class, (Object)p.getId());
                    if (p.getId().equals("30") || p.getId().equals("31") || p.getId().equals("36") || p.getId().equals("37")) {
                        if (pp.getQuantity() != 0) {
                            TestUtil.logErr((String)("id:" + p.getId() + " to have quantity of 0, actual:" + pp.getQuantity()));
                            continue;
                        }
                        TestUtil.logTrace((String)("id:" + p.getId() + " update was successfully"));
                        ++passModifiedCount1;
                        continue;
                    }
                    if (pp.getQuantity() != p.getQuantity()) {
                        TestUtil.logErr((String)("id:" + p.getId() + " quantity does not equal original value:" + p.getQuantity()));
                        continue;
                    }
                    TestUtil.logTrace((String)("id:" + pp.getId() + " quantity matches original value:" + p.getQuantity()));
                    ++passUnModifiedCount1;
                }
            } else {
                TestUtil.logErr((String)("Expected: 4 updates, actual:" + actual));
                for (SoftwareProduct p : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)p.getId());
                    TestUtil.logErr((String)("id:" + p.getId() + ", quantity:" + pp.getQuantity()));
                }
            }
            TestUtil.logMsg((String)"Testing modified CriteriaQuery");
            cd.where((Expression)cbuilder.gt((Expression)softwareproduct.get(softwareproduct_.getSingularAttribute("quantity", Integer.class)), (Number)100));
            actual = this.getEntityManager().createQuery(cd).executeUpdate();
            if (actual == 3) {
                TestUtil.logTrace((String)("Received expected number of updates:" + actual));
                this.clearCache();
                for (SoftwareProduct p : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(SoftwareProduct.class, (Object)p.getId());
                    if (p.getId().equals("29") || p.getId().equals("34") || p.getId().equals("38") || p.getId().equals("30") || p.getId().equals("31") || p.getId().equals("36") || p.getId().equals("37")) {
                        if (pp.getQuantity() != 0) {
                            TestUtil.logErr((String)("id:" + p.getId() + " to have quantity of 0, actual:" + pp.getQuantity()));
                            continue;
                        }
                        TestUtil.logTrace((String)("id:" + p.getId() + " update was successfully"));
                        ++passModifiedCount2;
                        continue;
                    }
                    if (pp.getQuantity() != p.getQuantity()) {
                        TestUtil.logErr((String)("id:" + p.getId() + " quantity does not equal original value:" + p.getQuantity()));
                        continue;
                    }
                    TestUtil.logTrace((String)("id:" + pp.getId() + " quantity matches original value:" + p.getQuantity()));
                    ++passUnModifiedCount2;
                }
            } else {
                TestUtil.logErr((String)("Expected: 3, actual:" + actual));
                for (SoftwareProduct p : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)p.getId());
                    TestUtil.logErr((String)("id:" + p.getId() + ", quantity:" + pp.getQuantity()));
                }
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (passModifiedCount1 != 4 || passUnModifiedCount1 != 6 || passModifiedCount2 != 7 || passUnModifiedCount2 != 3) {
            throw new EETest.Fault("modifiedQueryTest failed");
        }
    }

    @Override
    public void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PRODUCT_DETAILS").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PRODUCT_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

