/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.common.allowed;

import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import java.util.Collection;
import javax.ejb.EJBContext;
import javax.ejb.SessionContext;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class CancelInterceptor {
    private static CancelInterceptor instance = new CancelInterceptor();

    public static CancelInterceptor getInstance() {
        return instance;
    }

    public void cancelTimers(SessionContext sctx) {
        try {
            if (sctx.getRollbackOnly()) {
                return;
            }
            TimerService ts = sctx.getTimerService();
            Collection ccol = ts.getTimers();
            for (Timer t : ccol) {
                t.cancel();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @AroundInvoke
    public Object intercept(InvocationContext inv) throws Exception {
        String methodName = inv.getMethod().getName();
        TLogger.log("calling interceptor listener CancelInterceptor prior to " + methodName);
        try {
            Object result;
            Object object = result = inv.proceed();
            return object;
        }
        catch (TestFailedException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            EJBContext ejbContext = CancelInterceptor.getEJBContext();
            SessionContext sctx = (SessionContext)ejbContext;
            boolean isPostInvokeTest = false;
            boolean isRemove = false;
            if (methodName.equalsIgnoreCase("getResultsPostInvoke")) {
                isPostInvokeTest = true;
            } else if (methodName.equals("remove")) {
                isRemove = true;
            }
            if (!isPostInvokeTest && !isRemove) {
                this.cancelTimers(sctx);
            }
        }
    }

    protected static EJBContext getEJBContext() {
        EJBContext ec = null;
        try {
            InitialContext ic = new InitialContext();
            Object ob = ic.lookup("java:comp/env/ejbContext");
            ec = (EJBContext)ob;
        }
        catch (NamingException e) {
            throw new IllegalStateException("Make sure SessionContext or MessageDrivenContext with name ejbContext is injected into AroundInvoke bean.", e);
        }
        return ec;
    }
}

