/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.wsi.utils;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.jaxrpc.wsi.constants.DescriptionConstants;
import com.sun.ts.tests.jaxrpc.wsi.constants.SOAPConstants;
import com.sun.ts.tests.jaxrpc.wsi.constants.SchemaConstants;
import com.sun.ts.tests.jaxrpc.wsi.constants.WSIConstants;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DescriptionUtils
implements DescriptionConstants,
SOAPConstants,
SchemaConstants,
WSIConstants {
    public static boolean isDescription(Document document) {
        return DescriptionUtils.isElement(document.getDocumentElement(), "http://schemas.xmlsoap.org/wsdl/", "definitions");
    }

    public static boolean isSchema(Document document) {
        return DescriptionUtils.isElement(document.getDocumentElement(), "http://www.w3.org/2001/XMLSchema", "schema");
    }

    public static Element getTypes(Document document) {
        Element[] children = DescriptionUtils.getChildElements(document.getDocumentElement(), "http://schemas.xmlsoap.org/wsdl/", "types");
        if (children.length != 0) {
            return children[0];
        }
        return null;
    }

    public static Element[] getImports(Document document) {
        return DescriptionUtils.getChildElements(document.getDocumentElement(), "http://schemas.xmlsoap.org/wsdl/", "import");
    }

    public static Element[] getMessages(Document document) {
        return DescriptionUtils.getChildElements(document.getDocumentElement(), "http://schemas.xmlsoap.org/wsdl/", "message");
    }

    public static Element getMessage(Document document, String name) {
        Element[] messages = DescriptionUtils.getMessages(document);
        for (int i = 0; i < messages.length; ++i) {
            if (!name.equals(messages[i].getAttribute("name"))) continue;
            return messages[i];
        }
        return null;
    }

    public static Element[] getPortTypes(Document document) {
        return DescriptionUtils.getChildElements(document.getDocumentElement(), "http://schemas.xmlsoap.org/wsdl/", "portType");
    }

    public static Element getPortType(Document document, String name) {
        Element[] portTypes = DescriptionUtils.getPortTypes(document);
        for (int i = 0; i < portTypes.length; ++i) {
            if (!name.equals(portTypes[i].getAttribute("name"))) continue;
            return portTypes[i];
        }
        return null;
    }

    public static Element[] getBindings(Document document) {
        return DescriptionUtils.getChildElements(document.getDocumentElement(), "http://schemas.xmlsoap.org/wsdl/", "binding");
    }

    public static Element getBinding(Document document, String name) {
        Element[] bindings = DescriptionUtils.getBindings(document);
        for (int i = 0; i < bindings.length; ++i) {
            if (!name.equals(bindings[i].getAttribute("name"))) continue;
            return bindings[i];
        }
        return null;
    }

    public static Element[] getServices(Document document) {
        return DescriptionUtils.getChildElements(document.getDocumentElement(), "http://schemas.xmlsoap.org/wsdl/", "service");
    }

    public static Element[] getChildElements(Element element, String namespaceURI, String localName) {
        ArrayList<Element> children = new ArrayList<Element>();
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            Element child = (Element)node;
            if (namespaceURI != null && !namespaceURI.equals(child.getNamespaceURI()) || localName != null && !localName.equals(child.getLocalName())) continue;
            children.add(child);
        }
        return children.toArray(new Element[children.size()]);
    }

    public static Element[] getChildElements(Element element) {
        return DescriptionUtils.getChildElements(element, null, null);
    }

    public static Element getChildElement(Element element, String namespaceURI, String localName) {
        Element[] children = DescriptionUtils.getChildElements(element, namespaceURI, localName);
        if (children.length != 0) {
            return children[0];
        }
        return null;
    }

    public static Element getNamedChildElement(Element element, String namespaceURI, String localName, String name) {
        Element[] children = DescriptionUtils.getChildElements(element, namespaceURI, localName);
        for (int i = 0; i < children.length; ++i) {
            if (!name.equals(children[i].getAttribute("name"))) continue;
            return children[i];
        }
        return null;
    }

    public static boolean isElement(Element element, String namespaceURI, String localName) {
        if (element == null) {
            return false;
        }
        if (!namespaceURI.equals(element.getNamespaceURI())) {
            return false;
        }
        return localName.equals(element.getLocalName());
    }

    public static Attr[] getElementAttributes(Element element) {
        NamedNodeMap map = element.getAttributes();
        Attr[] attributes = new Attr[map.getLength()];
        for (int i = 0; i < attributes.length; ++i) {
            attributes[i] = (Attr)map.item(i);
        }
        return attributes;
    }

    public static boolean isNamespacePrefixDeclared(Element element, String prefix) {
        while (element != null) {
            Attr attribute = element.getAttributeNode("xmlns:" + prefix);
            if (attribute != null) {
                return true;
            }
            Node node = element.getParentNode();
            if (node.getNodeType() == 1) {
                element = (Element)node;
                continue;
            }
            element = null;
        }
        return false;
    }

    public static String getNamespaceURI(Element element, String prefix) {
        while (element != null) {
            Attr attribute = element.getAttributeNode("xmlns:" + prefix);
            if (attribute != null) {
                return attribute.getValue();
            }
            Node node = element.getParentNode();
            if (node.getNodeType() == 1) {
                element = (Element)node;
                continue;
            }
            element = null;
        }
        return null;
    }

    public static int getIndexOf(Element[] elements, String namespaceURI, String localName) {
        for (int i = 0; i < elements.length; ++i) {
            if (!DescriptionUtils.isElement(elements[i], namespaceURI, localName)) continue;
            return i;
        }
        return -1;
    }

    public static int getLastIndexOf(Element[] elements, String namespaceURI, String localName) {
        for (int i = elements.length - 1; i >= 0; --i) {
            if (!DescriptionUtils.isElement(elements[i], namespaceURI, localName)) continue;
            return i;
        }
        return -1;
    }

    public static Document getDocumentFromLocation(String location) throws EETest.Fault {
        try {
            URL url = new URL(location);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(url.openStream());
        }
        catch (MalformedURLException e) {
            throw new EETest.Fault("The location '" + location + "' is invalid", e);
        }
        catch (FactoryConfigurationError e) {
            throw new EETest.Fault("Unable to obtain XML parser", e);
        }
        catch (ParserConfigurationException e) {
            throw new EETest.Fault("Unable to obtain XML parser", e);
        }
        catch (SAXException e) {
            throw new EETest.Fault("The document at '" + location + "' is not valid XML", e);
        }
        catch (IOException e) {
            throw new EETest.Fault("The document at '" + location + "' could not be read", e);
        }
    }

    private DescriptionUtils() {
    }
}

