/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.ee.javax_xml_registry.BulkResponse;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Properties;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.infomodel.Organization;

public class JAXRClient
extends JAXRCommonClient {
    Locale tsLocale = new Locale("en", "US");

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            this.debug.clear();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            this.logMsg("in cleanup");
            if (this.conn != null) {
                this.logTrace("Cleanup is closing the connection");
                this.conn.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void bulkResponse_isPartialResponse() throws EETest.Fault {
        String testName = "bulkResponse_isPartialResponse";
        Collection orgKeys = null;
        try {
            Organization org = (Organization)this.blm.createObject("Organization");
            org.setName(this.blm.createInternationalString("TS Default Organization"));
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            orgs.add(org);
            BulkResponse br = this.blm.saveOrganizations(orgs);
            orgKeys = br.getCollection();
            this.debug.add("Don't expect a partial response since result set is small \n");
            this.debug.add("BulkResponse.isPartial returns " + br.isPartialResponse() + "\n");
            if (br.isPartialResponse()) {
                throw new EETest.Fault(testName + " failed - did not expect a partial response");
            }
            super.cleanUpRegistry(orgKeys, "Organization");
        }
        catch (Exception e) {
            try {
                TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + " failed - unexpected exception ");
            }
            catch (Throwable throwable) {
                super.cleanUpRegistry(orgKeys, "Organization");
                throw throwable;
            }
        }
    }

    public void bulkResponse_getCollection() throws EETest.Fault {
        String testName = "bulkResponse_getCollection";
        Object savekey = null;
        BusinessQueryManager bqm = null;
        Collection orgKeys = null;
        boolean pass = false;
        try {
            bqm = this.rs.getBusinessQueryManager();
            Organization org = (Organization)this.blm.createObject("Organization");
            org.setName(this.blm.createInternationalString(this.tsLocale, "TS Default Organization"));
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            orgs.add(org);
            BulkResponse br = this.blm.saveOrganizations(orgs);
            orgKeys = br.getCollection();
            br = bqm.getRegistryObjects(orgKeys, "Organization");
            Collection myOrgs = br.getCollection();
            for (Organization o : myOrgs) {
                if (!o.getName().getValue(this.tsLocale).equals("TS Default Organization")) continue;
                this.debug.add("Success:  used key to retrieve my organization \n");
                pass = true;
            }
            super.cleanUpRegistry(orgKeys, "Organization");
        }
        catch (Exception e) {
            try {
                TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + " failed - unexpected exception ");
            }
            catch (Throwable throwable) {
                super.cleanUpRegistry(orgKeys, "Organization");
                throw throwable;
            }
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed  ");
        }
    }

    public void bulkResponse_getExceptions() throws EETest.Fault {
        String testName = "bulkResponse_getExceptions";
        Collection orgKeys = null;
        try {
            Organization org = (Organization)this.blm.createObject("Organization");
            org.setName(this.blm.createInternationalString("TS Default Organization"));
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            orgs.add(org);
            BulkResponse br = this.blm.saveOrganizations(orgs);
            orgKeys = br.getCollection();
            Collection exceptions = br.getExceptions();
            this.debug.add("Returns null if result is available or exceptions in case of partial commit \n");
            if (exceptions == null) {
                this.debug.add("No exceptions  - null collection returned from br.getExceptions -  OK \n");
            } else if (exceptions.size() > 0) {
                this.debug.add("Exceptions returned count = " + exceptions.size() + "\n");
            } else {
                throw new EETest.Fault(testName + " failed ");
            }
            super.cleanUpRegistry(orgKeys, "Organization");
        }
        catch (Exception e) {
            try {
                TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + " failed - unexpected exception ");
            }
            catch (Throwable throwable) {
                super.cleanUpRegistry(orgKeys, "Organization");
                throw throwable;
            }
        }
    }
}

