/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.metamodelapi.entitytype;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.metamodelapi.entitytype.A;
import com.sun.ts.tests.jpa.core.metamodelapi.entitytype.DID2Employee;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void getName() throws EETest.Fault {
        boolean pass = false;
        String expected = "A";
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                String name = eType.getName();
                if (name.equals(expected)) {
                    TestUtil.logTrace((String)("Received:" + name));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected: " + expected + ", actual:" + name));
                }
            } else {
                TestUtil.logErr((String)"getEntity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getName failed");
        }
    }

    public void getDeclaredId() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null EntityType");
                TestUtil.logTrace((String)"entityType Name = A");
                SingularAttribute idAttrib = eType.getDeclaredId(String.class);
                String name = idAttrib.getType().getJavaType().getName();
                if (name.equals("java.lang.String")) {
                    TestUtil.logTrace((String)("Received:" + name));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected java.lang.String, actual:" + name));
                }
            } else {
                TestUtil.logErr((String)"getEntity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredId failed");
        }
    }

    public void getDeclaredIdIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained A IdentifiableType");
                try {
                    eType.getDeclaredId(Date.class);
                    TestUtil.logTrace((String)"Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
                }
            } else {
                TestUtil.logErr((String)"getEntity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredIdIllegalArgumentException failed");
        }
    }

    public void getDeclaredVersion() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                SingularAttribute idAttrib = eType.getDeclaredVersion(Integer.class);
                String name = idAttrib.getName();
                if (name.equals("value")) {
                    TestUtil.logTrace((String)("Received:" + name));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected: value, actual:" + name));
                }
            } else {
                TestUtil.logErr((String)"getEntity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredVersion failed");
        }
    }

    public void getDeclaredVersionIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                try {
                    eType.getDeclaredVersion(Date.class);
                    TestUtil.logTrace((String)"Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
                }
            } else {
                TestUtil.logErr((String)"getEntity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredVersionIllegalArgumentException failed");
        }
    }

    public void getId() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null EntityType");
                SingularAttribute idAttrib = eType.getId(String.class);
                String name = idAttrib.getType().getJavaType().getName();
                if (name.equals("java.lang.String")) {
                    TestUtil.logTrace((String)("Received expected: " + name));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected java.lang.String, actual:" + name));
                }
            } else {
                TestUtil.logErr((String)"getEntity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getId failed");
        }
    }

    public void getIdIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained A Entity");
                try {
                    eType.getId(Date.class);
                    TestUtil.logTrace((String)"Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
                }
            } else {
                TestUtil.logErr((String)"getEntity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getIdIllegalArgumentException failed");
        }
    }

    public void getIdClassAttributes() throws EETest.Fault {
        boolean pass = false;
        HashSet<String> expected = new HashSet<String>();
        expected.add("firstName");
        expected.add("lastName");
        HashSet<String> actual = new HashSet<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(DID2Employee.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null EntityType");
                Set idClassAttribSet = eType.getIdClassAttributes();
                if (idClassAttribSet != null) {
                    if (idClassAttribSet.size() > 0) {
                        for (SingularAttribute attrib : idClassAttribSet) {
                            actual.add(attrib.getName());
                        }
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            TestUtil.logTrace((String)"Received expected attributes");
                            for (String id : expected) {
                                TestUtil.logTrace((String)("id:" + id));
                            }
                            pass = true;
                        } else {
                            TestUtil.logErr((String)"Received Unexpected ids");
                            TestUtil.logErr((String)"Expected:");
                            for (String id : expected) {
                                TestUtil.logErr((String)("id:" + id));
                            }
                            TestUtil.logErr((String)"Actual:");
                            for (String attribName : actual) {
                                TestUtil.logErr((String)("attrib:" + attribName));
                            }
                        }
                    } else {
                        TestUtil.logErr((String)"getIdClassAttributes() returned 0 items");
                    }
                } else {
                    TestUtil.logErr((String)"getIdClassAttributes() returned null");
                }
            } else {
                TestUtil.logErr((String)"getEntity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getIdClassAttributes failed");
        }
    }

    public void getIdClassAttributesIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained A Entity");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                try {
                    eType.getIdClassAttributes();
                    TestUtil.logTrace((String)"Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
                }
            } else {
                TestUtil.logErr((String)"getEntity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getIdClassAttributesIllegalArgumentException failed");
        }
    }

    public void getIdType() throws EETest.Fault {
        boolean pass = false;
        String expected = "java.lang.String";
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                Type type = eType.getIdType();
                String sType = type.getJavaType().getName();
                if (sType.equals(expected)) {
                    TestUtil.logTrace((String)("Received:" + sType));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected: " + expected + ", actual:" + sType));
                }
            } else {
                TestUtil.logErr((String)"getEntity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getIdType failed");
        }
    }

    public void getSupertype() throws EETest.Fault {
        boolean pass = false;
        String expected = "com.sun.ts.tests.jpa.core.metamodelapi.entitytype.B";
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                IdentifiableType idType = eType.getSupertype();
                String name = idType.getJavaType().getName();
                if (name.equals(expected)) {
                    TestUtil.logTrace((String)("getSuperType() returned:" + name));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected: " + expected + ", actual:" + name));
                }
            } else {
                TestUtil.logErr((String)"getEntity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getSupertype failed");
        }
    }

    public void getVersion() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null EntityType");
                SingularAttribute idAttrib = eType.getVersion(Integer.class);
                String name = idAttrib.getType().getJavaType().getName();
                if (name.equals("java.lang.Integer")) {
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected java.lang.Integer, actual:" + name));
                }
            } else {
                TestUtil.logErr((String)"getEntity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getVersion failed");
        }
    }

    public void getVersionIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained A Entity");
                try {
                    eType.getVersion(Date.class);
                    TestUtil.logTrace((String)"Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
                }
            } else {
                TestUtil.logErr((String)"getEntity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getVersionIllegalArgumentException failed");
        }
    }

    public void hasSingleIdAttribute() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                TestUtil.logTrace((String)("entityType Name = " + eType.getName()));
                boolean hasSingleIdAttribute = eType.hasSingleIdAttribute();
                if (hasSingleIdAttribute) {
                    pass = true;
                    TestUtil.logTrace((String)("hasSingleIdAttribute() returned" + hasSingleIdAttribute));
                } else {
                    TestUtil.logErr((String)("Expected: false, actual:" + hasSingleIdAttribute));
                }
            } else {
                TestUtil.logErr((String)"getEntity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("hasSingleIdAttribute failed");
        }
    }

    public void hasVersionAttribute() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                TestUtil.logTrace((String)("entityType Name = " + eType.getName()));
                boolean hasVersionAttribute = eType.hasVersionAttribute();
                if (hasVersionAttribute) {
                    pass = true;
                    TestUtil.logTrace((String)("hasSingleIdAttribute() returned" + hasVersionAttribute));
                } else {
                    TestUtil.logErr((String)("Expected: false, actual:" + hasVersionAttribute));
                }
            } else {
                TestUtil.logErr((String)"getEntity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("hasVersionAttribute failed");
        }
    }

    public void getBindableJavaType() throws EETest.Fault {
        boolean pass = false;
        String expected = "com.sun.ts.tests.jpa.core.metamodelapi.entitytype.A";
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                String bindableJavaType = eType.getBindableJavaType().getName();
                if (bindableJavaType != null) {
                    if (bindableJavaType.equals(expected)) {
                        TestUtil.logTrace((String)("Received expected result: " + bindableJavaType));
                        pass = true;
                    } else {
                        TestUtil.logTrace((String)("Expected:" + expected + ", actual:" + bindableJavaType));
                    }
                } else {
                    TestUtil.logErr((String)"getName() returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getBindableJavaType failed");
        }
    }

    public void getBindableType() throws EETest.Fault {
        boolean pass = false;
        String expected = Bindable.BindableType.ENTITY_TYPE.name();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                String bindableType = eType.getBindableType().name();
                if (bindableType != null) {
                    if (bindableType.equals(expected)) {
                        TestUtil.logTrace((String)("Received expected result: " + bindableType));
                        pass = true;
                    } else {
                        TestUtil.logTrace((String)("Expected:" + expected + ", actual:" + bindableType));
                    }
                } else {
                    TestUtil.logErr((String)"getBindableType() returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getBindableType failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

