/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.defaultmapping.generics;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonb.defaultmapping.generics.model.CollectionContainer;
import com.sun.ts.tests.jsonb.defaultmapping.generics.model.GenericContainer;
import com.sun.ts.tests.jsonb.defaultmapping.generics.model.MultipleBoundsContainer;
import com.sun.ts.tests.jsonb.defaultmapping.generics.model.NumberContainer;
import com.sun.ts.tests.jsonb.defaultmapping.generics.model.StringContainer;
import com.sun.ts.tests.jsonb.defaultmapping.generics.model.WildcardContainer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;

public class GenericsMappingTest
extends ServiceEETest {
    private static final long serialVersionUID = 10L;
    private final Jsonb jsonb = JsonbBuilder.create();

    public static void main(String[] args) {
        GenericsMappingTest t = new GenericsMappingTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public Status testClassInformationOnRuntime() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new GenericContainer<String>(){
            {
                this.setInstance("Test String");
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*\\:\\s*\"Test String\"\\s*\\}")) {
            throw new EETest.Fault("Failed to marshal generic object with String attribute value.");
        }
        GenericContainer unmarshalledObject = (GenericContainer)this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", new GenericContainer<String>(){}.getClass().getGenericSuperclass());
        if (!"Test String".equals(unmarshalledObject.getInstance())) {
            throw new EETest.Fault("Failed to unmarshal generic object with String attribute value.");
        }
        return Status.passed((String)"OK");
    }

    public Status testClassFileAvailable() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new GenericContainer<String>(){
            {
                this.setInstance("Test String");
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*\\:\\s*\"Test String\"\\s*\\}")) {
            throw new EETest.Fault("Failed to marshal generic object with String attribute value.");
        }
        GenericContainer unmarshalledObject = (GenericContainer)this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", StringContainer.class);
        if (!"Test String".equals(unmarshalledObject.getInstance())) {
            throw new EETest.Fault("Failed to unmarshal generic object with String attribute value.");
        }
        return Status.passed((String)"OK");
    }

    public Status testRawTypeInformation() throws EETest.Fault {
        final List<String> list = Arrays.asList("Test 1", "Test 2");
        String jsonString = this.jsonb.toJson((Object)new CollectionContainer(){
            {
                this.setInstance(list);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*\\:\\s*\\[\\s*\"Test 1\"\\s*,\\s*\"Test 2\"\\s*\\]\\s*\\}")) {
            throw new EETest.Fault("Failed to marshal object with raw List attribute.");
        }
        CollectionContainer unmarshalledObject = (CollectionContainer)this.jsonb.fromJson("{ \"instance\" : [ \"Test 1\", \"Test 2\" ] }", CollectionContainer.class);
        if (!list.equals(unmarshalledObject.getInstance())) {
            throw new EETest.Fault("Failed to unmarshal object with raw List type attribute.");
        }
        return Status.passed((String)"OK");
    }

    public Status testNoTypeInformation() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new GenericContainer<String>(){
            {
                this.setInstance("Test String");
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*\\:\\s*\"Test String\"\\s*\\}")) {
            throw new EETest.Fault("Failed to marshal generic object with String attribute value.");
        }
        GenericContainer unmarshalledObject = (GenericContainer)this.jsonb.fromJson("{ \"instance\" : {\"value\":\"Test String\" } }", GenericContainer.class);
        if (!Map.class.isAssignableFrom(unmarshalledObject.getInstance().getClass()) && !"Test String".equals(((Map)unmarshalledObject.getInstance()).get("instance"))) {
            throw new EETest.Fault("Failed to unmarshal generic object without type information with String attribute value.");
        }
        return Status.passed((String)"OK");
    }

    public Status testBoundedTypeInformation() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new NumberContainer<Integer>(){
            {
                this.setInstance(Integer.MAX_VALUE);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*\\:\\s*2147483647\\s*\\}")) {
            throw new EETest.Fault("Failed to marshal object with bounded Number attribute.");
        }
        NumberContainer unmarshalledObject = (NumberContainer)this.jsonb.fromJson("{ \"instance\" : 2147483647 }", new NumberContainer<Integer>(){}.getClass().getGenericSuperclass());
        if ((Integer)unmarshalledObject.getInstance() != Integer.MAX_VALUE) {
            throw new EETest.Fault("Failed to unmarshal object with bounded Number attribute.");
        }
        return Status.passed((String)"OK");
    }

    public Status testMultipleBoundsTypeInformation() throws EETest.Fault {
        LinkedList<String> list = new LinkedList<String>(Arrays.asList("Test 1", "Test 2"));
        MultipleBoundsContainer container = new MultipleBoundsContainer();
        container.setInstance(new ArrayList());
        container.getInstance().add(list);
        Type type = new MultipleBoundsContainer<LinkedList<String>>(){}.getClass().getGenericSuperclass();
        String jsonString = this.jsonb.toJson(container, type);
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*\\:\\s*\\[\\[\\s*\"Test 1\"\\s*,\\s*\"Test 2\"\\s*\\]\\]\\s*\\}")) {
            throw new EETest.Fault("Failed to marshal object with multiple bounded attribute.");
        }
        MultipleBoundsContainer unmarshalledObject = (MultipleBoundsContainer)this.jsonb.fromJson("{ \"instance\" : [[ \"Test 1\", \"Test 2\" ]] }", type);
        if (!container.getInstance().equals(unmarshalledObject.getInstance())) {
            throw new EETest.Fault("Failed to unmarshal object with multiple bounded attribute.");
        }
        return Status.passed((String)"OK");
    }

    public Status testWildcardTypeInformation() throws EETest.Fault {
        final List<String> list = Arrays.asList("Test 1", "Test 2");
        String jsonString = this.jsonb.toJson((Object)new WildcardContainer(){
            {
                this.setInstance(list);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*\\:\\s*\\[\\s*\"Test 1\"\\s*,\\s*\"Test 2\"\\s*\\]\\s*\\}")) {
            throw new EETest.Fault("Failed to marshal object with unbound collection attribute.");
        }
        WildcardContainer unmarshalledObject = (WildcardContainer)this.jsonb.fromJson("{ \"instance\" : [ \"Test 1\", \"Test 2\" ] }", WildcardContainer.class);
        if (!list.equals(unmarshalledObject.getInstance())) {
            throw new EETest.Fault("Failed to unmarshal object with unbound collection attribute.");
        }
        return Status.passed((String)"OK");
    }
}

