/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxws.sharedclients;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxws.sharedclients.Client;
import com.sun.ts.tests.jaxws.sharedclients.DescriptionClient;
import com.sun.ts.tests.jaxws.sharedclients.HttpClient;
import com.sun.ts.tests.jaxws.sharedclients.SaajClient;
import com.sun.ts.tests.jaxws.sharedclients.StubContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;

public abstract class SOAPClient
extends Client {
    private static final String DEFAULT_CHARSET = "UTF-8";
    public static final int MODE_STANDALONE = 0;
    public static final int MODE_JavaEE = 1;
    private HttpClient httpClient;
    private SaajClient saajClient;
    private DescriptionClient descriptionClient;
    private String endpointURL = this.getEndpointURLString();
    private String wsdlURL = this.getWSDLURLString();
    protected StubContext stubContext;

    public SOAPClient(String webServerHost, int webServerPort, int mode) throws EETest.Fault {
        super(webServerHost, webServerPort, mode);
        this.httpClient = new HttpClient();
        this.httpClient.setUrl(this.endpointURL);
        this.saajClient = new SaajClient();
        this.saajClient.setUrl(this.endpointURL);
        this.descriptionClient = new DescriptionClient();
        this.descriptionClient.setURL(this.wsdlURL);
        this.initStubContext(mode);
    }

    public String getEndpointURL() {
        return this.endpointURL;
    }

    public String getWSDLURL() {
        return this.wsdlURL;
    }

    private void initStubContext(int mode) {
        this.stubContext = new StubContext();
        this.stubContext.setMode(mode);
        this.stubContext.setEndpointURL(this.endpointURL);
        this.stubContext.setWsdllocURL(this.wsdlURL);
    }

    private ByteArrayOutputStream getInputStreamAsOutputStream(InputStream is) throws IOException {
        int length;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        do {
            if ((length = is.read(buffer)) <= 0) continue;
            baos.write(buffer, 0, length);
        } while (length > 0);
        return baos;
    }

    public SOAPMessage makeSaajRequest(String request) throws SOAPException, IOException {
        return this.makeSaajRequest(request, null);
    }

    public SOAPMessage makeSaajRequest(SOAPMessage request) throws SOAPException, IOException {
        return this.makeSaajRequest(request, null);
    }

    public SOAPMessage makeSaajRequest(String request, Charset cs) throws SOAPException, IOException {
        this.saajClient.setCharset(cs);
        this.LoggingSOAPRequest(request);
        SOAPMessage response = this.saajClient.makeRequest(this.getInputStreamForString(request, cs));
        this.LoggingSOAPResponse(this.getResponseAsString(response));
        return response;
    }

    public SOAPMessage makeSaajRequest(SOAPMessage request, Charset cs) throws SOAPException, IOException {
        this.saajClient.setCharset(cs);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        request.writeTo((OutputStream)baos);
        String requestAsString = baos.toString();
        this.LoggingSOAPRequest(requestAsString);
        SOAPMessage response = this.saajClient.makeRequest(this.getInputStreamForString(requestAsString, cs));
        this.LoggingSOAPResponse(this.getResponseAsString(response));
        return response;
    }

    public InputStream makeHTTPRequest(String request) throws IOException {
        return this.makeHTTPRequest(request, null);
    }

    public InputStream makeHTTPRequest(String request, Charset cs) throws IOException {
        this.LoggingSOAPRequest(request);
        this.httpClient.setCharset(cs);
        InputStream response = this.httpClient.makeRequest(this.getInputStreamForString(request, cs));
        ByteArrayOutputStream baos = this.getInputStreamAsOutputStream(response);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        this.LoggingSOAPResponse(baos.toString());
        this.LoggingHTTPStatusCode();
        return bais;
    }

    public void logMessageInHarness(SOAPMessage message) {
        this.saajClient.logMessageInHarness(message);
    }

    public void logMessageInHarness(InputStream message) {
        this.httpClient.logMessageInHarness(message);
    }

    public int getStatusCode() throws IOException {
        return this.httpClient.getStatusCode();
    }

    public Document getDocument() throws EETest.Fault {
        return this.descriptionClient.getDocument();
    }

    public String getDescriptionURL() {
        return this.descriptionClient.getURL();
    }

    public void addHeader(String name, String value) {
        this.httpClient.addHeader(name, value);
    }

    public void setHeader(String name, String value) {
        this.httpClient.setHeader(name, value);
    }

    public void setHeaderCaseASIs(String name, String value) {
        this.httpClient.setHeaderCaseAsIs(name, value);
    }

    public String getResponseHeader(String name) {
        return this.httpClient.getResponseHeader(name);
    }

    private ByteArrayInputStream getInputStreamForString(String request, Charset cs) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStreamWriter osw = cs != null ? new OutputStreamWriter((OutputStream)bos, cs) : new OutputStreamWriter((OutputStream)bos, Charset.forName(DEFAULT_CHARSET));
        osw.write(request);
        osw.flush();
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        return bis;
    }

    private String getResponseAsString(SOAPMessage response) throws SOAPException, IOException {
        if (response == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        response.writeTo((OutputStream)baos);
        return baos.toString();
    }

    private void LoggingSOAPRequest(String request) {
        if (request == null) {
            return;
        }
        TestUtil.logMsg((String)"-------------------");
        TestUtil.logMsg((String)"Logging SOAPRequest");
        TestUtil.logMsg((String)"-------------------");
        TestUtil.logMsg((String)request);
    }

    private void LoggingSOAPResponse(String response) {
        if (response == null) {
            return;
        }
        TestUtil.logMsg((String)"--------------------");
        TestUtil.logMsg((String)"Logging SOAPResponse");
        TestUtil.logMsg((String)"--------------------");
        TestUtil.logMsg((String)response);
    }

    private void LoggingHTTPStatusCode() throws IOException {
        TestUtil.logMsg((String)("HTTPStatusCode=" + this.getStatusCode()));
    }
}

