/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.ee.pluggability.contracts.resource_local;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.common.pluggability.altprovider.implementation.EntityManagerFactoryImpl;
import com.sun.ts.tests.jpa.common.pluggability.altprovider.implementation.EntityManagerImpl;
import com.sun.ts.tests.jpa.common.pluggability.util.LogFileProcessor;
import com.sun.ts.tests.jpa.ee.pluggability.contracts.resource_local.Order;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.Persistence;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;

public class Client
extends PMClientBase {
    private transient EntityManagerImpl emImpl;
    private transient EntityManagerFactoryImpl emfImpl;
    private PersistenceUnitInfo puInfo;
    private long currentSeqNum = 0L;
    private static LogFileProcessor logProcessor = null;
    private String LOGMESSAGE_PREFIX = "JPA_ALTERNATE_PROVIDER : ";

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties props) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        super.setup(args, props);
        logProcessor = new LogFileProcessor(props);
        if (!logProcessor.fetchLog()) {
            throw new EETest.Fault("Could not fetch log file");
        }
        this.currentSeqNum = logProcessor.getCurrentSequenceNumber();
        this.getEntityManager();
    }

    public void createEMF() throws EETest.Fault {
        String[] expected = new String[]{this.LOGMESSAGE_PREFIX + "Called createContainerEntityManagerFactory(PersistenceUnitInfo, Map)"};
        logProcessor.fetchLog();
        boolean pass = logProcessor.verifyLogContains(expected);
        if (!pass) {
            throw new EETest.Fault("createEMF failed");
        }
    }

    public void getPersistenceProviderClassName() throws EETest.Fault {
        boolean pass1 = false;
        String expected1 = "com.sun.ts.tests.jpa.common.pluggability.altprovider.implementation.PersistenceProvider";
        this.getClassObjects();
        String actual = this.puInfo.getPersistenceProviderClassName();
        if (actual.equals(expected1)) {
            TestUtil.logTrace((String)("Received expected result:" + actual));
            pass1 = true;
        } else {
            TestUtil.logErr((String)("Expected: " + expected1 + ", actual:" + actual));
        }
        String[] expected2 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getPersistenceProviderClassName()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected2, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new EETest.Fault("getPersistenceProviderClassName failed");
        }
    }

    public void getPersistenceUnitNameTest() throws EETest.Fault {
        boolean pass1 = false;
        ArrayList<String> expected1 = new ArrayList<String>();
        expected1.add("CTS-EM-NOTX");
        this.getClassObjects();
        String actual = this.puInfo.getPersistenceUnitName();
        if (expected1.contains(actual)) {
            TestUtil.logTrace((String)("Received expected result:" + actual));
            pass1 = true;
        } else {
            TestUtil.logErr((String)"Did not get one of the expected results");
            TestUtil.logErr((String)"Expected:");
            for (String s : expected1) {
                TestUtil.logErr((String)s);
            }
            TestUtil.logErr((String)("actual:" + actual));
        }
        String[] expected2 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getPersistenceUnitName()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected2, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new EETest.Fault("getPersistenceUnitNameTest failed");
        }
    }

    public void getTransactionType() throws EETest.Fault {
        boolean pass1 = false;
        this.getClassObjects();
        PersistenceUnitTransactionType expected1 = PersistenceUnitTransactionType.RESOURCE_LOCAL;
        PersistenceUnitTransactionType actual = this.puInfo.getTransactionType();
        if (actual.equals((Object)expected1)) {
            pass1 = true;
            TestUtil.logTrace((String)("Received expected result:" + actual.toString()));
        } else {
            TestUtil.logErr((String)("Expected: " + expected1.name() + ", actual:" + actual.name()));
        }
        String[] expected2 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getTransactionType()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected2, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new EETest.Fault("getTransactionType failed");
        }
    }

    public void getManagedClassNames() throws EETest.Fault {
        boolean pass1 = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("com.sun.ts.tests.jpa.ee.pluggability.contracts.resource_local.Order");
        this.getClassObjects();
        List actual = this.puInfo.getManagedClassNames();
        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
            pass1 = true;
            TestUtil.logTrace((String)("Received expected result:" + (String)actual.get(0)));
        } else {
            TestUtil.logErr((String)"Did not get expected ManagedClassNames");
            TestUtil.logErr((String)"Expected:");
            for (String s : expected) {
                TestUtil.logErr((String)s);
            }
            TestUtil.logErr((String)"Actual:");
            for (String s : actual) {
                TestUtil.logErr((String)s);
            }
        }
        String[] expected1 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getManagedClassNames()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected1, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new EETest.Fault("getManagedClassNames failed");
        }
    }

    public void getJarFileUrls() throws EETest.Fault {
        boolean pass1 = false;
        String expected1 = "pluggability_contracts_resource_local.jar";
        this.getClassObjects();
        List actual = this.puInfo.getJarFileUrls();
        if (actual.size() > 0) {
            for (URL u : actual) {
                String sURL = u.toString();
                if (sURL.contains(expected1)) {
                    TestUtil.logTrace((String)("actual:" + sURL));
                    pass1 = true;
                    continue;
                }
                TestUtil.logErr((String)("getJarFileUrls() did not return a URL that contains:" + expected1));
                TestUtil.logTrace((String)("actual:" + sURL));
            }
        } else {
            TestUtil.logErr((String)"getJarFileUrls() returned no results");
        }
        String[] expected2 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getJarFileUrls()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected2, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new EETest.Fault("getJarFileUrls failed");
        }
    }

    public void getPersistenceUnitRootUrl() throws EETest.Fault {
        boolean pass1 = false;
        String expected1 = "pluggability_contracts_resource_local.jar";
        this.getClassObjects();
        URL actual = this.puInfo.getPersistenceUnitRootUrl();
        if (actual.toString().contains(expected1)) {
            TestUtil.logTrace((String)("Received expected result:" + actual.toString()));
            pass1 = true;
        } else {
            TestUtil.logErr((String)("Expected the actual to contain:" + expected1));
            TestUtil.logErr((String)("actual: " + actual.toString()));
        }
        String[] expected2 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getPersistenceUnitRootUrl()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected2, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new EETest.Fault("getPersistenceUnitRootUrl failed");
        }
    }

    public void getPersistenceXMLSchemaVersion() throws EETest.Fault {
        boolean pass1 = false;
        String expected1 = "2.1";
        this.getClassObjects();
        String actual = this.puInfo.getPersistenceXMLSchemaVersion();
        if (actual.toString().equals(expected1)) {
            TestUtil.logTrace((String)("Received expected result:" + actual.toString()));
            pass1 = true;
        } else {
            TestUtil.logErr((String)("expected: " + expected1));
            TestUtil.logErr((String)("actual: " + actual.toString()));
        }
        String[] expected2 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getPersistenceXMLSchemaVersion()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected2, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new EETest.Fault("getPersistenceXMLSchemaVersion failed");
        }
    }

    public void getProperties() throws EETest.Fault {
        boolean pass1 = true;
        Properties expected1 = new Properties();
        expected1.put("eclipselink.logging.level", "INFO");
        expected1.put("eclipselink.logging.logger", "DefaultLogger");
        this.getClassObjects();
        Properties actual = this.puInfo.getProperties();
        if (!actual.isEmpty()) {
            for (Map.Entry<Object, Object> e : expected1.entrySet()) {
                String eKey = (String)e.getKey();
                String eVal = (String)e.getValue();
                TestUtil.logTrace((String)("key:" + eKey + ", value:" + eVal));
                if (!actual.containsKey(eKey)) continue;
                String aVal = (String)actual.get(eKey);
                if (aVal.equals(eVal)) {
                    TestUtil.logTrace((String)("Found expected result:" + eKey + "," + eVal));
                    continue;
                }
                pass1 = false;
                TestUtil.logErr((String)("Actual did not contain expected property:" + eKey + "," + eVal));
            }
        } else {
            TestUtil.logErr((String)"getProperties() returned no properties");
        }
        if (!pass1) {
            String value;
            String key;
            TestUtil.logErr((String)"Expected:");
            for (Map.Entry<Object, Object> e : expected1.entrySet()) {
                key = (String)e.getKey();
                value = (String)e.getValue();
                TestUtil.logErr((String)("key:" + key + ", value:" + value));
            }
            TestUtil.logErr((String)"Actual:");
            for (Map.Entry<Object, Object> e : actual.entrySet()) {
                key = (String)e.getKey();
                value = (String)e.getValue();
                TestUtil.logErr((String)("key:" + key + ", value:" + value));
            }
        }
        String[] expected = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getProperties()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new EETest.Fault("getProperties failed");
        }
    }

    public void getSharedCacheMode() throws EETest.Fault {
        boolean pass1 = false;
        SharedCacheMode expected1 = SharedCacheMode.NONE;
        this.getClassObjects();
        SharedCacheMode actual = this.puInfo.getSharedCacheMode();
        if (actual.equals((Object)expected1)) {
            TestUtil.logTrace((String)("Received expected result:" + actual.name()));
            pass1 = true;
        } else {
            TestUtil.logErr((String)("expected: " + expected1.name()));
            TestUtil.logErr((String)("actual: " + actual.name()));
        }
        String[] expected2 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getSharedCacheMode()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected2, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new EETest.Fault("getSharedCacheMode failed");
        }
    }

    public void getValidationMode() throws EETest.Fault {
        boolean pass1 = false;
        ValidationMode expected1 = ValidationMode.NONE;
        this.getClassObjects();
        ValidationMode actual = this.puInfo.getValidationMode();
        if (actual.equals((Object)expected1)) {
            TestUtil.logTrace((String)("Received expected result:" + actual.name()));
            pass1 = true;
        } else {
            TestUtil.logErr((String)("expected: " + expected1.name()));
            TestUtil.logErr((String)("actual: " + actual.name()));
        }
        String[] expected2 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getValidationMode()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected2, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new EETest.Fault("getValidationMode failed");
        }
    }

    public void getClassLoader() throws EETest.Fault {
        boolean pass1 = false;
        this.getClassObjects();
        ClassLoader actual = this.puInfo.getClassLoader();
        if (actual != null) {
            pass1 = true;
            TestUtil.logTrace((String)("Received expected non null ClassLoader:" + actual.toString()));
        } else {
            TestUtil.logErr((String)"Received null ClassLoader");
        }
        String[] expected = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getClassLoader()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new EETest.Fault("getClassLoader failed");
        }
    }

    public void getNewTempClassLoader() throws EETest.Fault {
        boolean pass1 = false;
        this.getClassObjects();
        ClassLoader actual = this.emfImpl.newTempClassloader;
        if (actual != null) {
            pass1 = true;
            TestUtil.logTrace((String)("Received expected non null ClassLoader:" + actual.toString()));
        } else {
            TestUtil.logErr((String)"Received null ClassLoader");
        }
        String[] expected = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getNewTempClassLoader()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new EETest.Fault("getNewTempClassLoader failed");
        }
    }

    public void getMappingFileNames() throws EETest.Fault {
        boolean pass1 = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("META-INF/myMappingFile1.xml");
        expected.add("META-INF/myMappingFile2.xml");
        this.getClassObjects();
        List actual = this.puInfo.getMappingFileNames();
        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
            pass1 = true;
            TestUtil.logTrace((String)"Received expected result:");
            for (String s : actual) {
                TestUtil.logTrace((String)("result:" + s));
            }
        } else {
            TestUtil.logErr((String)"Did not get expected ManagedClassNames");
            TestUtil.logErr((String)"Expected:");
            for (String s : expected) {
                TestUtil.logErr((String)s);
            }
            TestUtil.logErr((String)"Actual:");
            for (String s : actual) {
                TestUtil.logErr((String)s);
            }
        }
        String[] expected1 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getMappingFileNames()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected1, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new EETest.Fault("getMappingFileNames failed");
        }
    }

    public void getNonJtaDataSource() throws EETest.Fault {
        boolean pass1 = false;
        String[] expected = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getNonJtaDataSource()"};
        this.getClassObjects();
        if (this.puInfo.getNonJtaDataSource() != null) {
            TestUtil.logTrace((String)("getNonJtaDataSource() returned non-null result:" + this.puInfo.getNonJtaDataSource().toString()));
            pass1 = true;
        } else {
            TestUtil.logErr((String)"getNonJtaDataSource() returned null result");
        }
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new EETest.Fault("getNonJtaDataSource failed");
        }
    }

    public void excludeUnlistedClasses() throws EETest.Fault {
        boolean pass1 = false;
        String[] expected = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.excludeUnlistedClasses()"};
        this.getClassObjects();
        if (!this.puInfo.excludeUnlistedClasses()) {
            TestUtil.logTrace((String)("excludeUnlistedClasses() returned expected result:" + this.puInfo.excludeUnlistedClasses()));
            pass1 = true;
        } else {
            TestUtil.logErr((String)"excludeUnlistedClasses() returned null result");
        }
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected, this.currentSeqNum);
        if (!pass1 || pass2) {
            throw new EETest.Fault("excludeUnlistedClasses failed");
        }
    }

    public void getProviderUtil() throws EETest.Fault {
        String[] expected = new String[]{this.LOGMESSAGE_PREFIX + "Called getProviderUtil()"};
        Persistence.getPersistenceUtil().isLoaded((Object)"Order");
        logProcessor.fetchLog();
        boolean pass = logProcessor.verifyLogContains(expected, this.currentSeqNum);
        if (!pass) {
            throw new EETest.Fault("getProviderUtil failed");
        }
    }

    public void isLoaded() throws EETest.Fault {
        String[] expected = new String[]{this.LOGMESSAGE_PREFIX + "Called isLoaded()"};
        Persistence.getPersistenceUtil().isLoaded(Order.class);
        logProcessor.fetchLog();
        boolean pass = logProcessor.verifyLogContains(expected, this.currentSeqNum);
        if (!pass) {
            throw new EETest.Fault("isLoaded failed");
        }
    }

    public void isLoadedWithoutReference() throws EETest.Fault {
        String[] expected = new String[]{this.LOGMESSAGE_PREFIX + "Called isLoadedWithoutReference()"};
        Persistence.getPersistenceUtil().isLoaded(Order.class, "attribute");
        logProcessor.fetchLog();
        boolean pass = logProcessor.verifyLogContains(expected, this.currentSeqNum);
        if (!pass) {
            throw new EETest.Fault("isLoadedWithoutReference failed");
        }
    }

    public void getClassObjects() {
        this.emImpl = (EntityManagerImpl)this.getEntityManager(false).unwrap(EntityManagerImpl.class);
        this.emfImpl = (EntityManagerFactoryImpl)this.emImpl.getEntityManagerFactory();
        this.puInfo = this.emfImpl.puInfo;
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        TestUtil.logTrace((String)"calling super.cleanup");
        super.cleanup();
    }
}

