/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.entity.cmp.handletest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.bb.common.EJBHandleObjectInputStream;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp.handletest.TestBean;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp.handletest.TestBeanHome;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.rmi.PortableRemoteObject;

public class Client
extends EETest {
    private static final String testName = "HandleTest";
    private static final String testBean = "java:comp/env/ejb/TestBean";
    private static final String testProps = "handletest.properties";
    private static final String testDir = System.getProperty("user.dir");
    private TestBean beanRef = null;
    private TestBeanHome beanHome = null;
    private Properties props = null;
    private TSNamingContext nctx = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.logMsg("Obtain naming context");
            this.nctx = new TSNamingContext();
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/TestBean");
            this.beanHome = (TestBeanHome)this.nctx.lookup(testBean, TestBeanHome.class);
            this.logMsg("Setup ok");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void test1() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, 1, "coffee-1", 1.0f);
            this.logMsg("get handle for object");
            Handle handle = this.beanRef.getHandle();
            if (handle == null) {
                pass = false;
                this.logErr("getHandle() returned null reference");
            } else if (!(handle instanceof Serializable)) {
                pass = false;
                this.logErr("getHandle() is not serializable");
            } else {
                this.logMsg("got handle and handle is serializable");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test1 failed", e);
        }
        finally {
            try {
                this.beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test1 failed");
        }
    }

    public void test2() throws EETest.Fault {
        ObjectInputStream is = null;
        ObjectOutputStream os = null;
        boolean pass = true;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, 2, "coffee-2", 2.0f);
            this.logMsg("ping object");
            this.beanRef.ping();
            this.logMsg("get handle for object");
            Handle handle = this.beanRef.getHandle();
            this.logMsg("write object output stream to byte array");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            os = new ObjectOutputStream(baos);
            os.writeObject(handle);
            this.logMsg("read object output stream from byte array");
            byte[] b = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(b);
            is = new EJBHandleObjectInputStream(bais);
            Handle deserializedHandle = (Handle)is.readObject();
            this.logMsg("create object reference from deserialized handle");
            EJBObject ejbObject = deserializedHandle.getEJBObject();
            TestBean beanRef2 = (TestBean)PortableRemoteObject.narrow((Object)ejbObject, TestBean.class);
            if (!this.beanRef.isIdentical(beanRef2)) {
                this.logErr("bean references not equal - unexpected");
                pass = false;
            } else {
                this.logMsg("bean references equal - expected");
            }
            Object o1 = this.beanRef.getPrimaryKey();
            Object o2 = beanRef2.getPrimaryKey();
            if (!o1.equals(o2)) {
                this.logErr("bean primary key is not equal - unexpected");
                pass = false;
            } else {
                this.logMsg("bean primary key is equal - expected");
            }
            this.logMsg("ping object via deserialized object reference");
            beanRef2.ping();
        }
        catch (Exception e) {
            throw new EETest.Fault("test2 failed", e);
        }
        finally {
            try {
                this.beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
            try {
                this.logMsg("closing object streams");
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("test2 failed");
        }
    }

    public void test3() throws EETest.Fault {
        ObjectInputStream is = null;
        ObjectOutputStream os = null;
        boolean pass = true;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, 3, "coffee-3", 3.0f);
            this.logMsg("ping object");
            this.beanRef.ping();
            this.logMsg("get handle for object");
            Handle handle = this.beanRef.getHandle();
            this.logMsg("write object output stream to byte array");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            os = new ObjectOutputStream(baos);
            os.writeObject(handle);
            Object o1 = this.beanRef.getPrimaryKey();
            this.logMsg("removing object instance of EJB");
            this.beanRef.remove();
            this.logMsg("read object output stream from byte array");
            byte[] b = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(b);
            is = new EJBHandleObjectInputStream(bais);
            Handle deserializedHandle = (Handle)is.readObject();
            try {
                this.logMsg("create object reference from deserialized handle");
                EJBObject ejbObject = deserializedHandle.getEJBObject();
                TestBean beanRef2 = (TestBean)PortableRemoteObject.narrow((Object)ejbObject, TestBean.class);
                this.logMsg("ping object via deserialized object reference");
                this.logMsg("attempt to ping object reference");
                beanRef2.ping();
                this.logErr("No exception received, expected EJBException");
                pass = false;
            }
            catch (RemoteException e) {
                this.logMsg("RemoteException received  - expected");
            }
            catch (Exception e) {
                this.logErr("Unexpected exception: " + e, e);
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test3 failed", e);
        }
        finally {
            try {
                this.beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
            try {
                this.logMsg("closing object streams");
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("test3 failed");
        }
    }

    public void test4() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("get handle for home");
            HomeHandle handle = this.beanHome.getHomeHandle();
            if (handle == null) {
                pass = false;
                this.logErr("getHomeHandle() returned null reference");
            } else if (!(handle instanceof Serializable)) {
                pass = false;
                this.logErr("getHomeHandle() is not serializable");
            } else {
                this.logMsg("got home handle and handle is serializable");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test4 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test4 failed");
        }
    }

    public void test5() throws EETest.Fault {
        ObjectInputStream is = null;
        ObjectOutputStream os = null;
        boolean pass = true;
        try {
            this.logMsg("get handle for home");
            HomeHandle handle = this.beanHome.getHomeHandle();
            this.logMsg("write object output stream to byte array");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            os = new ObjectOutputStream(baos);
            os.writeObject(handle);
            this.logMsg("read object output stream from byte array");
            byte[] b = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(b);
            is = new EJBHandleObjectInputStream(bais);
            this.logMsg("deserialize home handle");
            HomeHandle deserializedHandle = (HomeHandle)is.readObject();
            this.logMsg("getEJBHome from HomeHandle");
            TestBeanHome beanHome2 = (TestBeanHome)PortableRemoteObject.narrow((Object)deserializedHandle.getEJBHome(), TestBeanHome.class);
            this.logMsg("Create EJB instance from deserialized home handle");
            this.beanRef = beanHome2.create(this.props, 4, "coffee-4", 4.0f);
            this.logMsg("ping object");
            this.beanRef.ping();
            this.logMsg("remove object");
            this.beanRef.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test5 failed", e);
        }
        finally {
            try {
                this.beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
            try {
                this.logMsg("closing object streams");
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("test5 failed");
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }
}

