/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry.LifeCycleManager;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import com.sun.ts.tests.jaxr.common.JAXR_Util;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.EmailAddress;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.ExtrinsicObject;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.LocalizedString;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PersonName;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.RegistryPackage;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.Slot;
import javax.xml.registry.infomodel.SpecificationLink;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;

public class JAXRClient
extends JAXRCommonClient {
    JAXR_Util util = null;

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            super.cleanup();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void LifeCycleManager_createExtrinsicObjectTest() throws EETest.Fault {
        boolean pass;
        String testName;
        block10: {
            testName = "LifeCycleManager_createExtrinsicObjectTest";
            pass = false;
            ArrayList<String> debug = null;
            URL myUrl = null;
            String url = "http://www.ncsa.uiuc.edu/demoweb/url-primer.html";
            try {
                myUrl = new URL(url);
                DataHandler repositoryItem = new DataHandler(myUrl);
                RegistryService rs = this.conn.getRegistryService();
                debug = new ArrayList<String>();
                int providerlevel = rs.getCapabilityProfile().getCapabilityLevel();
                debug.add("     The capability level for this JAXR provider is: " + providerlevel + "\n");
                debug.add("\n getting the BusinessLifeCycleManager\n");
                BusinessLifeCycleManager blm = rs.getBusinessLifeCycleManager();
                try {
                    ExtrinsicObject eo = blm.createExtrinsicObject(repositoryItem);
                    if (providerlevel > 0) {
                        if (eo instanceof ExtrinsicObject) {
                            pass = true;
                        }
                        break block10;
                    }
                    pass = false;
                }
                catch (UnsupportedCapabilityException uce) {
                    TestUtil.printStackTrace((Throwable)uce);
                    if (providerlevel == 0) {
                        pass = true;
                    }
                    debug.add("UnsupportedCapabilityException was thrown!!\n");
                }
                catch (Exception uk) {
                    debug.add("Error: unexpected exception was thrown\n");
                    TestUtil.printStackTrace((Throwable)uk);
                    pass = false;
                }
            }
            catch (JAXRException e) {
                TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + "failed", e);
            }
            catch (Exception ue) {
                TestUtil.logErr((String)("Caught exception: " + ue.getMessage()));
                TestUtil.printStackTrace((Throwable)ue);
                throw new EETest.Fault(testName + "failed", ue);
            }
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void lifeCycleManager_createPersonNameL1Test() throws EETest.Fault {
        boolean pass;
        String testName;
        block11: {
            testName = "lifeCycleManager_createPersonNameL1Test";
            pass = false;
            ArrayList<String> debug = null;
            try {
                RegistryService rs = this.conn.getRegistryService();
                debug = new ArrayList<String>();
                if (!(rs instanceof RegistryService)) {
                    throw new EETest.Fault(testName + "Error failed to get a RegistryService object");
                }
                int providerlevel = rs.getCapabilityProfile().getCapabilityLevel();
                debug.add("     The capability level for this JAXR provider is: " + providerlevel + "\n");
                debug.add("\n getting the BusinessLifeCycleManager\n");
                BusinessLifeCycleManager blm = rs.getBusinessLifeCycleManager();
                try {
                    PersonName pn = blm.createPersonName("First", "Middle", "Last");
                    if (providerlevel > 0) {
                        if (pn instanceof PersonName) {
                            pass = true;
                        }
                        break block11;
                    }
                    pass = false;
                }
                catch (UnsupportedCapabilityException uce) {
                    TestUtil.printStackTrace((Throwable)uce);
                    if (providerlevel == 0) {
                        pass = true;
                    }
                    debug.add("UnsupportedCapabilityException was thrown!!\n");
                }
                catch (Exception uk) {
                    debug.add("Error: unexpected exception was thrown\n");
                    TestUtil.printStackTrace((Throwable)uk);
                    pass = false;
                }
            }
            catch (JAXRException e) {
                TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + "failed", e);
            }
            catch (Exception ue) {
                TestUtil.logErr((String)("Caught exception: " + ue.getMessage()));
                TestUtil.printStackTrace((Throwable)ue);
                throw new EETest.Fault(testName + "failed", ue);
            }
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void LifeCycleManager_createIntRegistryPackageTest() throws EETest.Fault {
        boolean pass;
        String testName;
        block10: {
            testName = "LifeCycleManager_createIntRegistryPackageTest";
            pass = false;
            ArrayList<String> debug = null;
            try {
                RegistryService rs = this.conn.getRegistryService();
                debug = new ArrayList<String>();
                int providerlevel = rs.getCapabilityProfile().getCapabilityLevel();
                debug.add("     The capability level for this JAXR provider is: " + providerlevel + "\n");
                BusinessLifeCycleManager blm = rs.getBusinessLifeCycleManager();
                try {
                    InternationalString name = blm.createInternationalString("TestPackage");
                    RegistryPackage rp = blm.createRegistryPackage(name);
                    if (providerlevel > 0) {
                        if (rp instanceof RegistryPackage) {
                            pass = true;
                        }
                        break block10;
                    }
                    pass = false;
                }
                catch (UnsupportedCapabilityException uce) {
                    TestUtil.printStackTrace((Throwable)uce);
                    if (providerlevel == 0) {
                        pass = true;
                    }
                    debug.add("UnsupportedCapabilityException was thrown!!\n");
                }
                catch (Exception uk) {
                    debug.add("Error: unexpected exception was thrown\n");
                    TestUtil.printStackTrace((Throwable)uk);
                    pass = false;
                }
            }
            catch (JAXRException e) {
                TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + "failed", e);
            }
            catch (Exception ue) {
                TestUtil.logErr((String)("Caught exception: " + ue.getMessage()));
                TestUtil.printStackTrace((Throwable)ue);
                throw new EETest.Fault(testName + "failed", ue);
            }
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void LifeCycleManager_createRegistryPackageTest() throws EETest.Fault {
        boolean pass;
        String testName;
        block11: {
            testName = "LifeCycleManager_createRegistryPackageTest";
            pass = false;
            ArrayList<String> debug = null;
            try {
                RegistryService rs = this.conn.getRegistryService();
                debug = new ArrayList<String>();
                if (!(rs instanceof RegistryService)) {
                    throw new EETest.Fault(testName + "Error failed to get a RegistryService object");
                }
                int providerlevel = rs.getCapabilityProfile().getCapabilityLevel();
                debug.add("     The capability level for this JAXR provider is: " + providerlevel + "\n");
                debug.add("\n getting the BusinessLifeCycleManager\n");
                BusinessLifeCycleManager blm = rs.getBusinessLifeCycleManager();
                try {
                    RegistryPackage rp = blm.createRegistryPackage("TestPackage");
                    if (providerlevel > 0) {
                        if (rp instanceof RegistryPackage) {
                            pass = true;
                        }
                        break block11;
                    }
                    pass = false;
                }
                catch (UnsupportedCapabilityException uce) {
                    TestUtil.printStackTrace((Throwable)uce);
                    if (providerlevel == 0) {
                        pass = true;
                    }
                    debug.add("UnsupportedCapabilityException was thrown!!\n");
                }
                catch (Exception uk) {
                    debug.add("Error: unexpected exception was thrown\n");
                    TestUtil.printStackTrace((Throwable)uk);
                    pass = false;
                }
            }
            catch (JAXRException e) {
                TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + "failed", e);
            }
            catch (Exception ue) {
                TestUtil.logErr((String)("Caught exception: " + ue.getMessage()));
                TestUtil.printStackTrace((Throwable)ue);
                throw new EETest.Fault(testName + "failed", ue);
            }
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void lifeCycleManager_createAssociationTest() throws EETest.Fault {
        String testName = "lifeCycleManager_createAssociationTest";
        boolean pass = false;
        String orgName = "TS Default Organization";
        try {
            InternationalString iName = this.blm.createInternationalString(orgName);
            Organization targetObject = this.blm.createOrganization(iName);
            Concept concept = null;
            Association assoc = this.blm.createAssociation((RegistryObject)targetObject, concept);
            if (assoc == null) {
                throw new EETest.Fault(testName + "Error: createAssociation returned null!");
            }
            if (assoc instanceof Association) {
                pass = true;
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void lifeCycleManager_createExternalClassificationTest() throws EETest.Fault {
        String testName = "lifeCycleManager_createExternalClassificationTest";
        boolean pass = false;
        String orgName = "TS Default Organization";
        String schemeName = "NAICS";
        String classificationName = "Book Publishers";
        String classificationValue = "51113";
        String schemeDescription = "North American Industry Classification System";
        try {
            ClassificationScheme scheme = this.blm.createClassificationScheme(schemeName, schemeDescription);
            Classification classification = this.blm.createClassification(scheme, classificationName, classificationValue);
            if (classification == null) {
                throw new EETest.Fault(testName + "Error: createClassification returned null!");
            }
            if (!(classification instanceof Classification)) {
                throw new EETest.Fault(testName + "Error: createClassification returned null!");
            }
            pass = true;
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void lifeCycleManager_createExternalClassificationInternationalTest() throws EETest.Fault {
        String testName = "lifeCycleManager_createExternalClassificationInternationalTest";
        boolean pass = false;
        String orgName = "TS Default Organization";
        String schemeName = "NAICS";
        String classificationName = "Book Publishers";
        String classificationValue = "51113";
        String schemeDescription = "North American Industry Classification System";
        Classification classification = null;
        try {
            ClassificationScheme scheme = this.blm.createClassificationScheme(schemeName, schemeDescription);
            InternationalString name = this.blm.createInternationalString(classificationName);
            classification = this.blm.createClassification(scheme, name, classificationValue);
            if (classification == null) {
                throw new EETest.Fault(testName + "Error: createClassification returned null!");
            }
            if (!(classification instanceof Classification)) {
                throw new EETest.Fault(testName + "Error: createClassification returned null!");
            }
            pass = true;
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void lifeCycleManager_createInternalClassificationTest() throws EETest.Fault {
        String testName = "lifeCycleManager_createInternalClassificationTest";
        boolean pass = false;
        String orgName = "TS Default Organization";
        String schemeName = "NAICS";
        String schemeDescription = "North American Industry Classification System";
        String conceptName = "NAICS";
        String conceptValue = "51";
        try {
            ClassificationScheme scheme = this.blm.createClassificationScheme(schemeName, schemeDescription);
            Concept concept = this.blm.createConcept((RegistryObject)scheme, conceptName, conceptValue);
            Classification classification = this.blm.createClassification(concept);
            if (classification == null) {
                throw new EETest.Fault(testName + "Error: createClassification returned null!");
            }
            if (!(classification instanceof Classification)) {
                throw new EETest.Fault(testName + "Error: createClassification returned null!");
            }
            pass = true;
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void lifeCycleManager_createInvalidInternalClassificationTest() throws EETest.Fault {
        String testName = "lifeCycleManager_createInvalidInternalClassificationTest";
        try {
            Concept concept = (Concept)this.blm.createObject("Concept");
            Classification classification = this.blm.createClassification(concept);
            throw new EETest.Fault(testName + "Error: InvalidRequestException not thrown as expected!");
        }
        catch (InvalidRequestException ir) {
            TestUtil.printStackTrace((Throwable)ir);
            this.debug.add("InvalidRequestException thrown as expected!");
            this.debug.add(ir.getMessage() + "\n");
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
    }

    public void lifeCycleManager_createClassificationSchemeTest() throws EETest.Fault {
        String testName = "lifeCycleManager_createClassificationSchemeTest";
        String schemeName = "NAICS";
        String schemeDescription = "North American Industry Classification System";
        try {
            ClassificationScheme scheme = this.blm.createClassificationScheme(schemeName, schemeDescription);
            if (!(scheme instanceof ClassificationScheme)) {
                throw new EETest.Fault(testName + "Error: ClassificationScheme not returned from create method");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
    }

    public void lifeCycleManager_createClassificationSchemeInvalidTest() throws EETest.Fault {
        String testName = "lifeCycleManager_createClassificationSchemeInvalidTest";
        String schemeName = "Geography";
        String schemeDescription = "North American Regions";
        String conceptName = "North America";
        String conceptValue = "NA";
        String conceptNameCA = "California";
        String conceptValueCA = "US-CA";
        String conceptNameUS = "United States";
        String conceptValueUS = "US";
        try {
            this.debug.add("Create a concept and then a child concept\n");
            ClassificationScheme scheme = this.blm.createClassificationScheme(schemeName, schemeDescription);
            Concept usConcept = this.blm.createConcept((RegistryObject)scheme, conceptNameUS, conceptValueUS);
            Concept caConcept = this.blm.createConcept((RegistryObject)scheme, conceptNameCA, conceptValueCA);
            usConcept.addChildConcept(caConcept);
            ClassificationScheme testScheme = this.blm.createClassificationScheme(caConcept);
            this.debug.add("Error: failed to throw an InvalidRequestException!\n");
            throw new EETest.Fault(testName + "concept has parent and should have thrown an error!");
        }
        catch (InvalidRequestException ir) {
            this.debug.add("Threw exception as expected!!\n");
            TestUtil.printStackTrace((Throwable)ir);
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
    }

    public void lifeCycleManager_createConceptTest() throws EETest.Fault {
        String testName = "lifeCycleManager_createConceptTest";
        String schemeName = "Geography";
        String schemeDescription = "North American Regions";
        String conceptName = "North America";
        String conceptValue = "NA";
        try {
            ClassificationScheme scheme = this.blm.createClassificationScheme(schemeName, schemeDescription);
            Concept usConcept = this.blm.createConcept((RegistryObject)scheme, conceptName, conceptValue);
            if (!(usConcept instanceof Concept)) {
                throw new EETest.Fault(testName + "concept has parent and should have thrown an error!");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
    }

    public void lifeCycleManager_createConceptInternationalTest() throws EETest.Fault {
        String testName = "lifeCycleManager_createConceptInternationalTest";
        String schemeName = "Geography";
        String schemeDescription = "North American Regions";
        String conceptName = "North America";
        String conceptValue = "NA";
        try {
            ClassificationScheme scheme = this.blm.createClassificationScheme(schemeName, schemeDescription);
            InternationalString name = this.blm.createInternationalString(conceptName);
            Concept usConcept = this.blm.createConcept((RegistryObject)scheme, name, conceptValue);
            if (!(usConcept instanceof Concept)) {
                throw new EETest.Fault(testName + "concept has parent and should have thrown an error!");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
    }

    public void lifeCycleManager_createExternalIdentifierTest() throws EETest.Fault {
        String testName = "lifeCycleManager_createExternalIdentifierTest";
        String cName = "Social Security";
        String cDescription = "Social Security Numbers";
        String name = "Social Security Number";
        String value = "026-10-5738";
        try {
            ClassificationScheme scheme = this.blm.createClassificationScheme(cName, cDescription);
            ExternalIdentifier ei = this.blm.createExternalIdentifier(scheme, name, value);
            if (!(ei instanceof ExternalIdentifier)) {
                throw new EETest.Fault(testName + "Error: ExternalIdentifier not returned");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
    }

    public void lifeCycleManager_createExternalIdentifierInternationalTest() throws EETest.Fault {
        String testName = "lifeCycleManager_createExternalIdentifierInternationalTest";
        String cName = "Social Security";
        String cDescription = "Social Security Numbers";
        String name = "Social Security Number";
        String value = "026-10-5738";
        try {
            ClassificationScheme scheme = this.blm.createClassificationScheme(cName, cDescription);
            InternationalString iName = this.blm.createInternationalString(name);
            ExternalIdentifier ei = this.blm.createExternalIdentifier(scheme, iName, value);
            if (!(ei instanceof ExternalIdentifier)) {
                throw new EETest.Fault(testName + "Error: ExternalIdentifier not returned");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
    }

    public void lifeCycleManager_createInternationalClassificationSchemeTest() throws EETest.Fault {
        String testName = "lifeCycleManager_createInternationalClassificationSchemeTest";
        String schemeName = "NAICS";
        String schemeDescription = "North American Industry Classification System";
        ClassificationScheme scheme = null;
        try {
            InternationalString ischemeDescription = this.blm.createInternationalString(schemeDescription);
            InternationalString ischemeName = this.blm.createInternationalString(schemeName);
            scheme = this.blm.createClassificationScheme(ischemeName, ischemeDescription);
            if (!(scheme instanceof ClassificationScheme)) {
                throw new EETest.Fault(testName + "Error: ClassificationScheme not returned from create method");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
    }

    public void lifeCycleManager_createClassificationSchemeConceptTest() throws EETest.Fault {
        String testName = "lifeCycleManager_createClassificationSchemeConceptTest";
        try {
            Concept concept = (Concept)this.blm.createObject("Concept");
            concept.setValue("conceptValue");
            if (concept == null) {
                throw new EETest.Fault(testName + "Error: createObject returned a null concept!");
            }
            ClassificationScheme scheme = this.blm.createClassificationScheme(concept);
            if (!(scheme instanceof ClassificationScheme)) {
                throw new EETest.Fault(testName + "Error: ClassificationScheme not returned from create method");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
    }

    public void lifeCycleManager_createEmailAddressTest() throws EETest.Fault {
        String testName = "lifeCycleManager_createEmailAddressTest";
        String address = "abc@myCo.com";
        try {
            EmailAddress ea = this.blm.createEmailAddress(address);
            if (!(ea instanceof EmailAddress)) {
                throw new EETest.Fault(testName + "Error: EmailAddress not returned from create method");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
    }

    public void lifeCycleManager_createEmailAddress2Test() throws EETest.Fault {
        String testName = "lifeCycleManager_createEmailAddress2Test";
        String address = "abc@myCo.com";
        String type = "headquarters";
        try {
            EmailAddress ea = this.blm.createEmailAddress(address, type);
            if (!(ea instanceof EmailAddress)) {
                throw new EETest.Fault(testName + "Error: EmailAddress not returned from create method");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
    }

    public void lifeCycleManager_createExternalLinkTest() throws EETest.Fault {
        String testName = "lifeCycleManager_createExternalLinkTest";
        String externalURI = this.baseuri + "jaxrTestPage1.html";
        String description = "web portal";
        try {
            ExternalLink el = this.blm.createExternalLink(externalURI, description);
            if (!(el instanceof ExternalLink)) {
                throw new EETest.Fault(testName + "Error: ExternalLink not returned from create method");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
    }

    public void lifeCycleManager_createExternalLinkTestInternational() throws EETest.Fault {
        String testName = "lifeCycleManager_createExternalLinkTestInternational";
        String externalURI = this.baseuri + "jaxrTestPage1.html";
        String description = "web portal";
        try {
            InternationalString idescription = this.blm.createInternationalString(description);
            ExternalLink el = this.blm.createExternalLink(externalURI, idescription);
            if (!(el instanceof ExternalLink)) {
                throw new EETest.Fault(testName + "Error: ExternalLink not returned from create method");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
    }

    public void lifeCycleManager_createKey() throws EETest.Fault {
        String testName = "lifeCycleManager_createKey";
        String theKey = "32D8CEB0-D8D9-11D5-AE91-000629DC0A2B";
        try {
            Key key = this.blm.createKey(theKey);
            if (!(key instanceof Key)) {
                throw new EETest.Fault(testName + "Error: Key not returned from create method");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
    }

    public void LifeCycleManager_createInternationalStringTest() throws EETest.Fault {
        String testName = "LifeCycleManager_createInternationalStringTest";
        try {
            InternationalString is = this.blm.createInternationalString();
            if (!(is instanceof InternationalString)) {
                throw new EETest.Fault(testName + "createInternationalString did not return InternationalString instance!");
            }
        }
        catch (JAXRException e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + "failed", e);
        }
    }

    public void LifeCycleManager_createInternationalString2Test() throws EETest.Fault {
        String testName = "LifeCycleManager_createInternationalString2Test";
        String str = "MyInternationalString";
        try {
            Locale l = Locale.getDefault();
            this.debug.add("The locale is set to: " + l.getCountry() + "\n");
            InternationalString is = this.blm.createInternationalString(l, str);
            if (!(is instanceof InternationalString)) {
                throw new EETest.Fault(testName + "createInternationalString did not return InternationalString instance!");
            }
        }
        catch (JAXRException e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + "failed", e);
        }
    }

    public void LifeCycleManager_createInternationalString3Test() throws EETest.Fault {
        String testName = "LifeCycleManager_createInternationalString3Test";
        String str = "MyInternationalString";
        try {
            InternationalString is = this.blm.createInternationalString(str);
            if (!(is instanceof InternationalString)) {
                throw new EETest.Fault(testName + "createInternationalString did not return InternationalString instance!");
            }
        }
        catch (JAXRException e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + "failed", e);
        }
    }

    public void LifeCycleManager_createLocalizedStringTest() throws EETest.Fault {
        String testName = "LifeCycleManager_createLocalizedStringTest";
        String str = "MyString";
        try {
            Locale l = Locale.getDefault();
            this.debug.add("The locale is set to: " + l.getCountry() + "\n");
            LocalizedString ls = this.blm.createLocalizedString(l, str);
            if (!(ls instanceof LocalizedString)) {
                throw new EETest.Fault(testName + "createLocalizedString did not return a LocalizedString instance!");
            }
        }
        catch (JAXRException e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + "failed", e);
        }
    }

    public void LifeCycleManager_createLocalizedStringTest2() throws EETest.Fault {
        String testName = "LifeCycleManager_createLocalizedStringTest2";
        String str = "MyString";
        String charset = "UTF-8";
        try {
            Locale l = Locale.getDefault();
            LocalizedString ls = this.blm.createLocalizedString(l, str, charset);
            if (!(ls instanceof LocalizedString)) {
                throw new EETest.Fault(testName + "createLocalizedString(locale, string, string)  did not return a LocalizedString instance!");
            }
        }
        catch (JAXRException e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + "failed", e);
        }
    }

    public void LifeCycleManager_createOrganizationTest() throws EETest.Fault {
        String testName = "LifeCycleManager_createOrganizationTest";
        String str = "MyOrganization";
        try {
            Locale l = Locale.getDefault();
            InternationalString iName = this.blm.createInternationalString(str);
            Organization org = this.blm.createOrganization(iName);
            if (!(org instanceof Organization)) {
                throw new EETest.Fault(testName + "createOrganization did not return an Organization instance!");
            }
        }
        catch (JAXRException e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + "failed", e);
        }
    }

    public void LifeCycleManager_createOrganizationInternationalTest() throws EETest.Fault {
        String testName = "LifeCycleManager_createOrganizationInternationalTest";
        String str = "MyOrganization";
        try {
            Locale l = Locale.getDefault();
            InternationalString istr = this.blm.createInternationalString();
            Organization org = this.blm.createOrganization(istr);
            if (!(org instanceof Organization)) {
                throw new EETest.Fault(testName + "createOrganization(internationalString)  did not return an Organization instance!");
            }
        }
        catch (JAXRException e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + "failed", e);
        }
    }

    public void LifeCycleManager_createPersonNameTest() throws EETest.Fault {
        String testName = "LifeCycleManager_createPersonNameTest";
        String name = "Minnie Mouse";
        try {
            PersonName pn = this.blm.createPersonName(name);
            if (!(pn instanceof PersonName)) {
                throw new EETest.Fault(testName + "createPersonName did not return a PersonName instance!");
            }
        }
        catch (JAXRException e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + "failed", e);
        }
    }

    public void LifeCycleManager_createPostalAddressTest() throws EETest.Fault {
        String testName = "LifeCycleManager_createPostalAddressTest";
        String name = "Minnie Mouse";
        String streetNumber = "6";
        String street = "Ivaloo";
        String city = "Somerville";
        String stateOrProvince = "MA";
        String country = "USA";
        String postalCode = "01950";
        String type = "snailmail";
        try {
            PostalAddress pa = this.blm.createPostalAddress(streetNumber, street, city, stateOrProvince, country, postalCode, type);
            if (!(pa instanceof PostalAddress)) {
                throw new EETest.Fault(testName + "createPostalAddress did not return a PostalAddress instance!");
            }
        }
        catch (JAXRException e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + "failed", e);
        }
    }

    public void lifeCycleManager_createServiceTest() throws EETest.Fault {
        String testName = "lifeCycleManager_createServiceTest";
        String serviceName = "MyTestService";
        try {
            Service s = this.blm.createService(serviceName);
            if (!(s instanceof Service)) {
                throw new EETest.Fault(testName + "Error: Service not returned from create method");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
    }

    public void lifeCycleManager_createServiceInternationalTest() throws EETest.Fault {
        String testName = "lifeCycleManager_createServiceInternationalTest";
        String name = "MyTestService";
        try {
            InternationalString serviceName = this.blm.createInternationalString(name);
            Service s = this.blm.createService(serviceName);
            if (!(s instanceof Service)) {
                throw new EETest.Fault(testName + "Error: Service not returned from create method");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
    }

    public void lifeCycleManager_createServiceBindingTest() throws EETest.Fault {
        String testName = "lifeCycleManager_createServiceBindingTest";
        try {
            ServiceBinding sb = this.blm.createServiceBinding();
            if (!(sb instanceof ServiceBinding)) {
                throw new EETest.Fault(testName + "Error: ServiceBinding not returned from create method");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
    }

    public void lifeCycleManager_createSlotTest() throws EETest.Fault {
        String testName = "lifeCycleManager_createSlotTest()";
        String name = "streetAddress";
        String value = "Main Street";
        String slotType = "type";
        try {
            Slot slot = this.blm.createSlot(name, value, slotType);
            if (!(slot instanceof Slot)) {
                throw new EETest.Fault(testName + "Error: Slot not returned from create method");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
    }

    public void lifeCycleManager_createSlot2Test() throws EETest.Fault {
        String testName = "lifeCycleManager_createSlot2Test()";
        String name = "streetAddress";
        String value = "Main Street";
        String slotType = "type";
        try {
            ArrayList<String> values = new ArrayList<String>();
            values.add(value);
            Slot slot = this.blm.createSlot(name, values, slotType);
            if (!(slot instanceof Slot)) {
                throw new EETest.Fault(testName + "Error: Slot not returned from create method");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
    }

    public void lifeCycleManager_createSpecificationLinkTest() throws EETest.Fault {
        String testName = "lifeCycleManager_createSpecificationLinkTest()";
        try {
            SpecificationLink sl = this.blm.createSpecificationLink();
            if (!(sl instanceof SpecificationLink)) {
                throw new EETest.Fault(testName + "Error: SpecificationLink not returned from create method");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
    }

    public void lifeCycleManager_createTelephoneNumberTest() throws EETest.Fault {
        String testName = "lifeCycleManager_createTelephoneNumberTest()";
        try {
            TelephoneNumber telno = this.blm.createTelephoneNumber();
            if (!(telno instanceof TelephoneNumber)) {
                throw new EETest.Fault(testName + "Error: TelephoneNumber not returned from create method");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
    }

    public void lifeCycleManager_createUserTest() throws EETest.Fault {
        String testName = "lifeCycleManager_createUserTest()";
        try {
            User user = this.blm.createUser();
            if (!(user instanceof User)) {
                throw new EETest.Fault(testName + "Error: User not returned from create method");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
    }

    public void lifeCycleManager_getRegistryService() throws EETest.Fault {
        String testName = "lifeCycleManager_getRegistryService()";
        try {
            RegistryService rs = this.blm.getRegistryService();
            if (!(rs instanceof RegistryService)) {
                throw new EETest.Fault(testName + "Error:  RegistryService was not returned from getRegistryService");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
    }
}

