/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.jsonparsertests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import com.sun.ts.tests.jsonp.api.jsonparsertests.Parser;
import com.sun.ts.tests.jsonp.common.JSONP_Util;
import com.sun.ts.tests.jsonp.common.MyBufferedInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParsingException;

public class Client
extends ServiceEETest {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    private boolean parseAndVerify_JsonObjectUTF(JsonParser parser) throws Exception {
        boolean pass = true;
        JSONP_Util.resetParseErrs();
        JSONP_Util.testEventType(parser, JsonParser.Event.START_OBJECT);
        JSONP_Util.testKeyStringValue(parser, "stringName", "stringValue");
        JSONP_Util.testKeyStartObjectValue(parser, "objectName");
        JSONP_Util.testKeyStringValue(parser, "foo", "bar");
        JSONP_Util.testEventType(parser, JsonParser.Event.END_OBJECT);
        JSONP_Util.testKeyStartArrayValue(parser, "arrayName");
        JSONP_Util.testIntegerValue(parser, 1);
        JSONP_Util.testIntegerValue(parser, 2);
        JSONP_Util.testIntegerValue(parser, 3);
        JSONP_Util.testEventType(parser, JsonParser.Event.END_ARRAY);
        JSONP_Util.testEventType(parser, JsonParser.Event.END_OBJECT);
        int parseErrs = JSONP_Util.getParseErrs();
        if (parseErrs != 0) {
            this.logErr("There were " + parseErrs + " parser errors that occurred.");
            pass = false;
        }
        return pass;
    }

    private boolean parseAndVerify_JsonObjectWithAllTypesOfData(JsonParser parser) throws Exception {
        boolean pass = true;
        JSONP_Util.resetParseErrs();
        JSONP_Util.testEventType(parser, JsonParser.Event.START_OBJECT);
        JSONP_Util.testKeyStringValue(parser, "emptyString", "");
        JSONP_Util.testKeyStartArrayValue(parser, "emptyArray");
        JSONP_Util.testEventType(parser, JsonParser.Event.END_ARRAY);
        JSONP_Util.testKeyStartObjectValue(parser, "emptyObject");
        JSONP_Util.testEventType(parser, JsonParser.Event.END_OBJECT);
        JSONP_Util.testKeyStringValue(parser, "string", "string");
        JSONP_Util.testKeyIntegerValue(parser, "number", 100);
        JSONP_Util.testKeyTrueValue(parser, "true");
        JSONP_Util.testKeyFalseValue(parser, "false");
        JSONP_Util.testKeyNullValue(parser, "null");
        JSONP_Util.testKeyStartObjectValue(parser, "object");
        JSONP_Util.testKeyStringValue(parser, "emptyString", "");
        JSONP_Util.testKeyStartArrayValue(parser, "emptyArray");
        JSONP_Util.testEventType(parser, JsonParser.Event.END_ARRAY);
        JSONP_Util.testKeyStartObjectValue(parser, "emptyObject");
        JSONP_Util.testEventType(parser, JsonParser.Event.END_OBJECT);
        JSONP_Util.testKeyStringValue(parser, "string", "string");
        JSONP_Util.testKeyIntegerValue(parser, "number", 100);
        JSONP_Util.testKeyTrueValue(parser, "true");
        JSONP_Util.testKeyFalseValue(parser, "false");
        JSONP_Util.testKeyNullValue(parser, "null");
        JSONP_Util.testKeyStartObjectValue(parser, "object");
        JSONP_Util.testKeyStringValue(parser, "name", "value");
        JSONP_Util.testEventType(parser, JsonParser.Event.END_OBJECT);
        JSONP_Util.testKeyStartArrayValue(parser, "array");
        JSONP_Util.testStringValue(parser, "one");
        JSONP_Util.testStringValue(parser, "two");
        JSONP_Util.testEventType(parser, JsonParser.Event.END_ARRAY);
        JSONP_Util.testEventType(parser, JsonParser.Event.END_OBJECT);
        JSONP_Util.testKeyStartArrayValue(parser, "array");
        JSONP_Util.testStringValue(parser, "string");
        JSONP_Util.testIntegerValue(parser, 100);
        JSONP_Util.testTrueValue(parser, JsonParser.Event.VALUE_TRUE);
        JSONP_Util.testFalseValue(parser, JsonParser.Event.VALUE_FALSE);
        JSONP_Util.testNullValue(parser, JsonParser.Event.VALUE_NULL);
        JSONP_Util.testEventType(parser, JsonParser.Event.START_OBJECT);
        JSONP_Util.testKeyStringValue(parser, "name", "value");
        JSONP_Util.testEventType(parser, JsonParser.Event.END_OBJECT);
        JSONP_Util.testEventType(parser, JsonParser.Event.START_ARRAY);
        JSONP_Util.testStringValue(parser, "one");
        JSONP_Util.testStringValue(parser, "two");
        JSONP_Util.testEventType(parser, JsonParser.Event.END_ARRAY);
        JSONP_Util.testEventType(parser, JsonParser.Event.END_ARRAY);
        JSONP_Util.testKeyIntegerValue(parser, "intPositive", 100);
        JSONP_Util.testKeyIntegerValue(parser, "intNegative", -100);
        JSONP_Util.testKeyLongValue(parser, "longMax", Long.MAX_VALUE);
        JSONP_Util.testKeyLongValue(parser, "longMin", Long.MIN_VALUE);
        JSONP_Util.testKeyDoubleValue(parser, "fracPositive", 0.5);
        JSONP_Util.testKeyDoubleValue(parser, "fracNegative", -0.5);
        JSONP_Util.testKeyDoubleValue(parser, "expPositive1", 7000.0);
        JSONP_Util.testKeyDoubleValue(parser, "expPositive2", 7000.0);
        JSONP_Util.testKeyDoubleValue(parser, "expPositive3", 9000.0);
        JSONP_Util.testKeyDoubleValue(parser, "expPositive4", 9000.0);
        JSONP_Util.testKeyDoubleValue(parser, "expNegative1", 0.007);
        JSONP_Util.testKeyDoubleValue(parser, "expNegative2", 0.007);
        JSONP_Util.testKeyStringValue(parser, "asciiChars", "!@#$%^&*()_+|~1234567890-=;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM");
        JSONP_Util.testEventType(parser, JsonParser.Event.END_OBJECT);
        int parseErrs = JSONP_Util.getParseErrs();
        if (parseErrs != 0) {
            this.logErr("There were " + parseErrs + " parser errors that occurred.");
            pass = false;
        }
        return pass;
    }

    private boolean parseAndVerify_JsonObjectWithLotsOfNestedObjectsData(JsonParser parser) throws Exception {
        int i;
        boolean pass = true;
        JSONP_Util.resetParseErrs();
        JSONP_Util.testEventType(parser, JsonParser.Event.START_OBJECT);
        for (i = 1; i < 31; ++i) {
            JSONP_Util.testKeyStartObjectValue(parser, "nested" + i);
            JSONP_Util.testKeyStringValue(parser, "name" + i, "value" + i);
        }
        for (i = 1; i < 31; ++i) {
            JSONP_Util.testEventType(parser, JsonParser.Event.END_OBJECT);
        }
        JSONP_Util.testEventType(parser, JsonParser.Event.END_OBJECT);
        int parseErrs = JSONP_Util.getParseErrs();
        if (parseErrs != 0) {
            this.logErr("There were " + parseErrs + " parser errors that occurred.");
            pass = false;
        }
        return pass;
    }

    private boolean parseAndVerify_JsonArrayWithLotsOfNestedObjectsData(JsonParser parser) throws Exception {
        int i;
        boolean pass = true;
        JSONP_Util.resetParseErrs();
        JSONP_Util.testEventType(parser, JsonParser.Event.START_ARRAY);
        JSONP_Util.testEventType(parser, JsonParser.Event.START_OBJECT);
        JSONP_Util.testKeyStringValue(parser, "name1", "value1");
        for (i = 2; i < 31; ++i) {
            JSONP_Util.testKeyStartObjectValue(parser, "nested" + i);
            JSONP_Util.testKeyStringValue(parser, "name" + i, "value" + i);
        }
        for (i = 2; i < 31; ++i) {
            JSONP_Util.testEventType(parser, JsonParser.Event.END_OBJECT);
        }
        JSONP_Util.testEventType(parser, JsonParser.Event.END_OBJECT);
        JSONP_Util.testEventType(parser, JsonParser.Event.END_ARRAY);
        int parseErrs = JSONP_Util.getParseErrs();
        if (parseErrs != 0) {
            this.logErr("There were " + parseErrs + " parser errors that occurred.");
            pass = false;
        }
        return pass;
    }

    private boolean parseAndVerify_JsonArrayWithLotsOfNestedArraysData(JsonParser parser) throws Exception {
        int i;
        boolean pass = true;
        JSONP_Util.resetParseErrs();
        JSONP_Util.testEventType(parser, JsonParser.Event.START_ARRAY);
        JSONP_Util.testEventType(parser, JsonParser.Event.START_ARRAY);
        JSONP_Util.testStringValue(parser, "name1");
        JSONP_Util.testStringValue(parser, "value1");
        for (i = 2; i < 31; ++i) {
            JSONP_Util.testStringValue(parser, "nested" + i);
            JSONP_Util.testEventType(parser, JsonParser.Event.START_ARRAY);
            JSONP_Util.testStringValue(parser, "name" + i);
            JSONP_Util.testStringValue(parser, "value" + i);
        }
        for (i = 2; i < 31; ++i) {
            JSONP_Util.testEventType(parser, JsonParser.Event.END_ARRAY);
        }
        JSONP_Util.testEventType(parser, JsonParser.Event.END_ARRAY);
        JSONP_Util.testEventType(parser, JsonParser.Event.END_ARRAY);
        int parseErrs = JSONP_Util.getParseErrs();
        if (parseErrs != 0) {
            this.logErr("There were " + parseErrs + " parser errors that occurred.");
            pass = false;
        }
        return pass;
    }

    private boolean parseAndVerify_JsonArrayWithMultipleArraysData(JsonParser parser) throws Exception {
        boolean pass = true;
        JSONP_Util.resetParseErrs();
        JSONP_Util.testEventType(parser, JsonParser.Event.START_ARRAY);
        JSONP_Util.testStringValue(parser, "string");
        JSONP_Util.testIntegerValue(parser, 100);
        JSONP_Util.testTrueValue(parser, JsonParser.Event.VALUE_TRUE);
        JSONP_Util.testFalseValue(parser, JsonParser.Event.VALUE_FALSE);
        JSONP_Util.testNullValue(parser, JsonParser.Event.VALUE_NULL);
        JSONP_Util.testEventType(parser, JsonParser.Event.START_OBJECT);
        JSONP_Util.testKeyStringValue(parser, "object", "object");
        JSONP_Util.testEventType(parser, JsonParser.Event.END_OBJECT);
        JSONP_Util.testEventType(parser, JsonParser.Event.START_ARRAY);
        JSONP_Util.testStringValue(parser, "one");
        JSONP_Util.testStringValue(parser, "two");
        JSONP_Util.testEventType(parser, JsonParser.Event.END_ARRAY);
        JSONP_Util.testEventType(parser, JsonParser.Event.START_ARRAY);
        JSONP_Util.testIntegerValue(parser, 100);
        JSONP_Util.testDoubleValue(parser, 7.0E7);
        JSONP_Util.testTrueValue(parser, JsonParser.Event.VALUE_TRUE);
        JSONP_Util.testFalseValue(parser, JsonParser.Event.VALUE_FALSE);
        JSONP_Util.testNullValue(parser, JsonParser.Event.VALUE_NULL);
        JSONP_Util.testEventType(parser, JsonParser.Event.START_OBJECT);
        JSONP_Util.testKeyStringValue(parser, "object2", "object2");
        JSONP_Util.testEventType(parser, JsonParser.Event.END_OBJECT);
        JSONP_Util.testEventType(parser, JsonParser.Event.END_ARRAY);
        JSONP_Util.testEventType(parser, JsonParser.Event.END_ARRAY);
        int parseErrs = JSONP_Util.getParseErrs();
        if (parseErrs != 0) {
            this.logErr("There were " + parseErrs + " parser errors that occurred.");
            pass = false;
        }
        return pass;
    }

    private boolean parseAndVerify_JsonArrayWithAllTypesOfData(JsonParser parser) throws Exception {
        boolean pass = true;
        JSONP_Util.resetParseErrs();
        JSONP_Util.testEventType(parser, JsonParser.Event.START_ARRAY);
        JSONP_Util.testStringValue(parser, "");
        JSONP_Util.testEventType(parser, JsonParser.Event.START_ARRAY);
        JSONP_Util.testEventType(parser, JsonParser.Event.END_ARRAY);
        JSONP_Util.testEventType(parser, JsonParser.Event.START_OBJECT);
        JSONP_Util.testEventType(parser, JsonParser.Event.END_OBJECT);
        JSONP_Util.testStringValue(parser, "string");
        JSONP_Util.testIntegerValue(parser, 100);
        JSONP_Util.testTrueValue(parser, JsonParser.Event.VALUE_TRUE);
        JSONP_Util.testFalseValue(parser, JsonParser.Event.VALUE_FALSE);
        JSONP_Util.testNullValue(parser, JsonParser.Event.VALUE_NULL);
        JSONP_Util.testEventType(parser, JsonParser.Event.START_OBJECT);
        JSONP_Util.testKeyStringValue(parser, "emptyString", "");
        JSONP_Util.testKeyStartArrayValue(parser, "emptyArray");
        JSONP_Util.testEventType(parser, JsonParser.Event.END_ARRAY);
        JSONP_Util.testKeyStartObjectValue(parser, "emptyObject");
        JSONP_Util.testEventType(parser, JsonParser.Event.END_OBJECT);
        JSONP_Util.testKeyStringValue(parser, "string", "string");
        JSONP_Util.testKeyIntegerValue(parser, "number", 100);
        JSONP_Util.testKeyTrueValue(parser, "true");
        JSONP_Util.testKeyFalseValue(parser, "false");
        JSONP_Util.testKeyNullValue(parser, "null");
        JSONP_Util.testKeyStartObjectValue(parser, "object");
        JSONP_Util.testKeyStringValue(parser, "name", "value");
        JSONP_Util.testEventType(parser, JsonParser.Event.END_OBJECT);
        JSONP_Util.testKeyStartArrayValue(parser, "array");
        JSONP_Util.testStringValue(parser, "one");
        JSONP_Util.testStringValue(parser, "two");
        JSONP_Util.testEventType(parser, JsonParser.Event.END_ARRAY);
        JSONP_Util.testEventType(parser, JsonParser.Event.END_OBJECT);
        JSONP_Util.testEventType(parser, JsonParser.Event.START_ARRAY);
        JSONP_Util.testStringValue(parser, "string");
        JSONP_Util.testIntegerValue(parser, 100);
        JSONP_Util.testTrueValue(parser, JsonParser.Event.VALUE_TRUE);
        JSONP_Util.testFalseValue(parser, JsonParser.Event.VALUE_FALSE);
        JSONP_Util.testNullValue(parser, JsonParser.Event.VALUE_NULL);
        JSONP_Util.testEventType(parser, JsonParser.Event.START_OBJECT);
        JSONP_Util.testKeyStringValue(parser, "name", "value");
        JSONP_Util.testEventType(parser, JsonParser.Event.END_OBJECT);
        JSONP_Util.testEventType(parser, JsonParser.Event.START_ARRAY);
        JSONP_Util.testStringValue(parser, "one");
        JSONP_Util.testStringValue(parser, "two");
        JSONP_Util.testEventType(parser, JsonParser.Event.END_ARRAY);
        JSONP_Util.testEventType(parser, JsonParser.Event.END_ARRAY);
        JSONP_Util.testIntegerValue(parser, 100);
        JSONP_Util.testIntegerValue(parser, -100);
        JSONP_Util.testLongValue(parser, Long.MAX_VALUE);
        JSONP_Util.testLongValue(parser, Long.MIN_VALUE);
        JSONP_Util.testDoubleValue(parser, 0.5);
        JSONP_Util.testDoubleValue(parser, -0.5);
        JSONP_Util.testDoubleValue(parser, 7000.0);
        JSONP_Util.testDoubleValue(parser, 7000.0);
        JSONP_Util.testDoubleValue(parser, 9000.0);
        JSONP_Util.testDoubleValue(parser, 9000.0);
        JSONP_Util.testDoubleValue(parser, 0.007);
        JSONP_Util.testDoubleValue(parser, 0.007);
        JSONP_Util.testStringValue(parser, "!@#$%^&*()_+|~1234567890-=;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM");
        JSONP_Util.testEventType(parser, JsonParser.Event.END_ARRAY);
        int parseErrs = JSONP_Util.getParseErrs();
        if (parseErrs != 0) {
            this.logErr("There were " + parseErrs + " parser errors that occurred.");
            pass = false;
        }
        return pass;
    }

    private boolean parseAndVerify_JsonHelloWorld(JsonParser parser) throws Exception {
        boolean pass = true;
        JSONP_Util.resetParseErrs();
        JSONP_Util.testEventType(parser, JsonParser.Event.START_OBJECT);
        JSONP_Util.testKeyStartObjectValue(parser, "greetingObj");
        JSONP_Util.dumpLocation(parser);
        JSONP_Util.testKeyStringValue(parser, "hello", "world");
        JSONP_Util.dumpLocation(parser);
        JSONP_Util.testEventType(parser, JsonParser.Event.END_OBJECT);
        JSONP_Util.dumpLocation(parser);
        JSONP_Util.testKeyStartArrayValue(parser, "greetingArr");
        JSONP_Util.dumpLocation(parser);
        JSONP_Util.testStringValue(parser, "hello");
        JSONP_Util.dumpLocation(parser);
        JSONP_Util.testStringValue(parser, "world");
        JSONP_Util.dumpLocation(parser);
        JSONP_Util.testEventType(parser, JsonParser.Event.END_ARRAY);
        JSONP_Util.dumpLocation(parser);
        JSONP_Util.testEventType(parser, JsonParser.Event.END_OBJECT);
        JSONP_Util.dumpLocation(parser);
        int parseErrs = JSONP_Util.getParseErrs();
        if (parseErrs != 0) {
            this.logErr("There were " + parseErrs + " parser errors that occurred.");
            pass = false;
        }
        return pass;
    }

    public void jsonParserTest1() throws EETest.Fault {
        boolean pass = true;
        JsonParser parser = null;
        Object event = null;
        try {
            this.logMsg("-------------------------------------");
            this.logMsg("TEST CASE [Json.createParser(Reader)]");
            this.logMsg("-------------------------------------");
            this.logMsg("Create Reader from (JSONP_Data.jsonObjectWithAllTypesOfData)");
            StringReader reader = new StringReader("{\"emptyString\" : \"\",\"emptyArray\" : [],\"emptyObject\" : {},\"string\" : \"string\",\"number\" :  100,\"true\" : true,\"false\" : false,\"null\" : null,\"object\" : {\"emptyString\" : \"\",\"emptyArray\" : [],\"emptyObject\" : {},\"string\" : \"string\",\"number\" :  100,\"true\" : true,\"false\" : false,\"null\" : null,\"object\" : { \"name\" : \"value\" },\"array\" : [ \"one\", \"two\" ]},\"array\" : [ \"string\", 100, true, false, null, { \"name\" : \"value\" }, [ \"one\", \"two\" ] ],\"intPositive\" : 100,\"intNegative\" : -100,\"longMax\"     : 9223372036854775807,\"longMin\"     : -9223372036854775808,\"fracPositive\" : 0.5,\"fracNegative\" : -0.5,\"expPositive1\" : 7e3,\"expPositive2\" : 7e+3,\"expPositive3\" : 9E3,\"expPositive4\" : 9E+3,\"expNegative1\" : 7e-3,\"expNegative2\" : 7E-3,\"asciiChars\" : \"!@#$%^&*()_+|~1234567890-=;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM\"}");
            this.logMsg("Create JsonParser from the Reader");
            parser = Json.createParser((Reader)reader);
            this.logMsg("Verify that JSON Parser Events/Data matches (JSONP_Data.jsonObjectWithAllTypesOfData)");
            pass = this.parseAndVerify_JsonObjectWithAllTypesOfData(parser);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonParserTest1 Failed: ", e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("jsonParserTest1 Failed");
        }
    }

    public void jsonParserTest2() throws EETest.Fault {
        boolean pass = true;
        JsonParser parser = null;
        Object event = null;
        try {
            this.logMsg("----------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createParserFactory(Map<String,?>).createParser(JsonObject)]");
            this.logMsg("----------------------------------------------------------------------------");
            this.logMsg("Create JsonObject from (JSONP_Data.jsonObjectWithAllTypesOfData)");
            JsonObject jsonObj = JSONP_Util.createJsonObjectFromString("{\"emptyString\" : \"\",\"emptyArray\" : [],\"emptyObject\" : {},\"string\" : \"string\",\"number\" :  100,\"true\" : true,\"false\" : false,\"null\" : null,\"object\" : {\"emptyString\" : \"\",\"emptyArray\" : [],\"emptyObject\" : {},\"string\" : \"string\",\"number\" :  100,\"true\" : true,\"false\" : false,\"null\" : null,\"object\" : { \"name\" : \"value\" },\"array\" : [ \"one\", \"two\" ]},\"array\" : [ \"string\", 100, true, false, null, { \"name\" : \"value\" }, [ \"one\", \"two\" ] ],\"intPositive\" : 100,\"intNegative\" : -100,\"longMax\"     : 9223372036854775807,\"longMin\"     : -9223372036854775808,\"fracPositive\" : 0.5,\"fracNegative\" : -0.5,\"expPositive1\" : 7e3,\"expPositive2\" : 7e+3,\"expPositive3\" : 9E3,\"expPositive4\" : 9E+3,\"expNegative1\" : 7e-3,\"expNegative2\" : 7E-3,\"asciiChars\" : \"!@#$%^&*()_+|~1234567890-=;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM\"}");
            JSONP_Util.dumpJsonObject(jsonObj);
            this.logMsg("Create JsonParser from the JsonObject");
            parser = Json.createParserFactory(JSONP_Util.getEmptyConfig()).createParser(jsonObj);
            this.logMsg("parser=" + parser);
            this.logMsg("Verify that JSON Parser Events/Data matches (JSONP_Data.jsonObjectWithAllTypesOfData)");
            pass = this.parseAndVerify_JsonObjectWithAllTypesOfData(parser);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonParserTest2 Failed: ", e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("jsonParserTest2 Failed");
        }
    }

    public void jsonParserTest3() throws EETest.Fault {
        boolean pass = true;
        JsonParser parser = null;
        Object event = null;
        try {
            this.logMsg("-------------------------------------------");
            this.logMsg("TEST CASE [Json.createParser(Reader) again]");
            this.logMsg("-------------------------------------------");
            this.logMsg("Create Reader from (JSONP_Data.jsonObjectWithLotsOfNestedObjectsData)");
            StringReader reader = new StringReader("{\"nested1\" : {\"name1\" : \"value1\",\"nested2\" : {\"name2\" : \"value2\",\"nested3\" : {\"name3\" : \"value3\",\"nested4\" : {\"name4\" : \"value4\",\"nested5\" : {\"name5\" : \"value5\",\"nested6\" : {\"name6\" : \"value6\",\"nested7\" : {\"name7\" : \"value7\",\"nested8\" : {\"name8\" : \"value8\",\"nested9\" : {\"name9\" : \"value9\",\"nested10\" : {\"name10\" : \"value10\",\"nested11\" : {\"name11\" : \"value11\",\"nested12\" : {\"name12\" : \"value12\",\"nested13\" : {\"name13\" : \"value13\",\"nested14\" : {\"name14\" : \"value14\",\"nested15\" : {\"name15\" : \"value15\",\"nested16\" : {\"name16\" : \"value16\",\"nested17\" : {\"name17\" : \"value17\",\"nested18\" : {\"name18\" : \"value18\",\"nested19\" : {\"name19\" : \"value19\",\"nested20\" : {\"name20\" : \"value20\",\"nested21\" : {\"name21\" : \"value21\",\"nested22\" : {\"name22\" : \"value22\",\"nested23\" : {\"name23\" : \"value23\",\"nested24\" : {\"name24\" : \"value24\",\"nested25\" : {\"name25\" : \"value25\",\"nested26\" : {\"name26\" : \"value26\",\"nested27\" : {\"name27\" : \"value27\",\"nested28\" : {\"name28\" : \"value28\",\"nested29\" : {\"name29\" : \"value29\",\"nested30\" : {\"name30\" : \"value30\"}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}");
            this.logMsg("Create JsonParser from the Reader");
            parser = Json.createParser((Reader)reader);
            this.logMsg("Verify that JSON Parser Events/Data matches (JSONP_Data.jsonObjectWithLotsOfNestedObjectsData)");
            pass = this.parseAndVerify_JsonObjectWithLotsOfNestedObjectsData(parser);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonParserTest3 Failed: ", e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("jsonParserTest3 Failed");
        }
    }

    public void jsonParserTest4() throws EETest.Fault {
        boolean pass = true;
        JsonParser parser = null;
        Object event = null;
        try {
            this.logMsg("-----------------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createParserFactory(Map<String,?>).createParser(JsonObject object) again]");
            this.logMsg("-----------------------------------------------------------------------------------------");
            this.logMsg("Create JsonObject from (JSONP_Data.jsonObjectWithLotsOfNestedObjectsData)");
            JsonObject jsonObj = JSONP_Util.createJsonObjectFromString("{\"nested1\" : {\"name1\" : \"value1\",\"nested2\" : {\"name2\" : \"value2\",\"nested3\" : {\"name3\" : \"value3\",\"nested4\" : {\"name4\" : \"value4\",\"nested5\" : {\"name5\" : \"value5\",\"nested6\" : {\"name6\" : \"value6\",\"nested7\" : {\"name7\" : \"value7\",\"nested8\" : {\"name8\" : \"value8\",\"nested9\" : {\"name9\" : \"value9\",\"nested10\" : {\"name10\" : \"value10\",\"nested11\" : {\"name11\" : \"value11\",\"nested12\" : {\"name12\" : \"value12\",\"nested13\" : {\"name13\" : \"value13\",\"nested14\" : {\"name14\" : \"value14\",\"nested15\" : {\"name15\" : \"value15\",\"nested16\" : {\"name16\" : \"value16\",\"nested17\" : {\"name17\" : \"value17\",\"nested18\" : {\"name18\" : \"value18\",\"nested19\" : {\"name19\" : \"value19\",\"nested20\" : {\"name20\" : \"value20\",\"nested21\" : {\"name21\" : \"value21\",\"nested22\" : {\"name22\" : \"value22\",\"nested23\" : {\"name23\" : \"value23\",\"nested24\" : {\"name24\" : \"value24\",\"nested25\" : {\"name25\" : \"value25\",\"nested26\" : {\"name26\" : \"value26\",\"nested27\" : {\"name27\" : \"value27\",\"nested28\" : {\"name28\" : \"value28\",\"nested29\" : {\"name29\" : \"value29\",\"nested30\" : {\"name30\" : \"value30\"}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}");
            JSONP_Util.dumpJsonObject(jsonObj);
            this.logMsg("Create JsonParser from the JsonObject");
            parser = Json.createParserFactory(JSONP_Util.getEmptyConfig()).createParser(jsonObj);
            this.logMsg("Verify that JSON Parser Events/Data matches (JSONP_Data.jsonObjectWithLotsOfNestedObjectsData)");
            pass = this.parseAndVerify_JsonObjectWithLotsOfNestedObjectsData(parser);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonParserTest4 Failed: ", e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("jsonParserTest4 Failed");
        }
    }

    public void jsonParserTest5() throws EETest.Fault {
        boolean pass = true;
        JsonParser parser = null;
        Object event = null;
        try {
            this.logMsg("---------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createParserFactory(Map<String,?>).createParser(JsonArray)]");
            this.logMsg("---------------------------------------------------------------------------");
            this.logMsg("Create JsonArray from (JSONP_Data.jsonArrayWithMultipleArraysData)");
            JsonArray jsonArr = JSONP_Util.createJsonArrayFromString("[ \"string\", 100, true, false, null, { \"object\" : \"object\" }, [ \"one\",\"two\" ], [ 100, 7e7, true, false, null, { \"object2\" : \"object2\" } ] ]");
            JSONP_Util.dumpJsonArray(jsonArr);
            this.logMsg("Create JsonParser from the JsonArray");
            parser = Json.createParserFactory(JSONP_Util.getEmptyConfig()).createParser(jsonArr);
            this.logMsg("Verify that JSON Parser Events/Data matches (JSONP_Data.jsonArrayWithMultipleArraysData)");
            pass = this.parseAndVerify_JsonArrayWithMultipleArraysData(parser);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonParserTest5 Failed: ", e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("jsonParserTest5 Failed");
        }
    }

    public void jsonParserTest6() throws EETest.Fault {
        boolean pass = true;
        JsonParser parser = null;
        Object event = null;
        try {
            this.logMsg("------------------------------------------");
            this.logMsg("TEST CASE [Json.createParser(InputStream)]");
            this.logMsg("------------------------------------------");
            this.logMsg("Get InputStream from data file as resource (jsonArrayWithAllTypesOfData.json)");
            InputStream istream = JSONP_Util.getInputStreamFromResource("jsonArrayWithAllTypesOfData.json");
            this.logMsg("Create JsonParser from the InputStream");
            parser = Json.createParser((InputStream)istream);
            this.logMsg("Verify that JSON Parser Events/Data matches (jsonArrayWithAllTypesOfData.json)");
            pass = this.parseAndVerify_JsonArrayWithAllTypesOfData(parser);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonParserTest6 Failed: ", e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("jsonParserTest6 Failed");
        }
    }

    public void jsonParserTest7() throws EETest.Fault {
        boolean pass = true;
        JsonParser parser = null;
        Object event = null;
        try {
            this.logMsg("-------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createParserFactory(Map<String, ?>).createParser(Reader)]");
            this.logMsg("-------------------------------------------------------------------------");
            this.logMsg("Create a Reader from (JSONP_Data.jsonObjectWithAllTypesOfData)");
            StringReader reader = new StringReader("{\"emptyString\" : \"\",\"emptyArray\" : [],\"emptyObject\" : {},\"string\" : \"string\",\"number\" :  100,\"true\" : true,\"false\" : false,\"null\" : null,\"object\" : {\"emptyString\" : \"\",\"emptyArray\" : [],\"emptyObject\" : {},\"string\" : \"string\",\"number\" :  100,\"true\" : true,\"false\" : false,\"null\" : null,\"object\" : { \"name\" : \"value\" },\"array\" : [ \"one\", \"two\" ]},\"array\" : [ \"string\", 100, true, false, null, { \"name\" : \"value\" }, [ \"one\", \"two\" ] ],\"intPositive\" : 100,\"intNegative\" : -100,\"longMax\"     : 9223372036854775807,\"longMin\"     : -9223372036854775808,\"fracPositive\" : 0.5,\"fracNegative\" : -0.5,\"expPositive1\" : 7e3,\"expPositive2\" : 7e+3,\"expPositive3\" : 9E3,\"expPositive4\" : 9E+3,\"expNegative1\" : 7e-3,\"expNegative2\" : 7E-3,\"asciiChars\" : \"!@#$%^&*()_+|~1234567890-=;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM\"}");
            this.logMsg("Create JsonParser using Reader and a configuration");
            parser = Json.createParserFactory(JSONP_Util.getEmptyConfig()).createParser((Reader)reader);
            this.logMsg("Call JsonParser.toString() to print the JsonObject");
            parser.toString();
            this.logMsg("Verify that JSON Parser Events/Data matches (JSONP_Data.jsonObjectWithAllTypesOfData)");
            if (!this.parseAndVerify_JsonObjectWithAllTypesOfData(parser)) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonParserTest7 Failed: ", e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("jsonParserTest7 Failed");
        }
    }

    public void jsonParserTest8() throws EETest.Fault {
        boolean pass = true;
        JsonParser parser = null;
        Object event = null;
        try {
            this.logMsg("----------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createParserFactory(Map<String, ?>).createParser(JsonArray)]");
            this.logMsg("----------------------------------------------------------------------------");
            this.logMsg("Create a JsonArray from (JSONP_Data.jsonArrayWithLotsOfNestedObjectsData)");
            JsonArray jsonArr = JSONP_Util.createJsonArrayFromString("[{\"name1\" : \"value1\",\"nested2\" : {\"name2\" : \"value2\",\"nested3\" : {\"name3\" : \"value3\",\"nested4\" : {\"name4\" : \"value4\",\"nested5\" : {\"name5\" : \"value5\",\"nested6\" : {\"name6\" : \"value6\",\"nested7\" : {\"name7\" : \"value7\",\"nested8\" : {\"name8\" : \"value8\",\"nested9\" : {\"name9\" : \"value9\",\"nested10\" : {\"name10\" : \"value10\",\"nested11\" : {\"name11\" : \"value11\",\"nested12\" : {\"name12\" : \"value12\",\"nested13\" : {\"name13\" : \"value13\",\"nested14\" : {\"name14\" : \"value14\",\"nested15\" : {\"name15\" : \"value15\",\"nested16\" : {\"name16\" : \"value16\",\"nested17\" : {\"name17\" : \"value17\",\"nested18\" : {\"name18\" : \"value18\",\"nested19\" : {\"name19\" : \"value19\",\"nested20\" : {\"name20\" : \"value20\",\"nested21\" : {\"name21\" : \"value21\",\"nested22\" : {\"name22\" : \"value22\",\"nested23\" : {\"name23\" : \"value23\",\"nested24\" : {\"name24\" : \"value24\",\"nested25\" : {\"name25\" : \"value25\",\"nested26\" : {\"name26\" : \"value26\",\"nested27\" : {\"name27\" : \"value27\",\"nested28\" : {\"name28\" : \"value28\",\"nested29\" : {\"name29\" : \"value29\",\"nested30\" : {\"name30\" : \"value30\"}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}]");
            JSONP_Util.dumpJsonArray(jsonArr);
            this.logMsg("Create JsonParser using JsonArray and a configuration");
            parser = Json.createParserFactory(JSONP_Util.getEmptyConfig()).createParser(jsonArr);
            this.logMsg("Call JsonParser.toString() to print the JsonObject");
            parser.toString();
            this.logMsg("Verify that JSON Parser Events/Data matches (JSONP_Data.jsonArrayWithLotsOfNestedObjectsData)");
            if (!this.parseAndVerify_JsonArrayWithLotsOfNestedObjectsData(parser)) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonParserTest8 Failed: ", e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("jsonParserTest8 Failed");
        }
    }

    public void jsonParserTest9() throws EETest.Fault {
        boolean pass = true;
        JsonParser parser = null;
        Object event = null;
        try {
            this.logMsg("----------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createParserFactory(Map<String, ?>).createParser(JsonArray)]");
            this.logMsg("----------------------------------------------------------------------------");
            this.logMsg("Create JsonArray from (JSONP_Data.jsonArrayWithMultipleArraysData)");
            JsonArray jsonArr = JSONP_Util.createJsonArrayFromString("[ \"string\", 100, true, false, null, { \"object\" : \"object\" }, [ \"one\",\"two\" ], [ 100, 7e7, true, false, null, { \"object2\" : \"object2\" } ] ]");
            JSONP_Util.dumpJsonArray(jsonArr);
            this.logMsg("Create JsonParser using JsonArray and a configuration");
            parser = Json.createParserFactory(JSONP_Util.getEmptyConfig()).createParser(jsonArr);
            this.logMsg("Call JsonParser.toString() to print the JsonArray");
            parser.toString();
            this.logMsg("Verify that JSON Parser Events/Data matches (JSONP_Data.jsonArrayWithMultipleArraysData)");
            if (!this.parseAndVerify_JsonArrayWithMultipleArraysData(parser)) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonParserTest9 Failed: ", e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("jsonParserTest9 Failed");
        }
    }

    public void jsonParserTest10() throws EETest.Fault {
        boolean pass = true;
        JsonParser parser = null;
        Object event = null;
        try {
            this.logMsg("------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createParserFactory(Map<String, ?>).createParser(InputStream)]");
            this.logMsg("------------------------------------------------------------------------------");
            this.logMsg("Create JsonParser using InputStream and a configuration");
            InputStream istream = JSONP_Util.getInputStreamFromResource("jsonObjectWithLotsOfNestedObjectsData.json");
            parser = Json.createParserFactory(JSONP_Util.getEmptyConfig()).createParser(istream);
            this.logMsg("Call JsonParser.toString() to print the JsonObject");
            parser.toString();
            this.logMsg("Verify that JSON Parser Events/Data matches (jsonObjectWithLotsOfNestedObjectsData.json)");
            if (!this.parseAndVerify_JsonObjectWithLotsOfNestedObjectsData(parser)) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonParserTest10 Failed: ", e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("jsonParserTest10 Failed");
        }
    }

    public void jsonParserTest11() throws EETest.Fault {
        boolean pass = true;
        JsonParser parser = null;
        Object event = null;
        try {
            this.logMsg("--------------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createParserFactory(Map<String,?>).createParser(InputStream, Charset)]");
            this.logMsg("--------------------------------------------------------------------------------------");
            this.logMsg("Get InputStream from data file as resource (jsonArrayWithAllTypesOfDataUTF16BE.json)");
            InputStream istream = JSONP_Util.getInputStreamFromResource("jsonArrayWithAllTypesOfDataUTF16BE.json");
            this.logMsg("Create JsonParser from the InputStream with character encoding UTF-16BE");
            parser = Json.createParserFactory(JSONP_Util.getEmptyConfig()).createParser(istream, JSONP_Util.UTF_16BE);
            this.logMsg("Verify that JSON Parser Events/Data matches (jsonArrayWithAllTypesOfDataUTF16BE.json)");
            pass = this.parseAndVerify_JsonArrayWithAllTypesOfData(parser);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonParserTest11 Failed: ", e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("jsonParserTest11 Failed");
        }
    }

    public void jsonParserTest12() throws EETest.Fault {
        boolean pass = true;
        JsonParser parser = null;
        Object event = null;
        try {
            this.logMsg("---------------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createParserFactory(Map<String, ?>).createParser(InputStream, Charset)]");
            this.logMsg("---------------------------------------------------------------------------------------");
            this.logMsg("Get InputStream from data file as resource (jsonArrayWithLotsOfNestedArraysData.json)");
            InputStream istream = JSONP_Util.getInputStreamFromResource("jsonArrayWithLotsOfNestedArraysData.json");
            this.logMsg("Create JsonParser from the InputStream with character encoding UTF-8 and a configuration");
            parser = Json.createParserFactory(JSONP_Util.getEmptyConfig()).createParser(istream, JSONP_Util.UTF_8);
            this.logMsg("Verify that JSON Parser Events/Data matches (jsonArrayWithLotsOfNestedArraysData.json)");
            if (!this.parseAndVerify_JsonArrayWithLotsOfNestedArraysData(parser)) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonParserTest12 Failed: ", e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("jsonParserTest12 Failed");
        }
    }

    public void jsonParserTest13() throws EETest.Fault {
        boolean pass = true;
        JsonParser parser = null;
        Object event = null;
        try {
            this.logMsg("---------------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createParserFactory(Map<String, ?>).createParser(InputStream, Charset)]");
            this.logMsg("---------------------------------------------------------------------------------------");
            this.logMsg("Get InputStream from data file as resource (jsonObjectWithAllTypesOfDataUTF16LE.json)");
            InputStream istream = JSONP_Util.getInputStreamFromResource("jsonObjectWithAllTypesOfDataUTF16LE.json");
            this.logMsg("Create JsonParser from the InputStream using UTF-16LE encoding");
            parser = Json.createParserFactory(JSONP_Util.getEmptyConfig()).createParser(istream, JSONP_Util.UTF_16LE);
            this.logMsg("Verify that JSON Parser Events/Data matches (jsonObjectWithAllTypesOfDataUTF16LE.json)");
            pass = this.parseAndVerify_JsonObjectWithAllTypesOfData(parser);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonParserTest13 Failed: ", e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("jsonParserTest13 Failed");
        }
    }

    public void jsonParserTest14() throws EETest.Fault {
        boolean pass = true;
        JsonParser parser = null;
        Object event = null;
        try {
            this.logMsg("------------------------------------------");
            this.logMsg("TEST CASE [Json.createParser(InputStream)]");
            this.logMsg("------------------------------------------");
            this.logMsg("Get InputStream from data file as resource (jsonHelloWorld.json)");
            InputStream istream = JSONP_Util.getInputStreamFromResource("jsonHelloWorld.json");
            this.logMsg("Create JsonParser from the InputStream");
            parser = Json.createParser((InputStream)istream);
            this.logMsg("Verify that JSON Parser Events/Data matches (jsonHelloWorld.json)");
            pass = this.parseAndVerify_JsonHelloWorld(parser);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonParserTest14 Failed: ", e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("jsonParserTest14 Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseUTFEncodedTests() throws EETest.Fault {
        InputStream istream;
        boolean pass = true;
        JsonParser parser = null;
        Object event = null;
        try {
            this.logMsg("-----------------------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createParserFactory(Map<String,?>).createParser(InputStream, Charset) as UTF-8]");
            this.logMsg("-----------------------------------------------------------------------------------------------");
            this.logMsg("Get InputStream from data file as resource (jsonObjectEncodingUTF8.json)");
            istream = JSONP_Util.getInputStreamFromResource("jsonObjectEncodingUTF8.json");
            this.logMsg("Create JsonParser from the InputStream with character encoding UTF-8");
            parser = Json.createParserFactory(JSONP_Util.getEmptyConfig()).createParser(istream, JSONP_Util.UTF_8);
            this.logMsg("Verify that JSON Parser Events/Data matches (jsonObjectEncodingUTF8.json)");
            if (!this.parseAndVerify_JsonObjectUTF(parser)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing parsing of UTF-8 encoding: " + e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception e) {}
        }
        try {
            this.logMsg("------------------------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createParserFactory(Map<String,?>).createParser(InputStream, Charset) as UTF-16]");
            this.logMsg("------------------------------------------------------------------------------------------------");
            this.logMsg("Get InputStream from data file as resource (jsonObjectEncodingUTF16.json)");
            istream = JSONP_Util.getInputStreamFromResource("jsonObjectEncodingUTF16.json");
            this.logMsg("Create JsonParser from the InputStream with character encoding UTF-16");
            parser = Json.createParserFactory(JSONP_Util.getEmptyConfig()).createParser(istream, JSONP_Util.UTF_16);
            this.logMsg("Verify that JSON Parser Events/Data matches (jsonObjectEncodingUTF16.json)");
            if (!this.parseAndVerify_JsonObjectUTF(parser)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing parsing of UTF-16 encoding: " + e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception e) {}
        }
        try {
            this.logMsg("--------------------------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createParserFactory(Map<String,?>).createParser(InputStream, Charset) as UTF-16LE]");
            this.logMsg("--------------------------------------------------------------------------------------------------");
            this.logMsg("Get InputStream from data file as resource (jsonObjectEncodingUTF16LE.json)");
            istream = JSONP_Util.getInputStreamFromResource("jsonObjectEncodingUTF16LE.json");
            this.logMsg("Create JsonParser from the InputStream with character encoding UTF-16LE");
            parser = Json.createParserFactory(JSONP_Util.getEmptyConfig()).createParser(istream, JSONP_Util.UTF_16LE);
            this.logMsg("Verify that JSON Parser Events/Data matches (jsonObjectEncodingUTF16LE.json)");
            if (!this.parseAndVerify_JsonObjectUTF(parser)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing parsing of UTF-16LE encoding: " + e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception e) {}
        }
        try {
            this.logMsg("--------------------------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createParserFactory(Map<String,?>).createParser(InputStream, Charset) as UTF-16BE]");
            this.logMsg("--------------------------------------------------------------------------------------------------");
            this.logMsg("Get InputStream from data file as resource (jsonObjectEncodingUTF16BE.json)");
            istream = JSONP_Util.getInputStreamFromResource("jsonObjectEncodingUTF16BE.json");
            this.logMsg("Create JsonParser from the InputStream with character encoding UTF-16BE");
            parser = Json.createParserFactory(JSONP_Util.getEmptyConfig()).createParser(istream, JSONP_Util.UTF_16BE);
            this.logMsg("Verify that JSON Parser Events/Data matches (jsonObjectEncodingUTF16BE.json)");
            if (!this.parseAndVerify_JsonObjectUTF(parser)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing parsing of UTF-16BE encoding: " + e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception e) {}
        }
        try {
            this.logMsg("--------------------------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createParserFactory(Map<String,?>).createParser(InputStream, Charset) as UTF-32LE]");
            this.logMsg("--------------------------------------------------------------------------------------------------");
            this.logMsg("Get InputStream from data file as resource (jsonObjectEncodingUTF32LE.json)");
            istream = JSONP_Util.getInputStreamFromResource("jsonObjectEncodingUTF32LE.json");
            this.logMsg("Create JsonParser from the InputStream with character encoding UTF-32LE");
            parser = Json.createParserFactory(JSONP_Util.getEmptyConfig()).createParser(istream, JSONP_Util.UTF_32LE);
            this.logMsg("Verify that JSON Parser Events/Data matches (jsonObjectEncodingUTF32LE.json)");
            if (!this.parseAndVerify_JsonObjectUTF(parser)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing parsing of UTF-32LE encoding: " + e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception e) {}
        }
        try {
            this.logMsg("-------------------------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createParserFactory(Map<String,?>).createParser(InputStream, Charset) as UTF-32BE]");
            this.logMsg("-------------------------------------------------------------------------------------------------");
            this.logMsg("Get InputStream from data file as resource (jsonObjectEncodingUTF32BE.json)");
            istream = JSONP_Util.getInputStreamFromResource("jsonObjectEncodingUTF32BE.json");
            this.logMsg("Create JsonParser from the InputStream with character encoding UTF-32BE");
            parser = Json.createParserFactory(JSONP_Util.getEmptyConfig()).createParser(istream, JSONP_Util.UTF_32BE);
            this.logMsg("Verify that JSON Parser Events/Data matches (jsonObjectEncodingUTF32BE.json)");
            if (!this.parseAndVerify_JsonObjectUTF(parser)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing parsing of UTF-32BE encoding: " + e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("parseUTFEncodedTests Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseUTFEncodedTests2() throws EETest.Fault {
        InputStream istream;
        boolean pass = true;
        JsonParser parser = null;
        Object event = null;
        try {
            this.logMsg("-------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createParser(InputStream) and auto-detect as UTF-8]");
            this.logMsg("-------------------------------------------------------------------");
            this.logMsg("Get InputStream from data file as resource (jsonObjectEncodingUTF8.json)");
            istream = JSONP_Util.getInputStreamFromResource("jsonObjectEncodingUTF8.json");
            this.logMsg("Create JsonParser from the InputStream and auto-detect character encoding UTF-8");
            parser = Json.createParser((InputStream)istream);
            this.logMsg("Verify that JSON Parser Events/Data matches (jsonObjectEncodingUTF8.json)");
            if (!this.parseAndVerify_JsonObjectUTF(parser)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing parsing of UTF-8 encoding: " + e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception e) {}
        }
        try {
            this.logMsg("----------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createParser(InputStream) and auto-detect as UTF-16LE]");
            this.logMsg("----------------------------------------------------------------------");
            this.logMsg("Get InputStream from data file as resource (jsonObjectEncodingUTF16LE.json)");
            istream = JSONP_Util.getInputStreamFromResource("jsonObjectEncodingUTF16LE.json");
            this.logMsg("Create JsonParser from the InputStream and auto-detect character encoding UTF-16LE");
            parser = Json.createParser((InputStream)istream);
            this.logMsg("Verify that JSON Parser Events/Data matches (jsonObjectEncodingUTF16LE.json)");
            if (!this.parseAndVerify_JsonObjectUTF(parser)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing parsing of UTF-16LE encoding: " + e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception e) {}
        }
        try {
            this.logMsg("----------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createParser(InputStream) and auto-detect as UTF-16BE]");
            this.logMsg("----------------------------------------------------------------------");
            this.logMsg("Get InputStream from data file as resource (jsonObjectEncodingUTF16BE.json)");
            istream = JSONP_Util.getInputStreamFromResource("jsonObjectEncodingUTF16BE.json");
            this.logMsg("Create JsonParser from the InputStream and auto-detect character encoding UTF-16BE");
            parser = Json.createParser((InputStream)istream);
            this.logMsg("Verify that JSON Parser Events/Data matches (jsonObjectEncodingUTF16BE.json)");
            if (!this.parseAndVerify_JsonObjectUTF(parser)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing parsing of UTF-16BE encoding: " + e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception e) {}
        }
        try {
            this.logMsg("----------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createParser(InputStream) and auto-detect as UTF-32LE]");
            this.logMsg("----------------------------------------------------------------------");
            this.logMsg("Get InputStream from data file as resource (jsonObjectEncodingUTF32LE.json)");
            istream = JSONP_Util.getInputStreamFromResource("jsonObjectEncodingUTF32LE.json");
            this.logMsg("Create JsonParser from the InputStream and auto-detect character encoding UTF-32LE");
            parser = Json.createParser((InputStream)istream);
            this.logMsg("Verify that JSON Parser Events/Data matches (jsonObjectEncodingUTF32LE.json)");
            if (!this.parseAndVerify_JsonObjectUTF(parser)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing parsing of UTF-32LE encoding: " + e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception e) {}
        }
        try {
            this.logMsg("----------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createParser(InputStream) and auto-detect as UTF-32BE]");
            this.logMsg("----------------------------------------------------------------------");
            this.logMsg("Get InputStream from data file as resource (jsonObjectEncodingUTF32BE.json)");
            istream = JSONP_Util.getInputStreamFromResource("jsonObjectEncodingUTF32BE.json");
            this.logMsg("Create JsonParser from the InputStream and auto-detect character encoding UTF-32BE");
            parser = Json.createParser((InputStream)istream);
            this.logMsg("Verify that JSON Parser Events/Data matches (jsonObjectEncodingUTF32BE.json)");
            if (!this.parseAndVerify_JsonObjectUTF(parser)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing parsing of UTF-32BE encoding: " + e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("parseUTFEncodedTests2 Failed");
        }
    }

    public void jsonParserIsIntegralNumberTest() throws EETest.Fault {
        boolean pass = true;
        JsonParser parser = null;
        String jsonTestString = "[123, 12345.45]";
        try {
            this.logMsg("Create JsonParser");
            parser = Json.createParser((Reader)new StringReader(jsonTestString));
            JsonParser.Event event = JSONP_Util.getNextSpecificParserEvent(parser, JsonParser.Event.VALUE_NUMBER);
            JSONP_Util.dumpEventType(event);
            if (!JSONP_Util.assertEqualsJsonNumberType(parser.isIntegralNumber(), true)) {
                pass = false;
            } else if (!JSONP_Util.assertEquals(123, parser.getInt())) {
                pass = false;
            }
            event = JSONP_Util.getNextSpecificParserEvent(parser, JsonParser.Event.VALUE_NUMBER);
            JSONP_Util.dumpEventType(event);
            if (!JSONP_Util.assertEqualsJsonNumberType(parser.isIntegralNumber(), false)) {
                pass = false;
            } else if (!JSONP_Util.assertEquals(12345.45, parser.getBigDecimal().doubleValue())) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonParserIsIntegralNumberTest Failed: ", e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("jsonParserIsIntegralNumberTest Failed");
        }
    }

    private boolean tripIllegalStateException(JsonParser parser, JsonParser.Event event) {
        boolean pass = true;
        if (event == null) {
            this.logErr("event is null - unexpected.");
            return false;
        }
        this.logMsg("Event=" + JSONP_Util.getEventTypeString(event));
        this.logMsg("Testing call to JsonParser.getString()");
        if (event != JsonParser.Event.VALUE_STRING && event != JsonParser.Event.VALUE_NUMBER && event != JsonParser.Event.KEY_NAME) {
            try {
                this.logMsg("Trip IllegalStateException by calling JsonParser.getString()");
                String string = parser.getString();
                pass = false;
                this.logErr("Failed to throw IllegalStateException");
            }
            catch (IllegalStateException e) {
                this.logMsg("Got expected IllegalStateException");
            }
            catch (Exception e) {
                pass = false;
                this.logErr("Caught unexpected exception: " + e);
            }
        } else {
            this.logMsg("No testing for IllegalStateException for this scenario.");
        }
        this.logMsg("Testing call to JsonParser.isIntegralNumber()");
        if (event != JsonParser.Event.VALUE_NUMBER) {
            try {
                this.logMsg("Trip IllegalStateException by calling JsonParser.isIntegralNumber()");
                boolean numberType = parser.isIntegralNumber();
                pass = false;
                this.logErr("Failed to throw IllegalStateException");
            }
            catch (IllegalStateException e) {
                this.logMsg("Got expected IllegalStateException");
            }
            catch (Exception e) {
                pass = false;
                this.logErr("Caught unexpected exception: " + e);
            }
        } else {
            this.logMsg("No testing for IllegalStateException for this scenario.");
        }
        this.logMsg("Testing call to JsonParser.getBigDecimal()");
        if (event != JsonParser.Event.VALUE_NUMBER) {
            try {
                this.logMsg("Trip IllegalStateException by calling JsonParser.getBigDecimal()");
                BigDecimal number = parser.getBigDecimal();
                pass = false;
                this.logErr("Failed to throw IllegalStateException");
            }
            catch (IllegalStateException e) {
                this.logMsg("Got expected IllegalStateException");
            }
            catch (Exception e) {
                pass = false;
                this.logErr("Caught unexpected exception: " + e);
            }
        } else {
            this.logMsg("No testing for IllegalStateException for this scenario.");
        }
        this.logMsg("Testing call to JsonParser.getInt()");
        if (event != JsonParser.Event.VALUE_NUMBER) {
            try {
                this.logMsg("Trip IllegalStateException by calling JsonParser.getInt()");
                int number = parser.getInt();
                pass = false;
                this.logErr("Failed to throw IllegalStateException");
            }
            catch (IllegalStateException e) {
                this.logMsg("Got expected IllegalStateException");
            }
            catch (Exception e) {
                pass = false;
                this.logErr("Caught unexpected exception: " + e);
            }
        } else {
            this.logMsg("No testing for IllegalStateException for this scenario.");
        }
        this.logMsg("Testing call to JsonParser.getLong()");
        if (event != JsonParser.Event.VALUE_NUMBER) {
            try {
                this.logMsg("Trip IllegalStateException by calling JsonParser.getLong()");
                long number = parser.getLong();
                pass = false;
                this.logErr("Failed to throw IllegalStateException");
            }
            catch (IllegalStateException e) {
                this.logMsg("Got expected IllegalStateException");
            }
            catch (Exception e) {
                pass = false;
                this.logErr("Caught unexpected exception: " + e);
            }
        } else {
            this.logMsg("No testing for IllegalStateException for this scenario.");
        }
        return pass;
    }

    public void jsonParserIllegalExceptionTests() throws EETest.Fault {
        boolean pass = true;
        JsonParser parser = null;
        String jsonTestString = "[\"string\",100,false,null,true,{\"foo\":\"bar\"}]";
        try {
            this.logMsg("Create JsonParser");
            parser = Json.createParserFactory(JSONP_Util.getEmptyConfig()).createParser((Reader)new StringReader(jsonTestString));
            JsonParser.Event event = JSONP_Util.getNextParserEvent(parser);
            if (!this.tripIllegalStateException(parser, event)) {
                pass = false;
            }
            if (!this.tripIllegalStateException(parser, event = JSONP_Util.getNextParserEvent(parser))) {
                pass = false;
            }
            if (!this.tripIllegalStateException(parser, event = JSONP_Util.getNextParserEvent(parser))) {
                pass = false;
            }
            if (!this.tripIllegalStateException(parser, event = JSONP_Util.getNextParserEvent(parser))) {
                pass = false;
            }
            if (!this.tripIllegalStateException(parser, event = JSONP_Util.getNextParserEvent(parser))) {
                pass = false;
            }
            if (!this.tripIllegalStateException(parser, event = JSONP_Util.getNextParserEvent(parser))) {
                pass = false;
            }
            if (!this.tripIllegalStateException(parser, event = JSONP_Util.getNextParserEvent(parser))) {
                pass = false;
            }
            if (!this.tripIllegalStateException(parser, event = JSONP_Util.getNextParserEvent(parser))) {
                pass = false;
            }
            if (!this.tripIllegalStateException(parser, event = JSONP_Util.getNextParserEvent(parser))) {
                pass = false;
            }
            if (!this.tripIllegalStateException(parser, event = JSONP_Util.getNextParserEvent(parser))) {
                pass = false;
            }
            if (!this.tripIllegalStateException(parser, event = JSONP_Util.getNextParserEvent(parser))) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonParserIllegalExceptionTests Failed: ", e);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("jsonParserIllegalExceptionTests Failed");
        }
    }

    public void jsonParserIOErrorTests() throws EETest.Fault {
        JsonParser parser;
        MyBufferedInputStream mbi;
        InputStream is;
        boolean pass = true;
        String jsonText = "{\"name1\":\"value1\",\"name2\":\"value2\"}";
        try {
            this.logMsg("Trip JsonException if there is an i/o error on Json.createParser(InputStream).");
            this.logMsg("Parsing " + jsonText);
            is = JSONP_Util.getInputStreamFromString(jsonText);
            mbi = new MyBufferedInputStream(is, true);
            this.logMsg("Calling Json.createParser(InputStream)");
            parser = Json.createParser((InputStream)mbi);
            this.logErr("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            this.logMsg("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonException if there is an i/o error on JsonParser.next().");
            this.logMsg("Parsing " + jsonText);
            is = JSONP_Util.getInputStreamFromString(jsonText);
            mbi = new MyBufferedInputStream(is, true);
            parser = Json.createParser((InputStream)mbi);
            this.logMsg("Calling JsonParser.next()");
            parser.next();
            this.logErr("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            this.logMsg("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonException if there is an i/o error on JsonParser.close().");
            this.logMsg("Parsing " + jsonText);
            is = JSONP_Util.getInputStreamFromString(jsonText);
            mbi = new MyBufferedInputStream(is);
            parser = Json.createParser((InputStream)mbi);
            mbi.setThrowIOException(true);
            this.logMsg("Calling JsonParser.close()");
            parser.close();
            this.logErr("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            this.logMsg("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonParserIOErrorTests Failed");
        }
    }

    public void jsonParserExceptionTests() throws EETest.Fault {
        JsonParser parser;
        InputStream is;
        boolean pass = true;
        try {
            this.logMsg("Trip JsonParsingException for JsonParser.next() if incorrect JSON is encountered");
            is = JSONP_Util.getInputStreamFromString("}{");
            parser = Json.createParser((InputStream)is);
            parser.next();
            this.logErr("Did not get expected JsonParsingException");
            pass = false;
        }
        catch (JsonParsingException e) {
            this.logMsg("Caught expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NoSuchElementException for JsonParser.next() if no more parsing states");
            is = JSONP_Util.getInputStreamFromString("{}");
            parser = Json.createParser((InputStream)is);
            parser.next();
            parser.next();
            parser.next();
            this.logErr("Did not get expected NoSuchElementException");
            pass = false;
        }
        catch (NoSuchElementException e) {
            this.logMsg("Caught expected NoSuchElementException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonParserExceptionTests Failed");
        }
    }

    public void invalidLiteralNamesTest() throws EETest.Fault {
        JsonParser parser;
        boolean pass = true;
        try {
            this.logMsg("Trip JsonParsingException for JsonParser.next() if invalid liternal TRUE instead of true.");
            this.logMsg("Reading [TRUE]");
            parser = Json.createParser((Reader)new StringReader("[TRUE]"));
            parser.next();
            parser.next();
            this.logErr("Did not get expected JsonParsingException");
            pass = false;
        }
        catch (JsonParsingException e) {
            this.logMsg("Caught expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonParsingException for JsonParser.next() if invalid liternal FALSE instead of false.");
            this.logMsg("Reading [FALSE]");
            parser = Json.createParser((Reader)new StringReader("[FALSE]"));
            parser.next();
            parser.next();
            this.logErr("Did not get expected JsonParsingException");
            pass = false;
        }
        catch (JsonParsingException e) {
            this.logMsg("Caught expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonParsingException for JsonParser.next() if invalid liternal NULL instead of null.");
            this.logMsg("Reading [NULL]");
            parser = Json.createParser((Reader)new StringReader("[NULL]"));
            parser.next();
            parser.next();
            this.logErr("Did not get expected JsonParsingException");
            pass = false;
        }
        catch (JsonParsingException e) {
            this.logMsg("Caught expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        if (!pass) {
            throw new EETest.Fault("invalidLiteralNamesTest Failed");
        }
    }

    public void jsonParser11Test() throws EETest.Fault {
        Parser parserTest = new Parser();
        TestResult result = parserTest.test();
        result.eval();
    }
}

