/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.criteriaapi.CriteriaBuilder;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.schema30.Address;
import com.sun.ts.tests.jpa.common.schema30.Alias;
import com.sun.ts.tests.jpa.common.schema30.Customer;
import com.sun.ts.tests.jpa.common.schema30.Customer_;
import com.sun.ts.tests.jpa.common.schema30.HardwareProduct;
import com.sun.ts.tests.jpa.common.schema30.LineItem;
import com.sun.ts.tests.jpa.common.schema30.Order_;
import com.sun.ts.tests.jpa.common.schema30.Product;
import com.sun.ts.tests.jpa.common.schema30.ShelfLife;
import com.sun.ts.tests.jpa.common.schema30.SoftwareProduct;
import com.sun.ts.tests.jpa.common.schema30.SoftwareProduct_;
import com.sun.ts.tests.jpa.common.schema30.Spouse;
import com.sun.ts.tests.jpa.common.schema30.Trim;
import com.sun.ts.tests.jpa.common.schema30.Util;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.persistence.Parameter;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;

public class Client
extends Util {
    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.getEntityManager();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void createQuery() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery();
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            pass = true;
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("createQuery Test  failed");
        }
    }

    public void createQuery2() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            pass = true;
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("createQuery2 Test  failed");
        }
    }

    public void createTuple() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query Tuple");
            pass = true;
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query Tuple");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("createTuple Test  failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void construct() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[16].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            cquery.select((Selection)cbuilder.construct(Customer.class, new Selection[]{customer.get(Customer_.getSingularAttribute("id", String.class)), customer.get(Customer_.getSingularAttribute("name", String.class))})).where((Expression)cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("city", String.class)), (Object)"Roslindale"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List actual = tq.getResultList();
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("construct Test  failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void tupleIntTest() throws EETest.Fault {
        boolean pass1 = true;
        boolean pass2 = false;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        for (Customer c : this.customerRef) {
            expected.add(Integer.valueOf(c.getId()));
        }
        Collections.sort(expected);
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            TestUtil.logTrace((String)"Use Tuple Query");
            cquery.multiselect(new Selection[]{customer.get(Customer_.getSingularAttribute("id", String.class)), customer.get(Customer_.getSingularAttribute("name", String.class))});
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Tuple t : result) {
                Integer id = Integer.valueOf((String)t.get(0));
                String name = (String)t.get(1);
                if (name != null) {
                    if (this.customerRef[id - 1].getName().equals(name)) {
                        actual.add(id);
                        continue;
                    }
                    TestUtil.logErr((String)("Expected name:|" + this.customerRef[id - 1].getName() + "|, actual:|" + name + "|"));
                    pass1 = false;
                    continue;
                }
                if (this.customerRef[id - 1].getName() == null) {
                    actual.add(id);
                    continue;
                }
                TestUtil.logErr((String)("Expected name:" + this.customerRef[id - 1].getName() + ", actual:null"));
                pass1 = false;
            }
            Collections.sort(actual);
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.size() + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass2 = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new EETest.Fault("tupleIntTest test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void tupleToArrayTest() throws EETest.Fault {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(this.customerRef[2].getId());
        expected.add(this.customerRef[2].getName());
        expected.add(this.customerRef[3].getId());
        expected.add(this.customerRef[3].getName());
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            TestUtil.logTrace((String)"Use Tuple Query");
            cquery.multiselect(new Selection[]{customer.get(Customer_.getSingularAttribute("id", String.class)), customer.get(Customer_.getSingularAttribute("name", String.class))});
            cquery.where((Expression)cbuilder.or((Expression)cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("id", String.class)), (Object)"3"), (Expression)cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("id", String.class)), (Object)"4")));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<String> actual = new ArrayList<String>();
            for (Tuple t : result) {
                for (Object o : t.toArray()) {
                    TestUtil.logTrace((String)("Object:" + o));
                    actual.add((String)o);
                }
            }
            if (TestUtil.traceflag) {
                TestUtil.logTrace((String)("actual" + actual));
            }
            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                TestUtil.logTrace((String)"Successfully returned expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)("expected: " + expected + ", actual: " + actual));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("tupleToArrayTest test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void tupleIntClassTest() throws EETest.Fault {
        boolean pass1 = true;
        boolean pass2 = false;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        for (Customer c : this.customerRef) {
            expected.add(Integer.valueOf(c.getId()));
        }
        Collections.sort(expected);
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            cquery.multiselect(new Selection[]{customer.get(Customer_.getSingularAttribute("id", String.class)), customer.get(Customer_.getSingularAttribute("name", String.class))});
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Tuple t : result) {
                Integer id = Integer.valueOf((String)t.get(0));
                String name = (String)t.get(1);
                if (name != null) {
                    if (this.customerRef[id - 1].getName().equals(name)) {
                        actual.add(id);
                        continue;
                    }
                    TestUtil.logErr((String)("Expected name:|" + this.customerRef[id - 1].getName() + "|, actual:|" + name + "|"));
                    pass1 = false;
                    continue;
                }
                if (this.customerRef[id - 1].getName() == null) {
                    actual.add(id);
                    continue;
                }
                TestUtil.logErr((String)("Expected name:" + this.customerRef[id - 1].getName() + ", actual:null"));
                pass1 = false;
            }
            Collections.sort(actual);
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.size() + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass2 = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new EETest.Fault("tupleIntClassTest test failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void tupleGetIntIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass;
        block8: {
            pass = false;
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createTupleQuery();
            if (cquery != null) {
                TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
                Root customer = cquery.from(Customer.class);
                EntityType Customer_ = customer.getModel();
                TestUtil.logTrace((String)"Use Tuple Query");
                cquery.multiselect(new Selection[]{customer.get(Customer_.getSingularAttribute("id", String.class)).alias("ID"), customer.get(Customer_.getSingularAttribute("name", String.class)).alias("NAME")});
                TypedQuery tq = this.getEntityManager().createQuery(cquery);
                List result = tq.getResultList();
                Iterator iterator = result.iterator();
                if (iterator.hasNext()) {
                    Tuple t = (Tuple)iterator.next();
                    TestUtil.logMsg((String)"Testing invalid index");
                    try {
                        t.get(99);
                        TestUtil.logErr((String)("Did not get expected IllegalArgumentException for invalid index:" + t.get(99)));
                    }
                    catch (IllegalArgumentException iae) {
                        TestUtil.logTrace((String)"Got expected IllegalArgumentException");
                        if (!this.getEntityTransaction().getRollbackOnly()) {
                            pass = true;
                            break block8;
                        }
                        TestUtil.logErr((String)"Transaction was marked for rollback and should not have been");
                    }
                    catch (Exception ex) {
                        TestUtil.logErr((String)"Received unexpected exception", (Throwable)ex);
                    }
                }
            } else {
                TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("tupleGetIntIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void tupleGetIntClassIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            TestUtil.logTrace((String)"Use Tuple Query");
            cquery.multiselect(new Selection[]{customer.get("id"), customer.get("name"), customer.get("home")});
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            Tuple t = (Tuple)result.get(0);
            TestUtil.logMsg((String)"Testing valid index");
            TestUtil.logTrace((String)("value:" + (String)t.get(1, String.class)));
            TestUtil.logMsg((String)"Testing invalid index");
            try {
                t.get(99, String.class);
                TestUtil.logErr((String)("Did not get expected IllegalArgumentException for invalid index:" + (String)t.get(99, String.class)));
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Got expected IllegalArgumentException");
                if (!this.getEntityTransaction().getRollbackOnly()) {
                    pass1 = true;
                } else {
                    TestUtil.logErr((String)"Transaction was marked for rollback and should not have been");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
            TestUtil.logMsg((String)"Testing invalid type");
            try {
                t.get(2, Date.class);
                TestUtil.logErr((String)("Did not get expected IllegalArgumentException for invalid type:" + t.get(2, Date.class)));
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Got expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new EETest.Fault("tupleGetIntClassIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void tupleGetElementsGetTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            TestUtil.logTrace((String)"Use Tuple Query");
            cquery.multiselect(new Selection[]{customer.get(Customer_.getSingularAttribute("id", String.class)).alias("ID"), customer.get(Customer_.getSingularAttribute("name", String.class)).alias("NAME")});
            cquery.where((Expression)cbuilder.isNotNull((Expression)customer.get(Customer_.getSingularAttribute("name", String.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            for (Tuple t : result) {
                String expId = (String)t.get("ID");
                String expName = (String)t.get("NAME");
                TestUtil.logTrace((String)("Received:" + expId + ", " + expName));
                List lte = t.getElements();
                for (TupleElement te : lte) {
                    String alias = te.getAlias();
                    String type = te.getJavaType().getName();
                    if (alias.equals("ID")) {
                        String actId = (String)t.get(te);
                        if (actId.equals(expId)) {
                            TestUtil.logTrace((String)("Received expected id:" + actId));
                            pass1 = true;
                        } else {
                            TestUtil.logErr((String)("Expected id:" + expId + ", actual:|" + actId + "|"));
                        }
                        if (type.equals("java.lang.String")) {
                            pass2 = true;
                            TestUtil.logTrace((String)("Received expected Java Type for ID:" + type));
                            continue;
                        }
                        TestUtil.logErr((String)("Expected java type of ID: java.lang.String, actual:|" + type + "|"));
                        continue;
                    }
                    if (alias.equals("NAME")) {
                        String actName = (String)t.get(te);
                        if (actName.equals(expName)) {
                            TestUtil.logTrace((String)("Received expected name:" + actName));
                            pass3 = true;
                        } else {
                            TestUtil.logErr((String)("Expected name:|" + expName + "|, actual:|" + actName + "|"));
                        }
                        if (type.equals("java.lang.String")) {
                            TestUtil.logTrace((String)("Received expected Java Type for NAME:" + type));
                            pass4 = true;
                            continue;
                        }
                        TestUtil.logErr((String)("Expected java type of NAME: java.lang.String, actual:|" + type + "|"));
                        continue;
                    }
                    TestUtil.logErr((String)("Received unexpected TupleElement:" + alias));
                }
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new EETest.Fault("tupleGetElementsGetTest failed");
        }
    }

    @SetupMethod(name="setupCustAliasProductData")
    public void tupleGetTupleElementIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass2;
        boolean pass1;
        block11: {
            pass1 = false;
            pass2 = false;
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createTupleQuery();
            if (cquery != null) {
                TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
                Root customer = cquery.from(Customer.class);
                TestUtil.logTrace((String)"Execute first Tuple Query");
                cquery.multiselect(new Selection[]{customer.get("id").alias("ID"), customer.get("name").alias("NAME")});
                cquery.where((Expression)cbuilder.equal((Expression)customer.get("id"), (Object)"3"));
                TypedQuery tq = this.getEntityManager().createQuery(cquery);
                List result = tq.getResultList();
                TestUtil.logTrace((String)("Number of Tuples from first query:" + result.size()));
                Tuple t1 = (Tuple)result.get(0);
                TestUtil.logTrace((String)("Tuples Received:" + t1.get(0) + ", " + t1.get(1)));
                CriteriaQuery cquery1 = cbuilder.createTupleQuery();
                Root product = cquery1.from(Product.class);
                TestUtil.logTrace((String)"Execute second Tuple Query");
                cquery1.multiselect(new Selection[]{product.get("id").alias("ID"), product.get("quantity").alias("QUANTITY")});
                cquery1.where((Expression)cbuilder.equal((Expression)product.get("id"), (Object)"1"));
                TypedQuery tq2 = this.getEntityManager().createQuery(cquery1);
                List result2 = tq2.getResultList();
                Tuple t2 = null;
                TestUtil.logTrace((String)("Number of Tuples received from second query:" + result2.size()));
                try {
                    t2 = (Tuple)result2.get(0);
                    pass1 = true;
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
                }
                if (t2 != null) {
                    TestUtil.logTrace((String)("Tuple Received:" + t2.get(0) + ", " + t2.get(1)));
                    List lte2 = t2.getElements();
                    TupleElement te2 = (TupleElement)lte2.get(1);
                    TestUtil.logTrace((String)("TupleElement from second query that will be looked up in the Tuple result returned from first query:" + te2.getAlias()));
                    try {
                        t1.get(te2);
                        TestUtil.logErr((String)"Did not throw IllegalArgumentException when calling Tuple.get with a TupleElement that doesn't exist");
                    }
                    catch (IllegalArgumentException iae) {
                        TestUtil.logTrace((String)"Got expected IllegalArgumentException");
                        if (!this.getEntityTransaction().getRollbackOnly()) {
                            pass2 = true;
                            break block11;
                        }
                        TestUtil.logErr((String)"Transaction was marked for rollback and should not have been");
                    }
                    catch (Exception e) {
                        TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
                    }
                } else {
                    TestUtil.logErr((String)"result2.get(0) returned null");
                }
            } else {
                TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
            }
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new EETest.Fault("tupleGetTupleElementIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void tupleGetStringTest() throws EETest.Fault {
        boolean pass1 = true;
        boolean pass2 = false;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        for (Customer c : this.customerRef) {
            expected.add(Integer.valueOf(c.getId()));
        }
        Collections.sort(expected);
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            TestUtil.logTrace((String)"Use Tuple Query");
            cquery.multiselect(new Selection[]{customer.get(Customer_.getSingularAttribute("id", String.class)).alias("ID"), customer.get(Customer_.getSingularAttribute("name", String.class)).alias("NAME")});
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Tuple t : result) {
                Integer id = Integer.valueOf((String)t.get(0));
                String name = (String)t.get(1);
                if (name != null) {
                    if (this.customerRef[id - 1].getName().equals(name)) {
                        actual.add(id);
                        continue;
                    }
                    TestUtil.logErr((String)("Expected name:|" + this.customerRef[id - 1].getName() + "|, actual:|" + name + "|"));
                    pass1 = false;
                    continue;
                }
                if (this.customerRef[id - 1].getName() == null) {
                    actual.add(id);
                    continue;
                }
                TestUtil.logErr((String)("Expected name:" + this.customerRef[id - 1].getName() + ", actual:null"));
                pass1 = false;
            }
            Collections.sort(actual);
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.size() + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass2 = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new EETest.Fault("tupleGetStringTest failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void tupleGetStringIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass;
        block7: {
            pass = false;
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createTupleQuery();
            if (cquery != null) {
                TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
                Root customer = cquery.from(Customer.class);
                EntityType Customer_ = customer.getModel();
                TestUtil.logTrace((String)"Use Tuple Query");
                cquery.multiselect(new Selection[]{customer.get(Customer_.getSingularAttribute("id", String.class)).alias("ID"), customer.get(Customer_.getSingularAttribute("name", String.class)).alias("NAME")});
                cquery.where((Expression)cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("id", String.class)), (Object)"1"));
                TypedQuery tq = this.getEntityManager().createQuery(cquery);
                List result = tq.getResultList();
                Tuple t = (Tuple)result.get(0);
                TestUtil.logMsg((String)"Testing valid alias");
                TestUtil.logTrace((String)("value:" + t.get("NAME")));
                TestUtil.logMsg((String)"Testing invalid alias");
                try {
                    t.get("doesnotexist");
                    TestUtil.logErr((String)"Did not get expected IllegalArgumentException for TupleElement:t.get(\"doesnotexist\")");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Got expected IllegalArgumentException");
                    if (!this.getEntityTransaction().getRollbackOnly()) {
                        pass = true;
                        break block7;
                    }
                    TestUtil.logErr((String)"Transaction was marked for rollback and should not have been");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Received unexpected exception:" + e));
                }
            } else {
                TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("tupleGetStringIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void tupleGetStringClassIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            TestUtil.logTrace((String)"Use Tuple Query");
            cquery.multiselect(new Selection[]{customer.get(Customer_.getSingularAttribute("id", String.class)).alias("ID"), customer.get(Customer_.getSingularAttribute("name", String.class)).alias("NAME")});
            cquery.where((Expression)cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("id", String.class)), (Object)"1"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            Tuple t = (Tuple)result.get(0);
            TestUtil.logMsg((String)"Testing valid index");
            TestUtil.logTrace((String)("value:" + t.get("NAME")));
            TestUtil.logMsg((String)"Testing a name that does not exist");
            try {
                t.get("doesnotexist", String.class);
                TestUtil.logErr((String)"Did not throw IllegalArgumentException for TupleElement: t.get(\"doesnotexist\", String.class)");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Got expected IllegalArgumentException");
                if (!this.getEntityTransaction().getRollbackOnly()) {
                    pass1 = true;
                } else {
                    TestUtil.logErr((String)"Transaction was marked for rollback and should not have been");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Received unexpected exception:" + e));
            }
            TestUtil.logMsg((String)"Testing invalid type");
            try {
                t.get("ID", Date.class);
                TestUtil.logErr((String)"Did not throw IllegalArgumentException for TupleElement:t.get(\"ID\", Date.class)");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Got expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Received unexpected exception:" + e));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new EETest.Fault("tupleGetStringClassIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void tupleGetStringClassTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = true;
        boolean pass3 = false;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        for (Customer c : this.customerRef) {
            expected.add(Integer.valueOf(c.getId()));
        }
        Collections.sort(expected);
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            TestUtil.logTrace((String)"Use Tuple Query");
            cquery.multiselect(new Selection[]{customer.get(Customer_.getSingularAttribute("id", String.class)).alias("ID"), customer.get(Customer_.getSingularAttribute("name", String.class)).alias("NAME")});
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            pass1 = true;
            for (Tuple t : result) {
                Integer id = Integer.valueOf((String)t.get(0));
                String name = (String)t.get(1);
                if (name != null) {
                    if (this.customerRef[id - 1].getName().equals(name)) {
                        actual.add(id);
                        continue;
                    }
                    TestUtil.logErr((String)("Expected name:|" + this.customerRef[id - 1].getName() + "|, actual:|" + name + "|"));
                    pass2 = false;
                    continue;
                }
                if (this.customerRef[id - 1].getName() == null) {
                    actual.add(id);
                    continue;
                }
                TestUtil.logErr((String)("Expected name:" + this.customerRef[id - 1].getName() + ", actual:null"));
                pass2 = false;
            }
            Collections.sort(actual);
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.size() + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass3 = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("tupleGetStringClassTest failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void tupleElementGetAliasTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            TestUtil.logTrace((String)"Use Tuple Query");
            Path idPath = customer.get(Customer_.getSingularAttribute("id", String.class));
            String id = idPath.alias("IDID").getAlias();
            if (id.equals("IDID")) {
                TestUtil.logTrace((String)("id=" + id));
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Expected id value:IDID, actual value:" + id));
            }
            Bindable b = idPath.getModel();
            Bindable.BindableType bbt = b.getBindableType();
            if (bbt.equals((Object)Bindable.BindableType.SINGULAR_ATTRIBUTE)) {
                TestUtil.logTrace((String)("Received expected model:" + bbt.name()));
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Expected model:" + Bindable.BindableType.SINGULAR_ATTRIBUTE.name() + ", actual:" + bbt.name()));
            }
            Path p = idPath.getParentPath();
            Class parent = p.getJavaType();
            if (parent.getName().equals(Customer.class.getName())) {
                TestUtil.logTrace((String)("Received expected parent:" + parent.getName()));
                pass3 = true;
            } else {
                TestUtil.logErr((String)("Expected parent class:" + Customer.class.getName() + ", actual:" + parent.getName()));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("tupleElementGetAliasTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void tupleElementGetJavaTypeTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            TestUtil.logTrace((String)"Use Tuple Query");
            Path idPath = customer.get(Customer_.getSingularAttribute("id", String.class));
            Class type = idPath.getJavaType();
            if (type.getSimpleName().equals("String")) {
                TestUtil.logTrace((String)("type=" + type.getSimpleName()));
                pass = true;
            } else {
                TestUtil.logErr((String)("Expected element type of String, actual value:" + type.getSimpleName()));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        if (!pass) {
            throw new EETest.Fault("tupleElementGetJavaTypeTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void tupleSelectionArrayTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = qbuilder.createTupleQuery();
            if (cquery != null) {
                TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
                Root cust = cquery.from(Customer.class);
                EntityType Customer_ = cust.getModel();
                TestUtil.logTrace((String)"Use Tuple Query");
                cquery.where((Expression)qbuilder.equal((Expression)cust.get(Customer_.getSingularAttribute("id", String.class)), (Object)"4"));
                Selection[] s = new Selection[]{cust.get("id"), cust.get("name")};
                cquery.select((Selection)qbuilder.tuple(s));
                TypedQuery q = this.getEntityManager().createQuery(cquery);
                List result = q.getResultList();
                if (result.size() == 1) {
                    Tuple t = (Tuple)result.get(0);
                    String id = (String)t.get(0);
                    if (id.equals(this.customerRef[3].getId())) {
                        TestUtil.logTrace((String)("Received expected id:" + id));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected id:" + this.customerRef[3].getId() + ", actual:" + id));
                    }
                    String name = (String)t.get(1);
                    if (name.equals(this.customerRef[3].getName())) {
                        TestUtil.logTrace((String)("Received expected name:" + name));
                    } else {
                        TestUtil.logErr((String)("Expected name:" + this.customerRef[3].getName() + ", actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)("Received incorrect result size - Expected: 1, Actual:" + result.size()));
                }
            } else {
                TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("tupleSelectionArrayTest failed");
        }
    }

    public void tupleSelectionArrayIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = qbuilder.createTupleQuery();
            if (cquery != null) {
                TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
                Root cust = cquery.from(Customer.class);
                Selection[] s = new Selection[]{cust.get("id"), cust.get("name")};
                TestUtil.logMsg((String)"Testing tuple");
                try {
                    qbuilder.tuple(new Selection[]{qbuilder.tuple(s)});
                    TestUtil.logErr((String)"Did not throw IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass1 = true;
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
                }
                TestUtil.logMsg((String)"Testing array");
                try {
                    qbuilder.tuple(new Selection[]{qbuilder.array(s)});
                    TestUtil.logErr((String)"Did not throw IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass2 = true;
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
                }
            } else {
                TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("tupleSelectionArrayIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void array() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = true;
        boolean pass3 = false;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        for (Customer c : this.customerRef) {
            expected.add(Integer.valueOf(c.getId()));
        }
        Collections.sort(expected);
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery();
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            TestUtil.logTrace((String)"Use Tuple Query");
            cquery.select((Selection)cbuilder.array(new Selection[]{customer.get(Customer_.getSingularAttribute("id", String.class)), customer.get(Customer_.getSingularAttribute("name", String.class))}));
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            List result = q.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            pass1 = true;
            for (Object[] row : result) {
                Integer id = Integer.valueOf((String)row[0]);
                String name = (String)row[1];
                if (name != null) {
                    if (this.customerRef[id - 1].getName().equals(name)) {
                        actual.add(id);
                        continue;
                    }
                    TestUtil.logErr((String)("Expected name:|" + this.customerRef[id - 1].getName() + "|, actual:|" + name + "|"));
                    pass2 = false;
                    continue;
                }
                if (this.customerRef[id - 1].getName() == null) {
                    actual.add(id);
                    continue;
                }
                TestUtil.logErr((String)("Expected name:" + this.customerRef[id - 1].getName() + ", actual:null"));
                pass2 = false;
            }
            Collections.sort(actual);
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.size() + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass3 = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("array test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void arrayIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = qbuilder.createTupleQuery();
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            Selection[] s = new Selection[]{customer.get("id"), customer.get("name")};
            TestUtil.logMsg((String)"Testing tuple");
            try {
                qbuilder.array(new Selection[]{qbuilder.tuple(s)});
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
            TestUtil.logMsg((String)"Testing array");
            try {
                qbuilder.array(new Selection[]{qbuilder.array(s)});
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("arrayIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void constructIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = qbuilder.createTupleQuery();
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            Selection[] s = new Selection[]{customer.get("id"), customer.get("name")};
            TestUtil.logMsg((String)"Testing tuple");
            try {
                qbuilder.construct(Customer.class, new Selection[]{qbuilder.tuple(s)});
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
            TestUtil.logMsg((String)"Testing array");
            try {
                qbuilder.construct(Customer.class, new Selection[]{qbuilder.array(s)});
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("constructIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void primaryKeyJoinColumnTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Product.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            cquery.select((Selection)product);
            cquery.where((Expression)cbuilder.equal((Expression)product.get("wareHouse"), (Object)"WH5"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            if (result.size() == 1 && ((Product)result.get(0)).getWareHouse().equals("WH5")) {
                TestUtil.logTrace((String)("Expected results received:" + ((Product)result.get(0)).getWareHouse()));
                pass = true;
            } else {
                TestUtil.logErr((String)("test returned: " + ((Product)result.get(0)).getWareHouse() + ", expected: WH5"));
                for (Product p : result) {
                    TestUtil.logErr((String)("**id=" + p.getId() + ", model=" + p.getWareHouse()));
                }
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("primaryKeyJoinColumnTest  failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void asc() throws EETest.Fault {
        int expectedModelNumber = 40;
        int expectedResultSize = 10;
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(HardwareProduct.class);
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root hardProd = cquery.from(HardwareProduct.class);
            EntityType HardwareProduct_ = hardProd.getModel();
            cquery.select((Selection)hardProd);
            cquery.orderBy(new Order[]{cbuilder.asc((Expression)hardProd.get(HardwareProduct_.getSingularAttribute("modelNumber")))});
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            if (result.size() == 10 && ((HardwareProduct)result.get(0)).getModelNumber() == 40) {
                TestUtil.logTrace((String)"Expected results received.");
                pass = true;
            } else {
                TestUtil.logErr((String)("test returned: " + ((HardwareProduct)result.get(0)).getModelNumber() + ", expected: " + 40));
                for (HardwareProduct o : result) {
                    TestUtil.logErr((String)("**id=" + o.getId() + ", model=" + o.getModelNumber()));
                }
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("asc Test  failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void desc() throws EETest.Fault {
        int expectedModelNumber = 104;
        int expectedResultSize = 10;
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(HardwareProduct.class);
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root hardProd = cquery.from(HardwareProduct.class);
            EntityType HardwareProduct_ = hardProd.getModel();
            cquery.select((Selection)hardProd);
            cquery.orderBy(new Order[]{cbuilder.desc((Expression)hardProd.get(HardwareProduct_.getSingularAttribute("modelNumber")))});
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            if (result.size() == 10 && ((HardwareProduct)result.get(7)).getModelNumber() == 104) {
                TestUtil.logTrace((String)"Expected results received.");
                pass = true;
            } else {
                TestUtil.logErr((String)("test returned: " + ((HardwareProduct)result.get(7)).getModelNumber() + "expected: " + 104));
                for (HardwareProduct o : result) {
                    TestUtil.logErr((String)("**id=" + o.getId() + ", model=" + o.getModelNumber()));
                }
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("desc Test  failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void avg() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Double.class);
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            EntityType order_ = order.getModel();
            cquery.select((Selection)cbuilder.avg((Expression)order.get(order_.getSingularAttribute("totalPrice", Double.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Double d1 = 1487.29;
            Double d2 = 1487.3;
            Double d3 = (Double)tq.getSingleResult();
            if (d3 >= d1 && d3 < d2) {
                TestUtil.logTrace((String)("Avg test returned expected results: " + d1));
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("avg test  failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void sumExpTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Number.class);
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root product = cquery.from(Product.class);
            EntityType Product_ = product.getModel();
            Path e = product.get(Product_.getSingularAttribute("price", Double.class));
            cquery.select((Selection)cbuilder.sum((Expression)e));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            double d1 = 33387.14;
            double d2 = 33387.15;
            Number d3 = (Number)tq.getSingleResult();
            if (d3 instanceof Double) {
                TestUtil.logTrace((String)"Received expected type of Double");
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Expected type Double, actual:" + d3));
            }
            double d4 = d3.doubleValue();
            if (d4 >= d1 && d4 < d2) {
                TestUtil.logTrace((String)("sum returned expected results: " + d1));
                pass2 = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new EETest.Fault("sumExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void sumExpNumTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root product = cquery.from(Product.class);
            EntityType Product_ = product.getModel();
            Path e = product.get(Product_.getSingularAttribute("quantity", Integer.class));
            cquery.select((Selection)cbuilder.sum((Expression)e, (Number)100));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("id")), (Object)"1"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Integer actual = (Integer)tq.getSingleResult();
            Integer expected = this.productRef[0].getQuantity() + 100;
            if (actual.equals(expected)) {
                TestUtil.logTrace((String)("sum returned expected results: " + actual));
                pass = true;
            } else {
                TestUtil.logErr((String)("Expected value:" + expected + ", actual value:" + actual));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("sumExpNumTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void sumNumExpTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root product = cquery.from(Product.class);
            EntityType Product_ = product.getModel();
            Path e = product.get(Product_.getSingularAttribute("quantity", Integer.class));
            cquery.select((Selection)cbuilder.sum((Number)100, (Expression)e));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("id")), (Object)"1"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Integer actual = (Integer)tq.getSingleResult();
            Integer expected = this.productRef[0].getQuantity() + 100;
            if (actual.equals(expected)) {
                TestUtil.logTrace((String)("sum test returned expected results: " + actual));
                pass = true;
            } else {
                TestUtil.logErr((String)("Expected value:" + expected + ", actual value:" + actual));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("sumNumExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void sumExpExpTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root product = cquery.from(Product.class);
            EntityType Product_ = product.getModel();
            Path e = product.get(Product_.getSingularAttribute("quantity", Integer.class));
            cquery.select((Selection)cbuilder.sum((Expression)e, (Expression)e));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("id")), (Object)"1"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Integer actual = (Integer)tq.getSingleResult();
            Integer expected = this.productRef[0].getQuantity() + this.productRef[0].getQuantity();
            if (actual.equals(expected)) {
                TestUtil.logTrace((String)("sum test returned expected results: " + actual));
                pass = true;
            } else {
                TestUtil.logErr((String)("Expected value:" + expected + ", actual value:" + actual));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("sumExpExpTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void max() throws EETest.Fault {
        boolean pass2 = false;
        boolean pass1 = false;
        Integer i1 = 8;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery1 = cbuilder.createQuery(Integer.class);
        CriteriaQuery cquery2 = cbuilder.createQuery(Integer.class);
        if (cquery1 != null && cquery2 != null) {
            Object result;
            TestUtil.logTrace((String)"select DISTINCT MAXIMUM number of lineItem quantities available an order may have");
            Root lineItem = cquery1.from(LineItem.class);
            EntityType lineItem_ = lineItem.getModel();
            cquery1.select((Selection)cbuilder.max((Expression)lineItem.get(lineItem_.getSingularAttribute("quantity", Integer.class))));
            cquery1.distinct(true);
            TypedQuery tq1 = this.getEntityManager().createQuery(cquery1);
            List i2 = tq1.getResultList();
            TestUtil.logTrace((String)"select MAXIMUM number of lineItem quantities available an order may have");
            Root lineItem2 = cquery2.from(LineItem.class);
            EntityType lineItem2_ = lineItem2.getModel();
            cquery2.select((Selection)cbuilder.max((Expression)lineItem2.get(lineItem2_.getSingularAttribute("quantity", Integer.class))));
            TypedQuery tq2 = this.getEntityManager().createQuery(cquery2);
            List i3 = tq2.getResultList();
            TestUtil.logMsg((String)"Verify select WITH DISTINCT keyword");
            if (i2.size() == 1) {
                result = (Integer)i2.get(0);
                if (result != null) {
                    if (((Integer)result).equals(i1)) {
                        TestUtil.logTrace((String)("Received expected results:" + result));
                        pass1 = true;
                    } else {
                        TestUtil.logTrace((String)("Expected: " + i1 + ", actual:" + result));
                    }
                } else {
                    TestUtil.logErr((String)"Receive null result from query");
                }
            } else {
                TestUtil.logErr((String)"Receive more than one result:");
                for (Integer i : i2) {
                    TestUtil.logErr((String)("Received:" + i));
                }
            }
            TestUtil.logMsg((String)"Verify select WITHOUT DISTINCT keyword");
            if (i3.size() == 1) {
                result = (Integer)i3.get(0);
                if (result != null) {
                    if (((Integer)result).equals(i1)) {
                        TestUtil.logTrace((String)("Received expected results:" + result));
                        pass2 = true;
                    } else {
                        TestUtil.logTrace((String)("Expected: " + i1 + ", actual:" + result));
                    }
                } else {
                    TestUtil.logErr((String)"Receive null result from query");
                }
            } else {
                TestUtil.logErr((String)"Receive more than one result:");
                for (Integer i : i3) {
                    TestUtil.logErr((String)("Received:" + i));
                }
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new EETest.Fault("max test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void min() throws EETest.Fault {
        boolean pass2 = false;
        boolean pass1 = false;
        Integer i1 = 1;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery1 = cbuilder.createQuery(Integer.class);
        CriteriaQuery cquery2 = cbuilder.createQuery(Integer.class);
        if (cquery1 != null && cquery2 != null) {
            Object result;
            TestUtil.logTrace((String)"select DISTINCT MIN number of lineItem quantities available an order may have");
            Root lineItem = cquery1.from(LineItem.class);
            EntityType lineItem_ = lineItem.getModel();
            cquery1.select((Selection)cbuilder.min((Expression)lineItem.get(lineItem_.getSingularAttribute("quantity", Integer.class))));
            cquery1.distinct(true);
            TypedQuery tq1 = this.getEntityManager().createQuery(cquery1);
            List i2 = tq1.getResultList();
            TestUtil.logTrace((String)"select MIN number of lineItem quantities available an order may have");
            Root lineItem2 = cquery2.from(LineItem.class);
            EntityType lineItem2_ = lineItem2.getModel();
            cquery2.select((Selection)cbuilder.min((Expression)lineItem2.get(lineItem2_.getSingularAttribute("quantity", Integer.class))));
            TypedQuery tq2 = this.getEntityManager().createQuery(cquery2);
            List i3 = tq2.getResultList();
            TestUtil.logMsg((String)"Verify select WITH DISTINCT keyword");
            if (i2.size() == 1) {
                result = (Integer)i2.get(0);
                if (result != null) {
                    if (((Integer)result).equals(i1)) {
                        TestUtil.logTrace((String)("Received expected results:" + result));
                        pass1 = true;
                    } else {
                        TestUtil.logTrace((String)("Expected: " + i1 + ", actual:" + result));
                    }
                } else {
                    TestUtil.logErr((String)"Receive null result from query");
                }
            } else {
                TestUtil.logErr((String)"Receive more than one result:");
                for (Integer i : i2) {
                    TestUtil.logErr((String)("Received:" + i));
                }
            }
            TestUtil.logMsg((String)"Verify select WITHOUT DISTINCT keyword");
            if (i3.size() == 1) {
                result = (Integer)i3.get(0);
                if (result != null) {
                    if (((Integer)result).equals(i1)) {
                        TestUtil.logTrace((String)("Received expected results:" + result));
                        pass2 = true;
                    } else {
                        TestUtil.logTrace((String)("Expected: " + i1 + ", actual:" + result));
                    }
                } else {
                    TestUtil.logErr((String)"Receive null result from query");
                }
            } else {
                TestUtil.logErr((String)"Receive more than one result:");
                for (Integer i : i3) {
                    TestUtil.logErr((String)("Received:" + i));
                }
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new EETest.Fault("max test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void greatest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(String.class);
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            EntityType Order_ = order.getModel();
            TestUtil.logTrace((String)"find Greatest Order id Using lexicographic comparision");
            cquery.select((Selection)cbuilder.greatest((Expression)order.get(Order_.getSingularAttribute("id", String.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            String expectedResult = "9";
            String queryOutput = (String)tq.getSingleResult();
            if (queryOutput.equals(expectedResult)) {
                TestUtil.logTrace((String)("Received expected result : " + expectedResult));
                pass = true;
            } else {
                TestUtil.logErr((String)("Query returned : " + queryOutput + " Expected result : " + expectedResult));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("greatest test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void least() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(String.class);
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            EntityType Order_ = order.getModel();
            TestUtil.logTrace((String)"find least Order id Using lexicographic comparision");
            cquery.select((Selection)cbuilder.least((Expression)order.get(Order_.getSingularAttribute("id", String.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            String expectedResult = "1";
            String queryOutput = (String)tq.getSingleResult();
            if (queryOutput.equals(expectedResult)) {
                TestUtil.logTrace((String)("Received expected result : " + expectedResult));
                pass = true;
            } else {
                TestUtil.logErr((String)("Query returned : " + queryOutput + " Expected result : " + expectedResult));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("least test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void count() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Long.class);
        if (cquery != null) {
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            EntityType Order_ = order.getModel();
            cquery.select((Selection)cbuilder.count((Expression)order.get(Order_.getSingularAttribute("id", String.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Long countResult = (Long)tq.getSingleResult();
            Long expectedCount = 20L;
            if (countResult.equals(expectedCount)) {
                TestUtil.logTrace((String)"Successfully returned expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)("count test returned:" + countResult + "expected: " + expectedCount));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("count test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void countDistinct() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Long.class);
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            TestUtil.logTrace((String)"count number of orders by customer");
            cquery.select((Selection)cbuilder.countDistinct((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("city", String.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Long countResult = (Long)tq.getSingleResult();
            Long expectedCount = 16L;
            if (countResult.equals(expectedCount)) {
                TestUtil.logTrace((String)"Successfully returned expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)("count test returned:" + countResult + "expected: " + expectedCount));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("countDistinct test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void exists() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{"19"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Product.class);
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root product = cquery.from(Product.class);
            EntityType Product_ = product.getModel();
            Subquery sq = cquery.subquery(Product.class);
            Root hardProd = sq.from(Product.class);
            if (hardProd.getModel().getName().equals(Product.class.getSimpleName())) {
                TestUtil.logTrace((String)"Received expected subquery root");
            } else {
                TestUtil.logErr((String)("Expected subquery root:" + Product.class.getSimpleName() + ", actual:" + hardProd.getModel().getName()));
            }
            sq.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("id", String.class)), (Object)"19")).select((Expression)hardProd);
            cquery.where((Expression)cbuilder.exists(sq));
            cquery.select((Selection)product);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("exists test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void subqueryFromEntityTypeTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{"19"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Product.class);
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root product = cquery.from(Product.class);
            EntityType Product_ = product.getModel();
            Subquery sq = cquery.subquery(Product.class);
            Root hardProd = sq.from(Product_);
            if (hardProd.getModel().getName().equals(Product_.getName())) {
                TestUtil.logTrace((String)"Received expected subquery root");
            } else {
                TestUtil.logErr((String)("Expected subquery root:" + Product_.getName() + ", actual:" + hardProd.getModel().getName()));
            }
            sq.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("id", String.class)), (Object)"19")).select((Expression)hardProd);
            cquery.where((Expression)cbuilder.exists(sq));
            cquery.select((Selection)product);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("subqueryFromEntityTypeTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void all() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(10050);
        expected.add(2578);
        expected.add(3000);
        expected.add(10000);
        expected.add(2368);
        Collections.sort(expected);
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
        if (cquery != null) {
            TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
            Root hardProd = cquery.from(HardwareProduct.class);
            EntityType HardwareProduct_ = hardProd.getModel();
            Subquery sq = cquery.subquery(Integer.class);
            Root subHardProd = sq.from(HardwareProduct.class);
            sq.select((Expression)subHardProd.get(HardwareProduct_.getSingularAttribute("modelNumber", Integer.class)));
            sq.where((Expression)cbuilder.lt((Expression)subHardProd.get(HardwareProduct_.getSingularAttribute("modelNumber", Integer.class)), (Number)1050));
            cquery.select((Selection)hardProd.get(HardwareProduct_.getSingularAttribute("modelNumber", Integer.class)));
            cquery.where((Expression)cbuilder.gt((Expression)hardProd.get(HardwareProduct_.getSingularAttribute("modelNumber", Integer.class)), cbuilder.all(sq)));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List actual = tq.getResultList();
            Collections.sort(actual);
            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                TestUtil.logTrace((String)"Received expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)"Did not get expected results");
                for (Integer i : expected) {
                    TestUtil.logErr((String)("expected:" + i));
                }
                for (Integer i : actual) {
                    TestUtil.logErr((String)("actual:" + i));
                }
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("all test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void some() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[18];
        for (int i = 0; i < 18; ++i) {
            expected[i] = this.customerRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Order_ = mm.entity(com.sun.ts.tests.jpa.common.schema30.Order.class);
            EntityType LineItem_ = mm.entity(LineItem.class);
            EntityType Customer_ = customer.getModel();
            CollectionJoin orders = customer.join(Customer_.getCollection("orders", com.sun.ts.tests.jpa.common.schema30.Order.class));
            Subquery sq = cquery.subquery(Double.class);
            Root order = sq.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            CollectionJoin lineItems = order.join(Order_.getCollection("lineItemsCollection", LineItem.class));
            sq.select((Expression)order.get(Order_.getSingularAttribute("totalPrice", Double.class))).where((Expression)cbuilder.equal((Expression)lineItems.get(LineItem_.getSingularAttribute("quantity", Integer.class)), (Object)3));
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.le((Expression)orders.get(Order_.getSingularAttribute("totalPrice", Double.class)), cbuilder.some(sq)));
            cquery.distinct(true);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("some test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void any() throws EETest.Fault {
        boolean pass = false;
        int j = 0;
        String[] expected = new String[17];
        for (int i = 0; i < 18; ++i) {
            if (i == 9) continue;
            expected[j++] = this.customerRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Order_ = mm.entity(com.sun.ts.tests.jpa.common.schema30.Order.class);
            EntityType LineItem_ = mm.entity(LineItem.class);
            EntityType Customer_ = customer.getModel();
            CollectionJoin orders = customer.join(Customer_.getCollection("orders", com.sun.ts.tests.jpa.common.schema30.Order.class));
            Subquery sq = cquery.subquery(Double.class);
            Root order = sq.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            CollectionJoin lineItems = order.join(Order_.getCollection("lineItemsCollection", LineItem.class));
            sq.select((Expression)order.get(Order_.getSingularAttribute("totalPrice", Double.class))).where((Expression)cbuilder.equal((Expression)lineItems.get(LineItem_.getSingularAttribute("quantity")), (Object)3));
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.lt((Expression)orders.get(Order_.getSingularAttribute("totalPrice", Double.class)), cbuilder.any(sq)));
            cquery.distinct(true);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("any test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void andPredicates() throws EETest.Fault {
        boolean pass = false;
        Customer expectedCustomer = this.customerRef[2];
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.and(new Predicate[]{cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("street", String.class)), (Object)"125 Moxy Lane"), cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("city", String.class)), (Object)"Swansea"), cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("state", String.class)), (Object)"MA"), cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("zip", String.class)), (Object)"11345")}));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Customer result = (Customer)tq.getSingleResult();
            if (result.equals((Object)expectedCustomer)) {
                TestUtil.logTrace((String)"Successfully returned expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)("expected: " + expectedCustomer + ", actual:" + result));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("andPredicates test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void orPredicates() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId(), this.customerRef[9].getId(), this.customerRef[10].getId(), this.customerRef[12].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.or(new Predicate[]{cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("street", String.class)), (Object)"47 Skyline Drive"), cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("city", String.class)), (Object)"Chelmsford"), cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("state", String.class)), (Object)"VT"), cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("zip", String.class)), (Object)"02155")}));
            cquery.distinct(true);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("orPredicates test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void notPredicate() throws EETest.Fault {
        boolean pass = false;
        Double expectedTotalPrice = 4500.0;
        String[] expected = new String[]{this.orderRef[4].getId(), this.orderRef[10].getId(), this.orderRef[15].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
        if (cquery != null) {
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            EntityType Order_ = order.getModel();
            cquery.select((Selection)order);
            cquery.where((Expression)cbuilder.not((Expression)cbuilder.lt((Expression)order.get(Order_.getSingularAttribute("totalPrice", Double.class)), (Number)expectedTotalPrice)));
            cquery.distinct(true);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (com.sun.ts.tests.jpa.common.schema30.Order o : result) {
                actual.add(Integer.parseInt(o.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("notPredicate test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void conjunction() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.orderRef[3].getId(), this.orderRef[8].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
        if (cquery != null) {
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            EntityType Order_ = order.getModel();
            EntityType Customer_ = mm.entity(Customer.class);
            cquery.select((Selection)order);
            cquery.where((Expression)cbuilder.and((Expression)cbuilder.equal((Expression)order.get(Order_.getSingularAttribute("customer", Customer.class)).get(Customer_.getSingularAttribute("name", String.class)), (Object)"Robert E. Bissett"), (Expression)cbuilder.isTrue((Expression)cbuilder.conjunction())));
            cquery.distinct(true);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (com.sun.ts.tests.jpa.common.schema30.Order o : result) {
                actual.add(Integer.parseInt(o.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("conjunction test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void disjunction() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.orderRef[3].getId(), this.orderRef[8].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
        if (cquery != null) {
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            EntityType Order_ = order.getModel();
            EntityType Customer_ = mm.entity(Customer.class);
            cquery.select((Selection)order);
            cquery.where((Expression)cbuilder.and((Expression)cbuilder.equal((Expression)order.get(Order_.getSingularAttribute("customer", Customer.class)).get(Customer_.getSingularAttribute("name", String.class)), (Object)"Robert E. Bissett"), (Expression)cbuilder.isFalse((Expression)cbuilder.disjunction())));
            cquery.distinct(true);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (com.sun.ts.tests.jpa.common.schema30.Order o : result) {
                actual.add(Integer.parseInt(o.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("disjunction test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void isTrue() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.orderRef[3].getId(), this.orderRef[8].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
        if (cquery != null) {
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            EntityType Order_ = order.getModel();
            EntityType Customer_ = mm.entity(Customer.class);
            cquery.select((Selection)order);
            cquery.where((Expression)cbuilder.and((Expression)cbuilder.equal((Expression)order.get(Order_.getSingularAttribute("customer", Customer.class)).get(Customer_.getSingularAttribute("name", String.class)), (Object)"Robert E. Bissett"), (Expression)cbuilder.isTrue((Expression)cbuilder.conjunction())));
            cquery.distinct(true);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (com.sun.ts.tests.jpa.common.schema30.Order o : result) {
                actual.add(Integer.parseInt(o.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("isTrue test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void isFalse() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.orderRef[3].getId(), this.orderRef[8].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
        if (cquery != null) {
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            EntityType Order_ = order.getModel();
            EntityType Customer_ = mm.entity(Customer.class);
            cquery.select((Selection)order);
            cquery.where((Expression)cbuilder.and((Expression)cbuilder.equal((Expression)order.get(Order_.getSingularAttribute("customer", Customer.class)).get(Customer_.getSingularAttribute("name", String.class)), (Object)"Robert E. Bissett"), (Expression)cbuilder.isFalse((Expression)cbuilder.disjunction())));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (com.sun.ts.tests.jpa.common.schema30.Order o : result) {
                actual.add(Integer.parseInt(o.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("isFalse test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void isNull() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[11].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = mm.entity(Customer.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.isNull((Expression)customer.get(Customer_.getSingularAttribute("name", String.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("isNull test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void isNotNull() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[17];
        int j = 0;
        for (int i = 0; i < 18; ++i) {
            if (i == 12) continue;
            expected[j++] = this.customerRef[i].getId();
        }
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = mm.entity(Customer.class);
            EntityType Address_ = mm.entity(Address.class);
            cquery.where((Expression)cb.isNotNull((Expression)customer.get(Customer_.getSingularAttribute("work", Address.class)).get(Address_.getSingularAttribute("zip", String.class))));
            cquery.select((Selection)customer);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("isNotNull test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void equalExpObjectTest() throws EETest.Fault {
        boolean pass = false;
        int j = 0;
        String[] expected = new String[17];
        for (int i = 0; i < 20; ++i) {
            if (i == 3 || !(i != 12 & i != 8)) continue;
            expected[j++] = this.orderRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
        if (cquery != null) {
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            EntityType Order_ = order.getModel();
            EntityType Customer_ = mm.entity(Customer.class);
            cquery.select((Selection)order);
            cquery.where((Expression)cbuilder.not((Expression)cbuilder.equal((Expression)order.get(Order_.getSingularAttribute("customer", Customer.class)).get(Customer_.getSingularAttribute("name", String.class)), (Object)"Robert E. Bissett")));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (com.sun.ts.tests.jpa.common.schema30.Order o : result) {
                actual.add(Integer.parseInt(o.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("equalExpObjectTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void equalExpExpTest() throws EETest.Fault {
        boolean pass = false;
        int j = 0;
        String[] expected = new String[17];
        for (int i = 0; i < 20; ++i) {
            if (i == 3 || !(i != 12 & i != 8)) continue;
            expected[j++] = this.orderRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
        if (cquery != null) {
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            EntityType Order_ = order.getModel();
            EntityType Customer_ = mm.entity(Customer.class);
            cquery.select((Selection)order);
            cquery.where((Expression)cbuilder.not((Expression)cbuilder.equal((Expression)order.get(Order_.getSingularAttribute("customer", Customer.class)).get(Customer_.getSingularAttribute("name", String.class)), cbuilder.literal((Object)"Robert E. Bissett"))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (com.sun.ts.tests.jpa.common.schema30.Order o : result) {
                actual.add(Integer.parseInt(o.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("equalExpExpTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void notEqualExpObjectTest() throws EETest.Fault {
        boolean pass = false;
        int j = 0;
        String[] expected = new String[17];
        for (int i = 0; i < 20; ++i) {
            if (i == 3 || !(i != 12 & i != 8)) continue;
            expected[j++] = this.orderRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
        if (cquery != null) {
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            EntityType Order_ = order.getModel();
            EntityType Customer_ = mm.entity(Customer.class);
            cquery.select((Selection)order);
            cquery.where((Expression)cbuilder.notEqual((Expression)order.get(Order_.getSingularAttribute("customer", Customer.class)).get(Customer_.getSingularAttribute("name", String.class)), (Object)"Robert E. Bissett"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (com.sun.ts.tests.jpa.common.schema30.Order o : result) {
                actual.add(Integer.parseInt(o.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("notEqualExpObjectTest test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void notEqualExpExpTest() throws EETest.Fault {
        boolean pass = false;
        int j = 0;
        String[] expected = new String[17];
        for (int i = 0; i < 20; ++i) {
            if (i == 3 || !(i != 12 & i != 8)) continue;
            expected[j++] = this.orderRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
        if (cquery != null) {
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            EntityType Order_ = order.getModel();
            EntityType Customer_ = mm.entity(Customer.class);
            cquery.select((Selection)order);
            cquery.where((Expression)cbuilder.notEqual((Expression)order.get(Order_.getSingularAttribute("customer", Customer.class)).get(Customer_.getSingularAttribute("name", String.class)), cbuilder.literal((Object)"Robert E. Bissett")));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (com.sun.ts.tests.jpa.common.schema30.Order o : result) {
                actual.add(Integer.parseInt(o.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("notEqualExpExpTest test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void sumAsDoubleTest() throws EETest.Fault {
        boolean pass = false;
        double expected = 217.5;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(Double.class);
        if (cquery != null) {
            Root prod = cquery.from(Product.class);
            EntityType Product_ = prod.getModel();
            cquery.where(new Predicate[]{cb.gt((Expression)prod.get(Product_.getSingularAttribute("quantity", Integer.class)), (Number)50), cb.lt((Expression)prod.get(Product_.getSingularAttribute("quantity", Integer.class)), (Number)100)});
            cquery.select((Selection)cb.sumAsDouble(cb.toFloat(cb.prod((Expression)prod.get(Product_.getSingularAttribute("quantity", Integer.class)), (Number)Float.valueOf(0.5f)))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Double actual = (Double)tq.getSingleResult();
            TestUtil.logTrace((String)("actual" + actual));
            if (expected == actual) {
                TestUtil.logTrace((String)"Successfully returned expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)("expected: " + expected + ", actual: " + actual));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("sumAsDoubleTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void sumAsLongTest() throws EETest.Fault {
        boolean pass = false;
        long expected = 435L;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(Long.class);
        if (cquery != null) {
            Root prod = cquery.from(Product.class);
            EntityType Product_ = prod.getModel();
            cquery.where(new Predicate[]{cb.gt((Expression)prod.get(Product_.getSingularAttribute("quantity", Integer.class)), (Number)50), cb.lt((Expression)prod.get(Product_.getSingularAttribute("quantity", Integer.class)), (Number)100)});
            cquery.select((Selection)cb.sumAsLong((Expression)prod.get(Product_.getSingularAttribute("quantity", Integer.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Long actual = (Long)tq.getSingleResult();
            TestUtil.logTrace((String)("actual" + actual));
            if (expected == actual) {
                TestUtil.logTrace((String)"Successfully returned expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)("expected: " + expected + ", actual: " + actual));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("sumAsLongTest failed");
        }
    }

    @SetupMethod(name="setupAliasOnlyData")
    public void greaterThanExpNumTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.aliasRef[7].getId(), this.aliasRef[9].getId(), this.aliasRef[12].getId(), this.aliasRef[13].getId(), this.aliasRef[17].getId(), this.aliasRef[27].getId(), this.aliasRef[28].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
        if (cquery != null) {
            Root alias = cquery.from(Alias.class);
            EntityType Alias_ = alias.getModel();
            cquery.select((Selection)alias);
            cquery.where((Expression)cbuilder.greaterThan(cbuilder.length((Expression)alias.get(Alias_.getSingularAttribute("alias", String.class))), (Comparable)Integer.valueOf(4)));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Alias a : result) {
                actual.add(Integer.parseInt(a.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("greaterThanExpNumTest failed");
        }
    }

    @SetupMethod(name="setupAliasOnlyData")
    public void greaterThanExpExpTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.aliasRef[7].getId(), this.aliasRef[9].getId(), this.aliasRef[12].getId(), this.aliasRef[13].getId(), this.aliasRef[17].getId(), this.aliasRef[27].getId(), this.aliasRef[28].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
        if (cquery != null) {
            Root alias = cquery.from(Alias.class);
            EntityType Alias_ = alias.getModel();
            cquery.select((Selection)alias);
            cquery.where((Expression)cbuilder.greaterThan(cbuilder.length((Expression)alias.get(Alias_.getSingularAttribute("alias", String.class))), cbuilder.literal((Object)4)));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Alias a : result) {
                actual.add(Integer.parseInt(a.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("greaterThanExpExpTest failed");
        }
    }

    @SetupMethod(name="setupAliasOnlyData")
    public void greaterThanOrEqualToExpNumTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.aliasRef[2].getId(), this.aliasRef[3].getId(), this.aliasRef[7].getId(), this.aliasRef[9].getId(), this.aliasRef[12].getId(), this.aliasRef[13].getId(), this.aliasRef[17].getId(), this.aliasRef[19].getId(), this.aliasRef[22].getId(), this.aliasRef[23].getId(), this.aliasRef[24].getId(), this.aliasRef[27].getId(), this.aliasRef[28].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
        if (cquery != null) {
            Root alias = cquery.from(Alias.class);
            EntityType Alias_ = alias.getModel();
            cquery.select((Selection)alias);
            cquery.where((Expression)cbuilder.greaterThanOrEqualTo(cbuilder.length((Expression)alias.get(Alias_.getSingularAttribute("alias", String.class))), (Comparable)Integer.valueOf(4)));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Alias a : result) {
                actual.add(Integer.parseInt(a.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("greaterThanOrEqualToExpNumTest failed");
        }
    }

    @SetupMethod(name="setupAliasOnlyData")
    public void greaterThanOrEqualToExpExpTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.aliasRef[2].getId(), this.aliasRef[3].getId(), this.aliasRef[7].getId(), this.aliasRef[9].getId(), this.aliasRef[12].getId(), this.aliasRef[13].getId(), this.aliasRef[17].getId(), this.aliasRef[19].getId(), this.aliasRef[22].getId(), this.aliasRef[23].getId(), this.aliasRef[24].getId(), this.aliasRef[27].getId(), this.aliasRef[28].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
        if (cquery != null) {
            Root alias = cquery.from(Alias.class);
            EntityType Alias_ = alias.getModel();
            cquery.select((Selection)alias);
            cquery.where((Expression)cbuilder.greaterThanOrEqualTo(cbuilder.length((Expression)alias.get(Alias_.getSingularAttribute("alias", String.class))), cbuilder.literal((Object)4)));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Alias a : result) {
                actual.add(Integer.parseInt(a.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("greaterThanOrEqualToExpExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void lessThanExpNumTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{"4", "6", "7", "8", "9", "12", "15", "16", "17", "19", "21", "22", "24", "27", "28", "30", "31", "35", "36", "37"};
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(Product.class);
        if (cquery != null) {
            Root prod = cquery.from(Product.class);
            EntityType Product_ = prod.getModel();
            cquery.where((Expression)cb.lessThan((Expression)prod.get(Product_.getSingularAttribute("quantity", Integer.class)), (Comparable)Integer.valueOf(50)));
            cquery.select((Selection)prod);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("lessThanExpNumTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void lessThanExpExpTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{"4", "6", "7", "8", "9", "12", "15", "16", "17", "19", "21", "22", "24", "27", "28", "30", "31", "35", "36", "37"};
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(Product.class);
        if (cquery != null) {
            Root prod = cquery.from(Product.class);
            EntityType Product_ = prod.getModel();
            cquery.where((Expression)cb.lessThan((Expression)prod.get(Product_.getSingularAttribute("quantity", Integer.class)), cb.literal((Object)50)));
            cquery.select((Selection)prod);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("lessThanExpExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void lessThanOrEqualToExpNumTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{"4", "5", "6", "7", "8", "9", "12", "15", "16", "17", "19", "20", "21", "22", "24", "27", "28", "30", "31", "35", "36", "37"};
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(Product.class);
        if (cquery != null) {
            Root prod = cquery.from(Product.class);
            EntityType Product_ = prod.getModel();
            cquery.where((Expression)cb.lessThanOrEqualTo((Expression)prod.get(Product_.getSingularAttribute("quantity", Integer.class)), (Comparable)Integer.valueOf(50)));
            cquery.select((Selection)prod);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("lessThanOrEqualToExpNumTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void lessThanOrEqualToExpExpTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{"4", "5", "6", "7", "8", "9", "12", "15", "16", "17", "19", "20", "21", "22", "24", "27", "28", "30", "31", "35", "36", "37"};
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(Product.class);
        if (cquery != null) {
            Root prod = cquery.from(Product.class);
            EntityType Product_ = prod.getModel();
            cquery.where((Expression)cb.lessThanOrEqualTo((Expression)prod.get(Product_.getSingularAttribute("quantity", Integer.class)), cb.literal((Object)50)));
            cquery.select((Selection)prod);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("lessThanOrEqualToExpExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void between() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{"31", "32", "33", "37"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        Date date1 = this.getSQLDate("2000-02-14");
        Date date6 = this.getSQLDate("2005-02-18");
        CriteriaQuery cquery = cbuilder.createQuery(Product.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = product.getModel();
            EmbeddableType ShelfLife_ = mm.embeddable(ShelfLife.class);
            cquery.select((Selection)product);
            cquery.where((Expression)cbuilder.between((Expression)product.get(Product_.getSingularAttribute("shelfLife", ShelfLife.class)).get(ShelfLife_.getSingularAttribute("soldDate", Date.class)), (Expression)cbuilder.parameter(Date.class, "date1"), (Expression)cbuilder.parameter(Date.class, "date6")));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            tq.setParameter("date1", (Object)date1);
            tq.setParameter("date6", (Object)date6);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("between test failed");
        }
    }

    @SetupMethod(name="setupAliasOnlyData")
    public void gtExpNumTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.aliasRef[7].getId(), this.aliasRef[9].getId(), this.aliasRef[12].getId(), this.aliasRef[13].getId(), this.aliasRef[17].getId(), this.aliasRef[27].getId(), this.aliasRef[28].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
        if (cquery != null) {
            Root alias = cquery.from(Alias.class);
            EntityType Alias_ = alias.getModel();
            cquery.select((Selection)alias);
            cquery.where((Expression)cbuilder.gt(cbuilder.length((Expression)alias.get(Alias_.getSingularAttribute("alias", String.class))), (Number)4));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Alias a : result) {
                actual.add(Integer.parseInt(a.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("gtExpNumTest failed");
        }
    }

    @SetupMethod(name="setupAliasOnlyData")
    public void gtExpExpTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.aliasRef[7].getId(), this.aliasRef[9].getId(), this.aliasRef[12].getId(), this.aliasRef[13].getId(), this.aliasRef[17].getId(), this.aliasRef[27].getId(), this.aliasRef[28].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
        if (cquery != null) {
            Root alias = cquery.from(Alias.class);
            EntityType Alias_ = alias.getModel();
            cquery.select((Selection)alias);
            cquery.where((Expression)cbuilder.gt(cbuilder.length((Expression)alias.get(Alias_.getSingularAttribute("alias", String.class))), cbuilder.literal((Object)4)));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Alias a : result) {
                actual.add(Integer.parseInt(a.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("gtExpExpTest failed");
        }
    }

    @SetupMethod(name="setupAliasOnlyData")
    public void geExpNumTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.aliasRef[2].getId(), this.aliasRef[3].getId(), this.aliasRef[7].getId(), this.aliasRef[9].getId(), this.aliasRef[12].getId(), this.aliasRef[13].getId(), this.aliasRef[17].getId(), this.aliasRef[19].getId(), this.aliasRef[22].getId(), this.aliasRef[23].getId(), this.aliasRef[24].getId(), this.aliasRef[27].getId(), this.aliasRef[28].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
        if (cquery != null) {
            Root alias = cquery.from(Alias.class);
            EntityType Alias_ = alias.getModel();
            cquery.select((Selection)alias);
            cquery.where((Expression)cbuilder.ge(cbuilder.length((Expression)alias.get(Alias_.getSingularAttribute("alias", String.class))), (Number)4));
            cquery.distinct(true);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Alias a : result) {
                actual.add(Integer.parseInt(a.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("geExpNumTest failed");
        }
    }

    @SetupMethod(name="setupAliasOnlyData")
    public void geExpExpTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.aliasRef[2].getId(), this.aliasRef[3].getId(), this.aliasRef[7].getId(), this.aliasRef[9].getId(), this.aliasRef[12].getId(), this.aliasRef[13].getId(), this.aliasRef[17].getId(), this.aliasRef[19].getId(), this.aliasRef[22].getId(), this.aliasRef[23].getId(), this.aliasRef[24].getId(), this.aliasRef[27].getId(), this.aliasRef[28].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
        if (cquery != null) {
            Root alias = cquery.from(Alias.class);
            EntityType Alias_ = alias.getModel();
            cquery.select((Selection)alias);
            cquery.where((Expression)cbuilder.ge(cbuilder.length((Expression)alias.get(Alias_.getSingularAttribute("alias", String.class))), cbuilder.literal((Object)4)));
            cquery.distinct(true);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Alias a : result) {
                actual.add(Integer.parseInt(a.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("geExpExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void ltExpNumTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{"4", "6", "7", "8", "9", "12", "15", "16", "17", "19", "21", "22", "24", "27", "28", "30", "31", "35", "36", "37"};
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(Product.class);
        if (cquery != null) {
            Root prod = cquery.from(Product.class);
            EntityType Product_ = prod.getModel();
            cquery.where((Expression)cb.lt((Expression)prod.get(Product_.getSingularAttribute("quantity", Integer.class)), (Number)50));
            cquery.select((Selection)prod);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("ltExpNumTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void ltExpExpTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{"4", "6", "7", "8", "9", "12", "15", "16", "17", "19", "21", "22", "24", "27", "28", "30", "31", "35", "36", "37"};
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(Product.class);
        if (cquery != null) {
            Root prod = cquery.from(Product.class);
            EntityType Product_ = prod.getModel();
            cquery.where((Expression)cb.lt((Expression)prod.get(Product_.getSingularAttribute("quantity", Integer.class)), cb.literal((Object)50)));
            cquery.select((Selection)prod);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("ltExpExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void leExpNumTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{"4", "5", "6", "7", "8", "9", "12", "15", "16", "17", "19", "20", "21", "22", "24", "27", "28", "30", "31", "35", "36", "37"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Product.class);
        if (cquery != null) {
            Root prod = cquery.from(Product.class);
            EntityType Product_ = prod.getModel();
            cquery.where((Expression)cbuilder.le((Expression)prod.get(Product_.getSingularAttribute("quantity", Integer.class)), (Number)50));
            cquery.select((Selection)prod);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("leExpNumTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void leExpExpTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{"4", "5", "6", "7", "8", "9", "12", "15", "16", "17", "19", "20", "21", "22", "24", "27", "28", "30", "31", "35", "36", "37"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Product.class);
        if (cquery != null) {
            Root prod = cquery.from(Product.class);
            EntityType Product_ = prod.getModel();
            cquery.where((Expression)cbuilder.le((Expression)prod.get(Product_.getSingularAttribute("quantity", Integer.class)), cbuilder.literal((Object)50)));
            cquery.select((Selection)prod);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("leExpExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void neg() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.neg((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class))));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Integer result = (Integer)tq.getSingleResult();
            Integer expectedResult = -5;
            if (result.intValue() == expectedResult.intValue()) {
                TestUtil.logTrace((String)"Successfully returned expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)("test returned:" + result + "expected: " + expectedResult));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("neg test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void abs() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.orderRef[0].getId(), this.orderRef[1].getId(), this.orderRef[3].getId(), this.orderRef[4].getId(), this.orderRef[5].getId(), this.orderRef[10].getId(), this.orderRef[15].getId(), this.orderRef[16].getId(), this.orderRef[17].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(com.sun.ts.tests.jpa.common.schema30.Order.class);
        if (cquery != null) {
            Root order = cquery.from(com.sun.ts.tests.jpa.common.schema30.Order.class);
            EntityType Order_ = order.getModel();
            cquery.select((Selection)order);
            cquery.where((Expression)cbuilder.lt((Expression)cbuilder.parameter(Double.class, "dbl"), cbuilder.abs(cbuilder.neg((Expression)order.get(Order_.getSingularAttribute("totalPrice", Double.class))))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            tq.setParameter("dbl", (Object)1180.0);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (com.sun.ts.tests.jpa.common.schema30.Order o : result) {
                actual.add(Integer.parseInt(o.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("abs test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void prodExpNumTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Number.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.prod((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Number)Float.valueOf(10.0f)));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Number result = (Number)tq.getSingleResult();
            Float expectedResult = Float.valueOf(50.0f);
            if (result instanceof Float) {
                TestUtil.logTrace((String)"Received expected type of Float");
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Expected type Double, actual:" + result));
            }
            Float f = Float.valueOf(result.floatValue());
            if (f.floatValue() == (float)expectedResult.intValue()) {
                TestUtil.logTrace((String)("Successfully returned expected results:" + f));
                pass2 = true;
            } else {
                TestUtil.logErr((String)("test returned:" + result.intValue() + "expected: " + expectedResult.intValue()));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new EETest.Fault("prodExpNumTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void prodNumExpTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.prod((Number)10, (Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class))));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Integer result = (Integer)tq.getSingleResult();
            Integer expectedResult = 50;
            if (result.intValue() == expectedResult.intValue()) {
                TestUtil.logTrace((String)("Successfully returned expected results:" + result));
                pass = true;
            } else {
                TestUtil.logErr((String)("test returned:" + result + "expected: " + expectedResult));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("prodNumExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void prodExpExpTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.prod((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class))));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Integer result = (Integer)tq.getSingleResult();
            Integer expectedResult = 25;
            if (result.intValue() == expectedResult.intValue()) {
                TestUtil.logTrace((String)("Successfully returned expected results:" + result));
                pass = true;
            } else {
                TestUtil.logErr((String)("expected: " + expectedResult + ", actual result:" + result));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("prodExpExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void diffExpNumberTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.diff((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Number)2));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Integer result = (Integer)tq.getSingleResult();
            Integer expected = 3;
            if (result.intValue() == expected.intValue()) {
                TestUtil.logTrace((String)("Successfully returned expected results" + result));
                pass = true;
            } else {
                TestUtil.logErr((String)("Expected: " + expected + ", actual:" + result));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("diffExpNumberTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void diffNumberExpTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.diff((Number)8, (Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class))));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Integer result = (Integer)tq.getSingleResult();
            Integer expected = 3;
            if (result.intValue() == expected.intValue()) {
                TestUtil.logTrace((String)("Successfully returned expected results" + result));
                pass = true;
            } else {
                TestUtil.logErr((String)("Expected: " + expected + ", actual:" + result));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("diffNumberExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void diffExpExpTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.diff((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class))));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Integer result = (Integer)tq.getSingleResult();
            Integer expected = 0;
            if (result.intValue() == expected.intValue()) {
                TestUtil.logTrace((String)("Successfully returned expected results" + result));
                pass = true;
            } else {
                TestUtil.logErr((String)("Expected: " + expected + ", actual:" + result));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("diffExpExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void quotExpNumTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(Number.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cb.quot((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Number)2));
            cquery.where((Expression)cb.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Number actual = (Number)tq.getSingleResult();
            Integer expected = 2;
            if (actual.intValue() == expected.intValue()) {
                TestUtil.logTrace((String)"Successfully returned expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)("expected: " + expected + ", actual:" + actual.intValue()));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("quotExpNumTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void quotNumExpTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(Number.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cb.quot((Number)10, (Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class))));
            cquery.where((Expression)cb.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Number actual = (Number)tq.getSingleResult();
            Integer expected = 2;
            if (actual.intValue() == expected.intValue()) {
                TestUtil.logTrace((String)"Successfully returned expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)("expected: " + expected + ", actual:" + actual.intValue()));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("quotNumExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void quotExpExpTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(Number.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cb.quot((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class))));
            cquery.where((Expression)cb.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Number actual = (Number)tq.getSingleResult();
            Integer expected = 1;
            if (actual.intValue() == expected.intValue()) {
                TestUtil.logTrace((String)"Successfully returned expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)("expected: " + expected + ", actual:" + actual.intValue()));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("quotExpExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void modExpIntTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{"5", "20"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Product.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.where((Expression)cbuilder.equal(cbuilder.mod(cbuilder.literal((Object)550), Integer.valueOf(100)), (Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("modExpIntTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void modExpExpTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{"5", "20"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Product.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.where((Expression)cbuilder.equal(cbuilder.mod(cbuilder.literal((Object)550), cbuilder.literal((Object)100)), (Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("modExpExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void modIntExpTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{"5", "20"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Product.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.where((Expression)cbuilder.equal(cbuilder.mod(Integer.valueOf(550), cbuilder.literal((Object)100)), (Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("modIntExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void sqrt() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Double.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.sqrt((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class))));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Double result = (Double)tq.getSingleResult();
            Double expectedResult = 2.1;
            if (result.intValue() == expectedResult.intValue()) {
                TestUtil.logTrace((String)"Successfully returned expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)("test returned:" + result.intValue() + "expected: " + expectedResult.intValue()));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("sqrt test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void toLong() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Long.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.toLong(cbuilder.prod((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Number)5L)));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Long result = (Long)tq.getSingleResult();
            Long expectedResult = 25L;
            if (result.intValue() == expectedResult.intValue()) {
                TestUtil.logTrace((String)"Successfully returned expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)("test returned:" + result.intValue() + "expected: " + expectedResult.intValue()));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("toLong test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void toInteger() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.toInteger((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class))));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("partNumber", Long.class)), (Object)373767373));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Integer result = (Integer)tq.getSingleResult();
            Integer expectedResult = 5;
            if (result.intValue() == expectedResult.intValue()) {
                TestUtil.logTrace((String)"Successfully returned expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)("test returned:" + result + "expected: " + expectedResult));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("toInteger test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void toFloat() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Float.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.toFloat(cbuilder.prod((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Number)Float.valueOf(0.5f))));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Float result = (Float)tq.getSingleResult();
            Float expectedResult = Float.valueOf(2.5f);
            if (result.intValue() == expectedResult.intValue()) {
                TestUtil.logTrace((String)"Successfully returned expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)("test returned:" + result.intValue() + "expected: " + expectedResult.intValue()));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("toFloat test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void toDouble() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Double.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.toDouble(cbuilder.sqrt((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)))));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Double result = (Double)tq.getSingleResult();
            Double expectedResult = 2.1;
            if (result.intValue() == expectedResult.intValue()) {
                TestUtil.logTrace((String)"Successfully returned expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)("test returned:" + result.intValue() + "expected: " + expectedResult.intValue()));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("toDouble test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void toBigDecimal() throws EETest.Fault {
        BigDecimal expectedResult = new BigDecimal("50.5");
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(BigDecimal.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.toBigDecimal(cbuilder.prod((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Number)new BigDecimal("10.1"))));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            BigDecimal result = (BigDecimal)tq.getSingleResult();
            if (result.compareTo(expectedResult) == 0) {
                TestUtil.logTrace((String)"Successfully returned expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)("test returned:" + result + "expected: " + expectedResult));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("toBigDecimal test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void toBigInteger() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(BigInteger.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.toBigInteger(cbuilder.prod((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Number)new BigInteger("10000000000"))));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class)), (Object)5));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            BigInteger result = (BigInteger)tq.getSingleResult();
            BigInteger expectedResult = new BigInteger("50000000000");
            if (result.compareTo(expectedResult) == 0) {
                TestUtil.logTrace((String)"Successfully returned expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)("test returned:" + result + "expected: " + expectedResult));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("toBigInteger test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void toStringTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(String.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)cbuilder.toString(cbuilder.literal((Object)Character.valueOf('a'))));
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("id", String.class)), (Object)"1"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            String result = (String)tq.getSingleResult();
            String expectedResult = "a";
            if (result.equals(expectedResult)) {
                TestUtil.logTrace((String)"Successfully returned expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)("test returned:" + result + "expected: " + expectedResult));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("toStringTest test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void literal() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)product.get(Product_.getSingularAttribute("quantity", Integer.class)));
            cquery.where((Expression)cbuilder.equal(cbuilder.literal((Object)5), (Expression)product.get(Product_.getSingularAttribute("quantity", Integer.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Integer result = (Integer)tq.getSingleResult();
            Integer expectedResult = 5;
            if (result.intValue() == expectedResult.intValue()) {
                TestUtil.logTrace((String)"Successfully returned expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)("test returned:" + result + "expected: " + expectedResult));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("literal test failed");
        }
    }

    public void literalIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            cbuilder.literal(null);
            TestUtil.logErr((String)"Did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Received unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("literalIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void parameter() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId(), this.customerRef[9].getId(), this.customerRef[10].getId(), this.customerRef[12].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            ParameterExpression param1 = cbuilder.parameter(String.class, "streetParam");
            ParameterExpression param2 = cbuilder.parameter(String.class, "cityParam");
            ParameterExpression param3 = cbuilder.parameter(String.class, "stateParam");
            ParameterExpression param4 = cbuilder.parameter(String.class, "zipParam");
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.or(new Predicate[]{cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("street", String.class)), (Expression)param1), cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("city", String.class)), (Expression)param2), cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("state", String.class)), (Expression)param3), cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("zip", String.class)), (Expression)param4)}));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            tq.setParameter("streetParam", (Object)"47 Skyline Drive");
            tq.setParameter("cityParam", (Object)"Chelmsford");
            tq.setParameter("stateParam", (Object)"VT");
            tq.setParameter("zipParam", (Object)"02155");
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("parameter test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void parameterCaseSensitiveTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[9].getId(), this.customerRef[13].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            ParameterExpression param1 = cbuilder.parameter(String.class, "stateParam");
            ParameterExpression param2 = cbuilder.parameter(String.class, "STATEPARAM");
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.or((Expression)cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("state", String.class)), (Expression)param1), (Expression)cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("state", String.class)), (Expression)param2)));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            tq.setParameter("stateParam", (Object)"RI");
            tq.setParameter("STATEPARAM", (Object)"VT");
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("parameterCaseSensitiveTest test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void criteriaBuilderValuesTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId(), this.customerRef[1].getId(), this.customerRef[2].getId(), this.customerRef[3].getId(), this.customerRef[6].getId(), this.customerRef[7].getId(), this.customerRef[8].getId(), this.customerRef[9].getId(), this.customerRef[10].getId(), this.customerRef[12].getId(), this.customerRef[14].getId(), this.customerRef[17].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            CriteriaBuilder.In inExp = cbuilder.in((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("state", String.class)));
            inExp.value((Expression)cbuilder.parameter(String.class, "state1"));
            inExp.value((Expression)cbuilder.parameter(String.class, "state2"));
            cquery.where((Expression)inExp);
            List result = this.getEntityManager().createQuery(cquery).setParameter("state1", (Object)"MA").setParameter("state2", (Object)"VT").getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                TestUtil.logTrace((String)("Customer id:" + c.getId() + ", state:" + c.getHome().getState()));
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("criteriaBuilderValuesTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void criteriaBuilderIn1Test() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId(), this.customerRef[1].getId(), this.customerRef[2].getId(), this.customerRef[3].getId(), this.customerRef[6].getId(), this.customerRef[7].getId(), this.customerRef[8].getId(), this.customerRef[9].getId(), this.customerRef[10].getId(), this.customerRef[12].getId(), this.customerRef[14].getId(), this.customerRef[17].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            CriteriaBuilder.In inExp = cbuilder.in((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("state", String.class)));
            inExp.value((Expression)cbuilder.parameter(String.class, "state1"));
            inExp.value((Expression)cbuilder.parameter(String.class, "state2"));
            cquery.where((Expression)inExp);
            List result = this.getEntityManager().createQuery(cquery).setParameter("state1", (Object)"MA").setParameter("state2", (Object)"VT").getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                TestUtil.logTrace((String)("Customer id:" + c.getId() + ", state:" + c.getHome().getState()));
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("criteriaBuilderIn1Test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void criteriaBuilderIn2Test() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        String[] expected = new String[]{this.spouse[0].getId(), this.spouse[3].getId(), this.spouse[4].getId(), this.spouse[5].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Spouse.class);
        if (cquery != null) {
            Root spouse = cquery.from(Spouse.class);
            CriteriaBuilder.In in = cbuilder.in((Expression)spouse.get("id"));
            for (String id : new String[]{"2", "3"}) {
                in.value((Object)id);
            }
            Predicate pred = in.not();
            cquery.where((Expression)pred);
            if (!pred.getOperator().equals((Object)Predicate.BooleanOperator.AND)) {
                TestUtil.logErr((String)("Expected: " + Predicate.BooleanOperator.AND + ", actual:" + pred.getOperator().name()));
            } else {
                pass1 = true;
            }
            if (!in.not().isNegated()) {
                TestUtil.logErr((String)("Expected in.not().isNegated() to return: true, actual:" + in.isNegated()));
            } else {
                pass2 = true;
            }
            List result = this.getEntityManager().createQuery(cquery).getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Spouse s : result) {
                TestUtil.logTrace((String)("Customer id:" + s.getId() + ", state:" + s.getSocialSecurityNumber()));
                actual.add(Integer.parseInt(s.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass3 = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("criteriaBuilderIn2Test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void criteriaBuilderInValueTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId(), this.customerRef[1].getId(), this.customerRef[2].getId(), this.customerRef[3].getId(), this.customerRef[6].getId(), this.customerRef[7].getId(), this.customerRef[8].getId(), this.customerRef[9].getId(), this.customerRef[10].getId(), this.customerRef[12].getId(), this.customerRef[14].getId(), this.customerRef[17].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            CriteriaBuilder.In inExp = cbuilder.in((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("state", String.class)));
            inExp.value((Object)"MA");
            inExp.value((Object)"VT");
            cquery.where((Expression)inExp);
            List result = this.getEntityManager().createQuery(cquery).getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                TestUtil.logTrace((String)("Customer id:" + c.getId() + ", state:" + c.getHome().getState()));
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("criteriaBuilderInValueTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void expressionInObjectArrayTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.spouse[1].getId(), this.spouse[2].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Spouse.class);
        if (cquery != null) {
            Root spouse = cquery.from(Spouse.class);
            Path exp = spouse.get("id");
            ParameterExpression param = cbuilder.parameter(String.class);
            cquery.where((Expression)exp.in(new Object[]{"2", "3"}));
            TypedQuery query = this.getEntityManager().createQuery(cquery);
            List result = query.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Spouse s : result) {
                TestUtil.logTrace((String)("Customer id:" + s.getId() + ", state:" + s.getSocialSecurityNumber()));
                actual.add(Integer.parseInt(s.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("expressionInObjectArrayTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void expressionInExpressionArrayTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.spouse[1].getId(), this.spouse[2].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Spouse.class);
        if (cquery != null) {
            Root spouse = cquery.from(Spouse.class);
            Path exp = spouse.get("id");
            ParameterExpression param = cbuilder.parameter(String.class);
            cquery.where((Expression)exp.in(new Expression[]{cbuilder.literal((Object)"2"), cbuilder.literal((Object)"3")}));
            TypedQuery query = this.getEntityManager().createQuery(cquery);
            List result = query.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Spouse s : result) {
                TestUtil.logTrace((String)("Customer id:" + s.getId() + ", state:" + s.getSocialSecurityNumber()));
                actual.add(Integer.parseInt(s.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("expressionInExpressionArrayTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void expressionInExpressionTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.spouse[1].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Spouse.class);
        if (cquery != null) {
            Root spouse = cquery.from(Spouse.class);
            Path exp = spouse.get("id");
            ParameterExpression param = cbuilder.parameter(String.class);
            Expression e = cbuilder.literal((Object)"2");
            cquery.where((Expression)exp.in(e));
            TypedQuery query = this.getEntityManager().createQuery(cquery);
            List result = query.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Spouse s : result) {
                TestUtil.logTrace((String)("Customer id:" + s.getId() + ", state:" + s.getSocialSecurityNumber()));
                actual.add(Integer.parseInt(s.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("expressionInExpressionTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void expressionInCollectionTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.spouse[1].getId(), this.spouse[2].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Spouse.class);
        if (cquery != null) {
            Root spouse = cquery.from(Spouse.class);
            Path exp = spouse.get("id");
            ParameterExpression param = cbuilder.parameter(String.class);
            ArrayList<String> col = new ArrayList<String>();
            col.add("2");
            col.add("3");
            cquery.where((Expression)exp.in(col));
            TypedQuery query = this.getEntityManager().createQuery(cquery);
            List result = query.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Spouse s : result) {
                TestUtil.logTrace((String)("Customer id:" + s.getId() + ", state:" + s.getSocialSecurityNumber()));
                actual.add(Integer.parseInt(s.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("expressionInCollectionTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void parameterExpressionIsNullTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Spouse.class);
        if (cquery != null) {
            cquery.from(Spouse.class);
            ParameterExpression param = cbuilder.parameter(String.class);
            cquery.where((Expression)param.isNull());
            TypedQuery query = this.getEntityManager().createQuery(cquery);
            List result = query.setParameter((Parameter)param, (Object)"2").getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Spouse s : result) {
                TestUtil.logTrace((String)("Customer id:" + s.getId() + ", state:" + s.getSocialSecurityNumber()));
                actual.add(Integer.parseInt(s.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("parameterExpressionIsNullTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void parameterExpressionIsNotNullTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.spouse[0].getId(), this.spouse[1].getId(), this.spouse[2].getId(), this.spouse[3].getId(), this.spouse[4].getId(), this.spouse[5].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Spouse.class);
        if (cquery != null) {
            cquery.from(Spouse.class);
            ParameterExpression param = cbuilder.parameter(String.class);
            cquery.where((Expression)param.isNotNull());
            TypedQuery query = this.getEntityManager().createQuery(cquery);
            List result = query.setParameter((Parameter)param, (Object)"2").getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Spouse s : result) {
                TestUtil.logTrace((String)("Customer id:" + s.getId() + ", state:" + s.getSocialSecurityNumber()));
                actual.add(Integer.parseInt(s.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("parameterExpressionIsNotNullTest failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void isEmpty() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[5].getId(), this.customerRef[14].getId(), this.customerRef[15].getId(), this.customerRef[16].getId(), this.customerRef[17].getId(), this.customerRef[18].getId(), this.customerRef[19].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.isEmpty((Expression)customer.get("aliases")));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("isEmpty test failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void isNotEmpty() throws EETest.Fault {
        boolean pass = false;
        int j = 0;
        String[] expected = new String[13];
        for (int i = 0; i < 14; ++i) {
            if (i == 5) continue;
            expected[j++] = this.customerRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.isNotEmpty((Expression)customer.get("aliases")));
            cquery.select((Selection)customer).distinct(true);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("isNotEmpty test failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void sizeCollectionTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)cbuilder.size((Expression)customer.get("aliases")));
            cquery.where((Expression)cbuilder.equal((Expression)customer.get("id"), (Object)"3"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Integer result = (Integer)tq.getSingleResult();
            Integer expectedSize = 2;
            if (result.intValue() == expectedSize.intValue()) {
                TestUtil.logTrace((String)"Successfully returned expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)("test returned:" + result + "expected: " + expectedSize));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("sizeCollectionTest failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void sizeExpTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            Path aliases = customer.get("aliases");
            cquery.select((Selection)cbuilder.size((Expression)aliases));
            cquery.where((Expression)cbuilder.equal((Expression)customer.get("id"), (Object)"3"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Integer result = (Integer)tq.getSingleResult();
            Integer expectedSize = 2;
            if (result.intValue() == expectedSize.intValue()) {
                TestUtil.logTrace((String)("Successfully returned expected results:" + result));
                pass = true;
            } else {
                TestUtil.logErr((String)("Expected: " + expectedSize + ", actual:" + result));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("sizeExpTest failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void isMember() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cqa = cbuilder.createQuery(Alias.class);
        Root aliasRoot = cqa.from(Alias.class);
        cqa = cqa.where((Expression)cbuilder.equal((Expression)aliasRoot.get("alias"), (Object)"aef"));
        Alias alias = (Alias)this.getEntityManager().createQuery(cqa).getSingleResult();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.isMember((Object)alias, (Expression)customer.get("aliases")));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            if (result.size() == 1) {
                if (((Customer)result.get(0)).equals((Object)this.customerRef[0])) {
                    TestUtil.logTrace((String)("Successfully returned expected results" + result.toString()));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("expected customer:" + this.customerRef[0].toString()));
                    TestUtil.logErr((String)("actual customer:" + result.toString()));
                }
            } else {
                TestUtil.logErr((String)("Expected number customers: 1, actual:" + result.size()));
                for (Customer c : result) {
                    TestUtil.logErr((String)("Received customer:" + c.toString()));
                }
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("isMember test failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void isNotMember() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[30];
        for (int i = 0; i < 30; ++i) {
            expected[i] = this.aliasRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
        if (cquery != null) {
            Root alias = cquery.from(Alias.class);
            cquery.where((Expression)cbuilder.isNotMember((Expression)alias.get("customerNoop"), (Expression)alias.get("customersNoop")));
            cquery.distinct(true);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Alias a : result) {
                actual.add(Integer.parseInt(a.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("isNotMember test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void likeExpStringTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[1].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.like((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("zip", String.class)), "%77"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("likeExpStringTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void likeExpExpTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[1].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.like((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("zip", String.class)), cbuilder.literal((Object)"%77")));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("likeExpExpTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void notLikeExpStringTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[17];
        int j = 0;
        for (int i = 0; i < 18; ++i) {
            if (i == 1) continue;
            expected[j++] = this.customerRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.notLike((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("zip", String.class)), "%77"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("notLikeExpStringTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void notLikeExpExpTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[17];
        int j = 0;
        for (int i = 0; i < 18; ++i) {
            if (i == 1) continue;
            expected[j++] = this.customerRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.notLike((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("zip", String.class)), cbuilder.literal((Object)"%77")));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("notLikeExpExpTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void notLikeExpExpExpTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[16];
        int j = 0;
        for (int i = 0; i < 18; ++i) {
            if (i == 1 || i == 5) continue;
            expected[j++] = this.customerRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.notLike((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("zip", String.class)), cbuilder.literal((Object)"%_7"), cbuilder.literal((Object)Character.valueOf('\\'))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("notLikeExpExpExpTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void notLikeExpExpCharTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[16];
        int j = 0;
        for (int i = 0; i < 18; ++i) {
            if (i == 1 || i == 5) continue;
            expected[j++] = this.customerRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.notLike((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("zip", String.class)), cbuilder.literal((Object)"%_7"), '\\'));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("notLikeExpExpCharTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void notLikeExpStringExpTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[16];
        int j = 0;
        for (int i = 0; i < 18; ++i) {
            if (i == 1 || i == 5) continue;
            expected[j++] = this.customerRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.notLike((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("zip", String.class)), "%_7", cbuilder.literal((Object)Character.valueOf('\\'))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("notLikeExpStringExpTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void notLikeExpStringCharTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[16];
        int j = 0;
        for (int i = 0; i < 18; ++i) {
            if (i == 1 || i == 5) continue;
            expected[j++] = this.customerRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.notLike((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("zip", String.class)), "%_7", '\\'));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("notLikeExpStringCharTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void concatExpStringTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[18];
        for (int i = 0; i < 18; ++i) {
            expected[i] = this.customerRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("work", Address.class)).get(Address_.getSingularAttribute("street", String.class)), cbuilder.concat(cbuilder.literal((Object)"1 Network"), " Drive")));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("concatExpStringTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void concatStringExpTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[18];
        for (int i = 0; i < 18; ++i) {
            expected[i] = this.customerRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("work", Address.class)).get(Address_.getSingularAttribute("street", String.class)), cbuilder.concat("1 Network", cbuilder.literal((Object)" Drive"))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("concatStringExpTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void concatExpExpTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[18];
        for (int i = 0; i < 18; ++i) {
            expected[i] = this.customerRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("work", Address.class)).get(Address_.getSingularAttribute("street", String.class)), cbuilder.concat(cbuilder.literal((Object)"1 Network"), cbuilder.literal((Object)" Drive"))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("concatExpExpTest failed");
        }
    }

    @SetupMethod(name="setupAliasOnlyData")
    public void substringExpIntTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.aliasRef[19].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
        if (cquery != null) {
            Root alias = cquery.from(Alias.class);
            EntityType Alias_ = alias.getModel();
            cquery.select((Selection)alias);
            cquery.where((Expression)cbuilder.equal((Expression)alias.get(Alias_.getSingularAttribute("alias", String.class)), cbuilder.substring((Expression)cbuilder.parameter(String.class, "string1"), 1)));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            tq.setParameter("string1", (Object)"iris");
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Alias a : result) {
                actual.add(Integer.parseInt(a.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("substringExpIntTest failed");
        }
    }

    @SetupMethod(name="setupAliasOnlyData")
    public void substringExpExpTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.aliasRef[19].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
        if (cquery != null) {
            Root alias = cquery.from(Alias.class);
            EntityType Alias_ = alias.getModel();
            cquery.select((Selection)alias);
            cquery.where((Expression)cbuilder.equal((Expression)alias.get(Alias_.getSingularAttribute("alias", String.class)), cbuilder.substring((Expression)cbuilder.parameter(String.class, "string1"), cbuilder.literal((Object)1))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            tq.setParameter("string1", (Object)"iris");
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Alias a : result) {
                actual.add(Integer.parseInt(a.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("substringExpExpTest failed");
        }
    }

    @SetupMethod(name="setupAliasOnlyData")
    public void substringExpIntIntTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.aliasRef[19].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
        if (cquery != null) {
            Root alias = cquery.from(Alias.class);
            EntityType Alias_ = alias.getModel();
            cquery.select((Selection)alias);
            cquery.where((Expression)cbuilder.equal((Expression)alias.get(Alias_.getSingularAttribute("alias", String.class)), cbuilder.substring((Expression)cbuilder.parameter(String.class, "string1"), 1, 4)));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            tq.setParameter("string1", (Object)"iris");
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Alias a : result) {
                actual.add(Integer.parseInt(a.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("substringExpIntIntTest failed");
        }
    }

    @SetupMethod(name="setupAliasOnlyData")
    public void substringExpExpExpTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.aliasRef[19].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
        if (cquery != null) {
            Root alias = cquery.from(Alias.class);
            EntityType Alias_ = alias.getModel();
            cquery.select((Selection)alias);
            cquery.where((Expression)cbuilder.equal((Expression)alias.get(Alias_.getSingularAttribute("alias", String.class)), cbuilder.substring((Expression)cbuilder.parameter(String.class, "string1"), cbuilder.literal((Object)1), cbuilder.literal((Object)4))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            tq.setParameter("string1", (Object)"iris");
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Alias a : result) {
                actual.add(Integer.parseInt(a.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("substringExpExpExpTest failed");
        }
    }

    public void trimspecTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = true;
        ArrayList<CriteriaBuilder.Trimspec> expected = new ArrayList<CriteriaBuilder.Trimspec>();
        expected.add(CriteriaBuilder.Trimspec.BOTH);
        expected.add(CriteriaBuilder.Trimspec.LEADING);
        expected.add(CriteriaBuilder.Trimspec.TRAILING);
        try {
            CriteriaBuilder.Trimspec[] ts = CriteriaBuilder.Trimspec.values();
            if (ts.length == 3) {
                for (CriteriaBuilder.Trimspec tspec : ts) {
                    pass1 = true;
                    if (expected.contains(tspec)) {
                        TestUtil.logMsg((String)("Testing valueOf:" + tspec));
                        CriteriaBuilder.Trimspec.valueOf((String)tspec.toString());
                        continue;
                    }
                    pass2 = false;
                    TestUtil.logErr((String)("values() returned incorrect value:" + tspec));
                }
            } else {
                TestUtil.logErr((String)("Expected number of values:3, actual:" + ts.length));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("trimspecTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void trimBothExpTest() throws EETest.Fault {
        boolean pass = false;
        String expectedResult = "David R. Vincent";
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(String.class);
        if (cquery != null) {
            Root cust = cquery.from(Customer.class);
            EntityType Customer_ = cust.getModel();
            cquery.where((Expression)cb.equal((Expression)cust.get(Customer_.getSingularAttribute("name", String.class)), cb.literal((Object)" David R. Vincent")));
            cquery.select((Selection)cb.trim(CriteriaBuilder.Trimspec.BOTH, (Expression)cust.get(Customer_.getSingularAttribute("name", String.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            String result = (String)tq.getSingleResult();
            if (result.equals("David R. Vincent")) {
                TestUtil.logTrace((String)("Received expected result:|" + result + "|"));
                pass = true;
            } else {
                TestUtil.logErr((String)("Mismatch in received results - expected = |David R. Vincent|, received = |" + result + "|"));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("trimBothExpTest failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    public void trimExpTest() throws EETest.Fault {
        boolean pass = false;
        String expected = " David R. Vincent ";
        String expected2 = "David R. Vincent";
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(String.class);
        if (cquery != null) {
            Root trim = cquery.from(Trim.class);
            EntityType trim_ = trim.getModel();
            cquery.where((Expression)cb.equal(cb.trim((Expression)trim.get(trim_.getSingularAttribute("name", String.class))), cb.literal((Object)" David R. Vincent ".trim())));
            cquery.select((Selection)cb.trim((Expression)trim.get(trim_.getSingularAttribute("name", String.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            String result = (String)tq.getSingleResult();
            if (result.equals("David R. Vincent")) {
                TestUtil.logTrace((String)("Received expected result:|" + result + "|"));
                pass = true;
            } else {
                TestUtil.logErr((String)("Mismatch in received results - expected = |David R. Vincent|, received = |" + result + "|"));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("trimExpTest failed");
        }
    }

    @SetupMethod(name="setupTrimData")
    public void trimTrailingCharExpTest() throws EETest.Fault {
        boolean pass = false;
        String expected = " David R. Vincent ";
        String expected2 = " David R. Vincent";
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(String.class);
        if (cquery != null) {
            Root trim = cquery.from(Trim.class);
            EntityType trim_ = trim.getModel();
            cquery.where((Expression)cb.equal(cb.trim((Expression)trim.get(trim_.getSingularAttribute("name", String.class))), cb.literal((Object)" David R. Vincent ".trim())));
            cquery.select((Selection)cb.trim(CriteriaBuilder.Trimspec.TRAILING, (Expression)trim.get(trim_.getSingularAttribute("name", String.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            String result = (String)tq.getSingleResult();
            if (result.equals(" David R. Vincent")) {
                TestUtil.logTrace((String)("Received expected result:|" + result + "|"));
                pass = true;
            } else {
                TestUtil.logErr((String)("Mismatch in received results - expected = | David R. Vincent|, received = |" + result + "|"));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("trimTrailingCharExpTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void lower() throws EETest.Fault {
        String expectedResult = "lisa m. presley";
        boolean pass = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(String.class);
        if (cquery != null) {
            Root cust = cquery.from(Customer.class);
            EntityType Customer_ = cust.getModel();
            cquery.where((Expression)cb.equal((Expression)cust.get(Customer_.getSingularAttribute("name", String.class)), cb.literal((Object)"Lisa M. Presley")));
            cquery.select((Selection)cb.lower((Expression)cust.get(Customer_.getSingularAttribute("name", String.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            String result = (String)tq.getSingleResult();
            if (result.equals("lisa m. presley")) {
                TestUtil.logTrace((String)"Successfully returned expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)("Mismatch in received results - expected = lisa m. presley received = " + result));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("lower test failed");
        }
    }

    @SetupMethod(name="setupAliasOnlyData")
    public void upper() throws EETest.Fault {
        String expectedResult = "IRIS";
        boolean pass = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(String.class);
        if (cquery != null) {
            Root alias = cquery.from(Alias.class);
            EntityType Alias_ = alias.getModel();
            cquery.where((Expression)cb.equal((Expression)alias.get(Alias_.getSingularAttribute("alias", String.class)), cb.literal((Object)"iris")));
            cquery.select((Selection)cb.upper((Expression)alias.get(Alias_.getSingularAttribute("alias", String.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            String result = (String)tq.getSingleResult();
            if (result != null) {
                if (result.equals("IRIS")) {
                    TestUtil.logTrace((String)"Successfully returned expected results");
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Mismatch in received results - expected = IRIS received = " + result));
                }
            } else {
                TestUtil.logErr((String)"Missing expected result");
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("upper test failed");
        }
    }

    @SetupMethod(name="setupAliasOnlyData")
    public void length() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.aliasRef[27].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
        if (cquery != null) {
            Root alias = cquery.from(Alias.class);
            EntityType Alias_ = alias.getModel();
            cquery.select((Selection)alias);
            cquery.where((Expression)cbuilder.equal(cbuilder.length((Expression)alias.get(Alias_.getSingularAttribute("alias", String.class))), (Object)9));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Alias a : result) {
                actual.add(Integer.parseInt(a.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("length test failed");
        }
    }

    @SetupMethod(name="setupAliasOnlyData")
    public void locateExpStringTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.aliasRef[12].getId(), this.aliasRef[13].getId(), this.aliasRef[17].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
        if (cquery != null) {
            Root alias = cquery.from(Alias.class);
            EntityType Alias_ = alias.getModel();
            cquery.select((Selection)alias);
            cquery.where((Expression)cbuilder.equal(cbuilder.locate((Expression)alias.get(Alias_.getSingularAttribute("alias", String.class)), "ev"), (Object)3));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Alias a : result) {
                actual.add(Integer.parseInt(a.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("locateExpStringTest failed");
        }
    }

    @SetupMethod(name="setupAliasOnlyData")
    public void locateExpExpTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.aliasRef[12].getId(), this.aliasRef[13].getId(), this.aliasRef[17].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
        if (cquery != null) {
            Root alias = cquery.from(Alias.class);
            EntityType Alias_ = alias.getModel();
            cquery.select((Selection)alias);
            cquery.where((Expression)cbuilder.equal(cbuilder.locate((Expression)alias.get(Alias_.getSingularAttribute("alias", String.class)), cbuilder.literal((Object)"ev")), (Object)3));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Alias a : result) {
                actual.add(Integer.parseInt(a.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("locateExpExpTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void currentDate() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Date.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = product.getModel();
            cquery.select((Selection)cbuilder.currentDate());
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("id", String.class)), (Object)"1"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Date result = (Date)tq.getSingleResult();
            Date d = Date.valueOf(result.toString());
            if (d.equals(result)) {
                TestUtil.logTrace((String)"Successfully returned expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)"Did not get the expected Date object");
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("currentDate test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void currentTime() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Time.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = product.getModel();
            cquery.select((Selection)cbuilder.currentTime());
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("id", String.class)), (Object)"1"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Time result = (Time)tq.getSingleResult();
            Time ts = new Time(result.getTime());
            if (result.equals(ts)) {
                TestUtil.logTrace((String)"Successfully returned expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)"Did not get the expected Time object");
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("currentTimes test failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void currentTimestamp() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Timestamp.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = product.getModel();
            cquery.select((Selection)cbuilder.currentTimestamp());
            cquery.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("id", String.class)), (Object)"1"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Timestamp result = (Timestamp)tq.getSingleResult();
            Timestamp ts = Timestamp.valueOf(result.toString());
            if (ts.equals(result)) {
                TestUtil.logTrace((String)"Successfully returned expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)"Did not get the expected Timestamp object");
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("currentTimestamp test failed");
        }
    }

    public void createCriteriaDeleteTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            CriteriaDelete cd = cbuilder.createCriteriaDelete(Product.class);
            if (cd != null) {
                TestUtil.logTrace((String)"Obtained Non-null CriteriaDelete");
                pass = true;
            } else {
                TestUtil.logErr((String)"Failed to get Non-null CriteriaDelete");
            }
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)ex);
        }
        if (!pass) {
            throw new EETest.Fault("createCriteriaDeleteTest test failed");
        }
    }

    public void createCriteriaUpdateTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            CriteriaUpdate cd = cbuilder.createCriteriaUpdate(Product.class);
            if (cd != null) {
                TestUtil.logTrace((String)"Obtained Non-null CriteriaUpdate");
                pass = true;
            } else {
                TestUtil.logErr((String)"Failed to get Non-null CriteriaUpdate");
            }
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)ex);
        }
        if (!pass) {
            throw new EETest.Fault("createCriteriaUpdateTest test failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void expressionAliasTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createQuery();
        if (cquery != null) {
            EntityType Customer_;
            Root customer = cquery.from(Customer.class);
            Path idPath = customer.get((Customer_ = customer.getModel()).getSingularAttribute("id", String.class));
            String id = idPath.alias("IDID").getAlias();
            if (id.equals("IDID")) {
                TestUtil.logTrace((String)("id=" + id));
                pass = true;
            } else {
                TestUtil.logErr((String)("Expected id value:IDID, actual value:" + id));
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        if (!pass) {
            throw new EETest.Fault("expressionAliasTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void treatPathClassTest() throws EETest.Fault {
        boolean pass = false;
        TestUtil.logTrace((String)"*****************************");
        TestUtil.logTrace((String)"SoftwareProducts:");
        TestUtil.logTrace((String)"--------------------");
        for (SoftwareProduct p : this.softwareRef) {
            TestUtil.logTrace((String)("ID:" + p.getId() + ":" + this.getEntityManager().find(Product.class, (Object)p.getId())));
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(String.class);
        if (cquery != null) {
            Root product = cquery.from(Product.class);
            EntityType Product_ = mm.entity(Product.class);
            cquery.select((Selection)product.get(Product_.getSingularAttribute("id", String.class)));
            cquery.where((Expression)cbuilder.like((Expression)cbuilder.treat(product, SoftwareProduct.class).get(SoftwareProduct_.name), "Java%"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List actual = tq.getResultList();
            ArrayList<String> expected = new ArrayList<String>();
            expected.add("34");
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected: " + expected.size() + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("treatPathClassTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinOnExpressionTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        try {
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin order = customer.join(Customer_.orders);
            CollectionJoin lineItem = order.join(Order_.lineItemsCollection, JoinType.INNER);
            Predicate exp = cbuilder.equal((Expression)lineItem.get("id"), (Object)"1");
            lineItem.on((Expression)exp);
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
            throw new EETest.Fault("queryTest61 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("joinOnExpressionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinOnPredicateArrayTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        try {
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin order = customer.join(Customer_.orders);
            CollectionJoin lineItem = order.join(Order_.lineItemsCollection, JoinType.INNER);
            Predicate pred = lineItem.getOn();
            if (pred == null) {
                TestUtil.logTrace((String)"Received expected null from getOn()");
                pass1 = true;
            } else {
                TestUtil.logErr((String)"Expected getOn() to return null:");
                List lExp = pred.getExpressions();
                for (Object exp : lExp) {
                    TestUtil.logErr((String)("actual:" + exp.toString()));
                }
            }
            Predicate[] predArray = new Predicate[]{cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")};
            lineItem.on(predArray);
            pred = lineItem.getOn();
            if (pred == null) {
                TestUtil.logErr((String)"Received null from getOn()");
            } else {
                pass2 = true;
                TestUtil.logTrace((String)"getOn() returned non-null:");
                List lExp = pred.getExpressions();
                for (Expression exp : lExp) {
                    TestUtil.logTrace((String)("actual:" + exp.toString()));
                }
            }
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass3 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
            throw new EETest.Fault("queryTest61 failed", e);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("joinOnPredicateArrayTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void nullifExpressionExpressionTest() throws EETest.Fault {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        for (Customer c : this.customerRef) {
            String id = c.getId();
            if (Integer.parseInt(id) > 18 || Integer.parseInt(id) == 9) continue;
            if (c.getHome().getCity().equals(c.getWork().getCity())) {
                expected.add(c.getId() + ",null");
                continue;
            }
            expected.add(c.getId() + "," + c.getHome().getCity().toLowerCase());
        }
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Tuple.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            Expression expHomeCity = cbuilder.lower((Expression)customer.get("home").get("city"));
            Expression expWorkCity = cbuilder.lower((Expression)customer.get("work").get("city"));
            cquery.multiselect(new Selection[]{customer.get("id"), cbuilder.nullif(expHomeCity, expWorkCity)});
            cquery.where((Expression)cbuilder.and((Expression)cbuilder.isNotNull((Expression)customer.get("home").get("city")), (Expression)cbuilder.isNotNull((Expression)customer.get("work").get("city"))));
            cquery.orderBy(new Order[]{cbuilder.asc((Expression)customer.get("id"))});
            List result = this.getEntityManager().createQuery(cquery).getResultList();
            for (Tuple t : result) {
                TestUtil.logTrace((String)("actual:" + t.toString()));
                String id = (String)t.get(0);
                String city = (String)t.get(1);
                if (city != null) {
                    actual.add(id + "," + city);
                    continue;
                }
                actual.add(id + ",null");
            }
            for (String s : actual) {
                TestUtil.logTrace((String)("actual:" + s));
            }
            Collections.sort(actual);
            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                TestUtil.logTrace((String)"Received expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)"Did not get expected results");
                for (String s : expected) {
                    TestUtil.logErr((String)("expected:" + s));
                }
                for (String s : actual) {
                    TestUtil.logErr((String)("actual:" + s));
                }
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("nullifExpressionExpressionTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void nullifExpressionObjectTest() throws EETest.Fault {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        for (Customer c : this.customerRef) {
            String id = c.getId();
            if (Integer.parseInt(id) > 18 || Integer.parseInt(id) == 9) continue;
            if (c.getHome().getCity().equals(c.getWork().getCity())) {
                expected.add(c.getId() + ",null");
                continue;
            }
            expected.add(c.getId() + "," + c.getHome().getCity().toLowerCase());
        }
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Tuple.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            Expression expHomeCity = cbuilder.lower((Expression)customer.get("home").get("city"));
            cquery.multiselect(new Selection[]{customer.get("id"), cbuilder.nullif(expHomeCity, (Object)"burlington")});
            cquery.where((Expression)cbuilder.isNotNull((Expression)customer.get("home").get("city")));
            cquery.orderBy(new Order[]{cbuilder.asc((Expression)customer.get("id"))});
            List result = this.getEntityManager().createQuery(cquery).getResultList();
            for (Tuple t : result) {
                TestUtil.logTrace((String)("actual:" + t.toString()));
                String id = (String)t.get(0);
                String city = (String)t.get(1);
                if (city != null) {
                    actual.add(id + "," + city);
                    continue;
                }
                actual.add(id + ",null");
            }
            for (String s : actual) {
                TestUtil.logTrace((String)("actual:" + s));
            }
            Collections.sort(actual);
            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                TestUtil.logTrace((String)"Received expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)"Did not get expected results");
                for (String s : expected) {
                    TestUtil.logErr((String)("expected:" + s));
                }
                for (String s : actual) {
                    TestUtil.logErr((String)("actual:" + s));
                }
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("nullifExpressionObjectTest failed");
        }
    }

    @SetupMethod(name="setupAliasOnlyData")
    public void locateExpressionExpressionExpressionTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.aliasRef[12].getId(), this.aliasRef[13].getId(), this.aliasRef[17].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
        if (cquery != null) {
            Root alias = cquery.from(Alias.class);
            EntityType Alias_ = alias.getModel();
            cquery.select((Selection)alias);
            Path exp1 = alias.get(Alias_.getSingularAttribute("alias", String.class));
            Expression exp2 = cbuilder.literal((Object)"ev");
            Expression exp3 = cbuilder.toInteger(cbuilder.literal((Object)1));
            cquery.where((Expression)cbuilder.gt(cbuilder.locate((Expression)exp1, exp2, exp3), (Number)0));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Alias a : result) {
                actual.add(Integer.parseInt(a.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("locateExpressionExpressionExpressionTest failed");
        }
    }

    @SetupMethod(name="setupAliasOnlyData")
    public void locateExpressionStringIntTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{this.aliasRef[12].getId(), this.aliasRef[13].getId(), this.aliasRef[17].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
        if (cquery != null) {
            Root alias = cquery.from(Alias.class);
            EntityType Alias_ = alias.getModel();
            cquery.select((Selection)alias);
            Path exp1 = alias.get(Alias_.getSingularAttribute("alias", String.class));
            cquery.where((Expression)cbuilder.gt(cbuilder.locate((Expression)exp1, "ev", 1), (Number)0));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Alias a : result) {
                actual.add(Integer.parseInt(a.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("locateExpressionExpressionExpressionTest failed");
        }
    }

    public void coalesceTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaBuilder.Coalesce col = cbuilder.coalesce();
        if (col != null) {
            TestUtil.logTrace((String)"Obtained Non-null Coalesce");
            pass = true;
        } else {
            TestUtil.logErr((String)"Failed to get Non-null Coalesce");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("coalesceTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void selectMultiSelectTest() throws EETest.Fault {
        Integer id;
        ArrayList<Integer> actual;
        List result;
        TypedQuery q;
        EntityType Customer_2;
        CriteriaQuery cquery;
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        for (Customer c : this.customerRef) {
            expected.add(Integer.valueOf(c.getId()));
        }
        Collections.sort(expected);
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        TestUtil.logMsg((String)"Testing select");
        try {
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery();
            if (cquery != null) {
                Root customer = cquery.from(Customer.class);
                Customer_2 = customer.getModel();
                cquery.select((Selection)customer.get(Customer_2.getSingularAttribute("id", String.class)));
                q = this.getEntityManager().createQuery(cquery);
                result = q.getResultList();
                actual = new ArrayList<Integer>();
                for (Object row : result) {
                    id = Integer.valueOf((String)row);
                    TestUtil.logTrace((String)("id=" + id));
                    actual.add(id);
                }
                Collections.sort(actual);
                if (!this.checkEntityPK(actual, expected)) {
                    TestUtil.logErr((String)("Did not get expected results. Expected " + expected.size() + " references, got: " + actual.size()));
                } else {
                    TestUtil.logTrace((String)"Expected results received");
                    pass1 = true;
                }
            } else {
                TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)ex);
        }
        TestUtil.logMsg((String)"Testing multiselect");
        try {
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery();
            if (cquery != null) {
                Root customer = cquery.from(Customer.class);
                Customer_2 = customer.getModel();
                cquery.multiselect(new Selection[]{customer.get(Customer_2.getSingularAttribute("id", String.class)), customer.get(Customer_2.getSingularAttribute("name", String.class))});
                q = this.getEntityManager().createQuery(cquery);
                result = q.getResultList();
                actual = new ArrayList();
                for (Object row : result) {
                    id = Integer.valueOf((String)row[0]);
                    String name = (String)row[1];
                    TestUtil.logTrace((String)("id=" + id));
                    TestUtil.logTrace((String)("name=" + name));
                    if (name != null && this.customerRef[id - 1].getName() != null) {
                        if (this.customerRef[id - 1].getName().equals(name)) {
                            actual.add(id);
                            continue;
                        }
                        TestUtil.logErr((String)("Expected name:|" + this.customerRef[id - 1].getName() + "|, actual:|" + name + "|"));
                        continue;
                    }
                    if (name == null && this.customerRef[id - 1].getName() == null) {
                        actual.add(id);
                        continue;
                    }
                    TestUtil.logErr((String)("Expected name:" + this.customerRef[id - 1].getName() + ", actual:null"));
                }
                Collections.sort(actual);
                if (!this.checkEntityPK(actual, expected)) {
                    TestUtil.logErr((String)("Did not get expected results. Expected " + expected.size() + " references, got: " + actual.size()));
                } else {
                    TestUtil.logTrace((String)"Expected results received");
                    pass2 = true;
                }
            } else {
                TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)ex);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("selectMultiSelectTest test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void multiRootTest() throws EETest.Fault {
        boolean pass = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i <= this.spouse.length; ++i) {
            for (int j = 1; j <= this.spouse.length; ++j) {
                list.add(Integer.toString(i) + "," + Integer.toString(j));
            }
        }
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery();
            if (cquery != null) {
                Root spouse1 = cquery.from(Spouse.class);
                Root spouse2 = cquery.from(Spouse.class);
                EntityType Spouse1_ = spouse1.getModel();
                EntityType Spouse2_ = spouse2.getModel();
                cquery.multiselect(new Selection[]{spouse1.get(Spouse1_.getSingularAttribute("id", String.class)), spouse2.get(Spouse2_.getSingularAttribute("id", String.class))});
                TypedQuery q = this.getEntityManager().createQuery(cquery);
                List result = q.getResultList();
                for (Object[] row : result) {
                    Integer sId1 = Integer.valueOf((String)row[0]);
                    Integer sId2 = Integer.valueOf((String)row[1]);
                    TestUtil.logTrace((String)("sId1=" + sId1 + ", sId2=" + sId2));
                    list.remove(sId1 + "," + sId2);
                }
                TestUtil.logTrace((String)("Size:" + list.size()));
                if (list.isEmpty()) {
                    TestUtil.logTrace((String)"All PK's were found");
                    pass = true;
                } else {
                    TestUtil.logErr((String)"Not all PK's were returned");
                    for (String s : list) {
                        TestUtil.logErr((String)("Not all PK's were returned:" + s));
                    }
                }
            } else {
                TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)ex);
        }
        if (!pass) {
            throw new EETest.Fault("multiRootTest test failed");
        }
    }
}

