/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.lock.entitymanager;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.lock.entitymanager.Coffee;
import java.util.HashMap;
import java.util.Properties;
import javax.persistence.LockModeType;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            TestUtil.logTrace((String)"Cleanup data");
            this.removeTestData();
            TestUtil.logTrace((String)"Create Test data");
            this.createTestData();
            TestUtil.logTrace((String)"Done creating test data");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void findTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin findTest1");
        boolean pass = false;
        this.getEntityTransaction().begin();
        try {
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1, LockModeType.PESSIMISTIC_READ);
            if (coffeeFound != null) {
                TestUtil.logTrace((String)"Found coffee as expected");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("findTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin findTest2");
        boolean pass = false;
        this.getEntityTransaction().begin();
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1, LockModeType.PESSIMISTIC_READ, myMap);
            if (coffeeFound != null) {
                TestUtil.logTrace((String)"Found coffee as expected");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("findTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findTest3() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin findTest3");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"locate Entity Coffee in EntityManager em1 and lock");
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1, LockModeType.PESSIMISTIC_READ);
            TestUtil.logTrace((String)"locate Entity Coffee in EntityManager em2 and update");
            Coffee coffeeFound2 = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1, LockModeType.PESSIMISTIC_WRITE);
            coffeeFound2.setPrice(6.0f);
            this.getEntityTransaction().commit();
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("findTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findTest4() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin findTest1");
        boolean pass = false;
        this.getEntityTransaction().begin();
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1, myMap);
            if (coffeeFound != null) {
                TestUtil.logTrace((String)"Found coffee as expected");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("findTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin lockTest1");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"locate Entity Coffee in EntityManager em1 and lock");
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1);
            this.getEntityManager().lock((Object)coffeeFound, LockModeType.PESSIMISTIC_WRITE);
            TestUtil.logTrace((String)"locate Entity Coffee in EntityManager and update");
            Coffee coffeeFound2 = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1);
            this.getEntityManager().lock((Object)coffeeFound2, LockModeType.PESSIMISTIC_WRITE);
            coffeeFound2.setPrice(6.0f);
            this.getEntityTransaction().commit();
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("lockTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin lockTest2");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"locate Entity Coffee in EntityManager em1 and lock");
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1);
            HashMap<String, String> myMap = new HashMap<String, String>();
            myMap.put("some.cts.specific.property", "nothing.in.particular");
            this.getEntityManager().lock((Object)coffeeFound, LockModeType.PESSIMISTIC_WRITE, myMap);
            TestUtil.logTrace((String)"locate Entity Coffee in EntityManager em1 and update");
            Coffee coffeeFound2 = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1);
            this.getEntityManager().lock((Object)coffeeFound2, LockModeType.PESSIMISTIC_WRITE, myMap);
            coffeeFound2.setPrice(6.0f);
            this.getEntityTransaction().commit();
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("lockTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTest1() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"locate Entity Coffee in EntityManager em1 and lock");
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1);
            this.getEntityManager().refresh((Object)coffeeFound, LockModeType.PESSIMISTIC_READ);
            TestUtil.logTrace((String)"locate Entity Coffee in EntityManager  and update");
            Coffee coffeeFound2 = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1);
            this.getEntityManager().refresh((Object)coffeeFound2, LockModeType.PESSIMISTIC_WRITE);
            coffeeFound2.setPrice(6.0f);
            this.getEntityTransaction().commit();
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("refreshTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin refreshTest2");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"locate Entity Coffee in EntityManager em1 and lock");
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)2);
            HashMap<String, String> myMap = new HashMap<String, String>();
            myMap.put("some.cts.specific.property", "nothing.in.particular");
            this.getEntityManager().refresh((Object)coffeeFound, LockModeType.PESSIMISTIC_READ, myMap);
            TestUtil.logTrace((String)"locate Entity Coffee in EntityManager and update");
            Coffee coffeeFound2 = (Coffee)this.getEntityManager().find(Coffee.class, (Object)2);
            this.getEntityManager().refresh((Object)coffeeFound2, LockModeType.PESSIMISTIC_WRITE, myMap);
            coffeeFound2.setPrice(6.0f);
            this.getEntityTransaction().commit();
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("refreshTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTest3() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin refreshTest3");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"locate Entity Coffee in EntityManager");
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)2);
            HashMap<String, String> myMap = new HashMap<String, String>();
            myMap.put("some.cts.specific.property", "nothing.in.particular");
            this.getEntityManager().refresh((Object)coffeeFound, myMap);
            TestUtil.logTrace((String)"locate Entity Coffee in EntityManager and update");
            Coffee coffeeFound2 = (Coffee)this.getEntityManager().find(Coffee.class, (Object)2);
            this.getEntityManager().refresh((Object)coffeeFound2, myMap);
            coffeeFound2.setPrice(6.0f);
            this.getEntityTransaction().commit();
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("refreshTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestData() throws Exception {
        try {
            TestUtil.logTrace((String)"createTestData");
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Create 5 Coffees");
            Coffee[] cRef = new Coffee[]{new Coffee(Integer.valueOf(1), "hazelnut", 1.0f), new Coffee(Integer.valueOf(2), "vanilla creme", 2.0f), new Coffee(Integer.valueOf(3), "decaf", 3.0f), new Coffee(Integer.valueOf(4), "breakfast blend", 4.0f), new Coffee(Integer.valueOf(5), "mocha", 5.0f)};
            TestUtil.logTrace((String)"Start to persist coffees ");
            for (Coffee c : cRef) {
                if (c == null) continue;
                this.getEntityManager().persist((Object)c);
                TestUtil.logTrace((String)("persisted coffee " + c));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception creating test data:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM COFFEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

