/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry.BusinessQueryManager;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.SpecificationLink;

public class JAXRClient
extends JAXRCommonClient {
    Locale tsLocale = new Locale("en", "US");

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            this.debug.clear();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            this.logMsg("in cleanup");
            if (this.conn != null) {
                this.logTrace("Cleanup is closing the connection");
                this.conn.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void businessQueryManager_findClassificationSchemeByNameTest() throws EETest.Fault {
        String testName = "businessQueryManager_findClassificationSchemeByNameTest";
        boolean pass = false;
        String schemeName = "PhoneType";
        try {
            pass = this.findClassificationSchemeByName(schemeName, testName);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void businessQueryManager_findClassificationSchemeByNamePartialNameTest() throws EETest.Fault {
        block4: {
            String testName = "businessQueryManager_findClassificationSchemeByNamePartialNameTest";
            String schemeName = "%honeTyp%";
            String fullSchemeName = "PhoneType";
            try {
                ArrayList<String> findQualifiers = new ArrayList<String>();
                findQualifiers.add("sortByNameDesc");
                BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
                ClassificationScheme scheme = bqm.findClassificationSchemeByName(findQualifiers, schemeName);
                if (scheme != null) {
                    this.debug.add("name is: " + scheme.getName().getValue());
                    if (!scheme.getName().getValue().equals(fullSchemeName)) {
                        throw new EETest.Fault(testName + " Error: unexpected scheme name returned");
                    }
                    break block4;
                }
                throw new EETest.Fault(testName + " Error: returned null scheme");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void businessQueryManager_findClassificationSchemeByNameNullTest() throws EETest.Fault {
        String testName = "businessQueryManager_findClassificationSchemeByNameNullTest";
        boolean pass = false;
        String schemeName = "invalidinvalidinvalidinvalidinvalid";
        try {
            ArrayList<String> findQualifiers = new ArrayList<String>();
            findQualifiers.add("sortByNameDesc");
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            ClassificationScheme scheme = bqm.findClassificationSchemeByName(findQualifiers, schemeName);
            if (scheme != null) {
                this.debug.add("name is: " + scheme.getName().getValue());
            } else {
                this.debug.add("Pass: null returned!!\n");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    private boolean findClassificationSchemeByName(String schemeName, String testName) {
        block5: {
            try {
                Locale en_US = new Locale("en", "US");
                ArrayList<String> findQualifiers = new ArrayList<String>();
                findQualifiers.add("sortByNameDesc");
                BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
                ClassificationScheme scheme = bqm.findClassificationSchemeByName(findQualifiers, schemeName);
                if (scheme != null) {
                    this.debug.add("name is: " + scheme.getName().getValue(en_US));
                    if (!scheme.getName().getValue(en_US).equals(schemeName)) {
                        return false;
                    }
                    break block5;
                }
                this.debug.add("Error: null returned!!\n");
                return false;
            }
            catch (InvalidRequestException ex) {
                TestUtil.logTrace((String)"Caught exception InvalidRequestException. Multiple match found");
                return true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void businessQueryManager_findOrganizationsTest() throws EETest.Fault {
        boolean pass;
        String testName;
        block15: {
            testName = "businessQueryManager_findOrganizationsTest";
            String orgName = testName + "_organization";
            Collection orgKeys = null;
            Key orgKey2222222222 = null;
            pass = false;
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(orgName));
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            orgs.add(org);
            BulkResponse br = this.blm.saveOrganizations(orgs);
            orgKeys = br.getCollection();
            if (orgKeys.size() != 1) {
                throw new EETest.Fault("Error: expected 1 organization to be saved.  exiting test");
            }
            for (Key orgKey2222222222 : orgKeys) {
            }
            ArrayList<String> findQualifiers = new ArrayList<String>();
            findQualifiers.add("exactNameMatch");
            ArrayList<String> namePatterns = new ArrayList<String>();
            namePatterns.add(orgName);
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            br = bqm.findOrganizations(findQualifiers, namePatterns, null, null, null, null);
            Collection collectionOrgsRet = br.getCollection();
            for (Organization o : collectionOrgsRet) {
                if (o.getKey().getId().equals(orgKey2222222222.getId())) {
                    this.debug.add("good.  Got back the correct organization!! \n");
                    pass = true;
                    continue;
                }
                pass = false;
            }
            try {
                this.debug.add(" Cleanup: Remove source organization\n");
                this.blm.deleteOrganizations(orgKeys);
            }
            catch (JAXRException je) {
                TestUtil.printStackTrace((Throwable)je);
                this.debug.add("Error: not able to delete registry object\n");
            }
            break block15;
            catch (Exception e) {
                try {
                    TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                    TestUtil.printStackTrace((Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        this.debug.add(" Cleanup: Remove source organization\n");
                        this.blm.deleteOrganizations(orgKeys);
                    }
                    catch (JAXRException je) {
                        TestUtil.printStackTrace((Throwable)je);
                        this.debug.add("Error: not able to delete registry object\n");
                    }
                    throw throwable;
                }
                try {
                    this.debug.add(" Cleanup: Remove source organization\n");
                    this.blm.deleteOrganizations(orgKeys);
                }
                catch (JAXRException je) {
                    TestUtil.printStackTrace((Throwable)je);
                    this.debug.add("Error: not able to delete registry object\n");
                }
            }
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed!");
        }
    }

    public void businessQueryManager_findServiceTest() throws EETest.Fault {
        String testName = "businessQueryManager_findServiceTest";
        boolean pass = false;
        Object keys = null;
        Object key = null;
        Key orgKey2 = null;
        int numOrgs = 3;
        ArrayList<Organization> orgs = null;
        ArrayList<Service> services = null;
        String serviceName = "Name:Test Service";
        String orgName = "TS Default Organization";
        try {
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(orgName));
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            orgs = new ArrayList<Organization>();
            orgs.add(org);
            BulkResponse br = this.blm.saveOrganizations(orgs);
            if (br.getExceptions() != null) {
                Collection ex = br.getExceptions();
                for (JAXRException je : ex) {
                    this.debug.add("== Detail Message for the JAXRException object: " + je.getMessage() + "\n");
                }
                throw new EETest.Fault(testName + " failed ");
            }
            Collection orgKeys = br.getCollection();
            if (orgKeys.size() != 1) {
                throw new EETest.Fault("Error: expected 1 organization to be saved.  exiting test");
            }
            for (Key orgKey2 : orgKeys) {
            }
            br = bqm.getRegistryObjects(orgKeys, "Organization");
            if (br.getExceptions() != null) {
                Collection ex = br.getExceptions();
                for (JAXRException je : ex) {
                    this.debug.add("== Detail Message for the JAXRException object: " + je.getMessage() + "\n");
                }
                throw new EETest.Fault("Error: retrieving organization  from registry.  exiting test");
            }
            Collection myOrgs = br.getCollection();
            services = new ArrayList<Service>();
            Service theService = (Service)this.blm.createObject("Service");
            Iterator iter = myOrgs.iterator();
            Organization myOrg = null;
            theService.setName(this.blm.createInternationalString(this.tsLocale, serviceName));
            theService.setDescription(this.blm.createInternationalString(this.tsLocale, "Description: Testservice"));
            while (iter.hasNext()) {
                myOrg = (Organization)iter.next();
                myOrg.addService(theService);
                services.add(theService);
            }
            br = this.blm.saveServices(services);
            Collection serviceKeys = br.getCollection();
            ArrayList<Organization> updatedOrg = new ArrayList<Organization>();
            updatedOrg.add(myOrg);
            br = this.blm.saveOrganizations(updatedOrg);
            ArrayList<String> names = new ArrayList<String>();
            names.add(serviceName);
            br = bqm.findServices(orgKey2, null, names, null, null);
            Service s2 = null;
            Collection ss = br.getCollection();
            this.debug.add("Count returned from findServices should be one \n");
            this.debug.add("Count returned : " + ss.size() + "\n");
            for (Service s2 : ss) {
                this.debug.add("And the service returned is: " + s2.getName().getValue(this.tsLocale) + "\n");
            }
            if (s2.getName().getValue(this.tsLocale).equals(serviceName)) {
                pass = true;
                this.debug.add(testName + "Found Service successfully!!!\n");
            } else {
                this.debug.add(testName + "Failed to add Service successfully!!\n");
            }
            br = this.blm.deleteServices(serviceKeys);
            br = bqm.findServices(orgKey2, null, names, null, null);
            s2 = null;
            ss = br.getCollection();
            this.debug.add("Count returned from findServices should be none \n");
            this.debug.add("Count returned : " + ss.size() + "\n");
            br = this.blm.deleteOrganizations(orgKeys);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void businessQueryManager_findServiceBindingsTest() throws EETest.Fault {
        block20: {
            String testName = "businessQueryManager_findServiceBindingsTest";
            String serviceName = "test service for businessQueryManager_findServiceBindingsTest";
            String url = "http://java.sun.com";
            Object serviceBindingKeys = null;
            ArrayList<Key> serviceKeys = null;
            Collection orgKeys = null;
            Collection conceptKeys = null;
            BulkResponse br = null;
            BusinessQueryManager bqm = null;
            Key serviceKey = null;
            ServiceBinding serviceBindingRet2222222222 = null;
            String orgName = "TS Default Organization";
            String externalURI = "http://java.sun.com";
            String description = "link for my service";
            bqm = this.rs.getBusinessQueryManager();
            Organization org = this.blm.createOrganization(orgName);
            ServiceBinding sb = this.blm.createServiceBinding();
            sb.setAccessURI(url);
            Service service = this.blm.createService(serviceName);
            Concept myConcept2222222222 = (Concept)this.blm.createObject("Concept");
            myConcept2222222222.setName(this.blm.createInternationalString("myWSDLFile"));
            ArrayList<Concept> cons = new ArrayList<Concept>();
            cons.add(myConcept2222222222);
            br = this.blm.saveConcepts(cons);
            conceptKeys = br.getCollection();
            if (conceptKeys.size() != 1) {
                this.debug.add("Error: expected one concept key to be returned \n");
                throw new EETest.Fault(testName + " test did not complete ");
            }
            br = bqm.getRegistryObjects(conceptKeys, "Concept");
            Collection cc = br.getCollection();
            if (cc.size() != 1) {
                this.debug.add("Error: expected one concept to be returned \n");
                throw new EETest.Fault(testName + " test did not complete ");
            }
            for (Concept myConcept2222222222 : cc) {
            }
            ExternalLink el = this.blm.createExternalLink(externalURI, description);
            ArrayList<ExternalLink> els = new ArrayList<ExternalLink>();
            els.add(el);
            myConcept2222222222.setExternalLinks(els);
            SpecificationLink sl = this.blm.createSpecificationLink();
            sl.setUsageDescription(this.blm.createInternationalString("yada yada"));
            sl.setSpecificationObject((RegistryObject)myConcept2222222222);
            sb.addSpecificationLink(sl);
            service.addServiceBinding(sb);
            org.addService(service);
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            orgs.add(org);
            br = this.blm.saveOrganizations(orgs);
            orgKeys = br.getCollection();
            Key orgKey2222222222 = null;
            this.debug.add("\nOrg key count is " + orgKeys.size() + "\n");
            if (orgKeys.size() != 1) {
                this.debug.add("Error: expected one org key to be returned \n");
                throw new EETest.Fault(testName + " test did not complete ");
            }
            for (Key orgKey2222222222 : orgKeys) {
            }
            ArrayList<String> namePatterns = new ArrayList<String>();
            namePatterns.add(serviceName);
            br = bqm.findServices(orgKey2222222222, null, namePatterns, null, null);
            Collection ss = br.getCollection();
            if (ss.size() != 1) {
                this.debug.add("Error: expected one service to be returned \n");
                throw new EETest.Fault(testName + " test did not complete ");
            }
            Service s2222222222 = null;
            for (Service s2222222222 : ss) {
                serviceKey = s2222222222.getKey();
            }
            ArrayList<Concept> ros = new ArrayList<Concept>();
            ros.add(myConcept2222222222);
            br = bqm.findServiceBindings(s2222222222.getKey(), null, null, ros);
            Collection serviceBindings = br.getCollection();
            if (serviceBindings.size() != 1) {
                this.debug.add("Error: expected one serviceBinding to be returned \n");
                throw new EETest.Fault(testName + " test did not complete ");
            }
            for (ServiceBinding serviceBindingRet2222222222 : serviceBindings) {
            }
            this.debug.add("Service name is: " + serviceBindingRet2222222222.getService().getName().getValue(this.tsLocale) + "\n");
            if (!serviceName.equals(serviceBindingRet2222222222.getService().getName().getValue(this.tsLocale))) {
                throw new EETest.Fault(testName + " didn't get back binding ");
            }
            this.debug.add("found the binding\n");
            try {
                serviceKeys = new ArrayList();
                serviceKeys.add(serviceKey);
                this.blm.deleteServices(serviceKeys);
                this.blm.deleteConcepts(conceptKeys);
                this.blm.deleteOrganizations(orgKeys);
            }
            catch (JAXRException je) {
                TestUtil.printStackTrace((Throwable)je);
                this.debug.add("Error: not able to delete registry object\n");
            }
            break block20;
            catch (Exception e) {
                try {
                    TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                    TestUtil.printStackTrace((Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        serviceKeys = new ArrayList<Key>();
                        serviceKeys.add(serviceKey);
                        this.blm.deleteServices(serviceKeys);
                        this.blm.deleteConcepts(conceptKeys);
                        this.blm.deleteOrganizations(orgKeys);
                    }
                    catch (JAXRException je) {
                        TestUtil.printStackTrace((Throwable)je);
                        this.debug.add("Error: not able to delete registry object\n");
                    }
                    throw throwable;
                }
                try {
                    serviceKeys = new ArrayList();
                    serviceKeys.add(serviceKey);
                    this.blm.deleteServices(serviceKeys);
                    this.blm.deleteConcepts(conceptKeys);
                    this.blm.deleteOrganizations(orgKeys);
                }
                catch (JAXRException je) {
                    TestUtil.printStackTrace((Throwable)je);
                    this.debug.add("Error: not able to delete registry object\n");
                }
            }
        }
    }

    public void businessQueryManager_findRegistryPackagesTest() throws EETest.Fault {
        String testName = "businessQueryManager_findRegistryPackagesTest";
        boolean pass = true;
        try {
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            int providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
            this.debug.add("Level 0 Providers must throw an UnsupportedCapabilityException for getRegistryObject(String)\n");
            this.debug.add("This provider reported a Capability Level of " + providerlevel + "\n");
            if (providerlevel == 0) {
                ArrayList<String> namePatterns = new ArrayList<String>();
                namePatterns.add("myRegistryPackage");
                BulkResponse br = bqm.findRegistryPackages(null, namePatterns, null, null);
                this.debug.add(" Call to findRegistryPackages(id) DID NOT throw an UnsupportedCapabilityException as expected\n");
                pass = false;
            }
        }
        catch (UnsupportedCapabilityException uc) {
            TestUtil.printStackTrace((Throwable)uc);
            this.debug.add(" Call to getRegistryObject(id) threw UnsupportedCapabilityException as expected\n");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }
}

