/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxws.common;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxws.common.HandlerTracker;
import com.sun.ts.tests.jaxws.common.Handler_Util;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.xml.ws.LogicalMessage;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.LogicalMessageContext;
import javax.xml.ws.handler.MessageContext;

public class LogicalHandlerBase
implements LogicalHandler<LogicalMessageContext> {
    private int destroyCalled = 0;
    private int doingHandlerWork = 0;
    private static final String NAMESPACEURI = "http://handlerservice.org/wsdl";
    private static final String PORT_NAME1 = "handlerservice.portname.1";
    private String whichHandlerType = null;
    private String handlerName = null;

    public void setWhichHandlerType(String w) {
        this.whichHandlerType = w;
    }

    public String getWhichHandlerType() {
        return this.whichHandlerType;
    }

    public void setHandlerName(String h) {
        this.handlerName = h;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public void preinvoke() {
        ++this.doingHandlerWork;
        if (this.destroyCalled > 0) {
            HandlerTracker.reportThrowable((Handler)this, new Exception("Violation of Handler Lifecycle - Handler used after destroy called"));
        }
    }

    public void postinvoke() {
        this.doingHandlerWork = 0;
    }

    @PostConstruct
    public void myInit() {
        System.out.println("in " + this + ":myInit");
        HandlerTracker.reportInit((Handler)this, "myInit");
    }

    @PreDestroy
    public void myDestroy() {
        System.out.println("in " + this + ":myDestroy");
        if (this.doingHandlerWork > 0) {
            HandlerTracker.reportThrowable((Handler)this, new Exception("Violation of Handler Lifecycle - destroy called during handler usage"));
        }
        ++this.destroyCalled;
        HandlerTracker.reportDestroy((Handler)this, "myDestroy");
    }

    public boolean handleMessage(LogicalMessageContext context) {
        System.out.println("in " + this + ":handleMessage");
        TestUtil.logTrace((String)("in " + this + ":handleMessage"));
        try {
            this.preinvoke();
            Handler_Util.setTraceFlag(Handler_Util.getValueFromMsg((Handler)this, (MessageContext)context, "harnesslogtraceflag"));
            Handler_Util.initTestUtil((Handler)this, Handler_Util.getValueFromMsg((Handler)this, (MessageContext)context, "harnessloghost"), Handler_Util.getValueFromMsg((Handler)this, (MessageContext)context, "harnesslogport"), Handler_Util.getValueFromMsg((Handler)this, (MessageContext)context, "harnesslogtraceflag"));
            if (!Handler_Util.checkForMsg((Handler)this, (MessageContext)context, "GetTrackerData")) {
                String direction = Handler_Util.getDirection((MessageContext)context);
                HandlerTracker.reportHandleMessage((Handler)this, direction);
                if (Handler_Util.checkForMsg((Handler)this, (MessageContext)context, "LogicalTest</testType>")) {
                    if (Handler_Util.checkForMsg((Handler)this, (MessageContext)context, "MessageContextTest")) {
                        this.doLogicalMessageContext(context, direction);
                        this.doMessageContext(context, direction);
                    } else if (Handler_Util.checkForMsg((Handler)this, (MessageContext)context, "ContextPropertiesTest")) {
                        this.doContextProperties(context, direction);
                    }
                }
            } else {
                TestUtil.logTrace((String)"found GetTrackerData message, handler will ignore");
            }
        }
        catch (Exception e) {
            HandlerTracker.reportThrowable((Handler)this, e);
        }
        finally {
            this.postinvoke();
        }
        System.out.println("exiting " + this + ":handleMessage");
        TestUtil.logTrace((String)("exiting " + this + ":handleMessage"));
        return true;
    }

    public void close(MessageContext context) {
        TestUtil.logTrace((String)("in " + this + ":close"));
        try {
            this.preinvoke();
            HandlerTracker.reportClose((Handler)this);
        }
        finally {
            this.postinvoke();
        }
    }

    public boolean handleFault(LogicalMessageContext context) {
        System.out.println("in " + this + ":handleFault");
        TestUtil.logTrace((String)("in " + this + ":handleFault"));
        try {
            this.preinvoke();
            HandlerTracker.reportHandleFault((Handler)this);
        }
        finally {
            this.postinvoke();
        }
        TestUtil.logTrace((String)("exiting " + this + ":handleFault"));
        System.out.println("exiting " + this + ":handleFault");
        return true;
    }

    private void doContextProperties(LogicalMessageContext context, String direction) {
        TestUtil.logTrace((String)"in doLogicalMessageContext");
        TestUtil.logTrace((String)("direction=" + direction));
        TestUtil.logTrace((String)("handlerName=" + this.handlerName));
        if (this.handlerName.equals("ClientLogicalHandler2") || this.handlerName.equals("ServerLogicalHandler2")) {
            Map m1 = null;
            String attachmentProp = "";
            if (direction.equals("Outbound")) {
                m1 = (Map)context.get((Object)"javax.xml.ws.binding.attachments.outbound");
                attachmentProp = "LogicalMessageContext.OUTBOUND_MESSAGE_ATTACHMENTS";
            } else {
                m1 = (Map)context.get((Object)"javax.xml.ws.binding.attachments.inbound");
                attachmentProp = "LogicalMessageContext.INBOUND_MESSAGE_ATTACHMENTS";
            }
            int cnt = 0;
            Iterator iterator = null;
            String sTmp = "";
            try {
                if (m1 != null) {
                    if (m1.size() > 0) {
                        for (String key : m1.keySet()) {
                            TestUtil.logTrace((String)("request attachments key[" + cnt + "]=" + key));
                            sTmp = "key[" + cnt + "]=" + key;
                            HandlerTracker.reportProperties((Handler)this, direction, attachmentProp, sTmp);
                            ++cnt;
                        }
                    } else {
                        TestUtil.logTrace((String)"empty");
                        HandlerTracker.reportProperties((Handler)this, direction, attachmentProp, "empty");
                    }
                } else {
                    TestUtil.logTrace((String)"null");
                    HandlerTracker.reportProperties((Handler)this, direction, attachmentProp, "null");
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
            if (direction.equals("Outbound")) {
                m1 = (Map)context.get((Object)"javax.xml.ws.binding.attachments.outbound");
                attachmentProp = "MessageContext.OUTBOUND_MESSAGE_ATTACHMENTS";
            } else {
                m1 = (Map)context.get((Object)"javax.xml.ws.binding.attachments.inbound");
                attachmentProp = "MessageContext.INBOUND_MESSAGE_ATTACHMENTS";
            }
            cnt = 0;
            iterator = null;
            try {
                if (m1 != null) {
                    if (m1.size() > 0) {
                        for (String key : m1.keySet()) {
                            TestUtil.logTrace((String)("request attachments key[" + cnt + "]=" + key));
                            sTmp = "key[" + cnt + "]=" + key;
                            HandlerTracker.reportProperties((Handler)this, direction, attachmentProp, sTmp);
                            ++cnt;
                        }
                    } else {
                        TestUtil.logTrace((String)"empty");
                        HandlerTracker.reportProperties((Handler)this, direction, attachmentProp, "empty");
                    }
                } else {
                    TestUtil.logTrace((String)"null");
                    HandlerTracker.reportProperties((Handler)this, direction, attachmentProp, "null");
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
            String ss = (String)context.get((Object)"javax.xml.ws.http.request.method");
            if (ss != null) {
                HandlerTracker.reportProperties((Handler)this, direction, "LogicalMessageContext.HTTP_REQUEST_METHOD", ss);
            } else {
                HandlerTracker.reportProperties((Handler)this, direction, "LogicalMessageContext.HTTP_REQUEST_METHOD", "null");
            }
            ss = (String)context.get((Object)"javax.xml.ws.http.request.method");
            if (ss != null) {
                HandlerTracker.reportProperties((Handler)this, direction, "MessageContext.HTTP_REQUEST_METHOD", ss);
            } else {
                HandlerTracker.reportProperties((Handler)this, direction, "MessageContext.HTTP_REQUEST_METHOD", "null");
            }
            Integer ii = (Integer)context.get((Object)"javax.xml.ws.http.response.code");
            if (ii != null) {
                HandlerTracker.reportProperties((Handler)this, direction, "LogicalMessageContext.HTTP_RESPONSE_CODE", ii.toString());
            } else {
                HandlerTracker.reportProperties((Handler)this, direction, "LogicalMessageContext.HTTP_RESPONSE_CODE", "null");
            }
            ii = (Integer)context.get((Object)"javax.xml.ws.http.response.code");
            if (ii != null) {
                HandlerTracker.reportProperties((Handler)this, direction, "MessageContext.HTTP_RESPONSE_CODE", ii.toString());
            } else {
                HandlerTracker.reportProperties((Handler)this, direction, "MessageContext.HTTP_RESPONSE_CODE", "null");
            }
            Map m2 = (Map)context.get((Object)"javax.xml.ws.http.request.headers");
            StringBuffer sb = new StringBuffer();
            cnt = 0;
            iterator = null;
            try {
                if (m2 != null) {
                    if (m2.size() > 0) {
                        for (String key : m2.keySet()) {
                            TestUtil.logTrace((String)("request headers key[" + cnt + "]=" + key));
                            sb.append("key[" + cnt + "]=" + key + "|");
                            ++cnt;
                        }
                    } else {
                        TestUtil.logTrace((String)"empty");
                        sb.append("empty");
                    }
                } else {
                    TestUtil.logTrace((String)"null");
                    sb.append("null");
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
            HandlerTracker.reportProperties((Handler)this, direction, "LogicalMessageContext.HTTP_REQUEST_HEADERS", sb.toString());
            m2 = (Map)context.get((Object)"javax.xml.ws.http.request.headers");
            sb = new StringBuffer();
            cnt = 0;
            iterator = null;
            try {
                if (m2 != null) {
                    if (m2.size() > 0) {
                        for (String key : m2.keySet()) {
                            TestUtil.logTrace((String)("request headers key[" + cnt + "]=" + key));
                            sb.append("key[" + cnt + "]=" + key + "|");
                            ++cnt;
                        }
                    } else {
                        TestUtil.logTrace((String)"empty");
                        sb.append("empty");
                    }
                } else {
                    TestUtil.logTrace((String)"null");
                    sb.append("null");
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
            HandlerTracker.reportProperties((Handler)this, direction, "MessageContext.HTTP_REQUEST_HEADERS", sb.toString());
            m2 = (Map)context.get((Object)"javax.xml.ws.http.response.headers");
            sb = new StringBuffer();
            cnt = 0;
            iterator = null;
            try {
                if (m2 != null) {
                    if (m2.size() > 0) {
                        for (String key : m2.keySet()) {
                            TestUtil.logTrace((String)("response headers key[" + cnt + "]=" + key));
                            sb.append("key[" + cnt + "]=" + key + "|");
                            ++cnt;
                        }
                    } else {
                        TestUtil.logTrace((String)"empty");
                        sb.append("empty");
                    }
                } else {
                    TestUtil.logTrace((String)"null");
                    sb.append("null");
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
            HandlerTracker.reportProperties((Handler)this, direction, "LogicalMessageContext.HTTP_RESPONSE_HEADERS", sb.toString());
            m2 = (Map)context.get((Object)"javax.xml.ws.http.response.headers");
            sb = new StringBuffer();
            cnt = 0;
            try {
                if (m2 != null) {
                    if (m2.size() > 0) {
                        for (String key : m2.keySet()) {
                            TestUtil.logTrace((String)("response headers key[" + cnt + "]=" + key));
                            sb.append("key[" + cnt + "]=" + key + "|");
                            ++cnt;
                        }
                    } else {
                        TestUtil.logTrace((String)"empty");
                        sb.append("empty");
                    }
                } else {
                    TestUtil.logTrace((String)"null");
                    sb.append("null");
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
            HandlerTracker.reportProperties((Handler)this, direction, "MessageContext.HTTP_RESPONSE_HEADERS", sb.toString());
            Object oo = context.get((Object)"javax.xml.ws.servlet.request");
            if (oo != null) {
                HandlerTracker.reportProperties((Handler)this, direction, "LogicalMessageContext.SERVLET_REQUEST", oo.toString());
            } else {
                HandlerTracker.reportProperties((Handler)this, direction, "LogicalMessageContext.SERVLET_REQUEST", "null");
            }
            oo = context.get((Object)"javax.xml.ws.servlet.request");
            if (oo != null) {
                HandlerTracker.reportProperties((Handler)this, direction, "MessageContext.SERVLET_REQUEST", oo.toString());
            } else {
                HandlerTracker.reportProperties((Handler)this, direction, "MessageContext.SERVLET_REQUEST", "null");
            }
            oo = context.get((Object)"javax.xml.ws.servlet.response");
            if (oo != null) {
                HandlerTracker.reportProperties((Handler)this, direction, "LogicalMessageContext.SERVLET_RESPONSE", oo.toString());
            } else {
                HandlerTracker.reportProperties((Handler)this, direction, "LogicalMessageContext.SERVLET_RESPONSE", "null");
            }
            oo = context.get((Object)"javax.xml.ws.servlet.response");
            if (oo != null) {
                HandlerTracker.reportProperties((Handler)this, direction, "MessageContext.SERVLET_RESPONSE", oo.toString());
            } else {
                HandlerTracker.reportProperties((Handler)this, direction, "MessageContext.SERVLET_RESPONSE", "null");
            }
            oo = context.get((Object)"javax.xml.ws.servlet.context");
            if (oo != null) {
                HandlerTracker.reportProperties((Handler)this, direction, "LogicalMessageContext.SERVLET_CONTEXT", oo.toString());
            } else {
                HandlerTracker.reportProperties((Handler)this, direction, "LogicalMessageContext.SERVLET_CONTEXT", "null");
            }
            oo = context.get((Object)"javax.xml.ws.servlet.context");
            if (oo != null) {
                HandlerTracker.reportProperties((Handler)this, direction, "MessageContext.SERVLET_CONTEXT", oo.toString());
            } else {
                HandlerTracker.reportProperties((Handler)this, direction, "MessageContext.SERVLET_CONTEXT", "null");
            }
        }
    }

    private void doLogicalMessageContext(LogicalMessageContext context, String direction) {
        TestUtil.logTrace((String)"in doLogicalMessageContext");
        TestUtil.logTrace((String)("direction=" + direction));
        TestUtil.logTrace((String)("handlerName=" + this.handlerName));
        if (this.handlerName.equals("ClientLogicalHandler2") || this.handlerName.equals("ServerLogicalHandler2")) {
            TestUtil.logTrace((String)"calling context.getMessage()");
            LogicalMessage lm = context.getMessage();
            if (lm != null) {
                HandlerTracker.reportLMCGetMessage((Handler)this, direction, "returned nonnull");
            } else {
                HandlerTracker.reportLMCGetMessage((Handler)this, direction, "returned null");
            }
        }
    }

    private void doMessageContext(LogicalMessageContext context, String direction) {
        String whichDirection = direction.toUpperCase();
        TestUtil.logTrace((String)"in doMessageContext");
        TestUtil.logTrace((String)("whichDirection=" + whichDirection));
        TestUtil.logTrace((String)("handlerName=" + this.handlerName));
        if (this.handlerName.equals("ClientLogicalHandler2") || this.handlerName.equals("ServerLogicalHandler2")) {
            HandlerTracker.reportComment((Handler)this, "BeginMessageContextCallbackInvocations");
            TestUtil.logTrace((String)("whichHandlerType=" + this.whichHandlerType));
            if (this.whichHandlerType.equals("Client")) {
                HandlerTracker.reportGet((Handler)this, this.whichHandlerType + "To" + this.whichHandlerType + "Prop", (String)context.get((Object)(this.whichHandlerType + "To" + this.whichHandlerType + "Prop")));
                String tmp = (String)context.get((Object)(this.whichHandlerType + "To" + this.whichHandlerType + "Prop"));
                tmp = tmp + whichDirection + this.whichHandlerType + "LogicalHandler2";
                context.put((Object)(this.whichHandlerType + "To" + this.whichHandlerType + "Prop"), (Object)tmp);
                HandlerTracker.reportPut((Handler)this, this.whichHandlerType + "To" + this.whichHandlerType + "Prop", tmp);
                context.setScope(this.whichHandlerType + "To" + this.whichHandlerType + "Prop", MessageContext.Scope.APPLICATION);
                HandlerTracker.reportSetScope((Handler)this, this.whichHandlerType + "To" + this.whichHandlerType + "Prop", MessageContext.Scope.APPLICATION.toString());
            } else {
                String tmp = "";
                if (direction.equals("Outbound")) {
                    HandlerTracker.reportGet((Handler)this, "Handler" + this.whichHandlerType + "HandlerProp", (String)context.get((Object)("Handler" + this.whichHandlerType + "HandlerProp")));
                    tmp = (String)context.get((Object)("Handler" + this.whichHandlerType + "HandlerProp"));
                }
                tmp = tmp + whichDirection + this.whichHandlerType + "LogicalHandler2";
                context.put((Object)("Handler" + this.whichHandlerType + "HandlerProp"), (Object)tmp);
                HandlerTracker.reportPut((Handler)this, "Handler" + this.whichHandlerType + "HandlerProp", tmp);
                context.setScope("Handler" + this.whichHandlerType + "HandlerProp", MessageContext.Scope.APPLICATION);
                HandlerTracker.reportSetScope((Handler)this, "Handler" + this.whichHandlerType + "HandlerProp", MessageContext.Scope.APPLICATION.toString());
            }
            HandlerTracker.reportComment((Handler)this, "EndMessageContextCallbackInvocations");
        } else if (this.handlerName.equals("ClientLogicalHandler1") || this.handlerName.equals("ServerLogicalHandler1")) {
            HandlerTracker.reportComment((Handler)this, "BeginMessageContextCallbackInvocations");
            if (direction.equals("Outbound")) {
                HandlerTracker.reportComment((Handler)this, "Set Properties and see that Handler3 can access them");
                context.put((Object)(whichDirection + this.whichHandlerType + "LogicalCrossHandlerPropSetByHandler1"), (Object)"SetByHandler1");
                HandlerTracker.reportPut((Handler)this, whichDirection + this.whichHandlerType + "LogicalCrossHandlerPropSetByHandler1", "SetByHandler1");
                context.put((Object)(whichDirection + this.whichHandlerType + "LogicalMessageScopeAppPropSetByHandler1"), (Object)"SetByHandler1");
                HandlerTracker.reportPut((Handler)this, whichDirection + this.whichHandlerType + "LogicalMessageScopeAppPropSetByHandler1", "SetByHandler1");
                context.setScope(whichDirection + this.whichHandlerType + "LogicalMessageScopeAppPropSetByHandler1", MessageContext.Scope.APPLICATION);
                HandlerTracker.reportSetScope((Handler)this, whichDirection + this.whichHandlerType + "LogicalMessageScopeAppPropSetByHandler1", MessageContext.Scope.APPLICATION.toString());
                context.put((Object)(whichDirection + this.whichHandlerType + "LogicalMessageScopeHandlerPropSetByHandler1"), (Object)"SetByHandler1");
                HandlerTracker.reportPut((Handler)this, whichDirection + this.whichHandlerType + "LogicalMessageScopeHandlerPropSetByHandler1", "SetByHandler1");
                context.setScope(whichDirection + this.whichHandlerType + "LogicalMessageScopeHandlerPropSetByHandler1", MessageContext.Scope.HANDLER);
                HandlerTracker.reportSetScope((Handler)this, whichDirection + this.whichHandlerType + "LogicalMessageScopeHandlerPropSetByHandler1", MessageContext.Scope.HANDLER.toString());
            } else if (direction.equals("Inbound")) {
                HandlerTracker.reportGet((Handler)this, whichDirection + this.whichHandlerType + "LogicalCrossHandlerPropSetByHandler3", (String)context.get((Object)(whichDirection + this.whichHandlerType + "LogicalCrossHandlerPropSetByHandler3")));
                HandlerTracker.reportGet((Handler)this, whichDirection + this.whichHandlerType + "LogicalMessageScopeAppPropSetByHandler3", (String)context.get((Object)(whichDirection + this.whichHandlerType + "LogicalMessageScopeAppPropSetByHandler3")));
                HandlerTracker.reportGet((Handler)this, whichDirection + this.whichHandlerType + "LogicalMessageScopeHandlerPropSetByHandler3", (String)context.get((Object)(whichDirection + this.whichHandlerType + "LogicalMessageScopeHandlerPropSetByHandler3")));
                HandlerTracker.reportGetScope((Handler)this, whichDirection + this.whichHandlerType + "LogicalCrossHandlerPropSetByHandler3", context.getScope(whichDirection + this.whichHandlerType + "LogicalCrossHandlerPropSetByHandler3").toString());
                HandlerTracker.reportGetScope((Handler)this, whichDirection + this.whichHandlerType + "LogicalMessageScopeAppPropSetByHandler3", context.getScope(whichDirection + this.whichHandlerType + "LogicalMessageScopeAppPropSetByHandler3").toString());
                HandlerTracker.reportGetScope((Handler)this, whichDirection + this.whichHandlerType + "LogicalMessageScopeHandlerPropSetByHandler3", context.getScope(whichDirection + this.whichHandlerType + "LogicalMessageScopeHandlerPropSetByHandler3").toString());
            }
            HandlerTracker.reportComment((Handler)this, "EndMessageContextCallbackInvocations");
        } else if (this.handlerName.equals("ClientLogicalHandler3") || this.handlerName.equals("ServerLogicalHandler3")) {
            HandlerTracker.reportComment((Handler)this, "BeginMessageContextCallbackInvocations");
            if (direction.equals("Outbound")) {
                TestUtil.logTrace((String)("whichHandlerType=" + this.whichHandlerType));
                HandlerTracker.reportGet((Handler)this, whichDirection + this.whichHandlerType + "LogicalCrossHandlerPropSetByHandler1", (String)context.get((Object)(whichDirection + this.whichHandlerType + "LogicalCrossHandlerPropSetByHandler1")));
                HandlerTracker.reportGet((Handler)this, whichDirection + this.whichHandlerType + "LogicalMessageScopeAppPropSetByHandler1", (String)context.get((Object)(whichDirection + this.whichHandlerType + "LogicalMessageScopeAppPropSetByHandler1")));
                HandlerTracker.reportGet((Handler)this, whichDirection + this.whichHandlerType + "LogicalMessageScopeHandlerPropSetByHandler1", (String)context.get((Object)(whichDirection + this.whichHandlerType + "LogicalMessageScopeHandlerPropSetByHandler1")));
                HandlerTracker.reportGetScope((Handler)this, whichDirection + this.whichHandlerType + "LogicalCrossHandlerPropSetByHandler1", context.getScope(whichDirection + this.whichHandlerType + "LogicalCrossHandlerPropSetByHandler1").toString());
                HandlerTracker.reportGetScope((Handler)this, whichDirection + this.whichHandlerType + "LogicalMessageScopeAppPropSetByHandler1", context.getScope(whichDirection + this.whichHandlerType + "LogicalMessageScopeAppPropSetByHandler1").toString());
                HandlerTracker.reportGetScope((Handler)this, whichDirection + this.whichHandlerType + "LogicalMessageScopeHandlerPropSetByHandler1", context.getScope(whichDirection + this.whichHandlerType + "LogicalMessageScopeHandlerPropSetByHandler1").toString());
            } else if (direction.equals("Inbound")) {
                context.put((Object)(whichDirection + this.whichHandlerType + "LogicalCrossHandlerPropSetByHandler3"), (Object)"SetByHandler3");
                HandlerTracker.reportPut((Handler)this, whichDirection + this.whichHandlerType + "LogicalCrossHandlerPropSetByHandler3", "SetByHandler3");
                context.put((Object)(whichDirection + this.whichHandlerType + "LogicalMessageScopeAppPropSetByHandler3"), (Object)"SetByHandler3");
                HandlerTracker.reportPut((Handler)this, whichDirection + this.whichHandlerType + "LogicalMessageScopeAppPropSetByHandler3", "SetByHandler3");
                context.setScope(whichDirection + this.whichHandlerType + "LogicalMessageScopeAppPropSetByHandler3", MessageContext.Scope.APPLICATION);
                HandlerTracker.reportSetScope((Handler)this, whichDirection + this.whichHandlerType + "LogicalMessageScopeAppPropSetByHandler3", MessageContext.Scope.APPLICATION.toString());
                context.put((Object)(whichDirection + this.whichHandlerType + "LogicalMessageScopeHandlerPropSetByHandler3"), (Object)"SetByHandler3");
                HandlerTracker.reportPut((Handler)this, whichDirection + this.whichHandlerType + "LogicalMessageScopeHandlerPropSetByHandler3", "SetByHandler3");
                context.setScope(whichDirection + this.whichHandlerType + "LogicalMessageScopeHandlerPropSetByHandler3", MessageContext.Scope.HANDLER);
                HandlerTracker.reportSetScope((Handler)this, whichDirection + this.whichHandlerType + "LogicalMessageScopeHandlerPropSetByHandler3", MessageContext.Scope.HANDLER.toString());
            }
            HandlerTracker.reportComment((Handler)this, "EndMessageContextCallbackInvocations");
        }
    }
}

