/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.pm.ejbql.schema;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.AddressDVC;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.AddressException;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.AddressLocal;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.AddressLocalHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.Alias;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.AliasHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.AliasLocal;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.AliasLocalHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.Country;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.CreditCardDVC;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.CreditCardException;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.CreditCardLocal;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.CreditCardLocalHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.Customer;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.CustomerHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.CustomerLocal;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.CustomerLocalHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.InfoDVC;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.InfoLocal;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.InfoLocalHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.Order;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.OrderHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.OrderLocal;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.OrderLocalHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.PhoneDVC;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.PhoneException;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.PhoneLocal;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.SpouseDVC;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.SpouseException;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.SpouseLocal;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.SpouseLocalHome;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;

public abstract class CustomerEJB
implements EntityBean {
    private static final String AddressLocal = "java:comp/env/ejb/AddressLocal";
    private static final String PhoneLocal = "java:comp/env/ejb/PhoneLocal";
    private static final String AliasLocal = "java:comp/env/ejb/AliasLocal";
    private static final String Alias = "java:comp/env/ejb/Alias";
    private static final String CreditCardLocal = "java:comp/env/ejb/CreditCardLocal";
    private static final String Customer = "java:comp/env/ejb/Customer";
    private static final String OrderLocal = "java:comp/env/ejb/OrderLocal";
    private static final String CustomerLocal = "java:comp/env/ejb/CustomerLocal";
    private static final String SpouseLocal = "java:comp/env/ejb/SpouseLocal";
    private static final String InfoLocal = "java:comp/env/ejb/InfoLocal";
    private static final String Order = "java:comp/env/ejb/Order";
    private EntityContext ectx = null;
    private TSNamingContext nctx = null;

    public abstract String getId();

    public abstract void setId(String var1);

    public abstract String getName();

    public abstract void setName(String var1);

    public abstract Country getCountry();

    public abstract void setCountry(Country var1);

    public abstract AddressLocal getHome();

    public abstract void setHome(AddressLocal var1);

    public abstract AddressLocal getWork();

    public abstract void setWork(AddressLocal var1);

    public abstract SpouseLocal getSpouse();

    public abstract void setSpouse(SpouseLocal var1);

    public abstract Collection getCreditCards();

    public abstract void setCreditCards(Collection var1);

    public abstract Collection getOrders();

    public abstract void setOrders(Collection var1);

    public abstract Collection getAliases();

    public abstract void setAliases(Collection var1);

    public abstract Collection getAliasesNoop();

    public abstract void setAliasesNoop(Collection var1);

    private AddressLocal createAddressLocal(String id, String street, String city, String state, String zip) throws Exception {
        TestUtil.logTrace((String)"createAddressLocal");
        TSNamingContext nctx = new TSNamingContext();
        AddressLocalHome addressLocalHome = (AddressLocalHome)nctx.lookup(AddressLocal);
        AddressLocal addressLocal = addressLocalHome.create(id, street, city, state, zip);
        return addressLocal;
    }

    private AddressLocal createAddressLocal(String id, String street, String city, String state, String zip, Collection phones) throws Exception {
        TestUtil.logTrace((String)"createAddressLocal");
        TSNamingContext nctx = new TSNamingContext();
        AddressLocalHome addressLocalHome = (AddressLocalHome)nctx.lookup(AddressLocal);
        AddressLocal addressLocal = addressLocalHome.create(id, street, city, state, zip, phones);
        return addressLocal;
    }

    private SpouseLocal createSpouseLocal(String id, String first, String maiden, String last, String sNumber, InfoDVC infoDVC) throws Exception {
        TestUtil.logTrace((String)"createSpouseLocal");
        TSNamingContext nctx = new TSNamingContext();
        TestUtil.logMsg((String)"createSpouseLocal: Converting infoDVC to infoLocal");
        InfoLocalHome infoLocalHome = (InfoLocalHome)nctx.lookup(InfoLocal);
        InfoLocal infoLocal = infoLocalHome.create(infoDVC.getId(), infoDVC.getStreet(), infoDVC.getCity(), infoDVC.getState(), infoDVC.getZip());
        TestUtil.logMsg((String)"createSpouseLocal: creating SpouseLocal");
        SpouseLocalHome spouseLocalHome = (SpouseLocalHome)nctx.lookup(SpouseLocal);
        SpouseLocal spouseLocal = spouseLocalHome.create(id, first, maiden, last, sNumber, infoLocal);
        return spouseLocal;
    }

    private CreditCardLocal createCreditCardLocal(String id, String number, String type, String expires, boolean approved, double balance, Order order, Customer customer) throws Exception {
        TestUtil.logTrace((String)"createCreditCardLocal");
        TSNamingContext nctx = new TSNamingContext();
        TestUtil.logMsg((String)"createCreditCardLocal: Converting order to orderlocal");
        OrderLocal orderLocal = null;
        if (order != null) {
            TestUtil.logMsg((String)"createCreditCardLocal: Converting order to orderlocal");
            String orderPK = (String)order.getPrimaryKey();
            OrderLocalHome orderLocalHome = (OrderLocalHome)nctx.lookup(OrderLocal);
            orderLocal = orderLocalHome.findByPrimaryKey(orderPK);
        } else {
            TestUtil.logMsg((String)"order reference is null");
        }
        TestUtil.logMsg((String)"createCreditCardLocal: Converting customer to customerlocal");
        CustomerLocal customerLocal = null;
        if (customer != null) {
            String customerPK = (String)customer.getPrimaryKey();
            CustomerLocalHome customerLocalHome = (CustomerLocalHome)nctx.lookup(CustomerLocal);
            customerLocal = customerLocalHome.findByPrimaryKey(customerPK);
        } else {
            TestUtil.logMsg((String)"customer reference is null");
        }
        TestUtil.logMsg((String)"createCreditCardLocal: Creating creditCardLocal");
        CreditCardLocalHome creditCardLocalHome = (CreditCardLocalHome)nctx.lookup(CreditCardLocal);
        CreditCardLocal creditCardLocal = creditCardLocalHome.create(id, number, type, expires, approved, balance, orderLocal, customerLocal);
        return creditCardLocal;
    }

    public abstract AddressLocal ejbSelectHomeAddress() throws FinderException;

    public abstract Collection ejbSelectAllWorkAddresses() throws FinderException;

    public abstract CreditCardLocal ejbSelectCreditCard(String var1) throws FinderException;

    public abstract Set ejbSelectHomeZipCodesByCity(String var1) throws FinderException;

    public abstract Collection ejbSelectAllHomeZipCodesByCity(String var1) throws FinderException;

    public abstract Collection ejbSelectCustomersByAlias(String var1) throws FinderException;

    public abstract Collection ejbSelectCustomersByAlias(String var1, String var2) throws FinderException;

    public abstract Collection ejbSelectPhonesByArea(String var1) throws FinderException;

    public abstract Set ejbSelectCustomerAddressBySet(String var1) throws FinderException;

    public abstract Collection ejbSelectCustomerAddressByCollection(String var1) throws FinderException;

    public abstract Collection ejbSelectCustomersByWorkZipCode() throws FinderException;

    public abstract Collection ejbSelectCustomersByNotNullWorkZipCode() throws FinderException;

    public abstract String ejbSelectCustomerByHomeAddress() throws FinderException;

    public abstract long ejbSelectAllHomeCities() throws FinderException;

    public abstract long ejbSelectNotNullHomeCities() throws FinderException;

    public abstract Collection ejbSelectCustomersByQuery42() throws FinderException;

    public String ejbCreate(String id, String name, AddressDVC home, AddressDVC work, Country country) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        try {
            this.setId(id);
            this.setName(name);
            this.setCountry(country);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        return null;
    }

    public void ejbPostCreate(String id, String name, AddressDVC home, AddressDVC work, Country country) throws CreateException {
        TestUtil.logTrace((String)"ejbPostCreate");
        try {
            AddressLocal homeAddr = this.createAddressLocal(home.getId(), home.getStreet(), home.getCity(), home.getState(), home.getZip(), home.getPhones());
            AddressLocal workAddr = this.createAddressLocal(work.getId(), work.getStreet(), work.getCity(), work.getState(), work.getZip(), work.getPhones());
            this.setHome(homeAddr);
            this.setWork(workAddr);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
    }

    public void setEntityContext(EntityContext c) {
        TestUtil.logTrace((String)"setEntityContext");
        this.ectx = c;
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"unsetEntityContext");
    }

    public void ejbRemove() throws RemoveException {
        Collection col;
        TestUtil.logTrace((String)"ejbRemove");
        if (this.getHome() != null) {
            col = this.getHome().getPhones();
            for (PhoneLocal p : col) {
                p.remove();
            }
            this.getHome().remove();
        }
        if (this.getWork() != null) {
            col = this.getWork().getPhones();
            for (PhoneLocal p : col) {
                p.remove();
            }
            this.getWork().remove();
        }
        col = this.getCreditCards();
        for (CreditCardLocal c : col) {
            c.remove();
        }
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public void ejbStore() {
        TestUtil.logTrace((String)"ejbStore");
    }

    public void ejbLoad() {
        TestUtil.logTrace((String)"ejbLoad");
    }

    public AddressDVC ejbHomeSelectHomeAddress() throws AddressException {
        TestUtil.logTrace((String)"ejbHomeSelectHomeAddress");
        try {
            AddressLocal aLeb = this.ejbSelectHomeAddress();
            Vector<PhoneDVC> v1 = new Vector<PhoneDVC>();
            Collection pCol = aLeb.getPhones();
            for (PhoneLocal pLeb : pCol) {
                PhoneDVC pDvc = new PhoneDVC(pLeb.getId(), pLeb.getArea(), pLeb.getNumber());
                v1.add(pDvc);
            }
            AddressDVC aDvc = new AddressDVC(aLeb.getId(), aLeb.getStreet(), aLeb.getCity(), aLeb.getState(), aLeb.getZip(), v1);
            return aDvc;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new AddressException("ejbHomeSelectHomeAddress: " + e);
        }
    }

    public Collection ejbHomeSelectAllWorkAddresses() throws AddressException {
        TestUtil.logTrace((String)"ejbHomeSelectAllWorkAddresses");
        try {
            Collection ccol = this.ejbSelectAllWorkAddresses();
            Iterator iterator = ccol.iterator();
            Vector<AddressDVC> v1 = new Vector<AddressDVC>();
            while (iterator.hasNext()) {
                AddressLocal aLeb = (AddressLocal)iterator.next();
                Collection ccol2 = aLeb.getPhones();
                Iterator iterator2 = ccol2.iterator();
                Vector<PhoneDVC> v2 = new Vector<PhoneDVC>();
                while (iterator2.hasNext()) {
                    PhoneLocal pLeb = (PhoneLocal)iterator2.next();
                    PhoneDVC pDvc = new PhoneDVC(pLeb.getId(), pLeb.getArea(), pLeb.getNumber());
                    v2.add(pDvc);
                }
                AddressDVC aDvc = new AddressDVC(aLeb.getId(), aLeb.getStreet(), aLeb.getCity(), aLeb.getState(), aLeb.getZip(), v2);
                v1.add(aDvc);
            }
            return v1;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new AddressException("ejbHomeSelectAllWorkAddresses: " + e);
        }
    }

    public Set ejbHomeSelectHomeZipCodesByCity(String city) throws AddressException {
        TestUtil.logTrace((String)"ejbHomeSelectHomeZipCodesByCity");
        try {
            Set s1 = this.ejbSelectHomeZipCodesByCity(city);
            return s1;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new AddressException("ejbHomeSelectHomeZipCodesByCity: " + e);
        }
    }

    public Collection ejbHomeSelectAllHomeZipCodesByCity(String city) throws AddressException {
        TestUtil.logTrace((String)"ejbHomeSelectAllHomeZipCodesByCity");
        try {
            Collection ccol = this.ejbSelectAllHomeZipCodesByCity(city);
            return ccol;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new AddressException("ejbHomeSelectAllHomeZipCodesByCity: " + e);
        }
    }

    public Collection ejbHomeSelectCustomersByAlias(String s) {
        TestUtil.logTrace((String)"ejbHomeSelectCustomersByAlias - one arg");
        try {
            Collection ccol = this.ejbSelectCustomersByAlias(s);
            return ccol;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("ejbHomeSelectCustomersByAlias: " + e);
        }
    }

    public Collection ejbHomeSelectCustomersByAlias(String s, String t) {
        TestUtil.logTrace((String)"ejbHomeSelectCustomersByAlias - two args");
        try {
            Collection ccol = this.ejbSelectCustomersByAlias(s, t);
            return ccol;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("ejbHomeSelectCustomersByAlias: " + e);
        }
    }

    public Collection ejbHomeSelectPhonesByArea(String area) throws PhoneException {
        Vector<Customer> v1 = new Vector<Customer>();
        TestUtil.logTrace((String)"ejbHomeSelectPhonesByArea");
        try {
            Collection ccol = this.ejbSelectPhonesByArea(area);
            for (CustomerLocal cLeb : ccol) {
                String customerPK = (String)cLeb.getPrimaryKey();
                CustomerHome customerHome = (CustomerHome)this.ectx.getEJBHome();
                Customer customer = customerHome.findByPrimaryKey(customerPK);
                v1.add(customer);
            }
            return v1;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new PhoneException("ejbHomeSelectPhonesByArea: " + e);
        }
    }

    public Set ejbHomeSelectCustomerAddressBySet(String state) {
        Set s1 = null;
        TestUtil.logTrace((String)"ejbHomeSelectCustomerAddressBySet");
        try {
            s1 = this.ejbSelectCustomerAddressBySet(state);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("ejbHomeSelectCustomerAddressBySet:" + e);
        }
        return s1;
    }

    public Collection ejbHomeSelectCustomerAddressByCollection(String state) {
        Collection ccol = null;
        TestUtil.logTrace((String)"ejbHomeSelectCustomerAddressByCollection");
        try {
            ccol = this.ejbSelectCustomerAddressByCollection(state);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("ejbHomeSelectCustomerAddressByCollection:" + e);
        }
        return ccol;
    }

    public Customer ejbHomeGetCustomerByHomePhoneNumber(String phone) {
        TestUtil.logTrace((String)"ejbHomeGetCustomerByHomePhoneNumber");
        try {
            CustomerLocalHome customerLocalHome = (CustomerLocalHome)this.ectx.getEJBLocalHome();
            CustomerLocal cLeb = customerLocalHome.findCustomerByHomePhoneNumber(phone);
            String customerPK = (String)cLeb.getPrimaryKey();
            CustomerHome customerHome = (CustomerHome)this.ectx.getEJBHome();
            Customer customer = customerHome.findByPrimaryKey(customerPK);
            return customer;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("ejbHomeGetCustomerByHomePhoneNumber:" + e);
        }
    }

    public Collection ejbHomeGetCustomersByWorkCity(String city) {
        Vector<Customer> v1 = new Vector<Customer>();
        TestUtil.logTrace((String)"ejbHomeGetCustomersByWorkCity");
        try {
            CustomerLocalHome customerLocalHome = (CustomerLocalHome)this.ectx.getEJBLocalHome();
            Collection cCol = customerLocalHome.findCustomersByWorkCity(city);
            for (CustomerLocal cLeb : cCol) {
                String customerPK = (String)cLeb.getPrimaryKey();
                CustomerHome customerHome = (CustomerHome)this.ectx.getEJBHome();
                Customer customer = customerHome.findByPrimaryKey(customerPK);
                v1.add(customer);
            }
            return v1;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("ejbHomeGetCustomersByWorkCity:" + e);
        }
    }

    public Customer ejbHomeGetCustomerByQuery29(String street, String city, String state, String zip) {
        TestUtil.logTrace((String)"ejbHomeGetCustomerByQuery29");
        try {
            CustomerLocalHome customerLocalHome = (CustomerLocalHome)this.ectx.getEJBLocalHome();
            CustomerLocal cLeb = customerLocalHome.findCustomerByQuery29(street, city, state, zip);
            String customerPK = (String)cLeb.getPrimaryKey();
            CustomerHome customerHome = (CustomerHome)this.ectx.getEJBHome();
            Customer customer = customerHome.findByPrimaryKey(customerPK);
            return customer;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("ejbHomeGetCustomerByQuery29:" + e);
        }
    }

    public Collection ejbHomeGetCustomersByQuery32(String city) {
        Vector<Customer> v1 = new Vector<Customer>();
        TestUtil.logTrace((String)"ejbHomeGetCustomersByQuery32");
        try {
            CustomerLocalHome customerLocalHome = (CustomerLocalHome)this.ectx.getEJBLocalHome();
            Collection cCol = customerLocalHome.findCustomersByQuery32(city);
            for (CustomerLocal cLeb : cCol) {
                String customerPK = (String)cLeb.getPrimaryKey();
                CustomerHome customerHome = (CustomerHome)this.ectx.getEJBHome();
                Customer customer = customerHome.findByPrimaryKey(customerPK);
                v1.add(customer);
            }
            return v1;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("ejbHomeGetCustomersByQuery32:" + e);
        }
    }

    public Collection ejbHomeSelectCustomersByWorkZipCode() {
        TestUtil.logTrace((String)"ejbHomeSelectCustomersByWorkZipCode");
        try {
            Collection c = this.ejbSelectCustomersByWorkZipCode();
            return c;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("ejbHomeSelectCustomersByWorkZipCode: " + e);
        }
    }

    public Collection ejbHomeSelectCustomersByNotNullWorkZipCode() {
        TestUtil.logTrace((String)"ejbHomeSelectCustomersByNotNullWorkZipCode");
        try {
            Collection c = this.ejbSelectCustomersByNotNullWorkZipCode();
            return c;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("ejbHomeSelectCustomersByNotNullWorkZipCode: " + e);
        }
    }

    public String ejbHomeSelectCustomerByHomeAddress() {
        TestUtil.logTrace((String)"ejbHomeSelectCustomerByHomeAddress");
        try {
            String s = this.ejbSelectCustomerByHomeAddress();
            return s;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("ejbHomeSelectCustomerByHomeAddress: " + e);
        }
    }

    public long ejbHomeSelectAllHomeCities() {
        TestUtil.logTrace((String)"ejbHomeSelectAllHomeCities");
        try {
            long l = this.ejbSelectAllHomeCities();
            return l;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("ejbHomeSelectAllHomeCities: " + e);
        }
    }

    public long ejbHomeSelectNotNullHomeCities() {
        TestUtil.logTrace((String)"ejbHomeSelectNotNullHomeCities");
        try {
            long l = this.ejbSelectNotNullHomeCities();
            return l;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("ejbHomeSelectNotNullHomeCities: " + e);
        }
    }

    public String ejbHomeGetSpouseInfo() {
        TestUtil.logTrace((String)"getSpouseInfo");
        try {
            TSNamingContext nctx = new TSNamingContext();
            SpouseLocalHome spouseLocalHome = (SpouseLocalHome)nctx.lookup(SpouseLocal);
            String s = spouseLocalHome.selectSpouseInfo();
            TestUtil.logTrace((String)"RETURNING STRING - NOT NULL");
            return s;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("getSpouseInfo:" + e);
        }
    }

    public Collection ejbHomeSelectCustomersByQuery42() throws AddressException {
        TestUtil.logTrace((String)"ejbHomeSelectCustomersByQuery42");
        try {
            Collection ccol = this.ejbSelectCustomersByQuery42();
            Iterator iterator = ccol.iterator();
            Vector<AddressDVC> v1 = new Vector<AddressDVC>();
            while (iterator.hasNext()) {
                AddressLocal aLeb = (AddressLocal)iterator.next();
                Collection ccol2 = aLeb.getPhones();
                Iterator iterator2 = ccol2.iterator();
                Vector<PhoneDVC> v2 = new Vector<PhoneDVC>();
                while (iterator2.hasNext()) {
                    PhoneLocal pLeb = (PhoneLocal)iterator2.next();
                    PhoneDVC pDvc = new PhoneDVC(pLeb.getId(), pLeb.getArea(), pLeb.getNumber());
                    v2.add(pDvc);
                }
                AddressDVC aDvc = new AddressDVC(aLeb.getId(), aLeb.getStreet(), aLeb.getCity(), aLeb.getState(), aLeb.getZip(), v2);
                v1.add(aDvc);
            }
            return v1;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new AddressException("ejbHomeSelectCustomersByQuery42: " + e);
        }
    }

    public void addOrder(Order order) {
        try {
            TSNamingContext nctx = new TSNamingContext();
            String orderPK = (String)order.getPrimaryKey();
            OrderLocalHome orderLocalHome = (OrderLocalHome)nctx.lookup(OrderLocal);
            OrderLocal orderLocal = orderLocalHome.findByPrimaryKey(orderPK);
            this.getOrders().add(orderLocal);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("addOrder:" + e);
        }
    }

    public void addAlias(Alias alias) {
        try {
            TSNamingContext nctx = new TSNamingContext();
            String aliasPK = (String)alias.getPrimaryKey();
            AliasLocalHome aliasLocalHome = (AliasLocalHome)nctx.lookup(AliasLocal);
            AliasLocal aliasLocal = aliasLocalHome.findByPrimaryKey(aliasPK);
            this.getAliases().add(aliasLocal);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("addAlias:" + e);
        }
    }

    public void ejbHomeAddSpouseEntry(SpouseDVC s) throws SpouseException {
        try {
            SpouseLocal spouseLocal = this.createSpouseLocal(s.getId(), s.getFirstName(), s.getMaidenName(), s.getLastName(), s.getSocialSecurityNumber(), s.getInfo());
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new SpouseException("addSpouseEntry:" + e);
        }
    }

    public void addSpouse(SpouseDVC s) throws SpouseException {
        try {
            SpouseLocal sLeb = this.createSpouseLocal(s.getId(), s.getFirstName(), s.getMaidenName(), s.getLastName(), s.getSocialSecurityNumber(), s.getInfo());
            this.setSpouse(sLeb);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new SpouseException("addSpouse:" + e);
        }
    }

    public void addCreditCard(CreditCardDVC p) throws CreditCardException {
        try {
            Collection cardCol = this.getCreditCards();
            CreditCardLocal cc = this.createCreditCardLocal(p.getId(), p.getNumber(), p.getType(), p.getExpires(), p.getApproved(), p.getBalance(), p.getOrder(), p.getCustomer());
            cardCol.add(cc);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreditCardException("addCreditCard: " + e);
        }
    }

    public AddressDVC getClientHomeAddress() throws AddressException {
        try {
            Vector<PhoneDVC> v = new Vector<PhoneDVC>();
            PhoneLocal pLeb2 = null;
            PhoneDVC pDvc = null;
            Collection ccol = this.getHome().getPhones();
            for (PhoneLocal pLeb2 : ccol) {
                pDvc = new PhoneDVC(pLeb2.getId(), pLeb2.getArea(), pLeb2.getNumber());
                v.add(pDvc);
            }
            AddressDVC homeAddr = new AddressDVC(this.getHome().getId(), this.getHome().getStreet(), this.getHome().getCity(), this.getHome().getState(), this.getHome().getZip(), v);
            return homeAddr;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new AddressException("getClientHomeAddress: " + e);
        }
    }

    public AddressDVC getClientWorkAddress() throws AddressException {
        try {
            Vector<PhoneDVC> v = new Vector<PhoneDVC>();
            PhoneLocal pLeb2 = null;
            PhoneDVC pDvc = null;
            Collection ccol = this.getWork().getPhones();
            for (PhoneLocal pLeb2 : ccol) {
                pDvc = new PhoneDVC(pLeb2.getId(), pLeb2.getArea(), pLeb2.getNumber());
                v.add(pDvc);
            }
            AddressDVC workAddr = new AddressDVC(this.getWork().getId(), this.getWork().getStreet(), this.getWork().getCity(), this.getWork().getState(), this.getWork().getZip(), v);
            return workAddr;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new AddressException("getClientWorkAddress: " + e);
        }
    }

    public Collection getClientCreditCards() throws CreditCardException {
        Vector<CreditCardDVC> v1 = new Vector<CreditCardDVC>();
        CreditCardLocal ccLeb2 = null;
        CreditCardDVC ccDvc = null;
        try {
            TSNamingContext nctx = new TSNamingContext();
            Collection ccol = this.getCreditCards();
            for (CreditCardLocal ccLeb2 : ccol) {
                String orderPK = (String)ccLeb2.getOrder().getPrimaryKey();
                OrderHome orderHome = (OrderHome)nctx.lookup(Order, OrderHome.class);
                Order order = orderHome.findByPrimaryKey(orderPK);
                String customerPK = (String)ccLeb2.getCustomer().getPrimaryKey();
                CustomerHome customerHome = (CustomerHome)nctx.lookup(Customer, CustomerHome.class);
                Customer customer = customerHome.findByPrimaryKey(customerPK);
                ccDvc = new CreditCardDVC(ccLeb2.getId(), ccLeb2.getNumber(), ccLeb2.getType(), ccLeb2.getExpires(), ccLeb2.getApproved(), ccLeb2.getBalance(), order, customer);
                v1.add(ccDvc);
            }
            return v1;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreditCardException("getClientCreditCards: " + e);
        }
    }

    public Collection getClientOrders() {
        Vector<Order> v1 = new Vector<Order>();
        try {
            TSNamingContext nctx = new TSNamingContext();
            Collection ccol = this.getOrders();
            for (OrderLocal oLoc : ccol) {
                String orderPK = (String)oLoc.getPrimaryKey();
                OrderHome orderHome = (OrderHome)nctx.lookup(Order, OrderHome.class);
                Order order = orderHome.findByPrimaryKey(orderPK);
                v1.add(order);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("getClientOrders:" + e);
        }
        return v1;
    }

    public Collection getClientAliases() {
        Vector<Alias> v1 = new Vector<Alias>();
        try {
            TSNamingContext nctx = new TSNamingContext();
            Collection ccol = this.getAliases();
            for (AliasLocal aLoc : ccol) {
                String aliasPK = (String)aLoc.getPrimaryKey();
                AliasHome aliasHome = (AliasHome)nctx.lookup(Alias, AliasHome.class);
                Alias alias = aliasHome.findByPrimaryKey(aliasPK);
                v1.add(alias);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("getClientAliases" + e);
        }
        return v1;
    }

    public void initLogging(Properties p) {
        TestUtil.logTrace((String)"initLogging");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }
}

