/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_soap.SOAPFaultException;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

public class Client
extends ServiceEETest {
    private Properties props = null;
    private Detail detail = null;
    private Detail detail2 = null;
    private DetailEntry detailentry = null;
    private SOAPFault soapfault = null;
    private Name name = null;
    private MessageFactory msgfactory = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            TestUtil.logMsg((String)"Create a SOAP MessageFactory instance");
            this.msgfactory = MessageFactory.newInstance();
            TestUtil.logMsg((String)"Create a SOAPMessage");
            SOAPMessage soapmsg = this.msgfactory.createMessage();
            TestUtil.logMsg((String)"Get SOAP Part");
            SOAPPart sp = soapmsg.getSOAPPart();
            TestUtil.logMsg((String)"Get SOAP Envelope");
            SOAPEnvelope envelope = sp.getEnvelope();
            TestUtil.logMsg((String)"Get SOAP Header");
            SOAPHeader hdr = envelope.getHeader();
            TestUtil.logMsg((String)"Get SOAP Body");
            SOAPBody body = envelope.getBody();
            this.soapfault = body.addFault();
            this.detail = this.soapfault.addDetail();
            this.name = envelope.createName("GetLastTradePrice", "WOMBAT", "http://www.wombat.org/trader");
            this.detailentry = this.detail.addDetailEntry(this.name);
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void SOAPFaultExceptionConstructorTest() throws EETest.Fault {
        TestUtil.logTrace((String)"SOAPFaultExceptionConstructorTest");
        boolean pass = true;
        QName faultCode = new QName("http://foo.bar", "faultCode");
        try {
            TestUtil.logMsg((String)"Create instance via SOAPFaultException(QName faultCode,String faultString,\nString faultActor, javax.xml.soap.Detail detail) ...");
            SOAPFaultException sf = new SOAPFaultException(faultCode, "faultString", "faultActor", this.detail);
            if (sf != null) {
                TestUtil.logMsg((String)"SOAPFaultException object created successfully");
            } else {
                TestUtil.logErr((String)"SOAPFaultException object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("SOAPFaultExceptionConstructorTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("SOAPFaultExceptionConstructorTest failed");
        }
    }

    public void getFaultActorTest() throws EETest.Fault {
        TestUtil.logTrace((String)"getFaultActorTest");
        QName faultCode = new QName("http://foo.bar", "faultCode");
        String expected = "faultActor";
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via SOAPFaultException(QName faultCode,String faultString,\nString faultActor, javax.xml.soap.Detail detail) ...");
            SOAPFaultException sf = new SOAPFaultException(faultCode, "faultString", "faultActor", this.detail);
            if (sf != null) {
                TestUtil.logMsg((String)"SOAPFaultException object created successfully");
                String s = sf.getFaultActor();
                if (s.equals(expected)) {
                    TestUtil.logMsg((String)("FaultActor returned as expected: " + s));
                } else {
                    TestUtil.logErr((String)("FaultActor expected " + expected + ", received " + s));
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)"SOAPFaultException object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("getFaultActorTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("getFaultActorTest failed");
        }
    }

    public void getFaultStringTest() throws EETest.Fault {
        TestUtil.logTrace((String)"getFaultStringTest");
        QName faultCode = new QName("http://foo.bar", "faultCode");
        String expected = "faultString";
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via SOAPFaultException(QName faultCode,String faultString,\nString faultActor, javax.xml.soap.Detail detail) ...");
            SOAPFaultException sf = new SOAPFaultException(faultCode, "faultString", "faultActor", this.detail);
            if (sf != null) {
                TestUtil.logMsg((String)"SOAPFaultException object created successfully");
                String s = sf.getFaultString();
                if (s.equals(expected)) {
                    TestUtil.logMsg((String)("FaultString returned as expected: " + s));
                } else {
                    TestUtil.logErr((String)("FaultString expected " + expected + ", received " + s));
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)"SOAPFaultException object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("getFaultStringTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("getFaultStringTest failed");
        }
    }

    public void getFaultCodeTest() throws EETest.Fault {
        QName faultCode;
        TestUtil.logTrace((String)"getFaultCodeTest");
        QName expected = faultCode = new QName("http://foo.bar", "faultCode");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via SOAPFaultException(QName faultCode,String faultString,\nString faultActor, javax.xml.soap.Detail detail) ...");
            SOAPFaultException sf = new SOAPFaultException(faultCode, "faultString", "faultActor", this.detail);
            if (sf != null) {
                TestUtil.logMsg((String)"SOAPFaultException object created successfully");
                QName s = sf.getFaultCode();
                if (s.equals(faultCode)) {
                    TestUtil.logMsg((String)("FaultCode returned as expected: " + s));
                } else {
                    TestUtil.logErr((String)("FaultCode expected " + expected + ", received " + s));
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)"SOAPFaultException object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("getFaultCodeTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("getFaultCodeTest failed");
        }
    }

    public void getDetailTest() throws EETest.Fault {
        TestUtil.logTrace((String)"getDetailTest");
        QName faultCode = new QName("http://foo.bar", "faultCode");
        String expected = "faultString";
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via SOAPFaultException(QName faultCode,String faultString,\nString faultActor, javax.xml.soap.Detail detail) ...");
            SOAPFaultException sf = new SOAPFaultException(faultCode, "faultString", "faultActor", this.detail);
            TestUtil.logMsg((String)("..........detail=" + this.detail));
            if (sf != null) {
                TestUtil.logMsg((String)"SOAPFaultException object created successfully");
                TestUtil.logMsg((String)"Get Detail element");
                this.detail2 = sf.getDetail();
                TestUtil.logMsg((String)("..........detail2=" + this.detail2));
                TestUtil.logMsg((String)"Get DetailEntry element");
                Iterator i = this.detail2.getDetailEntries();
                if (i == null || !i.hasNext()) {
                    TestUtil.logErr((String)"No DetailEntry in Detail object");
                    pass = false;
                } else {
                    DetailEntry detailentry = (DetailEntry)i.next();
                    TestUtil.logMsg((String)"Get Name element");
                    Name n = detailentry.getElementName();
                    String lname = n.getLocalName();
                    String prefix = n.getPrefix();
                    String uri = n.getURI();
                    TestUtil.logMsg((String)"Verify Name element of Detail element");
                    TestUtil.logMsg((String)("LocalName=" + lname + " Prefix=" + prefix + " URI=" + uri));
                    if (lname.equals("GetLastTradePrice") && prefix.equals("WOMBAT") && uri.equals("http://www.wombat.org/trader")) {
                        TestUtil.logMsg((String)"Name element of Detail element is correct");
                    } else {
                        TestUtil.logErr((String)"Name element of Detail element is in correct");
                        pass = false;
                    }
                }
            } else {
                TestUtil.logErr((String)"SOAPFaultException object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("getDetailTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("getDetailTest failed");
        }
    }
}

