/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.rmiiiop.ee.marshaltests;

import com.sun.ts.tests.rmiiiop.ee.marshaltests.MyUtil;

public class Timer {
    private static final long MSEC = 1000L;
    private static final String msgHeader = "Total elapsed time in";
    private long start;
    private long stop;
    private long elapsed;
    private boolean started;
    private int periods;
    private boolean enabled;

    public Timer() {
        this.init();
    }

    private void init() {
        this.start = 0L;
        this.stop = 0L;
        this.elapsed = 0L;
        this.started = false;
        this.periods = 0;
        this.enabled = true;
    }

    private void startTimer(boolean resumed) {
        if (this.enabled && !this.started) {
            this.started = true;
            if (!resumed) {
                this.periods = 0;
                this.elapsed = 0L;
            }
            this.start = System.currentTimeMillis();
        }
    }

    public void start() {
        this.startTimer(false);
    }

    public void stop() {
        if (this.enabled && this.started) {
            this.stop = System.currentTimeMillis();
            this.elapsed += this.stop - this.start;
            this.started = false;
            ++this.periods;
        }
    }

    public void resume() {
        this.startTimer(true);
    }

    public void reset() {
        if (this.enabled) {
            this.init();
        }
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public long getRunningElapsed() {
        return this.enabled ? System.currentTimeMillis() - this.start : 0L;
    }

    public long getElapsed() {
        return this.enabled ? this.elapsed : 0L;
    }

    public long getMilliseconds() {
        return this.enabled ? this.elapsed : 0L;
    }

    public long getSeconds() {
        return this.enabled ? this.elapsed / 1000L : 0L;
    }

    public double getTime() {
        return this.enabled ? (double)this.elapsed / 1000.0 : 0.0;
    }

    public int getPeriods() {
        return this.enabled ? this.periods : 0;
    }

    public int getDays() {
        if (!this.enabled) {
            return 0;
        }
        long t = this.getSeconds();
        if (t >= 86400L) {
            return (int)(t / 86400L);
        }
        return 0;
    }

    public int getHours() {
        if (!this.enabled) {
            return 0;
        }
        long t = this.getSeconds();
        if ((t %= 86400L) >= 3600L) {
            return (int)(t / 3600L);
        }
        return 0;
    }

    public int getMins() {
        if (!this.enabled) {
            return 0;
        }
        long t = this.getSeconds();
        t %= 86400L;
        if ((t %= 3600L) >= 60L) {
            return (int)(t / 60L);
        }
        return 0;
    }

    public int getSecs() {
        if (!this.enabled) {
            return 0;
        }
        long t = this.getSeconds();
        t %= 86400L;
        t %= 3600L;
        if ((t %= 60L) > 0L) {
            return (int)t;
        }
        return 0;
    }

    public int getMillis() {
        if (!this.enabled) {
            return 0;
        }
        long t = this.getMilliseconds();
        if ((t %= 1000L) > 0L) {
            return (int)t;
        }
        return 0;
    }

    public String getStringFormattedTime() {
        int numofdays = this.getDays();
        int numofhours = this.getHours();
        int numofmins = this.getMins();
        int numofsecs = this.getSecs();
        int numofmillis = this.getMillis();
        String s = null;
        if (!this.enabled) {
            return "Timer Not Enabled";
        }
        if (numofdays > 0) {
            s = "" + numofdays + " days " + numofhours + " hrs " + numofmins + " mins " + numofsecs + " secs " + numofmillis + " millisecs";
        } else if (numofhours > 0) {
            s = "" + numofhours + " hrs " + numofmins + " mins " + numofsecs + " secs " + numofmillis + " millisecs";
        } else if (numofmins > 0) {
            s = "" + numofmins + " mins " + numofsecs + " secs " + numofmillis + " millsecs";
        } else if (numofsecs > 0) {
            s = "" + numofsecs + " secs " + numofmillis + " millisecs";
        } else if (numofmillis > 0) {
            s = "" + numofmillis + " millisecs";
        }
        return s;
    }

    public String GetTimeLeftToRunString(long t) {
        int numofdays = 0;
        int numofhours = 0;
        int numofmins = 0;
        int numofsecs = 0;
        String s = null;
        if (t > 86400L) {
            numofdays = (int)(t / 86400L);
            t %= 86400L;
        }
        if (t > 3600L) {
            numofhours = (int)(t / 3600L);
            t %= 3600L;
        }
        if (t > 60L) {
            numofmins = (int)(t / 60L);
            t %= 60L;
        }
        if (t > 0L) {
            numofsecs = (int)t;
        }
        if (numofdays > 0) {
            s = "" + numofdays + "days:" + numofhours + "hrs:" + numofmins + "mins:" + numofsecs + "secs";
        } else if (numofhours > 0) {
            s = "" + numofhours + "hrs:" + numofmins + "mins:" + numofsecs + "secs";
        } else if (numofmins > 0) {
            s = "" + numofmins + "mins:" + numofsecs + "secs";
        } else if (numofsecs > 0) {
            s = "" + numofsecs + "secs";
        }
        return s;
    }

    public void print() {
        this.printMilliseconds();
    }

    public void printMilliseconds() {
        MyUtil.logMsg("Total elapsed time in milliseconds: " + this.getMilliseconds());
    }

    public void printSeconds() {
        MyUtil.logMsg("Total elapsed time in seconds: " + this.getSeconds());
    }

    public void printTime() {
        MyUtil.logMsg("Total elapsed time in seconds: " + this.getTime());
    }
}

