/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.rmiiiop.ee.marshaltests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.tests.rmiiiop.ee.marshaltests.CallBackBean;
import com.sun.ts.tests.rmiiiop.ee.marshaltests.Data;
import com.sun.ts.tests.rmiiiop.ee.marshaltests.Graph;
import com.sun.ts.tests.rmiiiop.ee.marshaltests.IDLStruct;
import com.sun.ts.tests.rmiiiop.ee.marshaltests.Multi;
import com.sun.ts.tests.rmiiiop.ee.marshaltests.MyUtil;
import com.sun.ts.tests.rmiiiop.ee.marshaltests.TestBean;
import com.sun.ts.tests.rmiiiop.ee.marshaltests.TestBeanHome;
import com.sun.ts.tests.rmiiiop.ee.marshaltests.Timer;
import com.sun.ts.tests.rmiiiop.ee.marshaltests.TypeCodeTester;
import com.sun.ts.tests.rmiiiop.ee.marshaltests.UserException;
import java.io.Serializable;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class Client
extends ServiceEETest
implements Serializable {
    private Properties testProps = null;
    private Properties beanProps = null;
    private static final String tBeanLookup = "java:comp/env/ejb/TestBeanEJB";
    private TSNamingContext nctx = null;
    private TestBean tBeanRef = null;
    private TestBeanHome tBeanHome = null;
    private CallBackBean[] cBeanRefs = new CallBackBean[10];

    public static void main(String[] args) {
        Client client = new Client();
        Status s = client.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        MyUtil.logTrace("Client.setup()");
        try {
            MyUtil.logTrace("Obtain Naming Context");
            this.nctx = new TSNamingContext();
            MyUtil.logMsg("Lookup the EJBHome of RMIIIOPTestBean: java:comp/env/ejb/TestBeanEJB");
            this.tBeanHome = (TestBeanHome)this.nctx.lookup(tBeanLookup, TestBeanHome.class);
            MyUtil.logMsg("Create an EJBObject instance of RMIIIOPTestBean");
            this.tBeanRef = this.tBeanHome.create(p);
        }
        catch (Exception e) {
            MyUtil.logErr("Exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        MyUtil.logMsg("Cleanup ok");
    }

    public void PrimTest01() throws EETest.Fault {
        String testname = "PrimTest01";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            failures += this.pass_a_boolean();
            failures += this.pass_a_byte();
            failures += this.pass_a_char();
            failures += this.pass_a_short();
            failures += this.pass_a_int();
            failures += this.pass_a_long();
            failures += this.pass_a_float();
            MyUtil.logSubTestResultSummary();
            if ((failures += this.pass_a_double()) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    public void PrimTest02() throws EETest.Fault {
        String testname = "PrimTest02";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            failures += this.pass_a_boolean_array();
            failures += this.pass_a_byte_array();
            failures += this.pass_a_char_array();
            failures += this.pass_a_short_array();
            failures += this.pass_a_int_array();
            failures += this.pass_a_long_array();
            failures += this.pass_a_float_array();
            MyUtil.logSubTestResultSummary();
            if ((failures += this.pass_a_double_array()) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    public void EXTest01() throws EETest.Fault {
        String testname = "EXTest01";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            if ((failures += this.throw_a_user_exception()) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    public void EXTest02a() throws EETest.Fault {
        String testname = "EXTest02a";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            if ((failures += this.throw_exception("EJBException")) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    public void EXTest02b() throws EETest.Fault {
        String testname = "EXTest02b";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            if ((failures += this.throw_exception("NullPointerException")) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    public void EXTest02c() throws EETest.Fault {
        String testname = "EXTest02c";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            if ((failures += this.throw_exception("Error")) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    public void RITest01() throws EETest.Fault {
        String testname = "RITest01";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            failures += this.return_a_remote_interface();
            failures += this.pass_a_remote_interface();
            if ((failures += this.return_a_remote_interface()) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    public void RITest02() throws EETest.Fault {
        String testname = "RITest02";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            failures += this.return_array_of_remote_interfaces();
            failures += this.pass_array_of_remote_interfaces();
            if ((failures += this.return_array_of_remote_interfaces()) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    public void OBVTest01() throws EETest.Fault {
        String testname = "OBVTest01";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            failures += this.pass_a_date_object();
            failures += this.pass_any_object();
            failures += this.return_a_date_object();
            failures += this.return_any_object();
            failures += this.pass_return_a_string_object();
            failures += this.pass_return_a_class_object();
            failures += this.pass_return_a_vector_object();
            if ((failures += this.pass_return_a_hashtable_object()) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    public void OBVTest02() throws EETest.Fault {
        String testname = "OBVTest02";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            failures += this.pass_a_date_object_array();
            failures += this.pass_any_object_array();
            failures += this.return_a_date_object_array();
            failures += this.return_any_object_array();
            failures += this.pass_return_string_object_array();
            if ((failures += this.pass_return_class_object_array()) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    public void OBVTest03() throws EETest.Fault {
        String testname = "OBVTest03";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            failures += this.pass_a_graph_of_objects();
            failures += this.return_a_graph_of_objects();
            if ((failures += this.pass_return_serializable_object()) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    public void OBVTest04() throws EETest.Fault {
        String testname = "OBVTest04";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            failures += this.pass_array_of_graph_objects();
            if ((failures += this.return_array_of_graph_objects()) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    public void OBVTest05() throws EETest.Fault {
        String testname = "OBVTest05";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            if ((failures += this.pass_return_object3_array(5)) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    public void MultiTest01() throws EETest.Fault {
        String testname = "MultiTest01";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            if ((failures += this.pass_return_multiclass_types()) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    public void IDLEntityTest01() throws EETest.Fault {
        String testname = "IDLEntityTest01";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            failures += this.pass_return_idl_entity_types("struct");
            if ((failures += this.pass_return_idl_entity_types("sequence")) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    public void RecursiveTest01() throws EETest.Fault {
        String testname = "RecursiveTest01";
        int failures = 0;
        try {
            MyUtil.logTrace(testname);
            failures += this.pass_return_recursive_vector_object();
            if ((failures += this.pass_return_recursive_hashtable_object()) > 0) {
                throw new EETest.Fault(testname + " failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault(testname + " failed", e);
        }
    }

    private int pass_a_boolean() {
        String subtestname = "PrimTest01:(pass_a_boolean)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            boolean ret = false;
            boolean saveret = false;
            MyUtil.logMsg("Passing/Returning boolean to/from RMIIIOPTestBean");
            for (int i = 0; i < Data.boolean_data.length && (!(ret = this.tBeanRef.pass_a_boolean(i, Data.boolean_data[i])) || ret); ++i) {
                if (!ret) continue;
                saveret = true;
            }
            if (saveret) {
                ret = saveret;
            }
            if (ret && !ret) {
                MyUtil.displayError("Invalid return", "false or true", "" + ret);
                ++failures;
            } else if (ret) {
                MyUtil.displayError("Wrong return", "false", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_byte() {
        String subtestname = "PrimTest01:(pass_a_byte)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            byte ret = 0;
            byte saveret = 0;
            MyUtil.logMsg("Passing/Returning byte to/from RMIIIOPTestBean");
            for (int i = 0; i < Data.byte_data.length && ((ret = this.tBeanRef.pass_a_byte(i, Data.byte_data[i])) == 0 || ret == 1); ++i) {
                if (ret != 1) continue;
                saveret = 1;
            }
            if (saveret == 1) {
                ret = saveret;
            }
            if (ret != 0 && ret != 1) {
                MyUtil.displayError("Invalid return", "0 or 1", "" + ret);
                ++failures;
            } else if (ret != 0) {
                MyUtil.displayError("Wrong return", "0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_char() {
        String subtestname = "PrimTest01:(pass_a_char)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            char ret = '0';
            char saveret = '0';
            MyUtil.logMsg("Passing/Returning char to/from RMIIIOPTestBean");
            for (int i = 0; i < Data.char_data.length && ((ret = (char)this.tBeanRef.pass_a_char(i, Data.char_data[i])) == '0' || ret == '1'); ++i) {
                if (ret != 49) continue;
                saveret = '1';
            }
            if (saveret == '1') {
                ret = saveret;
            }
            if (ret != '0' && ret != '1') {
                MyUtil.displayError("Invalid return", "'0' or '1'", "'" + ret + "'");
                ++failures;
            } else if (ret != '0') {
                MyUtil.displayError("Wrong return", "'0'", "'" + ret + "'");
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_short() {
        String subtestname = "PrimTest01:(pass_a_short)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            short ret = 0;
            short saveret = 0;
            MyUtil.logMsg("Passing/Returning short to/from RMIIIOPTestBean");
            for (int i = 0; i < Data.short_data.length && ((ret = this.tBeanRef.pass_a_short(i, Data.short_data[i])) == 0 || ret == 1); ++i) {
                if (ret != 1) continue;
                saveret = 1;
            }
            if (saveret == 1) {
                ret = saveret;
            }
            if (ret != 0 && ret != 1) {
                MyUtil.displayError("Invalid return", "0 or 1", "" + ret);
                ++failures;
            } else if (ret != 0) {
                MyUtil.displayError("Wrong return", "0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_int() {
        String subtestname = "PrimTest01:(pass_a_int)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            int ret = 0;
            int saveret = 0;
            MyUtil.logMsg("Passing/Returning int to/from RMIIIOPTestBean");
            for (int i = 0; i < Data.int_data.length && ((ret = this.tBeanRef.pass_a_int(i, Data.int_data[i])) == 0 || ret == 1); ++i) {
                if (ret != 1) continue;
                saveret = 1;
            }
            if (saveret == 1) {
                ret = saveret;
            }
            if (ret != 0 && ret != 1) {
                MyUtil.displayError("Invalid return", "0 or 1", "" + ret);
                ++failures;
            } else if (ret != 0) {
                MyUtil.displayError("Wrong return", "0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_long() {
        String subtestname = "PrimTest01:(pass_a_long)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            long ret = 0L;
            long saveret = 0L;
            MyUtil.logMsg("Passing/Returning long to/from RMIIIOPTestBean");
            for (int i = 0; i < Data.long_data.length && ((ret = this.tBeanRef.pass_a_long(i, Data.long_data[i])) == 0L || ret == 1L); ++i) {
                if (ret != 1L) continue;
                saveret = 1L;
            }
            if (saveret == 1L) {
                ret = saveret;
            }
            if (ret != 0L && ret != 1L) {
                MyUtil.displayError("Invalid return", "0 or 1", "" + ret);
                ++failures;
            } else if (ret != 0L) {
                MyUtil.displayError("Wrong return", "0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_float() {
        String subtestname = "PrimTest01:(pass_a_float)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            float ret = 0.0f;
            float saveret = 0.0f;
            MyUtil.logMsg("Passing/Returning float to/from RMIIIOPTestBean");
            for (int i = 0; i < Data.float_data.length && ((ret = this.tBeanRef.pass_a_float(i, Data.float_data[i])) == 0.0f || ret == 1.0f); ++i) {
                if (ret != 1.0f) continue;
                saveret = 1.0f;
            }
            if (saveret == 1.0f) {
                ret = saveret;
            }
            if (ret != 0.0f && ret != 1.0f) {
                MyUtil.displayError("Invalid return", "0.0 or 1.0", "" + ret);
                ++failures;
            } else if (ret != 0.0f) {
                MyUtil.displayError("Wrong return", "0.0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_double() {
        String subtestname = "PrimTest01:(pass_a_double)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            double ret = 0.0;
            double saveret = 0.0;
            MyUtil.logMsg("Passing/Returning double to/from RMIIIOPTestBean");
            for (int i = 0; i < Data.double_data.length && ((ret = this.tBeanRef.pass_a_double(i, Data.double_data[i])) == 0.0 || ret == 1.0); ++i) {
                if (ret != 1.0) continue;
                saveret = 1.0;
            }
            if (saveret == 1.0) {
                ret = saveret;
            }
            if (ret != 0.0 && ret != 1.0) {
                MyUtil.displayError("Invalid return", "0.0 or 1.0", "" + ret);
                ++failures;
            } else if (ret != 0.0) {
                MyUtil.displayError("Wrong return", "0.0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_boolean_array() {
        String subtestname = "PrimTest02:(pass_a_boolean_array)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing/Returning boolean array to/from RMIIIOPTestBean");
            boolean[] ret = this.tBeanRef.pass_a_boolean_array(Data.boolean_data);
            if (ret.length != Data.boolean_data.length) {
                MyUtil.displayError("Wrong length", "" + Data.boolean_data.length, "" + ret.length);
                ++failures;
            } else if (ret[0] && !ret[0]) {
                MyUtil.displayError("Invalid return", "false or true", "" + ret[0]);
                ++failures;
            } else if (ret[0]) {
                MyUtil.displayError("Wrong return", "false", "" + ret[0]);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_byte_array() {
        String subtestname = "PrimTest02:(pass_a_byte_array)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing/Returning byte array to/from RMIIIOPTestBean");
            byte[] ret = this.tBeanRef.pass_a_byte_array(Data.byte_data);
            if (ret.length != Data.byte_data.length) {
                MyUtil.displayError("Wrong length", "" + Data.byte_data.length, "" + ret.length);
                ++failures;
            } else if (ret[0] != 0 && ret[0] != 1) {
                MyUtil.displayError("Invalid return", "0 or 1", "" + ret[0]);
                ++failures;
            } else if (ret[0] != 0) {
                MyUtil.displayError("Wrong return", "0", "" + ret[0]);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_char_array() {
        String subtestname = "PrimTest02:(pass_a_char_array)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing/Returning char array to/from RMIIIOPTestBean");
            char[] ret = this.tBeanRef.pass_a_char_array(Data.char_data);
            if (ret.length != Data.char_data.length) {
                MyUtil.displayError("Wrong length", "" + Data.char_data.length, "" + ret.length);
                ++failures;
            } else if (ret[0] != '0' && ret[0] != '1') {
                MyUtil.displayError("Invalid return", "'0' or '1'", "'" + ret[0] + "'");
                ++failures;
            } else if (ret[0] != '0') {
                MyUtil.displayError("Wrong return", "'0'", "'" + ret[0] + "'");
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_short_array() {
        String subtestname = "PrimTest02:(pass_a_short_array)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing/Returning short array to/from RMIIIOPTestBean");
            short[] ret = this.tBeanRef.pass_a_short_array(Data.short_data);
            if (ret.length != Data.short_data.length) {
                MyUtil.displayError("Invalid length", "" + Data.short_data.length, "" + ret.length);
                ++failures;
            } else if (ret[0] != 0 && ret[0] != 1) {
                MyUtil.displayError("Invalid return", "0 or 1", "" + ret[0]);
                ++failures;
            } else if (ret[0] != 0) {
                MyUtil.displayError("Wrong return", "0", "" + ret[0]);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_int_array() {
        String subtestname = "PrimTest02:(pass_a_int_array)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing/Returning int array to/from RMIIIOPTestBean");
            int[] ret = this.tBeanRef.pass_a_int_array(Data.int_data);
            if (ret.length != Data.int_data.length) {
                MyUtil.displayError("Wrong length", "" + Data.int_data.length, "" + ret.length);
                ++failures;
            } else if (ret[0] != 0 && ret[0] != 1) {
                MyUtil.displayError("Invalid return", "0 or 1", "" + ret[0]);
                ++failures;
            } else if (ret[0] != 0) {
                MyUtil.displayError("Wrong return", "0", "" + ret[0]);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_long_array() {
        String subtestname = "PrimTest02:(pass_a_long_array)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing/Returning long array to/from RMIIIOPTestBean");
            long[] ret = this.tBeanRef.pass_a_long_array(Data.long_data);
            if (ret.length != Data.long_data.length) {
                MyUtil.displayError("Wrong length", "" + Data.long_data.length, "" + ret.length);
                ++failures;
            } else if (ret[0] != 0L && ret[0] != 1L) {
                MyUtil.displayError("Invalid return", "0 or 1", "" + ret[0]);
                ++failures;
            } else if (ret[0] != 0L) {
                MyUtil.displayError("Wrong return", "0", "" + ret[0]);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_float_array() {
        String subtestname = "PrimTest02:(pass_a_float_array)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing/Returning float array to/from RMIIIOPTestBean");
            float[] ret = this.tBeanRef.pass_a_float_array(Data.float_data);
            if (ret.length != Data.float_data.length) {
                MyUtil.displayError("Wrong length", "" + Data.float_data.length, "" + ret.length);
                ++failures;
            } else if (ret[0] != 0.0f && ret[0] != 1.0f) {
                MyUtil.displayError("Invalid return", "0.0 or 1.0", "" + ret[0]);
                ++failures;
            } else if (ret[0] != 0.0f) {
                MyUtil.displayError("Wrong return", "0.0", "" + ret[0]);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_double_array() {
        String subtestname = "PrimTest02:(pass_a_double_array)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing/Returning double array to/from RMIIIOPTestBean");
            double[] ret = this.tBeanRef.pass_a_double_array(Data.double_data);
            if (ret.length != Data.double_data.length) {
                MyUtil.displayError("Wrong length", "" + Data.double_data.length, "" + ret.length);
                ++failures;
            } else if (ret[0] != 0.0 && ret[0] != 1.0) {
                MyUtil.displayError("Invalid return", "0.0 or 1.0", "" + ret[0]);
                ++failures;
            } else if (ret[0] != 0.0) {
                MyUtil.displayError("Wrong return", "0.0", "" + ret[0]);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int throw_a_user_exception() {
        String subtestname = "EXTest01:(throw_a_user_exception)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Throw a user defined exception from RMIIIOPTestBean");
            this.tBeanRef.throw_a_user_exception();
            MyUtil.logErr("No UserException was thrown");
            ++failures;
        }
        catch (UserException e) {
            MyUtil.logMsg("Caught UserException as expected");
            MyUtil.logMsg("Checking UserException message");
            if (!e.getMessage().equals("This is a UserException test")) {
                MyUtil.displayError("Wrong message", "This is a UserException test", e.getMessage());
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int throw_exception(String s) {
        String subtestname = "EXTest02a:(throw_exception)";
        int failures = 0;
        if (s.equals("EJBException")) {
            subtestname = "EXTest02a:(throw_exception)";
        } else if (s.equals("NullPointerException")) {
            subtestname = "EXTest02b:(throw_exception)";
        } else if (s.equals("Error")) {
            subtestname = "EXTest02c:(throw_exception)";
        }
        MyUtil.logMsg(subtestname);
        try {
            if (s.equals("EJBException")) {
                MyUtil.logMsg("Throw an EJBException from RMIIIOPTestBean");
                try {
                    this.tBeanRef.throw_exception("EJBException");
                    MyUtil.logErr("No EJBException was thrown");
                    ++failures;
                }
                catch (RemoteException e) {
                    MyUtil.logMsg("Caught RemoteException as expected");
                }
                catch (Exception e) {
                    MyUtil.logErr("Caught unexpected exception: " + e.getMessage(), e);
                    ++failures;
                }
            } else if (s.equals("Error")) {
                MyUtil.logMsg("Throw an Error from RMIIIOPTestBean");
                try {
                    this.tBeanRef.throw_exception("Error");
                    MyUtil.logErr("No Error was thrown");
                    ++failures;
                }
                catch (RemoteException e) {
                    MyUtil.logMsg("Caught RemoteException as expected");
                }
                catch (Exception e) {
                    MyUtil.logErr("Caught unexpected exception: " + e.getMessage(), e);
                    ++failures;
                }
            } else if (s.equals("NullPointerException")) {
                MyUtil.logMsg("Throw a NullPointerException from RMIIIOPTestBean");
                try {
                    this.tBeanRef.throw_exception("NullPointerException");
                    MyUtil.logErr("No NullPointerException was thrown");
                    ++failures;
                }
                catch (RemoteException e) {
                    MyUtil.logMsg("Caught RemoteException as expected");
                }
                catch (Exception e) {
                    MyUtil.logErr("Caught unexpected exception: " + e.getMessage(), e);
                    ++failures;
                }
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_remote_interface() {
        String subtestname = "RITest01:(pass_a_remote_interface)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing a Remote Interface to RMIIIOPTestBean");
            int ret = this.tBeanRef.pass_a_remote_interface(this.cBeanRefs[0]);
            if (ret != 0) {
                MyUtil.logErr("Could not pass a Remote Interface to RMIIIOPTestBean");
                MyUtil.displayError("Wrong return", "0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int return_a_remote_interface() {
        String subtestname = "RITest01:(return_a_remote_interface)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Returning a Remote Interface from RMIIIOPTestBean");
            this.cBeanRefs[0] = this.tBeanRef.return_a_remote_interface();
            if (this.cBeanRefs[0] == null) {
                MyUtil.logErr("Could not return a Remote Interface from RMIIIOPTestBean");
                ++failures;
            } else {
                try {
                    MyUtil.logMsg("Invoking the methods of the returned Remote Interface");
                    this.cBeanRefs[0].method1();
                    this.cBeanRefs[0].method2();
                }
                catch (Exception e) {
                    MyUtil.logErr("Unable to invoke the methods of the Remote Interface");
                    MyUtil.logErr("Caught exception: " + e.getMessage());
                    MyUtil.printStackTrace(e);
                    MyUtil.logErr(e.toString());
                    ++failures;
                }
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_array_of_remote_interfaces() {
        String subtestname = "RITest02:(pass_array_of_remote_interfaces)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing array of Remote Interfaces to RMIIIOPTestBean");
            int ret = this.tBeanRef.pass_array_of_remote_interfaces(this.cBeanRefs);
            if (ret != 0) {
                MyUtil.logErr("Could not pass array of Remote Interfaces to RMIIIOPTestBean");
                MyUtil.displayError("Wrong return", "0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int return_array_of_remote_interfaces() {
        String subtestname = "RITest02:(return_array_of_remote_interfaces)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Returning array of Remote Interfaces from RMIIIOPTestBean");
            this.cBeanRefs = this.tBeanRef.return_array_of_remote_interfaces();
            if (this.cBeanRefs == null) {
                MyUtil.logErr("Could not return array of Remote Interfaces from RMIIIOPTestBean");
                ++failures;
            } else if (this.cBeanRefs.length != 10) {
                MyUtil.displayError("Wrong length", "10", "" + this.cBeanRefs.length);
                ++failures;
                for (int i = 0; i < this.cBeanRefs.length; ++i) {
                    try {
                        MyUtil.logMsg("Invoking the methods of the returned Remote Interface refs[" + i + "]");
                        this.cBeanRefs[i].method1();
                        this.cBeanRefs[i].method2();
                        continue;
                    }
                    catch (Exception e) {
                        MyUtil.logErr("Unable to invoke the methods of the Remote Interface refs[" + i + "]");
                        MyUtil.logErr("Caught exception: " + e.getMessage());
                        MyUtil.printStackTrace(e);
                        MyUtil.logErr(e.toString());
                        ++failures;
                    }
                }
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_date_object() {
        String subtestname = "OBVTest01:(pass_a_date_object)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing a Date object to RMIIIOPTestBean");
            int ret = this.tBeanRef.pass_a_date_object(Data.date);
            if (ret != 0) {
                MyUtil.logErr("Could not pass a Date object to RMIIIOPTestBean");
                MyUtil.displayError("Wrong return", "0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_any_object() {
        String subtestname = "OBVTest01:(pass_any_object)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing any Java object to RMIIIOPTestBean");
            int ret = this.tBeanRef.pass_any_object(Data.bitset);
            if (ret != 0) {
                MyUtil.logErr("Could not pass a BitSet object to RMIIIOPTestBean");
                MyUtil.displayError("Wrong return", "0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int return_a_date_object() {
        String subtestname = "OBVTest01:(return_a_date_object)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Returning a Date object from RMIIIOPTestBean");
            Date d = this.tBeanRef.return_a_date_object();
            if (d == null) {
                MyUtil.logErr("Could not return a Date object from RMIIIOPTestBean");
                ++failures;
            } else if (!d.equals(Data.date)) {
                MyUtil.logErr("Returned Date object doesn't match expected Date object");
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int return_any_object() {
        String subtestname = "OBVTest01:(return_any_object)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Returning any Java object from RMIIIOPTestBean");
            Object o = this.tBeanRef.return_any_object();
            if (!(o instanceof BitSet)) {
                MyUtil.logErr("Could not return a BitSet object from RMIIIOPTestBean");
                ++failures;
            }
            if (!o.equals(Data.bitset)) {
                MyUtil.logErr("Returned BitSet object doesn't match expected BitSet object");
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_return_a_string_object() {
        String subtestname = "OBVTest01:(pass_return_a_string_object)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Returning a String object from RMIIIOPTestBean");
            String o = this.tBeanRef.pass_return_a_string_object(Data.string_data[0]);
            if (o == null) {
                MyUtil.logErr("Could not return a String object from RMIIIOPTestBean");
                ++failures;
            } else if (!o.equals(Data.string_data[0])) {
                MyUtil.logErr("Returned String object doesn't match expected String object");
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_return_a_class_object() {
        String subtestname = "OBVTest01:(pass_return_a_class_object)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Returning a Class object from RMIIIOPTestBean");
            Class o = this.tBeanRef.pass_return_a_class_object(Data.class_data[0]);
            if (o == null) {
                MyUtil.logErr("Could not return a Class object from RMIIIOPTestBean");
                ++failures;
            } else if (!o.equals(Data.class_data[0])) {
                MyUtil.logErr("Returned Class object doesn't match expected Class object");
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_return_a_vector_object() {
        String subtestname = "OBVTest01:(pass_return_a_vector_object)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Returning a Vector object from RMIIIOPTestBean");
            Vector o = this.tBeanRef.pass_return_a_vector_object(Data.vector);
            if (o == null) {
                MyUtil.logErr("Could not return a Vector object from RMIIIOPTestBean");
                ++failures;
            } else if (o.size() != Data.vector.size()) {
                MyUtil.logErr("Vector has wrong size" + Data.vector.size() + "" + o.size());
                ++failures;
            } else {
                Object o2;
                Object o1 = o.elementAt(0);
                if (!(o1 instanceof BigInteger)) {
                    MyUtil.logErr("o1 is not a BigInteger");
                    ++failures;
                }
                if (!o1.equals(new BigInteger("3512359"))) {
                    MyUtil.logErr("Returned BigInteger doesn't match expected BigInteger");
                    ++failures;
                }
                if (!((o2 = o.elementAt(1)) instanceof String)) {
                    MyUtil.logErr("o2 is not a String");
                    ++failures;
                }
                if (!o2.equals("two")) {
                    MyUtil.logErr("Returned string doesn't match expected string");
                    ++failures;
                }
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_return_a_hashtable_object() {
        String subtestname = "OBVTest01:(pass_return_a_hashtable_object)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Returning a Hashtable object from RMIIIOPTestBean");
            Hashtable o = this.tBeanRef.pass_return_a_hashtable_object(Data.table);
            if (o == null) {
                MyUtil.logErr("Could not return a Hashtable object from RMIIIOPTestBean");
                ++failures;
            } else if (o.size() != Data.table.size()) {
                MyUtil.logErr("Hashtable has wrong size" + Data.table.size() + "" + o.size());
                ++failures;
            } else {
                Object o2;
                Object o1 = o.get("one");
                if (!(o1 instanceof BigInteger)) {
                    MyUtil.logErr("o1 is not a BigInteger");
                    ++failures;
                }
                if (!o1.equals(new BigInteger("3512359"))) {
                    MyUtil.logErr("Returned BigInteger doesn't match expected BigInteger");
                    ++failures;
                }
                if (!((o2 = o.get("two")) instanceof String)) {
                    MyUtil.logErr("o2 is not a String");
                    ++failures;
                }
                if (!o2.equals("two")) {
                    MyUtil.logErr("Returned String object doesn't match expected String object");
                    ++failures;
                }
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_return_recursive_vector_object() {
        String subtestname = "RecursiveTest01:(pass_return_recursive_vector_object)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Returning a Vector object from RMIIIOPTestBean");
            Vector o = this.tBeanRef.pass_return_a_vector_object(Data.vector);
            if (o == null) {
                MyUtil.logErr("Could not return a Vector object from RMIIIOPTestBean");
                ++failures;
            } else if (o.size() != Data.vector.size()) {
                MyUtil.logErr("Vector has wrong size" + Data.vector.size() + "" + o.size());
                ++failures;
            } else {
                Object o3 = o.elementAt(2);
                if (!(o3 instanceof Vector)) {
                    MyUtil.logErr("o3 is not a vector");
                    ++failures;
                }
                if (!o3.equals(o)) {
                    MyUtil.logErr("Returned vector doesn't match expected vector object");
                    MyUtil.logErr("o3 is unexpected vector object");
                    ++failures;
                }
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_return_recursive_hashtable_object() {
        String subtestname = "RecursiveTest01:(pass_return_recursive_hashtable_object)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Returning a Hashtable object from RMIIIOPTestBean");
            Hashtable o = this.tBeanRef.pass_return_a_hashtable_object(Data.table2);
            if (o == null) {
                MyUtil.logErr("Could not return a Hashtable object from RMIIIOPTestBean");
                ++failures;
            } else if (o.size() != Data.table2.size()) {
                MyUtil.logErr("Could not return a Hashtable object from RMIIIOPTestBean");
                MyUtil.logErr("Table has wrong size" + Data.table.size() + "" + o.size());
                ++failures;
            } else {
                Object o3 = o.get("three");
                if (!(o3 instanceof Hashtable)) {
                    MyUtil.logErr("Could not return a Hashtable object from RMIIIOPTestBean");
                    MyUtil.logErr("o3 is not a Hashtable");
                    ++failures;
                }
                if (!o3.equals(o)) {
                    MyUtil.logErr("Returned Hashtable doesn't match expected Hashtable object");
                    MyUtil.logErr("o3 is unexpected Hashtable object");
                    ++failures;
                }
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_date_object_array() {
        String subtestname = "OBVTest02:(pass_a_date_object_array)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing a Date object array to RMIIIOPTestBean");
            int ret = this.tBeanRef.pass_a_date_object_array(Data.date_array);
            if (ret != 0) {
                MyUtil.logErr("Could not pass a Date object array to RMIIIOPTestBean");
                MyUtil.displayError("Wrong return", "0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_return_string_object_array() {
        String subtestname = "OBVTest02:(pass_return_string_object_array)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Returning a String object array from RMIIIOPTestBean");
            String[] s = this.tBeanRef.pass_return_arrays_of_string_objects(Data.string_data);
            if (s.length != Data.string_data.length) {
                MyUtil.logErr("Could not return a String object array from RMIIIOPTestBean");
                MyUtil.displayError("Wrong length", "" + Data.string_data.length, "" + s.length);
                ++failures;
            }
            for (int i = 0; i < s.length; ++i) {
                if (s[i] == null) {
                    MyUtil.logErr("Could not return a String object array from RMIIIOPTestBean");
                    MyUtil.logErr("s[" + i + "] not a String object");
                    ++failures;
                    continue;
                }
                if (s[i].equals(Data.string_data[i])) continue;
                MyUtil.logErr("Returned String doesn't match expected String object");
                MyUtil.logErr("s[" + i + "] is unexpected String object");
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_return_class_object_array() {
        String subtestname = "OBVTest02:(pass_return_class_object_array)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Returning a Class object array from RMIIIOPTestBean");
            Class[] c = this.tBeanRef.pass_return_arrays_of_class_objects(Data.class_data);
            if (c.length != Data.class_data.length) {
                MyUtil.logErr("Could not return a Class object array from RMIIIOPTestBean");
                MyUtil.displayError("Wrong length", "" + Data.class_data.length, "" + c.length);
                ++failures;
            }
            for (int i = 0; i < c.length; ++i) {
                if (c[i] == null) {
                    MyUtil.logErr("Could not return a Class object array from RMIIIOPTestBean");
                    MyUtil.logErr("c[" + i + "] not a Class object");
                    ++failures;
                    continue;
                }
                if (c[i].equals(Data.class_data[i])) continue;
                MyUtil.logErr("Returned Class object doesn't match expected Class object");
                MyUtil.logErr("c[" + i + "] is unexpected Class object");
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_any_object_array() {
        String subtestname = "OBVTest02:(pass_any_object_array)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing any Java object array to RMIIIOPTestBean");
            int ret = this.tBeanRef.pass_any_object_array(Data.bitset_array);
            if (ret != 0) {
                MyUtil.logErr("Could not pass a BitSet object array to RMIIIOPTestBean");
                MyUtil.displayError("Wrong return", "0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int return_a_date_object_array() {
        String subtestname = "OBVTest02:(return_a_date_object_array)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Returning a Date object array from RMIIIOPTestBean");
            Date[] d = this.tBeanRef.return_a_date_object_array();
            if (d.length != Data.date_array.length) {
                MyUtil.logErr("Could not return a Date object array from RMIIIOPTestBean");
                MyUtil.displayError("Wrong length", "" + Data.date_array.length, "" + d.length);
                ++failures;
            }
            for (int i = 0; i < d.length; ++i) {
                if (d[i] == null) {
                    MyUtil.logErr("Could not return a Date object array from RMIIIOPTestBean");
                    MyUtil.logErr("d[" + i + "] not a Date object");
                    ++failures;
                    continue;
                }
                if (d[i].equals(Data.date_array[i])) continue;
                MyUtil.logErr("Returned Date object doesn't match expected Date object");
                MyUtil.logErr("d[" + i + "] is unexpected Date object");
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int return_any_object_array() {
        String subtestname = "OBVTest02:(return_any_object_array)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Returning any Java object array from RMIIIOPTestBean");
            Object[] o = this.tBeanRef.return_any_object_array();
            if (o.length != Data.bitset_array.length) {
                MyUtil.logErr("Could not return BitSet object array from RMIIIOPTestBean");
                MyUtil.displayError("Wrong length", "" + Data.bitset_array.length, "" + o.length);
                ++failures;
            }
            for (int i = 0; i < o.length; ++i) {
                if (!(o[i] instanceof BitSet)) {
                    MyUtil.logErr("Could not return a BitSet object array from RMIIIOPTestBean");
                    MyUtil.logErr("o[" + i + "] not a BitSet object");
                    ++failures;
                }
                if (o[i].equals(Data.bitset_array[i])) continue;
                MyUtil.logErr("Returned BitSet object doesn't match expected BitSet object");
                MyUtil.logErr("o[" + i + "] is unexpected BitSet object");
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_a_graph_of_objects() {
        String subtestname = "OBVTest03:(pass_a_graph_of_objects)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing a Graph object to RMIIIOPTestBean");
            int ret = this.tBeanRef.pass_a_graph_of_objects(Data.graph);
            if (ret != 0) {
                MyUtil.logErr("Could not pass a Graph object to RMIIIOPTestBean");
                MyUtil.displayError("Wrong return", "0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int return_a_graph_of_objects() {
        String subtestname = "OBVTest03:(return_a_graph_of_objects)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Returning a Graph object from RMIIIOPTestBean");
            Graph g = this.tBeanRef.return_a_graph_of_objects();
            if (g == null) {
                MyUtil.logMsg("Could not return a Graph object from RMIIIOPTestBean");
                ++failures;
            }
            StringBuffer result = new StringBuffer("{ ");
            Graph list = g;
            for (Graph list2 = Data.graph; list != null && list2 != null; list = list.next(), list2 = list2.next()) {
                result.append(list.data()).append(" ");
                if (!list.CONSTANT_STRING.equals(list2.CONSTANT_STRING)) {
                    ++failures;
                    MyUtil.displayError("list.CONSTANT_STRING != list2.CONSTANT_STRING");
                    MyUtil.displayError("list.CONSTANT_STRING", "" + list2.CONSTANT_STRING, "" + list.CONSTANT_STRING);
                }
                if (list.CONSTANT_INT != list2.CONSTANT_INT) {
                    ++failures;
                    MyUtil.displayError(": list.CONSTANT_INT != list2.CONSTANT_INT");
                    MyUtil.displayError("list.CONSTANT_INT", "" + list2.CONSTANT_INT, "" + list.CONSTANT_INT);
                }
                if (list.CONSTANT_BITSET.equals(list2.CONSTANT_BITSET)) continue;
                ++failures;
                MyUtil.displayError("list.CONSTANT_BITSET != list2.CONSTANT_BITSET");
                MyUtil.displayError("list.CONSTANT_BITSET", "" + list2.CONSTANT_BITSET, "" + list.CONSTANT_BITSET);
            }
            result.append("}").toString();
            if (!result.toString().equals("{ This is a graph object test. }")) {
                ++failures;
                MyUtil.displayError("graph string != Data.graph_expected_string");
                MyUtil.displayError("graph string", "{ This is a graph object test. }", "" + result);
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_array_of_graph_objects() {
        String subtestname = "OBVTest04:(pass_array_of_graph_objects)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing array of Graph objects to RMIIIOPTestBean");
            int ret = this.tBeanRef.pass_array_of_graph_objects(Data.graph_array);
            if (ret != 0) {
                MyUtil.logErr("Could not pass array of Graph objects to RMIIIOPTestBean");
                MyUtil.displayError("Wrong return", "0", "" + ret);
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int return_array_of_graph_objects() {
        String subtestname = "OBVTest04:(return_array_of_graph_objects)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Returning array of Graph objects from RMIIIOPTestBean");
            Graph[] g = this.tBeanRef.return_array_of_graph_objects();
            for (int i = 0; i < g.length; ++i) {
                if (g[i] == null) {
                    MyUtil.displayError("g[" + i + "] is not a Graph object");
                    ++failures;
                }
                StringBuffer result = new StringBuffer("{ ");
                Graph list = g[i];
                for (Graph list2 = Data.graph_array[i]; list != null && list2 != null; list = list.next(), list2 = list2.next()) {
                    result.append(list.data()).append(" ");
                    if (!list.CONSTANT_STRING.equals(list2.CONSTANT_STRING)) {
                        ++failures;
                        MyUtil.displayError("g[" + i + "].CONSTANT_STRING != list2.CONSTANT_STRING");
                        MyUtil.displayError("g[" + i + "].CONSTANT_STRING", "" + list2.CONSTANT_STRING, "" + g[i].CONSTANT_STRING);
                    }
                    if (list.CONSTANT_INT != list2.CONSTANT_INT) {
                        ++failures;
                        MyUtil.displayError("g[" + i + "].CONSTANT_INT != list2.CONSTANT_INT");
                        MyUtil.displayError("g[" + i + "].CONSTANT_INT", "" + list2.CONSTANT_INT, "" + g[i].CONSTANT_INT);
                    }
                    if (list.CONSTANT_BITSET.equals(list2.CONSTANT_BITSET)) continue;
                    ++failures;
                    MyUtil.displayError("g[" + i + "].CONSTANT_BITSET != list2.CONSTANT_BITSET");
                    MyUtil.displayError("g[" + i + "].CONSTANT_BITSET", "" + list2.CONSTANT_BITSET, "" + g[i].CONSTANT_BITSET);
                }
                result.append("}").toString();
                if (result.toString().equals("{ This is a graph object test. }")) continue;
                ++failures;
                MyUtil.displayError("g[" + i + "] graph string != Data.graph_expected_string");
                MyUtil.displayError("g[" + i + "] graph string", "{ This is a graph object test. }", "" + result);
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_return_object3_array(int vectorsize) {
        int j;
        int k;
        int m;
        String subtestname = "OBVTest05:(pass_return_object3_array)";
        int failures = 0;
        Object[][][] main = new Vector[vectorsize][][];
        Object[][][] w = null;
        Timer timer = new Timer();
        MyUtil.logMsg(subtestname);
        MyUtil.logMsg("Initialize 3 dimensional object array with vectorsize = " + vectorsize);
        for (m = 0; m < main.length; ++m) {
            main[m] = new Vector[vectorsize][];
            for (k = 0; k < main[m].length; ++k) {
                main[m][k] = new Vector[vectorsize];
                for (j = 0; j < main[m][k].length; ++j) {
                    main[m][k][j] = new Vector(vectorsize);
                    for (int i = 0; i < vectorsize; ++i) {
                        ((Vector)main[m][k][j]).insertElementAt(i * j, i);
                    }
                }
            }
        }
        try {
            MyUtil.logMsg("Pass and return the 3 dimensional object array to RMIIIOPTestBean");
            MyUtil.logMsg("Please wait this method call can take a long time ....");
            timer.start();
            w = this.tBeanRef.pass_return_object3_array(main);
            timer.stop();
            MyUtil.logMsg("Method call took ....[" + timer.getStringFormattedTime() + "]");
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            MyUtil.logMsg(subtestname + "failed");
            MyUtil.logDoneSubTest(subtestname);
            return ++failures;
        }
        MyUtil.logMsg("Compare returned 3 dimensional object array with the one passed");
        MyUtil.logMsg("Checking lengths");
        if (main.length != w.length) {
            MyUtil.displayError("Wrong Length", " main array length of " + main.length, " is different from the returned array length of " + w.length);
            ++failures;
        }
        MyUtil.logMsg("Checking data");
        for (m = 0; m < main.length && failures == 0; ++m) {
            if (main[m].length != w[m].length) {
                MyUtil.displayError("Wrong Data1", " main [" + m + "] array length of " + main[m].length, " is different from the returned array[" + m + "] length of " + w[m].length);
                ++failures;
                break;
            }
            for (k = 0; k < main[m].length; ++k) {
                if (main[m][k].length != w[m][k].length) {
                    MyUtil.displayError("Wrong Data2", " main [" + m + "][" + k + "] array length of " + main[m][k].length, " is different from the returned array[" + m + "][" + k + "] length of " + w[m][k].length);
                    ++failures;
                    break;
                }
                if (failures != 0) break;
                for (j = 0; j < main[m][k].length; ++j) {
                    if (((Vector)main[m][k][j]).size() != ((Vector)w[m][k][j]).size()) {
                        MyUtil.displayError("Wrong Data3", " main [" + m + "][" + k + "][" + j + "] vector length of " + ((Vector)main[m][k][j]).size(), " is different from the returned vector [" + m + "][" + k + "][" + j + "] length of " + ((Vector)w[m][k][j]).size());
                        ++failures;
                        break;
                    }
                    Enumeration e = ((Vector)main[m][k][j]).elements();
                    Enumeration f = ((Vector)w[m][k][j]).elements();
                    int counter = 0;
                    while (e.hasMoreElements()) {
                        if (!((Integer)e.nextElement()).equals((Integer)f.nextElement())) {
                            MyUtil.displayError("Wrong Data4: element " + counter + " in Vector (" + m + "," + k + "," + j + ")");
                            ++failures;
                            break;
                        }
                        ++counter;
                    }
                    if (failures != 0) break;
                    if (f.hasMoreElements()) {
                        MyUtil.displayError("Wrong Data5:  returned Vector (" + m + "," + k + "," + j + ") ");
                        ++failures;
                        break;
                    }
                    if (failures != 0) break;
                }
                if (failures != 0) break;
            }
            if (failures != 0) break;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    public int pass_return_multiclass_types() {
        String subtestname = "MultiTest01:(pass_return_multiclass_types)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing/Returning Multi Class Types to RMIIIOPTestBean");
            Multi ret = null;
            ret = this.tBeanRef.pass_return_multiclass_types(Data.multiTypes);
            if (ret == null) {
                MyUtil.logErr("Could not pass Multi Class Types to RMIIIOPTestBean");
                ++failures;
            } else if (ret.getBear1().getSize() != Data.bear1Size) {
                MyUtil.displayError("Wrong bear1Size", "" + Data.bear1Size, "" + ret.getBear1().getSize());
                ++failures;
            } else if (ret.getBear2().getSize() != Data.bear2Size) {
                MyUtil.displayError("Wrong bear2Size", "" + Data.bear2Size, "" + ret.getBear2().getSize());
                ++failures;
            } else if (ret.getBear3().getSize() != Data.bear3Size) {
                MyUtil.displayError("Wrong bear3Size", "" + Data.bear3Size, "" + ret.getBear3().getSize());
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    public int pass_return_idl_entity_types(String idltype) {
        String subtestname = "IDLEntityTest01:(pass_return_idl_entity_types)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Passing/Returning IDLEntity Types to RMIIIOPTestBean");
            if (idltype.equals("struct")) {
                MyUtil.logMsg("Passing/Returning struct IDLEntity type to RMIIIOPTestBean");
                IDLStruct ret = null;
                ret = this.tBeanRef.pass_return_idl_entity_types(Data.idlType1);
                if (ret == null) {
                    MyUtil.logErr("Could not pass struct IDLEntity type to RMIIIOPTestBean");
                    ++failures;
                } else if (ret.x != Data.idlType1_value) {
                    MyUtil.displayError("Wrong value", "" + Data.idlType1_value, "" + ret.x);
                    ++failures;
                }
            } else if (idltype.equals("sequence")) {
                MyUtil.logMsg("Passing/Returning sequence IDLEntity type to RMIIIOPTestBean");
                IDLStruct[] ret = null;
                ret = this.tBeanRef.pass_return_idl_entity_types(Data.idlType2);
                if (ret == null) {
                    MyUtil.logErr("Could not pass sequence IDLEntity type to RMIIIOPTestBean");
                    ++failures;
                } else {
                    for (int i = 0; i < 10; ++i) {
                        if (ret[i].x == (short)i) continue;
                        MyUtil.displayError("Wrong value", "" + i, "" + ret[i].x);
                        ++failures;
                    }
                }
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }

    private int pass_return_serializable_object() {
        String subtestname = "OBVTest03:(pass_return_serializable_object)";
        int failures = 0;
        MyUtil.logMsg(subtestname);
        try {
            MyUtil.logMsg("Returning a serializable from RMIIIOPTestBean");
            TypeCodeTester tct = new TypeCodeTester();
            Serializable obj = this.tBeanRef.pass_return_serializable_object(tct);
            TypeCodeTester o = (TypeCodeTester)obj;
            if (!(o.byteField == tct.byteField && o.booleanField == tct.booleanField && o.shortField == tct.shortField && o.intField == tct.intField && o.longField == tct.longField && o.floatField == tct.floatField && o.doubleField == tct.doubleField && o.charField == tct.charField && o.stringField.equals(tct.stringField) && Arrays.equals(o.byteArrayField, tct.byteArrayField) && Arrays.equals(o.booleanArrayField, tct.booleanArrayField) && Arrays.equals(o.shortArrayField, tct.shortArrayField) && Arrays.equals(o.intArrayField, tct.intArrayField) && Arrays.equals(o.longArrayField, tct.longArrayField) && Arrays.equals(o.doubleArrayField, tct.doubleArrayField) && Arrays.equals(o.charArrayField, tct.charArrayField) && Arrays.equals(o.stringArrayField, tct.stringArrayField) && o.recursiveField == o)) {
                MyUtil.logErr("Returned serializable doesn't match expected serializable");
                ++failures;
            }
        }
        catch (Exception e) {
            MyUtil.logErr("Caught exception: " + e.getMessage());
            MyUtil.printStackTrace(e);
            MyUtil.logErr(e.toString());
            ++failures;
        }
        if (failures > 0) {
            MyUtil.logMsg(subtestname + "failed");
        } else {
            MyUtil.logMsg(subtestname + "passed");
        }
        MyUtil.logDoneSubTest(subtestname);
        return failures;
    }
}

