/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices12.narrow;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.webservices12.narrow.InterfaceTest1;
import com.sun.ts.tests.webservices12.narrow.InterfaceTest2;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import javax.xml.ws.Service;

public class Client
extends ServiceEETest {
    InterfaceTest1 port1 = null;
    InterfaceTest2 port2 = null;

    private void getPort() throws Exception {
        try {
            InitialContext ic = new InitialContext();
            Service svc = (Service)ic.lookup("java:comp/env/service/wsinterfacetest");
            Object ret = svc.getPort(InterfaceTest1.class);
            this.port1 = (InterfaceTest1)PortableRemoteObject.narrow((Object)ret, InterfaceTest1.class);
            ret = svc.getPort(InterfaceTest2.class);
            this.port2 = (InterfaceTest2)PortableRemoteObject.narrow((Object)ret, InterfaceTest2.class);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new EETest.Fault(t.toString());
        }
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        boolean pass = true;
        try {
            this.getPort();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
        if (!pass) {
            throw new EETest.Fault("setup failed:");
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void narrowTest() throws EETest.Fault {
        TestUtil.logTrace((String)"narrowTest");
        boolean pass = true;
        TestUtil.logMsg((String)"Invoking methods on interface 1 ...");
        if (this.interface1Test()) {
            TestUtil.logMsg((String)"interface 1 test PASSED ...");
        } else {
            pass = false;
            TestUtil.logErr((String)"interface 1 test FAILED ...");
        }
        TestUtil.logMsg((String)"Invoking methods on interface 2 ...");
        if (this.interface2Test()) {
            TestUtil.logMsg((String)"interface 2 test PASSED ...");
        } else {
            pass = false;
            TestUtil.logErr((String)"interface 2 test FAILED ...");
        }
        if (!pass) {
            throw new EETest.Fault("narrowTest failed");
        }
    }

    private boolean interface1Test() throws EETest.Fault {
        TestUtil.logTrace((String)"interface1Test");
        boolean pass = true;
        String exp = "interface1:hello, world";
        try {
            String rec = this.port1.hello1("hello, world");
            TestUtil.logMsg((String)("Invoking RPC method port1.hello1(\"hello, world\")=" + rec));
            if (rec.equals(exp)) {
                TestUtil.logMsg((String)("Result match - " + exp));
            } else {
                TestUtil.logErr((String)("Result mismatch - expected: " + exp + ", received: " + rec));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }

    private boolean interface2Test() throws EETest.Fault {
        TestUtil.logTrace((String)"interface2Test");
        boolean pass = true;
        String exp1 = "interface2:hello, world";
        String exp2 = "interface2:hello, world";
        try {
            String rec = this.port2.hello1("hello, world");
            TestUtil.logMsg((String)("Invoking RPC method port2.hello1(\"hello, world\")=" + rec));
            if (rec.equals(exp1)) {
                TestUtil.logMsg((String)("Result match - " + exp1));
            } else {
                TestUtil.logErr((String)("Result mismatch - expected: " + exp1 + ", received: " + rec));
                pass = false;
            }
            rec = this.port2.hello2("hello, world");
            TestUtil.logMsg((String)("Invoking RPC method port2.hello2(\"hello, world\")=" + rec));
            if (rec.equals(exp2)) {
                TestUtil.logMsg((String)("Result match - " + exp2));
            } else {
                TestUtil.logErr((String)("Result mismatch - expected: " + exp2 + ", received: " + rec));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }
}

