/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.entitytest.detach.manyXone;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.entitytest.detach.manyXone.A;
import java.util.Properties;
import javax.persistence.EntityExistsException;
import javax.persistence.PersistenceException;
import javax.transaction.TransactionRolledbackException;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachMX1Test1() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin detachMX1Test1");
        boolean pass = false;
        A aRef = new A("3", "a3", 3);
        try {
            TestUtil.logTrace((String)"Persist Instance");
            this.createA(aRef);
            TestUtil.logTrace((String)"Call EntityManager.clear()");
            this.clearCache();
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Call getEntityManager.contains to determine if the instance is detached");
            if (this.getEntityManager().contains((Object)aRef)) {
                TestUtil.logTrace((String)"entity is not detached, unexpected cannot proceed with test.");
            } else {
                try {
                    TestUtil.logTrace((String)"Status is false as expected, try perist()");
                    this.getEntityManager().persist((Object)aRef);
                    TestUtil.logMsg((String)"Did not throw IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logMsg((String)"received expected IllegalArgumentException when trying to persist a detached entity");
                    pass = true;
                }
                catch (EntityExistsException eee) {
                    TestUtil.logMsg((String)"EntityExistsException thrown trying to persist an existing entity");
                    pass = true;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logMsg((String)"or, Transaction commit will fail.   Test the commit failed by testing the transaction is marked for rollback");
            if (!pass && (e instanceof TransactionRolledbackException || e instanceof PersistenceException)) {
                TestUtil.logMsg((String)"Received exception TransactionRolledbackException or PersistenceException");
                pass = true;
            }
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("detachMX1Test1 failed");
        }
    }

    private void createA(A a) {
        TestUtil.logTrace((String)"Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityTransaction().commit();
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM BEJB_MX1_UNI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_MX1_UNI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

