/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.common.interceptor;

import com.sun.ts.tests.ejb30.common.calc.CalculatorException;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.interceptor.AroundInvokeTestImpl;
import com.sun.ts.tests.ejb30.common.messaging.StatusReporter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Arrays;
import java.util.Map;
import javax.ejb.EJBContext;
import javax.interceptor.InvocationContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;

public class AroundInvokeTestMDBImpl
extends AroundInvokeTestImpl
implements Serializable {
    protected static QueueConnectionFactory getQueueConnectionFactory(InvocationContext inv) {
        EJBContext ejbContext = AroundInvokeTestMDBImpl.getEJBContext();
        return AroundInvokeTestMDBImpl.getQueueConnectionFactory(ejbContext);
    }

    protected static Queue getQueue(InvocationContext inv) {
        EJBContext ejbContext = AroundInvokeTestMDBImpl.getEJBContext();
        return AroundInvokeTestMDBImpl.getQueue(ejbContext);
    }

    protected static QueueConnectionFactory getQueueConnectionFactory(EJBContext ejbContext) {
        Object obj = ejbContext.lookup("qFactory");
        return (QueueConnectionFactory)obj;
    }

    protected static Queue getQueue(EJBContext ejbContext) {
        Object obj = ejbContext.lookup("replyQueue");
        return (Queue)obj;
    }

    public AroundInvokeTestMDBImpl() {
    }

    public AroundInvokeTestMDBImpl(Object bean, Principal princ) {
        this.bean = bean;
        this.beanPrincipal = princ;
    }

    public static Object intercept2(InvocationContext ctx, int orderInChain) throws CalculatorException {
        Object result = null;
        String methName = AroundInvokeTestMDBImpl.getTestName(ctx);
        if ("orderTest".equals(methName)) {
            AroundInvokeTestMDBImpl.checkOrder(ctx, orderInChain);
        } else if ("sameInvocationContextTest".equals(methName)) {
            AroundInvokeTestMDBImpl.checkInvocationContext(ctx, orderInChain);
        }
        try {
            result = ctx.proceed();
        }
        catch (CalculatorException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    public static void checkInvocationContext(InvocationContext ctx, int orderInChain) {
        String testname = "sameInvocationContextTest";
        boolean status = true;
        String reason = null;
        Map map = ctx.getContextData();
        Object obj = map.get("same.invocationcontext");
        if (obj == null) {
            map.put("same.invocationcontext", ctx);
            TLogger.log("In interceptor " + orderInChain + ", an instance of InvocationContext is saved inside context data.");
        } else if (obj == ctx) {
            TLogger.log("In interceptor " + orderInChain + ", same instance of InvocationContext is found, and continue to the next interceptor...");
            if (orderInChain == 3) {
                status = true;
                reason = "same instance of InvocationContext is used in this interceptor.";
                TLogger.log(reason);
                StatusReporter.report(testname, status, reason, AroundInvokeTestMDBImpl.getQueueConnectionFactory(ctx), AroundInvokeTestMDBImpl.getQueue(ctx));
            }
        } else {
            status = false;
            reason = "The following InvocationContext are expected to be the same instance, will not go to the next interceptor:" + ctx + ", " + obj;
            TLogger.log(reason);
            StatusReporter.report(testname, status, reason, AroundInvokeTestMDBImpl.getQueueConnectionFactory(ctx), AroundInvokeTestMDBImpl.getQueue(ctx));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void checkOrder(InvocationContext ctx, int num) {
        String testname = "orderTest";
        boolean status = true;
        String reason = null;
        Map map = ctx.getContextData();
        Object obj = map.get("interceptor.order");
        if (num == 1) {
            if (obj != null) {
                status = false;
                reason = "Expected null for key interceptor.order, actual " + obj;
                TLogger.log(reason);
                StatusReporter.report(testname, status, reason, AroundInvokeTestMDBImpl.getQueueConnectionFactory(ctx), AroundInvokeTestMDBImpl.getQueue(ctx));
                return;
            }
            Integer order = new Integer(1);
            map.put("interceptor.order", order);
            TLogger.log("order of current interceptor: 1");
        } else if (num > 1) {
            if (obj == null) {
                status = false;
                reason = "Illegal state of InvocationContext: keyed data is null.";
                TLogger.log(reason);
                StatusReporter.report(testname, status, reason, AroundInvokeTestMDBImpl.getQueueConnectionFactory(ctx), AroundInvokeTestMDBImpl.getQueue(ctx));
                return;
            }
            int order = (Integer)obj;
            if (order != num - 1) {
                status = false;
                reason = "Expected order of previous interceptor " + (num - 1) + ", actual " + order;
                TLogger.log(reason);
                StatusReporter.report(testname, status, reason, AroundInvokeTestMDBImpl.getQueueConnectionFactory(ctx), AroundInvokeTestMDBImpl.getQueue(ctx));
                return;
            }
            int currentOrder = AroundInvokeTestMDBImpl.incrementOrder(map);
            TLogger.log("order of current interceptor: " + currentOrder);
        }
        if (num == 3) {
            status = true;
            reason = testname + " passed.";
            TLogger.log(reason);
            StatusReporter.report(testname, status, reason, AroundInvokeTestMDBImpl.getQueueConnectionFactory(ctx), AroundInvokeTestMDBImpl.getQueue(ctx));
        }
    }

    @Override
    protected void getParametersTest(InvocationContext ctx) {
        String expected = "Object[]{Message}";
        String reason = null;
        boolean status = true;
        Object[] params = ctx.getParameters();
        String errorMsg = null;
        if (params == null) {
            status = false;
            errorMsg = ", actual null";
        } else if (params.length != 1) {
            status = false;
            errorMsg = ", actual " + Arrays.asList(params).toString();
        } else if (!(params[0] instanceof Message)) {
            status = false;
            errorMsg = ", actual " + params[0];
        }
        reason = errorMsg == null ? "getParametersTest passed." : "Expected " + expected + errorMsg;
        TLogger.log(reason);
        StatusReporter.report("getParametersTest", status, reason, AroundInvokeTestMDBImpl.getQueueConnectionFactory(ctx), AroundInvokeTestMDBImpl.getQueue(ctx));
    }

    public static void ensureRollbackOnly(Message msg, EJBContext ejbContext) {
        boolean status = false;
        String reason = null;
        String testname = null;
        try {
            testname = msg.getStringProperty("COM_SUN_JMS_TESTNAME");
        }
        catch (JMSException e) {
            status = false;
            reason = "Failed to get test name from message: " + msg;
            TLogger.log(reason);
            StatusReporter.report("getParametersTest", status, reason, AroundInvokeTestMDBImpl.getQueueConnectionFactory(ejbContext), AroundInvokeTestMDBImpl.getQueue(ejbContext));
            return;
        }
        if (testname.equals("txRollbackOnlyTest")) {
            boolean rb = ejbContext.getRollbackOnly();
            if (rb) {
                status = true;
                reason = "tx was set to rollbackonly in interceptor, as expected.";
            } else {
                status = false;
                reason = "Expected tx set to rollbackonly, actual getRollbackOnly() returned " + rb;
            }
            TLogger.log(reason);
            StatusReporter.report(testname, status, reason, AroundInvokeTestMDBImpl.getQueueConnectionFactory(ejbContext), AroundInvokeTestMDBImpl.getQueue(ejbContext));
        }
    }

    @Override
    protected void setParametersTest(InvocationContext ctx) {
        Object[] params = ctx.getParameters();
        ctx.setParameters(params);
        Object[] params2 = ctx.getParameters();
        boolean status = true;
        String reason = null;
        if (params.length != params2.length) {
            status = false;
            reason = "Expected 2 InvocationContext.getParameters() to be the same, but they are of different length:" + params.length + ", and " + params2.length;
        } else if (!params[0].equals(params2[0])) {
            status = false;
            reason = "Expected 2 InvocationContext.getParameters() return the same, but they were different:param: " + Arrays.asList(params) + "\nparam2:" + Arrays.asList(params2);
        } else {
            status = true;
            reason = "setParametersTest passed.";
        }
        TLogger.log(reason);
        StatusReporter.report("setParametersTest", status, reason, AroundInvokeTestMDBImpl.getQueueConnectionFactory(ctx), AroundInvokeTestMDBImpl.getQueue(ctx));
    }

    @Override
    protected void getMethodTest(InvocationContext ctx) {
        boolean status = true;
        String reason = null;
        Method meth = ctx.getMethod();
        Method expectedMeth = null;
        if (this.bean == null) {
            String methName = meth.getName();
            Class<?>[] paramTypes = meth.getParameterTypes();
            if (methName.equals("onMessage")) {
                if (paramTypes != null && paramTypes.length == 1 && paramTypes[0].equals(Message.class)) {
                    status = true;
                    reason = "The method returned from getMethod is correct:onMessage";
                } else {
                    status = false;
                    reason = "The method returned from getMethod: param types do not match: " + (paramTypes == null ? "null" : Arrays.asList(paramTypes).toString());
                }
            } else {
                status = false;
                reason = "The method returned from getMethod is not named onMessage";
            }
            TLogger.log(reason);
            StatusReporter.report("getMethodTest", status, reason, AroundInvokeTestMDBImpl.getQueueConnectionFactory(ctx), AroundInvokeTestMDBImpl.getQueue(ctx));
        } else {
            try {
                expectedMeth = this.bean.getClass().getMethod("onMessage", Message.class);
            }
            catch (NoSuchMethodException e) {
                status = false;
                reason = "Failed to get method onMessage from bean " + this.bean;
                TLogger.log(reason, e);
                StatusReporter.report("getMethodTest", status, reason, AroundInvokeTestMDBImpl.getQueueConnectionFactory(ctx), AroundInvokeTestMDBImpl.getQueue(ctx));
                return;
            }
            if (!meth.equals(expectedMeth)) {
                status = false;
                reason = "Expected " + expectedMeth + ", actual " + meth;
            } else {
                status = true;
                reason = "Expected method is the same as returned by getMethod().";
            }
            TLogger.log(reason);
            StatusReporter.report("getMethodTest", status, reason, AroundInvokeTestMDBImpl.getQueueConnectionFactory(ctx), AroundInvokeTestMDBImpl.getQueue(ctx));
        }
    }

    @Override
    protected void txRollbackOnlyTest(InvocationContext ctx) {
        EJBContext con = AroundInvokeTestMDBImpl.getEJBContext();
        con.setRollbackOnly();
    }

    @Override
    protected void txRollbackOnlyAfterTest(InvocationContext ctx) {
        boolean status = true;
        String reason = null;
        EJBContext con = AroundInvokeTestMDBImpl.getEJBContext();
        con.setRollbackOnly();
        boolean rb = con.getRollbackOnly();
        if (!rb) {
            status = false;
            reason = "Expected getRollbackOnly() returns true, actual " + rb;
        } else {
            status = true;
            reason = "txRollbackOnlyAfterTest passed.";
        }
        StatusReporter.report("txRollbackOnlyAfterTest", status, reason, AroundInvokeTestMDBImpl.getQueueConnectionFactory(ctx), AroundInvokeTestMDBImpl.getQueue(ctx));
    }

    @Override
    protected void getContextDataTest(InvocationContext ctx) {
        boolean status = true;
        String reason = null;
        Map map = ctx.getContextData();
        String msg = (String)map.get("msg.key");
        if (!"from bean class intercept()".equals(msg)) {
            status = false;
            reason = "Expected InvocationContext data for key msg.key: from bean class intercept(), actual " + msg;
        } else {
            status = true;
            reason = "getContextDataTest for InvocationContext passed.";
        }
        TLogger.log(reason);
        StatusReporter.report("getContextDataTest", status, reason, AroundInvokeTestMDBImpl.getQueueConnectionFactory(ctx), AroundInvokeTestMDBImpl.getQueue(ctx));
    }

    @Override
    protected void getBeanTest(InvocationContext ctx) {
        boolean status = true;
        String reason = null;
        Object bean = ctx.getTarget();
        if (this.bean == null) {
            if (bean == null) {
                status = false;
                reason = "InvocationContext.getBean() returned null.";
                TLogger.log(reason);
                StatusReporter.report("getBeanTest", status, reason, AroundInvokeTestMDBImpl.getQueueConnectionFactory(ctx), AroundInvokeTestMDBImpl.getQueue(ctx));
                return;
            }
            status = true;
            TLogger.log(reason);
            StatusReporter.report("getBeanTest", status, reason, AroundInvokeTestMDBImpl.getQueueConnectionFactory(ctx), AroundInvokeTestMDBImpl.getQueue(ctx));
            return;
        }
        if (this.bean != bean) {
            status = false;
            reason = "Expected " + this.bean + ", actual " + bean;
        } else {
            status = true;
            reason = "getBeanTest passed";
        }
        TLogger.log(reason);
        StatusReporter.report("getBeanTest", status, reason, AroundInvokeTestMDBImpl.getQueueConnectionFactory(ctx), AroundInvokeTestMDBImpl.getQueue(ctx));
    }

    @Override
    protected void suppressExceptionTest(InvocationContext ctx) {
        throw new IllegalStateException("This test does not apply to MDB.");
    }

    @Override
    protected void runtimeExceptionTest(InvocationContext ctx) {
        throw new IllegalStateException("This test does not apply to MDB.");
    }

    @Override
    protected void runtimeExceptionAfterTest(InvocationContext ctx) {
        throw new IllegalStateException("This test does not apply to MDB.");
    }

    @Override
    protected void exceptionTest(InvocationContext ctx) {
        throw new IllegalStateException("This test does not apply to MDB.");
    }

    @Override
    protected void getParametersEmptyTest(InvocationContext ctx) {
        throw new IllegalStateException("This test does not apply to MDB.");
    }

    @Override
    protected void checkOrder0(InvocationContext ctx, int orderInChain) {
        AroundInvokeTestMDBImpl.checkOrder(ctx, orderInChain);
    }

    @Override
    protected void checkInvocationContext0(InvocationContext ctx, int orderInChain) {
        AroundInvokeTestMDBImpl.checkInvocationContext(ctx, orderInChain);
    }

    @Override
    protected void sameSecContextTest(InvocationContext ctx) {
        boolean status = true;
        String reason = null;
        EJBContext ejbContext = AroundInvokeTestMDBImpl.getEJBContext();
        Principal princ = ejbContext.getCallerPrincipal();
        if (princ == null) {
            status = false;
            reason = "In AroundInvokeTestMDBImpl, caller principal is null.";
            TLogger.log(reason);
            StatusReporter.report("sameSecContextTest", status, reason, AroundInvokeTestMDBImpl.getQueueConnectionFactory(ctx), AroundInvokeTestMDBImpl.getQueue(ctx));
            return;
        }
        if (this.bean != null) {
            if (this.beanPrincipal != null) {
                if (!princ.equals(this.beanPrincipal)) {
                    status = false;
                    reason = "Principal in interceptor is not the same as in bean.";
                } else {
                    status = true;
                    reason = "sameSecContextTest passed: interceptor has the same Principal as bean method.";
                }
            } else {
                status = false;
                reason = "In AroundInvokeTestMDBImpl, bean is not null, but beanPrincipal is null.";
            }
        }
        TLogger.log(reason);
        StatusReporter.report("sameSecContextTest", status, reason, AroundInvokeTestMDBImpl.getQueueConnectionFactory(ctx), AroundInvokeTestMDBImpl.getQueue(ctx));
    }
}

