/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.singleton.concurrency.container.accesstimeout;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.lite.singleton.concurrency.container.accesstimeout.Interceptor1;
import java.util.concurrent.TimeUnit;
import javax.ejb.AccessTimeout;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.interceptor.Interceptors;

@Singleton(name="TimeUnit")
@Startup
public class TimeUnitBean {
    @AccessTimeout(value=1000L)
    @Interceptors(value={Interceptor1.class})
    public int timeoutInterceptor(long waitVal, int resultVal) {
        return resultVal;
    }

    @AccessTimeout(value=0L)
    public int zero(long waitVal, int resultVal) {
        return this.waitAndReturn(waitVal, resultVal);
    }

    @AccessTimeout(value=-1L)
    public int minus1(long waitVal, int resultVal) {
        return this.waitAndReturn(waitVal, resultVal);
    }

    @AccessTimeout(value=1000L)
    public int defaults(long waitVal, int resultVal) {
        return this.waitAndReturn(waitVal, resultVal);
    }

    @AccessTimeout(unit=TimeUnit.NANOSECONDS, value=1000000000L)
    public int nanoseconds(long waitVal, int resultVal) {
        return this.waitAndReturn(waitVal, resultVal);
    }

    @AccessTimeout(unit=TimeUnit.MICROSECONDS, value=1000000L)
    public int microseconds(long waitVal, int resultVal) {
        return this.waitAndReturn(waitVal, resultVal);
    }

    @AccessTimeout(unit=TimeUnit.SECONDS, value=1L)
    public int seconds(long waitVal, int resultVal) {
        return this.waitAndReturn(waitVal, resultVal);
    }

    @AccessTimeout(unit=TimeUnit.DAYS, value=1L)
    public int days(long waitVal, int resultVal) {
        return this.waitAndReturn(waitVal, resultVal);
    }

    @AccessTimeout(unit=TimeUnit.HOURS, value=1L)
    public int hours(long waitVal, int resultVal) {
        return this.waitAndReturn(waitVal, resultVal);
    }

    @AccessTimeout(unit=TimeUnit.MINUTES, value=0x7FFFFFFFL)
    public int minutes(long waitVal, int resultVal) {
        return this.waitAndReturn(waitVal, resultVal);
    }

    private int waitAndReturn(long waitVal, int resultVal) {
        Helper.busyWait(waitVal);
        return resultVal;
    }
}

