/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry.Connection;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import java.net.PasswordAuthentication;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.x500.X500PrivateCredential;
import javax.xml.registry.RegistryService;

public class JAXRClient
extends JAXRCommonClient {
    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            this.logMsg("in cleanup");
            if (this.conn != null) {
                this.logTrace("Cleanup is closing the connection");
                this.conn.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void ConnectionisSynchronousDefaultTest() throws EETest.Fault {
        String testName = "ConnectionisSynchronousDefaultTest";
        boolean pass = true;
        try {
            if (!this.conn.isSynchronous()) {
                this.logMsg("Error isSynchronous() should return true, it returned: " + this.conn.isSynchronous());
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + "failed", e);
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void ConnectionsetSynchronousTest1() throws EETest.Fault {
        String testName = "ConnectionsetSynchronousTest1";
        boolean pass = true;
        try {
            this.conn.setSynchronous(true);
            if (!this.conn.isSynchronous()) {
                this.logMsg("Error synchronous was set to true, its: " + this.conn.isSynchronous());
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed", e);
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed");
        }
    }

    public void ConnectionCloseTest() throws EETest.Fault {
        String testName = "ConnectionCloseTest";
        boolean pass = true;
        try {
            this.conn.close();
            try {
                if (!this.conn.isClosed()) {
                    this.logMsg("Connection.close() has been called, but it is still open!");
                    pass = false;
                }
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                this.logMsg("Connection is closed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed", e);
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed");
        }
    }

    public void ConnectionsetCredentialsTest() throws EETest.Fault {
        String testName = "ConnectionsetCredentialsTest";
        this.debug.clear();
        boolean pass = false;
        Set<PasswordAuthentication> credentials = null;
        try {
            switch (this.jaxrSecurityCredentialType) {
                case 0: {
                    PasswordAuthentication pa;
                    credentials = new HashSet();
                    PasswordAuthentication passwdAuth = new PasswordAuthentication(this.jaxrUser, this.jaxrPassword.toCharArray());
                    credentials.add(passwdAuth);
                    this.conn.setCredentials(credentials);
                    for (Object e : credentials) {
                        if (!(e instanceof PasswordAuthentication)) continue;
                        pa = (PasswordAuthentication)e;
                        this.debug.add("Setting password to: " + new String(pa.getPassword()) + "\n");
                        this.debug.add("Setting username to:  " + pa.getUserName() + "\n");
                    }
                    credentials = this.conn.getCredentials();
                    for (Object e : credentials) {
                        if (e instanceof PasswordAuthentication) {
                            pa = (PasswordAuthentication)e;
                            this.debug.add("Password returned: " + new String(pa.getPassword()) + "\n");
                            this.debug.add("Username returned:  " + pa.getUserName() + "\n");
                            if (!pa.getUserName().equals(this.jaxrUser) || !new String(pa.getPassword()).equals(this.jaxrPassword)) continue;
                            pass = true;
                            continue;
                        }
                        this.debug.add("Error: returned unexpected object!\n");
                        this.debug.add("Object is: " + e.toString() + "\n");
                    }
                    break;
                }
                case 1: {
                    X500PrivateCredential cred;
                    credentials = super.getDigitalCertificateCredentials(this.jaxrAlias, this.jaxrAliasPassword);
                    this.conn.setCredentials(credentials);
                    for (Object e : credentials) {
                        if (!(e instanceof X500PrivateCredential)) continue;
                        cred = (X500PrivateCredential)e;
                        this.debug.add("alias is: " + cred.getAlias());
                    }
                    credentials = this.conn.getCredentials();
                    for (Object e : credentials) {
                        if (e instanceof X500PrivateCredential) {
                            cred = (X500PrivateCredential)e;
                            this.debug.add("alias returned: " + cred.getAlias());
                            if (!cred.getAlias().equals(this.jaxrAlias)) continue;
                            pass = true;
                            continue;
                        }
                        this.debug.add("Error: returned unexpected object!\n");
                        this.debug.add("Object is: " + e.toString() + "\n");
                    }
                    break;
                }
                default: {
                    throw new EETest.Fault("failed: jaxrSecurityCredentialType is invalid");
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed", e);
        }
        finally {
            TestUtil.logTrace((String)this.debug.toString());
            if (!pass) {
                throw new EETest.Fault(testName + " failed");
            }
        }
    }

    public void ConnectiongetRegistryServiceTest() throws EETest.Fault {
        String testName = "ConnectiongetRegistryServiceTest";
        boolean pass = true;
        RegistryService rs = null;
        try {
            rs = this.conn.getRegistryService();
            if (!(rs instanceof RegistryService)) {
                this.logMsg("Error we did not get a RegistryService object");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + "failed", e);
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void ConnectionisClosedTest() throws EETest.Fault {
        String testName = "ConnectionisClosedTest";
        boolean pass = true;
        this.debug.clear();
        try {
            if (this.conn.isClosed()) {
                this.debug.add("Error connection is open, yet isClosed method returns");
                this.debug.add(" " + this.conn.isClosed());
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + "failed", e);
        }
        finally {
            TestUtil.logTrace((String)this.debug.toString());
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }
}

