/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.common;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.interop.csiv2.common.CSIv2FileLoggerImpl;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.rmi.AccessException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import javax.ejb.CreateException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public class CSIv2Log {
    static Hashtable watchList = new Hashtable();
    private static CSIv2Log theRemoteLog;
    private static CSIv2Log theLocalLog;
    private boolean logRemotely;
    public static String assertion;
    private static String logFileLocation;
    private static String logFileAction;
    private static String theServerInterceptorLog;
    private static CSIv2FileLoggerImpl serverInterceptorLogger;
    private static String LOG_SERVLET_PATH;
    private static String ri_webhostname;
    private static String ri_webportnum;
    private static boolean isInterceptorLoggingRequired;

    private CSIv2Log(boolean remote) {
        this.logRemotely = remote;
        String errMsg = "ERROR - CSIv2Log constructor, could not get value for jvm option:  ";
        if (logFileLocation == null) {
            System.err.println(errMsg + "ri.log.file.location");
        } else {
            this.debug("CSIv2Log constructor - System.getProperty(ri.log.file.location) = " + logFileLocation);
        }
        if (ri_webhostname == null) {
            System.err.println(errMsg + "webServerHost.2");
            ri_webhostname = "localhost";
        } else {
            this.debug("CSIv2Log constructor - System.getProperty(webServerHost.2) = " + ri_webhostname);
        }
        if (ri_webportnum == null) {
            System.err.println(errMsg + "webServerPort.2");
            ri_webportnum = "8080";
        } else {
            this.debug("CSIv2Log constructor - System.getProperty(webServerPort.2) = " + ri_webportnum);
        }
        isInterceptorLoggingRequired = CSIv2Log.getSysPropInterceptorLoggingRequired();
        if (isInterceptorLoggingRequired) {
            this.debug("creating CSIv2FileLoggerImpl for " + theServerInterceptorLog);
            serverInterceptorLogger = CSIv2FileLoggerImpl.getFileLogger(theServerInterceptorLog);
            if (serverInterceptorLogger == null) {
                System.err.println("ERROR in CSIv2Log constructor invoking CSIv2FileLoggerImpl.getFileLogger()");
            }
        }
    }

    public static void addWatch(String operationName) {
        if (isInterceptorLoggingRequired) {
            System.out.println("CSIv2log.addWatch():  Watching for call to " + operationName + "...");
            if (!watchList.containsKey(operationName)) {
                watchList.put(operationName, new Integer(0));
            }
        }
    }

    public static void clearWatchList() {
        if (isInterceptorLoggingRequired) {
            TestUtil.logTrace((String)"CSIv2log.clearWatchList(): Clearing watch list...");
            watchList = new Hashtable();
        }
    }

    public static void incrementWatch(String operationName) {
        if (isInterceptorLoggingRequired) {
            TestUtil.logTrace((String)("CSIv2log.incrementWatch(): Pending Incrementing watch count for " + operationName + "."));
            if (watchList.containsKey(operationName)) {
                int i = (Integer)watchList.get(operationName) + 1;
                TestUtil.logTrace((String)("Incrementing watch count for " + operationName + ": " + i));
                watchList.put(operationName, new Integer(i));
            } else {
                TestUtil.logTrace((String)("CSIv2log.incrementWatch(): Did not find " + operationName));
            }
        }
    }

    public static void decrementWatch(String operationName) {
        if (isInterceptorLoggingRequired && watchList.containsKey(operationName)) {
            int i = (Integer)watchList.get(operationName) - 1;
            if (i == -1) {
                TestUtil.logTrace((String)("CSIv2Log.decrementWatch(): Ignoring first call to decrement watch for " + operationName + "..."));
            } else if (i <= 0) {
                TestUtil.logTrace((String)("CSIv2Log.decrementWatch(): Removing " + operationName + " from watch list..."));
                watchList.remove(operationName);
            } else {
                TestUtil.logTrace((String)("CSIv2Log.decrementWatch(): Decrementing watch count for " + operationName + ": " + i));
                watchList.put(operationName, new Integer(i));
            }
        }
    }

    public static CSIv2Log getLog() {
        return CSIv2Log.getLogImpl(true);
    }

    public static CSIv2Log getLocalLog() {
        return CSIv2Log.getLogImpl(false);
    }

    private static CSIv2Log getLogImpl(boolean remote) {
        if (remote && theRemoteLog == null) {
            theRemoteLog = new CSIv2Log(remote);
        } else if (!remote && theLocalLog == null) {
            theLocalLog = new CSIv2Log(remote);
        }
        CSIv2Log result = remote ? theRemoteLog : theLocalLog;
        return result;
    }

    public void startLog() {
        if (isInterceptorLoggingRequired) {
            this.log(1, "<csiv2-log>");
        }
    }

    public void logStartAssertion(String name) {
        if (isInterceptorLoggingRequired) {
            this.log(2, "<assertion name=\"" + name + "\">");
        }
    }

    public void logStartInvocation() {
        if (isInterceptorLoggingRequired) {
            this.log(3, "<invocation>");
        }
    }

    public void logStartEJBHome() {
        if (isInterceptorLoggingRequired) {
            this.log(4, "<ejb-home>");
        }
    }

    public void logStartClient() {
        if (isInterceptorLoggingRequired) {
            this.log(5, "<client>");
        }
    }

    public void logStartClientInterceptor() {
        if (isInterceptorLoggingRequired) {
            this.log(6, "<client-interceptor>");
        }
    }

    public void logOperationName(String operation) {
        if (isInterceptorLoggingRequired) {
            this.log(7, "<operation>" + operation + "</operation>");
        }
    }

    public void logRequestServiceContext(String logEntry) {
        if (isInterceptorLoggingRequired) {
            if (logEntry == null) {
                this.log(7, "<req-svc-context present=\"false\"/>");
            } else {
                this.log(7, "<req-svc-context present=\"true\">\n" + logEntry);
                this.log(7, "</req-svc-context>");
            }
        }
    }

    public void logSSLUsed(boolean sslUsed) {
        if (isInterceptorLoggingRequired) {
            this.log(7, "<ssl-used>" + sslUsed + "</ssl-used>");
        }
    }

    public void logReply(Throwable t) {
        if (isInterceptorLoggingRequired) {
            this.log(6, "<reply>");
            if (t == null) {
                this.log(7, "<no-exception/>");
            } else if (t instanceof CreateException) {
                this.log(7, "<create-exception>");
                this.log(8, t.getMessage().trim());
                this.log(7, "</create-exception>");
            } else if (t instanceof AccessException) {
                this.log(7, "<access-exception>");
                this.log(8, t.getMessage().trim());
                this.log(7, "</access-exception>");
            } else {
                this.log(7, "<other-exception>");
                this.log(8, t.getMessage().trim());
                this.log(7, "</other-exception>");
            }
            this.log(6, "</reply>");
        }
    }

    public void logLocationForward(boolean locationForward) {
        if (isInterceptorLoggingRequired) {
            this.log(7, "<location-forward>" + locationForward + "</location-forward>");
        }
    }

    public void logReplyServiceContext(String logEntry) {
        if (isInterceptorLoggingRequired) {
            if (logEntry == null) {
                this.log(7, "<reply-svc-context present=\"false\"/>");
            } else {
                this.log(7, "<reply-svc-context present=\"true\">\n" + logEntry);
                this.log(7, "</reply-svc-context>");
            }
        }
    }

    public void logIOR(String ior) {
        if (isInterceptorLoggingRequired) {
            this.log(7, "<ior>" + ior);
            this.log(7, "</ior>");
        }
    }

    public void logEndClientInterceptor() {
        if (isInterceptorLoggingRequired) {
            this.log(6, "</client-interceptor>");
        }
    }

    public void logStartServerInterceptor() {
        if (isInterceptorLoggingRequired) {
            this.log(6, "<server-interceptor>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logTransportClientPrincipals(Socket socket) {
        if (isInterceptorLoggingRequired) {
            if (socket instanceof SSLSocket) {
                this.log(7, "<transport-client-principals>");
                try {
                    SSLSocket sslSocket = (SSLSocket)socket;
                    SSLSession session = sslSocket.getSession();
                    Certificate[] certificates = session.getPeerCertificates();
                    for (int i = 0; i < certificates.length; ++i) {
                        String principalName = ((X509Certificate)certificates[i]).getSubjectX500Principal().getName("RFC1779");
                        this.log(8, "<principal>" + principalName + "</principal>");
                    }
                }
                catch (SSLPeerUnverifiedException sslSocket) {
                }
                finally {
                    this.log(7, "</transport-client-principals>");
                }
            } else {
                this.log(7, "<transport-client-principals/>");
            }
        } else if (socket instanceof SSLSocket) {
            try {
                SSLSocket sslSocket = (SSLSocket)socket;
                SSLSession session = sslSocket.getSession();
                Certificate[] certificates = session.getPeerCertificates();
                this.log("<transport-client-principals>");
                for (int i = 0; i < certificates.length; ++i) {
                    String principalName = ((X509Certificate)certificates[i]).getSubjectX500Principal().getName("RFC1779");
                    this.log("<peer_principal>" + principalName + "</peer_principal>");
                }
                Certificate[] certificates2 = session.getLocalCertificates();
                for (int i = 0; i < certificates2.length; ++i) {
                    String principalName = ((X509Certificate)certificates2[i]).getSubjectX500Principal().getName("RFC1779");
                    this.log("<local_principal>" + principalName + "</local_principal>");
                }
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            }
            finally {
                this.log("</transport-client-principals>");
            }
        } else {
            this.log("Not an SSL socket");
            this.log("<transport-client-principals/>");
        }
    }

    public void logStartServer() {
        if (isInterceptorLoggingRequired) {
            this.log(7, "<server>");
        }
    }

    public void logInvocationPrincipal(String principal) {
        if (isInterceptorLoggingRequired) {
            this.log(8, "<invocation-principal>" + principal + "</invocation-principal>");
        } else {
            this.log("<invocation-principal>" + principal + "</invocation-principal>");
        }
    }

    public void logEndServer() {
        if (isInterceptorLoggingRequired) {
            this.log(7, "</server>");
        }
    }

    public void logEndServerInterceptor() {
        if (isInterceptorLoggingRequired) {
            this.log(6, "</server-interceptor>");
        }
    }

    public void logEndClient() {
        if (isInterceptorLoggingRequired) {
            this.log(5, "</client>");
        }
    }

    public void logEndEJBHome() {
        if (isInterceptorLoggingRequired) {
            this.log(4, "</ejb-home>");
        }
    }

    public void logStartEJBRemote() {
        if (isInterceptorLoggingRequired) {
            this.log(4, "<ejb-remote>");
        }
    }

    public void logEndEJBRemote() {
        if (isInterceptorLoggingRequired) {
            this.log(4, "</ejb-remote>");
        }
    }

    public void logEndInvocation() {
        if (isInterceptorLoggingRequired) {
            this.log(3, "</invocation>");
        }
    }

    public void logEndAssertion() {
        if (isInterceptorLoggingRequired) {
            this.log(2, "</assertion>");
        }
        assertion = null;
    }

    public void endLog() {
        if (isInterceptorLoggingRequired) {
            this.log(1, "</csiv2-log>");
        }
    }

    public String getLogContents() {
        String result = null;
        if (this.logRemotely) {
            try {
                result = this.invokeServletAndGetLogContent(ri_webhostname, ri_webportnum);
            }
            catch (Exception e) {
                TestUtil.logErr((String)"COULD NOT GET LOG INFO FROM LOGGER SERVLET, RESULT: ", (Throwable)e);
                System.err.println("COULD NOT GET LOG INFO FROM LOGGER SERVLET, RESULT: " + e);
            }
        } else {
            try {
                result = serverInterceptorLogger.get();
            }
            catch (Exception e) {
                TestUtil.logErr((String)("ERROR: Could not read log info from file: " + theServerInterceptorLog + "   due to exception:  "), (Throwable)e);
                System.err.println("ERROR: Could not read log info from file: " + theServerInterceptorLog + "   due to exception:  " + e);
            }
        }
        return result;
    }

    public void purge() {
        if (isInterceptorLoggingRequired) {
            if (this.logRemotely) {
                try {
                    this.invokeServletAndPurgeLog(ri_webhostname, ri_webportnum);
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"COULD NOT PURGE LOG FILE: ", (Throwable)e);
                    System.err.println("COULD NOT PURGE LOG FILE: " + e);
                }
            } else {
                try {
                    serverInterceptorLogger.purge();
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"ERROR: Could not invoke localLogger.purge(): ", (Throwable)e);
                    System.err.println("ERROR: Could not invoke localLogger.purge(): " + e);
                }
            }
        }
    }

    private void log(String message) {
        if (isInterceptorLoggingRequired) {
            if (this.logRemotely) {
                try {
                    String string = this.invokeServletAndLogMessage(ri_webhostname, ri_webportnum, message);
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"ERROR: Could not write message to log: ", (Throwable)e);
                    System.err.println("ERROR: Could not write message to log: " + e);
                }
            } else {
                try {
                    serverInterceptorLogger.log(message);
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"ERROR: Could not log message to localLogger: ", (Throwable)e);
                    System.err.println("ERROR: Could not log message to localLogger: " + e);
                }
                if (message.indexOf("<assertion name") > 0) {
                    int start = message.indexOf("\"") + 1;
                    int end = message.indexOf("\"", start);
                    assertion = message.substring(start, end);
                    this.debug("Assertion name: " + assertion);
                }
            }
        }
    }

    private void log(int index, String message) {
        if (isInterceptorLoggingRequired) {
            StringBuffer strbuf = new StringBuffer(message);
            for (int i = 0; i < 2 * (index - 1); ++i) {
                strbuf.insert(i, ' ');
            }
            message = strbuf.toString();
            if (this.logRemotely) {
                try {
                    String i = this.invokeServletAndLogMessage(ri_webhostname, ri_webportnum, message);
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"ERROR: Could not log message to log: ", (Throwable)e);
                    System.err.println("ERROR: Could not log message to log: " + e);
                }
            } else {
                serverInterceptorLogger.log(message);
            }
        }
    }

    public static String binHex(byte[] bytes) {
        StringBuffer result = new StringBuffer("");
        char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            result.append(digits[(b & 0xF0) >> 4]);
            result.append(digits[b & 0xF]);
        }
        return result.toString();
    }

    private void logHex(byte[] bytes) {
        String hex = CSIv2Log.binHex(bytes);
        for (int i = 0; i < hex.length(); i += 220) {
            String line = hex.substring(i, Math.min(i + 220, hex.length()));
            TestUtil.logMsg((String)line);
            this.log(line);
        }
    }

    public void enableLoggingInterceptor(boolean enableLocal, boolean enableRI) {
        if (isInterceptorLoggingRequired) {
            CSIv2Log.clearWatchList();
        }
    }

    private String getLogAssertion() {
        String rval = null;
        try {
            rval = this.invokeServletAndGetAssertionName(ri_webhostname, ri_webportnum);
            this.debug("CSIv2Log.getLogAssertion():  Assertion name = " + rval);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"ERROR: Could not getAssertionName from log. ", (Throwable)e);
            System.err.println("ERROR: Could not getAssertionName from log. " + e);
        }
        return rval;
    }

    private String invokeServletAndGetAssertionName(String hostname, String portnum) {
        return this.invokeServletAndGetResponse("POST", "getAssertion", hostname, portnum, null);
    }

    private String invokeServletAndGetLogContent(String hostname, String portnum) {
        return this.invokeServletAndGetResponse("POST", "getLogContent", hostname, portnum, null);
    }

    private String invokeServletAndPurgeLog(String hostname, String portnum) {
        this.debug("in CSIv2Log.invokeServletAndPurgeLog():  hostname = " + hostname);
        this.debug("in CSIv2Log.invokeServletAndPurgeLog():  portnum = " + portnum);
        return this.invokeServletAndGetResponse("POST", "Purge", hostname, portnum, null);
    }

    private String invokeServletAndLogMessage(String hostname, String portnum, String logMsg) {
        this.debug("in CSIv2Log.invokeServletAndLogMessage():  hostname = " + hostname);
        this.debug("in CSIv2Log.invokeServletAndLogMessage():  portnum = " + portnum);
        this.debug("in CSIv2Log.invokeServletAndLogMessage():  logMsg = " + logMsg);
        return this.invokeServletAndGetResponse("POST", "Log", hostname, portnum, logMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String invokeServletAndGetResponse(String requestMethod, String logFileAction, String hostname, String sPortnum, String logMessage) {
        String sContext = LOG_SERVLET_PATH;
        String retVal = null;
        if (isInterceptorLoggingRequired) {
            String msg;
            int portnum = 8080;
            if (sPortnum != null) {
                portnum = Integer.parseInt(sPortnum);
            } else {
                msg = "ERROR - CSIv2Log.invokeServletAndGetResponse():  invalid portnum passed in. Check JVM settings.";
                TestUtil.logErr((String)msg);
                System.err.println(msg);
            }
            if (hostname == null) {
                msg = "ERROR - CSIv2Log.invokeServletAndGetResponse():  invalid hostname passed in. Check JVM settings.";
                TestUtil.logErr((String)msg);
                System.err.println(msg);
                hostname = "localhost";
            }
            if (!sContext.startsWith("/")) {
                sContext = "/" + sContext;
            }
            HttpURLConnection conn = null;
            FilterOutputStream wr = null;
            try {
                String urlParameters = null;
                urlParameters = "ri.log.file.location=" + URLEncoder.encode(logFileLocation, "UTF-8") + "&log.file.action=" + URLEncoder.encode(logFileAction, "UTF-8") + "&log.file.name=" + URLEncoder.encode("serverInterceptorLog.txt", "UTF-8");
                if (logMessage != null) {
                    urlParameters = urlParameters + "&log.message=" + URLEncoder.encode(logMessage, "UTF-8");
                }
                String url = "http://" + hostname + ":" + portnum + "/" + sContext;
                URL newURL = new URL(url);
                conn = (HttpURLConnection)newURL.openConnection();
                if (requestMethod.equalsIgnoreCase("POST")) {
                    conn.setDoInput(true);
                    conn.setDoOutput(true);
                }
                conn.setRequestMethod(requestMethod);
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                conn.setRequestProperty("Content-Length", "" + Integer.toString(urlParameters.getBytes().length));
                conn.setRequestProperty("Content-Language", "en-US");
                conn.setUseCaches(false);
                wr = new DataOutputStream(conn.getOutputStream());
                ((DataOutputStream)wr).writeBytes(urlParameters);
                ((DataOutputStream)wr).flush();
                wr.close();
                int code = conn.getResponseCode();
                StringBuilder sbResponse = new StringBuilder();
                InputStream content = conn.getInputStream();
                try (BufferedReader in = new BufferedReader(new InputStreamReader(content));){
                    String line;
                    while ((line = in.readLine()) != null) {
                        sbResponse.append(line + "\n");
                    }
                }
                String string = retVal = sbResponse.toString();
                return string;
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Abnormal return status and Exception encountered while invoking " + sContext));
                TestUtil.logTrace((String)"Exception in CSIv2Log.invokeServletAndGetResponse() is ", (Throwable)e);
            }
            finally {
                try {
                    wr.close();
                }
                catch (Exception exception) {}
            }
        }
        return "No CSIv2 logs. Nothing was recorded";
    }

    private void debug(String str) {
        TestUtil.logTrace((String)str);
    }

    private static boolean getSysPropInterceptorLoggingRequired() {
        String sysPropText = System.getProperty("interceptor.logging.required");
        if (sysPropText != null) {
            isInterceptorLoggingRequired = Boolean.parseBoolean(sysPropText);
            TestUtil.logTrace((String)("System property interceptor.logging.required = " + isInterceptorLoggingRequired));
        }
        return isInterceptorLoggingRequired;
    }

    static {
        logFileLocation = System.getProperty("ri.log.file.location");
        logFileAction = "getLogContent";
        theServerInterceptorLog = logFileLocation + File.separator + "serverInterceptorLog.txt";
        LOG_SERVLET_PATH = "/logger_servlet_web/LoggerServlet";
        ri_webhostname = System.getProperty("webServerHost.2");
        ri_webportnum = System.getProperty("webServerPort.2");
        isInterceptorLoggingRequired = true;
    }
}

