/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.patchtests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.JsonAssert;
import com.sun.ts.tests.jsonp.api.common.JsonValueType;
import com.sun.ts.tests.jsonp.api.common.SimpleValues;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import com.sun.ts.tests.jsonp.api.patchtests.CommonOperation;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonPatch;
import javax.json.JsonPatchBuilder;
import javax.json.JsonPointer;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;

class PatchOperationAdd
extends CommonOperation {
    private final String OPERATION = "ADD";

    PatchOperationAdd() {
    }

    TestResult test() {
        TestResult result = new TestResult("RFC 6902 add operation");
        TestUtil.logMsg((String)"Testing RFC 6902 add operation:");
        this.testAddStringOnEmptyObject(result);
        this.testAddStringOnSimpleObject(result);
        this.testAddStringOnEmptyArray(result);
        this.testAddStringOnSimpleArray(result);
        this.testAddStringOnSimpleArray2(result);
        this.testAddIntOnEmptyObject(result);
        this.testAddIntOnSimpleObject(result);
        this.testAddIntOnEmptyArray(result);
        this.testAddIntOnSimpleArray(result);
        this.testAddIntOnSimpleArray2(result);
        this.testAddBooleanOnEmptyObject(result);
        this.testAddBooleanOnSimpleObject(result);
        this.testAddBooleanOnEmptyArray(result);
        this.testAddBooleanOnSimpleArray(result);
        this.testAddBooleanOnSimpleArray2(result);
        this.testAddObjectOnEmptyObject(result);
        this.testAddObjectOnSimpleObject(result);
        this.testAddObjectOnEmptyArray(result);
        this.testAddObjectOnSimpleArray(result);
        this.testAddObjectOnSimpleArray2(result);
        this.testAddArrayToReplaceObject(result);
        this.testAddArrayToReplaceDocument(result);
        this.testAddStringArrayToStringArray(result);
        this.testAddStringToNonExistingObject(result);
        return result;
    }

    private void testAddStringOnEmptyObject(TestResult result) {
        TestUtil.logMsg((String)" - for String on empty JSON object");
        JsonObject in = SimpleValues.createEmptyObject();
        JsonObject check = SimpleValues.createSimpleObjectStr();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/address", "In a galaxy far far away");
    }

    private void testAddStringOnEmptyArray(TestResult result) {
        TestUtil.logMsg((String)" - for String on empty JSON array");
        JsonArray in = SimpleValues.createEmptyArray();
        JsonArray check = SimpleValues.createEmptyArrayWithStr();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/0", "In a galaxy far far away");
    }

    private void testAddStringOnSimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for String on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObject();
        JsonObject check = SimpleValues.createSimpleObjectWithStr();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/address", "In a galaxy far far away");
    }

    private void testAddStringOnSimpleArray(TestResult result) {
        TestUtil.logMsg((String)" - for String on simple JSON array of size 1");
        JsonArray in = SimpleValues.createStringArray1();
        JsonArray checkBefore = SimpleValues.createSimpleStringArrayWithStrBefore();
        JsonArray checkAfter = SimpleValues.createSimpleStringArrayWithStrAfter();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)checkBefore, "/0", "In a galaxy far far away");
        this.simpleOperation(result, (JsonValue)in, (JsonValue)checkAfter, "/1", "In a galaxy far far away");
    }

    private void testAddStringOnSimpleArray2(TestResult result) {
        TestUtil.logMsg((String)" - for String on simple JSON array of size 2");
        JsonArray in = SimpleValues.createStringArray2();
        JsonArray check = SimpleValues.createSimpleStringArray5();
        this.complexOperation(result, in, check, new String[]{"/2", "/1", "/0"}, new String[]{"Fifth value", "Third value", "First value"});
        this.complexOperation(result, in, check, new String[]{"/0", "/2", "/4"}, new String[]{"First value", "Third value", "Fifth value"});
    }

    private void testAddIntOnEmptyObject(TestResult result) {
        TestUtil.logMsg((String)" - for int on empty JSON object");
        JsonObject in = SimpleValues.createEmptyObject();
        JsonObject check = SimpleValues.createSimpleObjectInt();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/age", 42);
    }

    private void testAddIntOnEmptyArray(TestResult result) {
        TestUtil.logMsg((String)" - for int on empty JSON array");
        JsonArray in = SimpleValues.createEmptyArray();
        JsonArray check = SimpleValues.createEmptyArrayWithInt();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/0", 42);
    }

    private void testAddIntOnSimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for int on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObject();
        JsonObject check = SimpleValues.createSimpleObjectWithInt();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/age", 42);
    }

    private void testAddIntOnSimpleArray(TestResult result) {
        TestUtil.logMsg((String)" - for int on simple JSON array of size 1");
        JsonArray in = SimpleValues.createIntArray1();
        JsonArray checkBefore = SimpleValues.createSimpleIntArrayWithIntBefore();
        JsonArray checkAfter = SimpleValues.createSimpleIntArrayWithIntAfter();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)checkBefore, "/0", 42);
        this.simpleOperation(result, (JsonValue)in, (JsonValue)checkAfter, "/1", 42);
    }

    private void testAddIntOnSimpleArray2(TestResult result) {
        TestUtil.logMsg((String)" - for int on simple JSON array of size 2");
        JsonArray in = SimpleValues.createIntArray2();
        JsonArray check = SimpleValues.createSimpleIntArray5();
        this.complexOperation(result, in, check, new String[]{"/2", "/1", "/0"}, new Integer[]{5, 3, 1});
        this.complexOperation(result, in, check, new String[]{"/0", "/2", "/4"}, new Integer[]{1, 3, 5});
    }

    private void testAddBooleanOnEmptyObject(TestResult result) {
        TestUtil.logMsg((String)" - for boolean on empty JSON object");
        JsonObject in = SimpleValues.createEmptyObject();
        JsonObject check = SimpleValues.createSimpleObjectBool();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/married", true);
    }

    private void testAddBooleanOnEmptyArray(TestResult result) {
        TestUtil.logMsg((String)" - for boolean on empty JSON array");
        JsonArray in = SimpleValues.createEmptyArray();
        JsonArray check = SimpleValues.createEmptyArrayWithBool();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/0", true);
    }

    private void testAddBooleanOnSimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for boolean on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObject();
        JsonObject check = SimpleValues.createSimpleObjectWithBool();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/married", true);
    }

    private void testAddBooleanOnSimpleArray(TestResult result) {
        TestUtil.logMsg((String)" - for boolean on simple JSON array of size 1");
        JsonArray in = SimpleValues.createBoolArray1();
        JsonArray checkBefore = SimpleValues.createSimpleBoolArrayWithBoolBefore();
        JsonArray checkAfter = SimpleValues.createSimpleBoolArrayWithBoolAfter();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)checkBefore, "/0", false);
        this.simpleOperation(result, (JsonValue)in, (JsonValue)checkAfter, "/1", false);
    }

    private void testAddBooleanOnSimpleArray2(TestResult result) {
        TestUtil.logMsg((String)" - for boolean on simple JSON array of size 2");
        JsonArray in = SimpleValues.createBoolArray2();
        JsonArray check = SimpleValues.createSimpleBoolArray5();
        this.complexOperation(result, in, check, new String[]{"/2", "/1", "/0"}, new Boolean[]{true, true, false});
        this.complexOperation(result, in, check, new String[]{"/0", "/2", "/4"}, new Boolean[]{false, true, true});
    }

    private void testAddObjectOnEmptyObject(TestResult result) {
        TestUtil.logMsg((String)" - for JsonObject on empty JSON object");
        JsonObject in = SimpleValues.createEmptyObject();
        JsonObject check = SimpleValues.createSimpleObjectObject();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/wife", SimpleValues.OBJ_VALUE);
    }

    private void testAddObjectOnEmptyArray(TestResult result) {
        TestUtil.logMsg((String)" - for JsonObject on empty JSON array");
        JsonArray in = SimpleValues.createEmptyArray();
        JsonArray check = SimpleValues.createEmptyArrayWithObject();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/0", SimpleValues.OBJ_VALUE);
    }

    private void testAddObjectOnSimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for JsonObject on simple JSON object");
        JsonObject in = SimpleValues.createCompoundObject();
        JsonObject check = SimpleValues.createCompoundObjectWithObject();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/wife", SimpleValues.OBJ_VALUE);
    }

    private void testAddObjectOnSimpleArray(TestResult result) {
        TestUtil.logMsg((String)" - for JsonObject on simple JSON array of size 1");
        JsonArray in = SimpleValues.createObjectArray1();
        JsonArray checkBefore = SimpleValues.createSimpleObjectArrayWithObjectBefore();
        JsonArray checkAfter = SimpleValues.createSimpleObjectArrayWithObjectAfter();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)checkBefore, "/0", SimpleValues.OBJ_VALUE);
        this.simpleOperation(result, (JsonValue)in, (JsonValue)checkAfter, "/1", SimpleValues.OBJ_VALUE);
    }

    private void testAddObjectOnSimpleArray2(TestResult result) {
        TestUtil.logMsg((String)" - for JsonObject on simple JSON array of size 2");
        JsonArray in = SimpleValues.createObjectArray2();
        JsonArray check = SimpleValues.createSimpleObjectArray5();
        this.complexOperation(result, in, check, new String[]{"/2", "/1", "/0"}, new JsonObject[]{SimpleValues.OBJ_VALUE_5, SimpleValues.OBJ_VALUE_3, SimpleValues.OBJ_VALUE_1});
        this.complexOperation(result, in, check, new String[]{"/0", "/2", "/4"}, new JsonObject[]{SimpleValues.OBJ_VALUE_1, SimpleValues.OBJ_VALUE_3, SimpleValues.OBJ_VALUE_5});
    }

    private void testAddArrayToReplaceObject(TestResult result) {
        TestUtil.logMsg((String)" - for JsonArray to replace JsonObject");
        JsonObject in = SimpleValues.createCompoundObject();
        JsonObject check = SimpleValues.createCompoundObjectWithObjectReplaced();
        JsonArray value = SimpleValues.createSimpleStringArray5();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/child", value);
    }

    private void testAddArrayToReplaceDocument(TestResult result) {
        TestUtil.logMsg((String)" - for JsonArray to replace whole document");
        JsonObject in = SimpleValues.createCompoundObject();
        JsonArray check = SimpleValues.createSimpleStringArray5();
        JsonArray value = SimpleValues.createSimpleStringArray5();
        JsonPatch patch1 = PatchOperationAdd.builderAdd(Json.createPatchBuilder(), "", value).build();
        JsonStructure out1 = patch1.apply((JsonStructure)in);
        if (!JsonAssert.assertEquals((JsonValue)check, (JsonValue)out1)) {
            String className = value.getClass().getSimpleName();
            result.fail("ADD " + className + " to compound object", "ADD operation for " + className + " failed on compound value");
        }
    }

    private void testAddStringArrayToStringArray(TestResult result) {
        TestUtil.logMsg((String)" - for String array to be added to existing String array");
        JsonArray in = SimpleValues.createStringArray2();
        JsonArray check = SimpleValues.createStringArray2WithStringArrayInTheMiddle();
        JsonArray value = SimpleValues.createStringInnerArray2();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/1", value);
    }

    private void testAddStringToNonExistingObject(TestResult result) {
        TestUtil.logMsg((String)" - for String to be added to non existing JsonObject");
        JsonObject in = SimpleValues.createSimpleObject();
        JsonString value = Json.createValue((String)"In a galaxy far far away");
        String path = "/child/address";
        JsonPointer ptr = Json.createPointer((String)"/child/address");
        this.simpleOperationFail(result, (JsonValue)in, "/child/address", value);
    }

    @Override
    protected String operationName() {
        return "ADD";
    }

    @Override
    protected JsonPatchBuilder createOperationBuilder(String path, Object value) {
        return PatchOperationAdd.builderAdd(Json.createPatchBuilder(), path, value);
    }

    @Override
    protected JsonPatchBuilder updateOperationBuilder(JsonPatchBuilder builder, String path, Object value) {
        return PatchOperationAdd.builderAdd(builder, path, value);
    }

    private static JsonPatchBuilder builderAdd(JsonPatchBuilder builder, String path, Object value) {
        switch (JsonValueType.getType(value.getClass())) {
            case String: {
                return builder.add(path, (String)value);
            }
            case Integer: {
                return builder.add(path, ((Integer)value).intValue());
            }
            case Boolean: {
                return builder.add(path, ((Boolean)value).booleanValue());
            }
            case JsonValue: {
                return builder.add(path, (JsonValue)value);
            }
        }
        throw new IllegalArgumentException("Value does not match known JSON value type");
    }
}

