/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry.QueryManager;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import java.util.Properties;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.RegistryService;

public class JAXRClient
extends JAXRCommonClient {
    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            this.debug.clear();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            this.logMsg("in cleanup");
            if (this.conn != null) {
                this.logTrace("Cleanup is closing the connection");
                this.conn.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void queryManager_getRegistryService() throws EETest.Fault {
        String testName = "queryManager_getRegistryService";
        BusinessQueryManager bqm = null;
        try {
            bqm = this.rs.getBusinessQueryManager();
            RegistryService parentRs = bqm.getRegistryService();
            if (parentRs == null) {
                throw new EETest.Fault(testName + " failed  - returned null parent!! ");
            }
            if (!(parentRs instanceof RegistryService)) {
                throw new EETest.Fault(testName + " failed - RegistryService not returned!! ");
            }
            this.debug.add("Verify that getRegistryService returns the parent Registry service that created this \n");
            if (!parentRs.equals(this.rs)) {
                throw new EETest.Fault(testName + "Error: parent rs should be the same as rs");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }
}

