/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.mergetests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.SimpleValues;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import com.sun.ts.tests.jsonp.api.mergetests.MergeCommon;
import javax.json.JsonObject;
import javax.json.JsonValue;

public class MergeRemoveValue
extends MergeCommon {
    MergeRemoveValue() {
    }

    TestResult test() {
        TestResult result = new TestResult("RFC 7396: Remove existing values");
        TestUtil.logMsg((String)"Testing RFC 7396: Remove existing values");
        this.testStringOnEmptyObject(result);
        this.testStringOnsimpleObject(result);
        this.testIntOnEmptyObject(result);
        this.testIntOnsimpleObject(result);
        this.testBoolOnEmptyObject(result);
        this.testBoolOnsimpleObject(result);
        this.testObjectOnEmptyObject(result);
        this.testObjectOnsimpleObject(result);
        return result;
    }

    private void testStringOnEmptyObject(TestResult result) {
        TestUtil.logMsg((String)" - for String to produce empty JSON object");
        JsonObject in = SimpleValues.createSimpleObjectStr();
        JsonObject patch = SimpleValues.createPatchRemoveStr();
        JsonObject check = SimpleValues.createEmptyObject();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testStringOnsimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for String on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObjectWithStr();
        JsonObject patch = SimpleValues.createPatchRemoveStr();
        JsonObject check = SimpleValues.createSimpleObject();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testIntOnEmptyObject(TestResult result) {
        TestUtil.logMsg((String)" - for int to produce empty JSON object");
        JsonObject in = SimpleValues.createSimpleObjectInt();
        JsonObject patch = SimpleValues.createPatchRemoveInt();
        JsonObject check = SimpleValues.createEmptyObject();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testIntOnsimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for int on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObjectWithInt();
        JsonObject patch = SimpleValues.createPatchRemoveInt();
        JsonObject check = SimpleValues.createSimpleObject();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testBoolOnEmptyObject(TestResult result) {
        TestUtil.logMsg((String)" - for boolean to produce empty JSON object");
        JsonObject in = SimpleValues.createSimpleObjectBool();
        JsonObject patch = SimpleValues.createPatchRemoveBool();
        JsonObject check = SimpleValues.createEmptyObject();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testBoolOnsimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for boolean on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObjectWithBool();
        JsonObject patch = SimpleValues.createPatchRemoveBool();
        JsonObject check = SimpleValues.createSimpleObject();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testObjectOnEmptyObject(TestResult result) {
        TestUtil.logMsg((String)" - for JsonObject to produce empty JSON object");
        JsonObject in = SimpleValues.createSimpleObjectObject();
        JsonObject patch = SimpleValues.createPatchRemoveObject();
        JsonObject check = SimpleValues.createEmptyObject();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testObjectOnsimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for JsonObject on compoubnd JSON object");
        JsonObject in = SimpleValues.createCompoundObjectWithObject();
        JsonObject patch = SimpleValues.createPatchRemoveObject();
        JsonObject check = SimpleValues.createCompoundObject();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }
}

