/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.jsonarraytests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.ArrayBuilder;
import com.sun.ts.tests.jsonp.api.common.JsonAssert;
import com.sun.ts.tests.jsonp.api.common.JsonIO;
import com.sun.ts.tests.jsonp.api.common.JsonValueType;
import com.sun.ts.tests.jsonp.api.common.SimpleValues;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import com.sun.ts.tests.jsonp.api.jsonarraytests.ArrayCommon;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public class ArrayBuildAdd
extends ArrayCommon {
    ArrayBuildAdd() {
    }

    TestResult test() {
        TestResult result = new TestResult("JsonArrayBuilder API add() methods added in JSON-P 1.1.");
        TestUtil.logMsg((String)"JsonArrayBuilder API add() methods added in JSON-P 1.1.");
        this.testAdd(result);
        this.testAddNullBuilder(result);
        this.testAddOutOfBounds(result);
        this.testAddNull(result);
        this.testAddNullOutOfBounds(result);
        this.testAddArrayBuilder(result);
        this.testAddArrayBuilderNull(result);
        this.testAddArrayBuilderOutOfBounds(result);
        this.testAddObjectBuilder(result);
        this.testAddObjectBuilderNull(result);
        this.testAddObjectBuilderOutOfBounds(result);
        this.testAddAllString(result);
        this.testAddAllInt(result);
        this.testAddAllBool(result);
        this.testAddAllObject(result);
        this.testAddAllNull(result);
        return result;
    }

    private void testAdd(TestResult result) {
        Object[] values;
        for (Object value : values = new Object[]{SimpleValues.OBJ_VALUE, "In a galaxy far far away", 42, 9223372036854775765L, 3.441073578556931E305, SimpleValues.BIN_VALUE, SimpleValues.BDC_VALUE, true}) {
            String typeName = JsonValueType.getType(value).name();
            TestUtil.logMsg((String)(" - add(int," + typeName + ")"));
            String json = "[" + JsonValueType.toStringValue(value) + "]";
            JsonValue check = JsonIO.read(json);
            JsonArrayBuilder builder = this.createArrayBuilder(0, value);
            JsonArray out = builder.build();
            if (!this.operationFailed(check, (JsonValue)out)) continue;
            result.fail("add(" + typeName + ")", "Builder output " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString(check));
        }
    }

    private void testAddOutOfBounds(TestResult result) {
        Object[] values = new Object[]{SimpleValues.OBJ_VALUE, "In a galaxy far far away", 42, 9223372036854775765L, 3.441073578556931E305, SimpleValues.BIN_VALUE, SimpleValues.BDC_VALUE, true};
        int[] indexes = new int[]{-1, 2, 3};
        for (Object value : values) {
            String typeName = JsonValueType.getType(value).name();
            TestUtil.logMsg((String)(" - add(int," + typeName + ")"));
            String json = "[" + JsonValueType.toStringValue(value) + "]";
            JsonArrayBuilder builder = this.createArrayBuilder(value);
            for (int index : indexes) {
                try {
                    builder = this.updateOperationBuilder(builder, index, value);
                    result.fail("add(int," + typeName + ")", "Calling method with out of bounds index=" + index + " argument shall throw IndexOutOfBoundsException");
                }
                catch (IndexOutOfBoundsException e) {
                    TestUtil.logMsg((String)("    - Expected exception for index=" + index + ": " + e.getMessage()));
                }
                catch (Throwable t) {
                    result.fail("add(int,(" + typeName + ")null)", "Calling method with with out of bounds index=" + index + " argument shall throw IndexOutOfBoundsException, not " + t.getClass().getSimpleName());
                }
            }
        }
    }

    private void testAddNullBuilder(TestResult result) {
        JsonValueType[] types;
        for (JsonValueType type : types = new JsonValueType[]{JsonValueType.JsonValue, JsonValueType.String, JsonValueType.BigInteger, JsonValueType.BigDecimal}) {
            String typeName = type.name();
            TestUtil.logMsg((String)(" - add(int,(" + typeName + ")null)"));
            try {
                ArrayBuilder.add(Json.createArrayBuilder(), 0, type);
                result.fail("add(int,(" + typeName + ")null)", "Calling method with null argument shall throw NullPointerException");
            }
            catch (NullPointerException e) {
                TestUtil.logMsg((String)("    - Expected exception: " + e.getMessage()));
            }
            catch (Throwable t) {
                result.fail("add(int,(" + typeName + ")null)", "Calling method with null argument shall throw NullPointerException, not " + t.getClass().getSimpleName());
            }
        }
    }

    private void testAddNull(TestResult result) {
        TestUtil.logMsg((String)" - addNull(int)");
        Object value = null;
        String json = "[" + JsonValueType.toStringValue(value) + "]";
        JsonValue check = JsonIO.read(json);
        JsonArrayBuilder builder = this.createArrayBuilder(0, value);
        JsonArray out = builder.build();
        if (this.operationFailed(check, (JsonValue)out)) {
            result.fail("addNull(int)", "Builder output " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString(check));
        }
    }

    private void testAddNullOutOfBounds(TestResult result) {
        int[] indexes = new int[]{-1, 2, 3};
        TestUtil.logMsg((String)" - addNull(int)");
        Object value = null;
        JsonArrayBuilder builder = this.createArrayBuilder(value);
        for (int index : indexes) {
            try {
                builder = this.updateOperationBuilder(builder, index, value);
                result.fail("addNull(int)", "Calling method with out of bounds index=" + index + " argument shall throw IndexOutOfBoundsException");
            }
            catch (IndexOutOfBoundsException e) {
                TestUtil.logMsg((String)("    - Expected exception for index=" + index + ": " + e.getMessage()));
            }
            catch (Throwable t) {
                result.fail("addNull(int)", "Calling method with with out of bounds index=" + index + " argument shall throw IndexOutOfBoundsException, not " + t.getClass().getSimpleName());
            }
        }
    }

    private void testAddArrayBuilder(TestResult result) {
        TestUtil.logMsg((String)" - add(int,JsonArrayBuilder)");
        JsonValue checkBeg = JsonIO.read("[[" + JsonValueType.toStringValue("First value") + "," + JsonValueType.toStringValue("Second value") + "," + JsonValueType.toStringValue("Third value") + "," + JsonValueType.toStringValue("Fourth value") + "]," + JsonValueType.toStringValue("Fifth value") + "]");
        JsonValue checkEnd = JsonIO.read("[" + JsonValueType.toStringValue("First value") + ",[" + JsonValueType.toStringValue("Second value") + "," + JsonValueType.toStringValue("Third value") + "," + JsonValueType.toStringValue("Fourth value") + "," + JsonValueType.toStringValue("Fifth value") + "]]");
        JsonArrayBuilder inBeg = this.createArrayBuilder("Fifth value");
        JsonArrayBuilder inEnd = this.createArrayBuilder("First value");
        JsonArrayBuilder argBeg = this.createArrayBuilder("First value").add("Second value").add("Third value").add("Fourth value");
        JsonArrayBuilder argEnd = this.createArrayBuilder("Second value").add("Third value").add("Fourth value").add("Fifth value");
        this.verifyAddBuilder(result, checkBeg, 0, argBeg, inBeg);
        this.verifyAddBuilder(result, checkEnd, 1, argEnd, inEnd);
    }

    private void testAddArrayBuilderNull(TestResult result) {
        TestUtil.logMsg((String)" - add(int,(JsonArrayBuilder)null)");
        JsonArrayBuilder in = this.createArrayBuilder("John Smith");
        JsonArrayBuilder arg = null;
        try {
            in.add(0, arg);
            result.fail("add(int,(JsonArrayBuilder)null)", "Calling method with null argument shall throw NullPointerException");
        }
        catch (NullPointerException e) {
            TestUtil.logMsg((String)("    - Expected exception: " + e.getMessage()));
        }
        catch (Throwable t) {
            result.fail("add(int,(JsonArrayBuilder)null)", "Calling method with null argument shall throw NullPointerException, not " + t.getClass().getSimpleName());
        }
    }

    private void testAddArrayBuilderOutOfBounds(TestResult result) {
        TestUtil.logMsg((String)" - add(int,JsonArrayBuilder)");
        int[] indexes = new int[]{-1, 5, 6};
        JsonArrayBuilder in = this.createArrayBuilder("First value").add("Second value").add("Third value").add("Fourth value");
        JsonArrayBuilder arg = this.createArrayBuilder("Fifth value");
        for (int index : indexes) {
            try {
                in.add(index, arg);
                result.fail("add(int,JsonArrayBuilder)", "Calling method with out of bounds index=" + index + " argument shall throw IndexOutOfBoundsException");
            }
            catch (IndexOutOfBoundsException e) {
                TestUtil.logMsg((String)("    - Expected exception for index=" + index + ": " + e.getMessage()));
            }
            catch (Throwable t) {
                result.fail("add(int,JsonArrayBuilder)", "Calling method with with out of bounds index=" + index + " argument shall throw IndexOutOfBoundsException, not " + t.getClass().getSimpleName());
            }
        }
    }

    private void testAddObjectBuilder(TestResult result) {
        TestUtil.logMsg((String)" - add(int,JsonObjectBuilder)");
        JsonValue checkBeg = JsonIO.read("[{" + JsonValueType.toStringValue("address") + ":" + JsonValueType.toStringValue("In a galaxy far far away") + "}," + JsonValueType.toStringValue("First value") + "]");
        JsonValue checkEnd = JsonIO.read("[" + JsonValueType.toStringValue("First value") + ",{" + JsonValueType.toStringValue("address") + ":" + JsonValueType.toStringValue("In a galaxy far far away") + "}]");
        JsonArrayBuilder inBeg = this.createArrayBuilder("First value");
        JsonArrayBuilder inEnd = this.createArrayBuilder("First value");
        JsonObjectBuilder argBeg = Json.createObjectBuilder().add("address", "In a galaxy far far away");
        JsonObjectBuilder argEnd = Json.createObjectBuilder().add("address", "In a galaxy far far away");
        this.verifyAddBuilder(result, checkBeg, 0, argBeg, inBeg);
        this.verifyAddBuilder(result, checkEnd, 1, argEnd, inEnd);
    }

    private void testAddObjectBuilderNull(TestResult result) {
        TestUtil.logMsg((String)" - add(int,(JsonObjectBuilder)null)");
        JsonArrayBuilder in = this.createArrayBuilder("John Smith");
        JsonObjectBuilder arg = null;
        try {
            in.add(0, arg);
            result.fail("add(int,(JsonObjectBuilder)null)", "Calling method with null argument shall throw NullPointerException");
        }
        catch (NullPointerException e) {
            TestUtil.logMsg((String)("    - Expected exception: " + e.getMessage()));
        }
        catch (Throwable t) {
            result.fail("add(int,(JsonObjectBuilder)null)", "Calling method with null argument shall throw NullPointerException, not " + t.getClass().getSimpleName());
        }
    }

    private void testAddObjectBuilderOutOfBounds(TestResult result) {
        TestUtil.logMsg((String)" - add(int,JsonObjectBuilder)");
        int[] indexes = new int[]{-1, 5, 6};
        JsonArrayBuilder in = this.createArrayBuilder("First value").add("Second value").add("Third value").add("Fourth value");
        JsonObjectBuilder arg = Json.createObjectBuilder().add("address", "In a galaxy far far away");
        for (int index : indexes) {
            try {
                in.add(index, arg);
                result.fail("add(int,JsonObjectBuilder)", "Calling method with out of bounds index=" + index + " argument shall throw IndexOutOfBoundsException");
            }
            catch (IndexOutOfBoundsException e) {
                TestUtil.logMsg((String)("    - Expected exception for index=" + index + ": " + e.getMessage()));
            }
            catch (Throwable t) {
                result.fail("add(int,JsonObjectBuilder)", "Calling method with with out of bounds index=" + index + " argument shall throw IndexOutOfBoundsException, not " + t.getClass().getSimpleName());
            }
        }
    }

    private void testAddAllString(TestResult result) {
        TestUtil.logMsg((String)" - addAll(JsonArrayBuilder) for String array");
        JsonArray check = SimpleValues.createSimpleStringArray5();
        Object[] strings = new String[]{"First value", "Second value", "Third value", "Fourth value", "Fifth value"};
        this.verifyAddAll(result, check, strings);
    }

    private void testAddAllInt(TestResult result) {
        TestUtil.logMsg((String)" - addAll(JsonArrayBuilder) for int array");
        JsonArray check = SimpleValues.createSimpleIntArray5();
        Object[] ints = new Integer[]{1, 2, 3, 4, 5};
        this.verifyAddAll(result, check, ints);
    }

    private void testAddAllBool(TestResult result) {
        TestUtil.logMsg((String)" - addAll(JsonArrayBuilder) for boolean array");
        JsonArray check = SimpleValues.createSimpleBoolArray5();
        Object[] bools = new Boolean[]{false, true, true, false, true};
        this.verifyAddAll(result, check, bools);
    }

    private void testAddAllObject(TestResult result) {
        TestUtil.logMsg((String)" - addAll(JsonArrayBuilder) for JsonObject array");
        JsonArray check = SimpleValues.createSimpleObjectArray5();
        Object[] bools = new JsonObject[]{SimpleValues.OBJ_VALUE_1, SimpleValues.OBJ_VALUE_2, SimpleValues.OBJ_VALUE_3, SimpleValues.OBJ_VALUE_4, SimpleValues.OBJ_VALUE_5};
        this.verifyAddAll(result, check, bools);
    }

    private void testAddAllNull(TestResult result) {
        TestUtil.logMsg((String)" - addAll(JsonArrayBuilder) for null builder argument");
        JsonArrayBuilder builder = Json.createArrayBuilder();
        try {
            builder.addAll((JsonArrayBuilder)null);
            result.fail("addAll(null)", "Calling method with null argument shall throw NullPointerException");
        }
        catch (NullPointerException e) {
            TestUtil.logMsg((String)("    - Expected exception: " + e.getMessage()));
        }
        catch (Throwable t) {
            result.fail("addAll(null)", "Calling method with null argument shall throw NullPointerException, not " + t.getClass().getSimpleName());
        }
    }

    private void verifyAddAll(TestResult result, JsonArray check, Object[] values) {
        JsonArrayBuilder builderIn = Json.createArrayBuilder();
        for (Object value : values) {
            builderIn = this.updateOperationBuilder(builderIn, value);
        }
        JsonArrayBuilder builderOut = Json.createArrayBuilder();
        builderOut.addAll(builderIn);
        JsonArray out = builderOut.build();
        if (this.operationFailed((JsonValue)check, (JsonValue)out)) {
            result.fail("addAll(JsonArrayBuilder)", "Output builder " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString((JsonValue)check));
        }
    }

    private void verifyAddBuilder(TestResult result, JsonValue check, int index, JsonArrayBuilder src, JsonArrayBuilder target) {
        JsonArray out = target.add(index, src).build();
        if (this.operationFailed(check, (JsonValue)out)) {
            result.fail("add(int,JsonArrayBuilder)", "Output builder " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString(check));
        }
    }

    private void verifyAddBuilder(TestResult result, JsonValue check, int index, JsonObjectBuilder src, JsonArrayBuilder target) {
        JsonArray out = target.add(index, src).build();
        if (this.operationFailed(check, (JsonValue)out)) {
            result.fail("add(int,JsonObjectBuilder)", "Output builder " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString(check));
        }
    }

    @Override
    protected JsonArrayBuilder createArrayBuilder(Object value) {
        return ArrayBuilder.add(Json.createArrayBuilder(), value);
    }

    @Override
    protected JsonArrayBuilder createArrayBuilder(int index, Object value) {
        return ArrayBuilder.add(Json.createArrayBuilder(), index, value);
    }

    @Override
    protected JsonArrayBuilder updateOperationBuilder(JsonArrayBuilder builder, Object value) {
        return ArrayBuilder.add(builder, value);
    }

    @Override
    protected JsonArrayBuilder updateOperationBuilder(JsonArrayBuilder builder, int index, Object value) {
        return ArrayBuilder.add(builder, index, value);
    }
}

