/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry_infomodel.ExternalIdentifier;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import java.util.Locale;
import java.util.Properties;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Organization;

public class JAXRClient
extends JAXRCommonClient {
    Locale tsLocale = new Locale("en", "US");

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            super.cleanUpRegistry();
            this.debug.clear();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            super.cleanup();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void externalIdentifier_getRegistryObjectTest() throws EETest.Fault {
        String testName = "externalIdentifier_getRegistryObjectTest";
        String cName = "Social Security";
        String cDescription = "Social Security Numbers";
        String name = "Social Security Number";
        String value = "026-10-5738";
        String orgName = "TS Default Organization";
        try {
            this.debug.add("Create a parent organization \n");
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgName));
            this.debug.add("Create an ExternalIdentifier \n");
            ClassificationScheme scheme = this.blm.createClassificationScheme(cName, cDescription);
            InternationalString iName = this.blm.createInternationalString(this.tsLocale, name);
            ExternalIdentifier ei = this.blm.createExternalIdentifier(scheme, iName, value);
            this.debug.add("add the ExternalIdentifier to the org parent \n");
            org.addExternalIdentifier(ei);
            this.debug.add("Get the parent RegistryObject  from the ExternalIdentifier \n");
            Organization ro = (Organization)ei.getRegistryObject();
            if (ro == null) {
                throw new EETest.Fault(testName + " failed - getRegistryObject returned null!");
            }
            this.debug.add("Verify the RegistryObject returned by checking the orgName= " + orgName + "\n");
            if (!ro.getName().getValue(this.tsLocale).equals(orgName)) {
                throw new EETest.Fault(testName + " failed - unexpected name returned for RegistryObject");
            }
            this.debug.add("Got the parent Organization: " + ro.getName().getValue(this.tsLocale) + "\n");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void externalIdentifier_getValueTest() throws EETest.Fault {
        String testName = "externalIdentifier_getValueTest";
        String cName = "Social Security";
        String cDescription = "Social Security Numbers";
        String name = "Social Security Number";
        String value = "026-10-5738";
        try {
            this.debug.add("Create an ExternalIdentifier \n");
            ClassificationScheme scheme = this.blm.createClassificationScheme(cName, cDescription);
            InternationalString iName = this.blm.createInternationalString(name);
            ExternalIdentifier ei = this.blm.createExternalIdentifier(scheme, iName, value);
            this.debug.add("Verify that getValue returns  : " + value + "\n");
            if (!ei.getValue().equals(value)) {
                throw new EETest.Fault(testName + " failed - did not get back expected String from getValuE");
            }
            this.debug.add("String returned from ExternalIdentifier.getValue matched value \n");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void externalIdentifier_setValueTest() throws EETest.Fault {
        String testName = "externalIdentifier_setValueTest";
        String cName = "Social Security";
        String cDescription = "Social Security Numbers";
        String name = "Social Security Number";
        String value = "026-10-5738";
        String newValue = "032-11-1201";
        try {
            this.debug.add("Create an ExternalIdentifier \n");
            ClassificationScheme scheme = this.blm.createClassificationScheme(cName, cDescription);
            InternationalString iName = this.blm.createInternationalString(name);
            ExternalIdentifier ei = this.blm.createExternalIdentifier(scheme, iName, value);
            this.debug.add("Set value with ExternalIdentifier.setValue to: " + newValue + "\n");
            ei.setValue(newValue);
            this.debug.add("Verify getValue returns : " + newValue + "\n");
            if (!ei.getValue().equals(newValue)) {
                throw new EETest.Fault(testName + " failed - did not get back expected String from getValue");
            }
            this.debug.add("String returned from ExternalIdentifier.getValue matched value \n");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void externalIdentifier_getIdentificationScheme() throws EETest.Fault {
        String testName = "externalIdentifier_getIdentificationScheme";
        String cName = "Social Security";
        String cDescription = "Social Security Numbers";
        String name = "Social Security Number";
        String value = "026-10-5738";
        try {
            this.debug.add("Create an ExternalIdentifier \n");
            ClassificationScheme scheme = this.blm.createClassificationScheme(cName, cDescription);
            ExternalIdentifier ei = this.blm.createExternalIdentifier(scheme, name, value);
            this.debug.add("Verify that ExternalIdentifier.getIdentificationScheme() returns scheme from create method\n");
            ClassificationScheme retScheme = ei.getIdentificationScheme();
            if (!retScheme.getDescription().getValue().equals(cDescription)) {
                throw new EETest.Fault(testName + " failed - expected description not returned from scheme");
            }
            this.debug.add("Found expected description from scheme: " + retScheme.getDescription().getValue() + "\n");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void externalIdentifier_setIdentificationScheme() throws EETest.Fault {
        String testName = "externalIdentifier_setIdentificationScheme";
        String cName = "Social Security";
        String cDescription = "Social Security Numbers";
        String name = "Social Security Number";
        String value = "026-10-5738";
        try {
            this.debug.add("Create an ExternalIdentifier \n");
            ClassificationScheme scheme = this.blm.createClassificationScheme(cName, cDescription);
            ExternalIdentifier ei = (ExternalIdentifier)this.blm.createObject("ExternalIdentifier");
            ei.setIdentificationScheme(scheme);
            this.debug.add("call ei.setIdentificationScheme(scheme) with this scheme description: " + cDescription + "\n");
            ClassificationScheme retScheme = ei.getIdentificationScheme();
            this.debug.add("Verify scheme returned from  ei.getIdentificationScheme by checking the scheme description \n");
            if (!retScheme.getDescription().getValue().equals(cDescription)) {
                throw new EETest.Fault(testName + " failed - expected description not returned from scheme");
            }
            this.debug.add("Found expected description from scheme: " + retScheme.getDescription().getValue() + "\n");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }
}

