/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.utils;

import com.ibm.jbatch.tck.spi.JobExecutionTimeoutException;
import com.ibm.jbatch.tck.spi.JobExecutionWaiter;
import com.ibm.jbatch.tck.spi.JobExecutionWaiterFactory;
import com.ibm.jbatch.tck.utils.ServiceGateway;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import com.sun.ts.lib.util.TestUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionIsRunningException;
import javax.batch.operations.JobExecutionNotMostRecentException;
import javax.batch.operations.JobExecutionNotRunningException;
import javax.batch.operations.JobOperator;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.JobStartException;
import javax.batch.operations.NoSuchJobException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.operations.NoSuchJobInstanceException;
import javax.batch.runtime.BatchRuntime;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.StepExecution;

public class JobOperatorBridge {
    public static final String DEFAULT_JOB_OPERATOR_SLEEP_TIME = "60000";
    private static final Logger logger = Logger.getLogger(JobOperatorBridge.class.getName());
    private JobOperator jobOp = BatchRuntime.getJobOperator();
    private JobExecutionWaiterFactory waiterFactory = ServiceGateway.getJobExecutionWaiterFactoryService();
    private int sleepTime = Integer.parseInt(System.getProperty("tck.execution.waiter.timeout", "60000"));
    private final String TIMEOUT_MSG = "Test failure due to timeout exception.  Either the timeout should be increased and there is nothing else wrong, or perhaps the runtime implementation is handing and/or unresponsive<p>";

    public List<String> getJobNames() throws JobSecurityException {
        return new ArrayList<String>(this.jobOp.getJobNames());
    }

    public int getJobInstanceCount(String jobName) throws NoSuchJobException, JobSecurityException {
        return this.jobOp.getJobInstanceCount(jobName);
    }

    public List<Long> getRunningExecutions(String jobName) throws NoSuchJobException, JobSecurityException {
        return this.jobOp.getRunningExecutions(jobName);
    }

    public List<JobExecution> getJobExecutions(JobInstance instance) throws NoSuchJobInstanceException, JobSecurityException {
        return this.jobOp.getJobExecutions(instance);
    }

    public TCKJobExecutionWrapper restartJobAndWaitForResult(long oldExecutionId, Properties restartJobParameters) throws NoSuchJobExecutionException, NoSuchJobException, JobRestartException, JobExecutionAlreadyCompleteException, JobExecutionNotMostRecentException, JobSecurityException, JobExecutionTimeoutException {
        JobExecution terminatedJobExecution = null;
        long newExecutionId = this.jobOp.restart(oldExecutionId, restartJobParameters);
        JobExecutionWaiter waiter = this.waiterFactory.createWaiter(newExecutionId, this.jobOp, this.sleepTime);
        try {
            terminatedJobExecution = waiter.awaitTermination();
        }
        catch (JobExecutionTimeoutException e) {
            logger.severe("Test failure due to timeout exception.  Either the timeout should be increased and there is nothing else wrong, or perhaps the runtime implementation is handing and/or unresponsive<p>");
            TestUtil.logMsg((String)"Test failure due to timeout exception.  Either the timeout should be increased and there is nothing else wrong, or perhaps the runtime implementation is handing and/or unresponsive<p>");
            throw e;
        }
        return new TCKJobExecutionWrapper(terminatedJobExecution, this.jobOp);
    }

    public TCKJobExecutionWrapper restartJobWithoutWaitingForResult(long oldExecutionId, Properties jobParameters) throws NoSuchJobExecutionException, NoSuchJobException, JobRestartException, JobExecutionAlreadyCompleteException, JobExecutionNotMostRecentException, JobSecurityException, JobExecutionTimeoutException {
        Long execID = this.jobOp.restart(oldExecutionId, jobParameters);
        JobExecution jobExecution = this.jobOp.getJobExecution(execID.longValue());
        return new TCKJobExecutionWrapper(jobExecution, this.jobOp);
    }

    public void abandonJobExecution(long executionId) throws NoSuchJobInstanceException, JobExecutionIsRunningException, JobSecurityException, NoSuchJobExecutionException {
        this.jobOp.abandon(executionId);
    }

    public TCKJobExecutionWrapper startJobAndWaitForResult(String jobName) throws JobStartException, NoSuchJobExecutionException, JobSecurityException, JobExecutionTimeoutException {
        return this.startJobAndWaitForResult(jobName, null);
    }

    public TCKJobExecutionWrapper startJobWithoutWaitingForResult(String jobName, Properties jobParameters) throws JobStartException, NoSuchJobExecutionException, JobSecurityException {
        Long execID = this.jobOp.start(jobName, jobParameters);
        JobExecution jobExecution = this.jobOp.getJobExecution(execID.longValue());
        return new TCKJobExecutionWrapper(jobExecution, this.jobOp);
    }

    public void stopJobWithoutWaitingForResult(long jobInstanceId) throws NoSuchJobExecutionException, JobExecutionNotRunningException, JobSecurityException {
        this.jobOp.stop(jobInstanceId);
    }

    public JobExecution stopJobAndWaitForResult(JobExecution jobExecution) throws NoSuchJobExecutionException, JobExecutionNotRunningException, JobSecurityException, JobExecutionTimeoutException {
        JobExecution terminatedJobExecution = null;
        this.jobOp.stop(jobExecution.getExecutionId());
        JobExecutionWaiter waiter = this.waiterFactory.createWaiter(jobExecution.getExecutionId(), this.jobOp, this.sleepTime);
        try {
            terminatedJobExecution = waiter.awaitTermination();
        }
        catch (JobExecutionTimeoutException e) {
            logger.severe("Test failure due to timeout exception.  Either the timeout should be increased and there is nothing else wrong, or perhaps the runtime implementation is handing and/or unresponsive<p>");
            TestUtil.logMsg((String)"Test failure due to timeout exception.  Either the timeout should be increased and there is nothing else wrong, or perhaps the runtime implementation is handing and/or unresponsive<p>");
            throw e;
        }
        return new TCKJobExecutionWrapper(terminatedJobExecution, this.jobOp);
    }

    public TCKJobExecutionWrapper startJobAndWaitForResult(String jobName, Properties jobParameters) throws JobStartException, NoSuchJobExecutionException, JobSecurityException, JobExecutionTimeoutException {
        JobExecution terminatedJobExecution = null;
        long executionId = this.jobOp.start(jobName, jobParameters);
        JobExecutionWaiter waiter = this.waiterFactory.createWaiter(executionId, this.jobOp, this.sleepTime);
        try {
            terminatedJobExecution = waiter.awaitTermination();
        }
        catch (JobExecutionTimeoutException e) {
            logger.severe("Test failure due to timeout exception.  Either the timeout should be increased and there is nothing else wrong, or perhaps the runtime implementation is handing and/or unresponsive<p>");
            TestUtil.logMsg((String)"Test failure due to timeout exception.  Either the timeout should be increased and there is nothing else wrong, or perhaps the runtime implementation is handing and/or unresponsive<p>");
            throw e;
        }
        return new TCKJobExecutionWrapper(terminatedJobExecution, this.jobOp);
    }

    public Properties getParameters(long executionId) throws NoSuchJobInstanceException, JobSecurityException, NoSuchJobExecutionException {
        return this.jobOp.getParameters(executionId);
    }

    public JobInstance getJobInstance(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        return this.jobOp.getJobInstance(executionId);
    }

    public JobExecution getJobExecution(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        return this.jobOp.getJobExecution(executionId);
    }

    public List<JobInstance> getJobInstances(String jobName, int start, int end) throws NoSuchJobException, JobSecurityException {
        return this.jobOp.getJobInstances(jobName, start, end);
    }

    public List<StepExecution> getStepExecutions(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        return this.jobOp.getStepExecutions(executionId);
    }

    public void startJobWithoutWaitingForResult(String jobName) throws JobStartException, NoSuchJobExecutionException, JobSecurityException {
        this.startJobWithoutWaitingForResult(jobName, null);
    }
}

