/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.ee.propagation.cm.jta;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.ee.common.Account;
import com.sun.ts.tests.jpa.ee.propagation.cm.jta.Teller;
import java.util.List;
import javax.annotation.Resource;
import javax.ejb.EJBException;
import javax.ejb.Local;
import javax.ejb.SessionContext;
import javax.ejb.Stateful;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;

@Stateful(name="TellerBean2")
@Local(value={Teller.class})
public class TellerBean2
implements Teller {
    public SessionContext sessionContext;
    private static final int[] ACCOUNTS = new int[]{5555};
    private static final double[] BALANCES = new double[]{5678.9};
    private Account accountRef;
    @PersistenceContext(unitName="CTS-JTA-UNIT2", type=PersistenceContextType.TRANSACTION)
    private EntityManager entityManager;

    @Resource
    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    @Override
    public double balance(int acct) {
        double balance;
        TestUtil.logTrace((String)"balance");
        Account thisAccount = (Account)this.entityManager.find(Account.class, (Object)acct);
        try {
            balance = thisAccount.balance();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Exception occurred in balance: " + e);
        }
        return balance;
    }

    @Override
    public double deposit(int acct, double amt) {
        double balance;
        TestUtil.logTrace((String)"deposit");
        Account thisAccount = (Account)this.entityManager.find(Account.class, (Object)acct);
        try {
            balance = thisAccount.deposit(amt);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Exception occurred in deposit: " + e);
        }
        return balance;
    }

    @Override
    public double withdraw(int acct, double amt) {
        double balance;
        TestUtil.logTrace((String)"withdraw");
        Account thisAccount = (Account)this.entityManager.find(Account.class, (Object)acct);
        try {
            balance = thisAccount.withdraw(amt);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Exception occurred in withdraw: " + e);
        }
        return balance;
    }

    @Override
    public boolean checkAccountStatus(Account acct) {
        TestUtil.logTrace((String)"checkAccountStatus");
        Account thisAccount = (Account)this.entityManager.find(Account.class, (Object)acct.id());
        return acct.equals((Object)thisAccount);
    }

    @Override
    public String getAllAccounts() {
        StringBuffer accounts = new StringBuffer();
        List result = null;
        try {
            result = this.entityManager.createQuery("select a from Account a").getResultList();
            for (Account a1 : result) {
                accounts.append("" + a1.id() + "  " + a1.balance() + "\n");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Exception occurred in getAllAccounts: " + e);
        }
        return accounts.toString();
    }

    @Override
    public void createTestData() {
        try {
            TestUtil.logTrace((String)"createAccountData");
            TestUtil.logTrace((String)("Create " + ACCOUNTS.length + " Account Entities"));
            System.out.println("Create " + ACCOUNTS.length + " Account Entities");
            for (int i = 0; i < ACCOUNTS.length; ++i) {
                TestUtil.logTrace((String)("Creating account=" + ACCOUNTS[i] + ", balance=" + BALANCES[i]));
                System.out.println("Creating account=" + ACCOUNTS[i] + ", balance=" + BALANCES[i]);
                this.accountRef = new Account(Integer.valueOf(ACCOUNTS[i]), BALANCES[i]);
                this.entityManager.persist((Object)this.accountRef);
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Unexpected while creating test data:" + e));
        }
    }

    @Override
    public void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        try {
            this.entityManager.createNativeQuery("DELETE FROM ACCOUNT").executeUpdate();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        TestUtil.logTrace((String)"Clearing cache");
        this.entityManager.getEntityManagerFactory().getCache().evictAll();
    }
}

