/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry_infomodel.ServiceBinding;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Properties;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.SpecificationLink;

public class JAXRClient
extends JAXRCommonClient {
    Locale tsLocale = new Locale("en", "US");

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            this.debug.clear();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            this.logMsg("in cleanup");
            if (this.conn != null) {
                this.logTrace("Cleanup is closing the connection");
                this.conn.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void serviceBinding_addGetSpecificationLinkTest() throws EETest.Fault {
        String testName = "serviceBinding_addGetSpecificationLinkTest";
        boolean pass = true;
        SpecificationLink lnk2 = null;
        String usageDescription = "To test addSpecificationLink";
        try {
            ServiceBinding sb = this.blm.createServiceBinding();
            SpecificationLink sl = this.blm.createSpecificationLink();
            InternationalString iusageDescription = this.blm.createInternationalString(usageDescription);
            sl.setUsageDescription(iusageDescription);
            sb.addSpecificationLink(sl);
            Collection c = sb.getSpecificationLinks();
            for (SpecificationLink lnk2 : c) {
                if (lnk2.getUsageDescription().getValue().equals(usageDescription)) continue;
                throw new EETest.Fault(testName + "Error: getSpecificationLinks - can't find added SpecificationLink");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void serviceBinding_addGetSpecificationLinksTest() throws EETest.Fault {
        String testName = "serviceBinding_addGetSpecificationLinksTest";
        int count = 3;
        SpecificationLink lnk = null;
        boolean pass = true;
        try {
            ServiceBinding sb = this.blm.createServiceBinding();
            ArrayList<SpecificationLink> lnks = new ArrayList<SpecificationLink>();
            for (int i = 0; i < count; ++i) {
                lnk = this.blm.createSpecificationLink();
                lnks.add(lnk);
            }
            sb.addSpecificationLinks(lnks);
            Collection c = sb.getSpecificationLinks();
            if (c.size() != count) {
                throw new EETest.Fault(testName + "Error: should have 3 SpecificationLinks");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void serviceBinding_setGetAccessURI() throws EETest.Fault {
        String testName = "serviceBinding_setGetAccessURI";
        String url = this.baseuri + "jaxrTestPage1.html";
        boolean pass = true;
        try {
            ServiceBinding sb = this.blm.createServiceBinding();
            sb.setAccessURI(url);
            if (!sb.getAccessURI().equals(url)) {
                throw new EETest.Fault(testName + "Error: did not get expected URI back");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void serviceBinding_getAccessURINullTest() throws EETest.Fault {
        String testName = "serviceBinding_getAccessURINullTest";
        boolean pass = true;
        try {
            ServiceBinding sb = this.blm.createServiceBinding();
            if (sb.getAccessURI() != null) {
                throw new EETest.Fault(testName + "Error: AccessURI expected to be null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void serviceBinding_setAccessURIInvalidTest() throws EETest.Fault {
        String testName = "serviceBinding_setAccessURIInvalidTest";
        String url = this.baseuri + "jaxrTestPage1.html";
        boolean pass = false;
        try {
            ServiceBinding sb = this.blm.createServiceBinding();
            ServiceBinding target = this.blm.createServiceBinding();
            sb.setTargetBinding(target);
            sb.setAccessURI(url);
            throw new EETest.Fault(testName + "Error: InvalidRequestException was not thrown");
        }
        catch (InvalidRequestException ir) {
            TestUtil.printStackTrace((Throwable)ir);
            pass = true;
            this.debug.add("InvalidRequestException was thrown as expected\n");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void serviceBinding_getService() throws EETest.Fault {
        String testName = "serviceBinding_getService";
        String serviceName = "test service for serviceBinding_getService";
        boolean pass = true;
        try {
            ServiceBinding sb = this.blm.createServiceBinding();
            Service service = this.blm.createService(this.blm.createInternationalString(this.tsLocale, serviceName));
            service.addServiceBinding(sb);
            Service testService = sb.getService();
            if (testService == null) {
                throw new EETest.Fault(testName + "Error: serviceBinding returned a null service");
            }
            if (!testService.getName().getValue(this.tsLocale).equals(serviceName)) {
                throw new EETest.Fault(testName + "Error: did not get expected Service");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void serviceBinding_setGetTargetBinding() throws EETest.Fault {
        String testName = "serviceBinding_setGetTargetBinding";
        String uri = "target binding uri";
        boolean pass = true;
        try {
            ServiceBinding sb = this.blm.createServiceBinding();
            ServiceBinding target = this.blm.createServiceBinding();
            target.setValidateURI(false);
            target.setAccessURI(uri);
            sb.setTargetBinding(target);
            ServiceBinding retTarget = sb.getTargetBinding();
            if (!retTarget.getAccessURI().equals(uri)) {
                throw new EETest.Fault(testName + "Error: did not get expected target");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void serviceBinding_setTargetBindingInvalidTest() throws EETest.Fault {
        String testName = "serviceBinding_setTargetBindingInvalidTest";
        String url = this.baseuri + "jaxrTestPage1.html";
        boolean pass = false;
        try {
            ServiceBinding sb = this.blm.createServiceBinding();
            sb.setAccessURI(url);
            ServiceBinding target = this.blm.createServiceBinding();
            sb.setTargetBinding(target);
            throw new EETest.Fault(testName + "Error: InvalidRequestException was not thrown");
        }
        catch (InvalidRequestException ir) {
            TestUtil.printStackTrace((Throwable)ir);
            pass = true;
            this.debug.add("InvalidRequestException was thrown as expected\n");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void serviceBinding_removeSpecificationLink() throws EETest.Fault {
        String testName = "serviceBinding_removeSpecificationLink";
        boolean pass = true;
        SpecificationLink lnk2 = null;
        String usageDescription = "To test serviceBinding_removeSpecificationLink";
        try {
            ServiceBinding sb = this.blm.createServiceBinding();
            SpecificationLink sl = this.blm.createSpecificationLink();
            InternationalString iusageDescription = this.blm.createInternationalString(usageDescription);
            sl.setUsageDescription(iusageDescription);
            sb.addSpecificationLink(sl);
            Collection c = sb.getSpecificationLinks();
            for (SpecificationLink lnk2 : c) {
                if (lnk2.getUsageDescription().getValue().equals(usageDescription)) continue;
                throw new EETest.Fault(testName + "Error: test did not complete.  Cannot find SpecificationLink");
            }
            sb.removeSpecificationLink(sl);
            c = sb.getSpecificationLinks();
            if (c.size() != 0) {
                throw new EETest.Fault(testName + "Error: SpecificationLink was not removed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void serviceBinding_removeSpecificationLinksTest() throws EETest.Fault {
        String testName = "serviceBinding_removeSpecificationLinksTest";
        boolean pass = true;
        SpecificationLink lnk = null;
        int count = 5;
        String usageDescription = "To test serviceBinding_removeSpecificationLink";
        try {
            ServiceBinding sb = this.blm.createServiceBinding();
            ArrayList<SpecificationLink> lnks = new ArrayList<SpecificationLink>();
            for (int i = 0; i < count; ++i) {
                lnk = this.blm.createSpecificationLink();
                lnks.add(lnk);
            }
            sb.addSpecificationLinks(lnks);
            Collection c = sb.getSpecificationLinks();
            if (c.size() != count) {
                throw new EETest.Fault(testName + "Error: test did not complete - incorrect count of SpecificationLinks");
            }
            sb.removeSpecificationLinks(lnks);
            c = sb.getSpecificationLinks();
            if (c.size() != 0) {
                throw new EETest.Fault(testName + "Error: SpecificationLinks were not removed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }
}

