/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.entityTransaction;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import java.util.Properties;
import javax.persistence.EntityTransaction;

public class Client
extends PMClientBase {
    Properties props = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        this.props = p;
        try {
            super.setup(args, p);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"done cleanup, calling super.cleanup");
        super.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginIllegalStateExceptionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            EntityTransaction t = this.getEntityTransaction();
            t.begin();
            if (t.isActive()) {
                try {
                    t.begin();
                    TestUtil.logErr((String)"IllegalStateException was not thrown");
                }
                catch (IllegalStateException ise) {
                    TestUtil.logTrace((String)"IllegalStateException Caught as Expected.");
                    pass = true;
                }
            } else {
                TestUtil.logErr((String)"isActive() returned false when a transaction was active");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("beginIllegalStateExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitIllegalStateExceptionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            EntityTransaction t = this.getEntityTransaction();
            if (!t.isActive()) {
                try {
                    t.commit();
                    TestUtil.logErr((String)"IllegalStateException was not thrown");
                }
                catch (IllegalStateException ise) {
                    TestUtil.logTrace((String)"IllegalStateException Caught as Expected.");
                    pass = true;
                }
            } else {
                TestUtil.logErr((String)"isActive() returened true when no transaction  was active");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("commitIllegalStateExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRollbackOnlyIllegalStateExceptionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            EntityTransaction t = this.getEntityTransaction();
            if (!t.isActive()) {
                try {
                    t.getRollbackOnly();
                    TestUtil.logErr((String)"IllegalStateException was not thrown");
                }
                catch (IllegalStateException ise) {
                    TestUtil.logTrace((String)"IllegalStateException Caught as Expected.");
                    pass = true;
                }
            } else {
                TestUtil.logErr((String)"isActive() returned true when no transaction  was active");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("getRollbackOnlyIllegalStateExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackIllegalStateExceptionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            EntityTransaction t = this.getEntityTransaction();
            if (!t.isActive()) {
                try {
                    t.rollback();
                    TestUtil.logErr((String)"IllegalStateException was not thrown");
                }
                catch (IllegalStateException ise) {
                    TestUtil.logTrace((String)"IllegalStateException Caught as Expected.");
                    pass = true;
                }
            } else {
                TestUtil.logErr((String)"isActive() returned true when no transaction  was active");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("rollbackIllegalStateExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRollbackOnlyIllegalStateExceptionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            EntityTransaction t = this.getEntityTransaction();
            if (!t.isActive()) {
                try {
                    t.setRollbackOnly();
                    TestUtil.logErr((String)"IllegalStateException was not thrown");
                }
                catch (IllegalStateException ise) {
                    TestUtil.logTrace((String)"IllegalStateException Caught as Expected.");
                    pass = true;
                }
            } else {
                TestUtil.logErr((String)"isActive() returned true when no transaction  was active");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("setRollbackOnlyIllegalStateExceptionTest failed");
        }
    }
}

