/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.utils;

import com.ibm.jbatch.tck.utils.BeanDefinition;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Named;

public class BatchXMLGenerator {
    private static final Logger logger = Logger.getLogger(BatchXMLGenerator.class.getName());
    private static final String SLASH = System.getProperty("file.separator");
    List<BeanDefinition> beanDefinitions = new ArrayList<BeanDefinition>();
    private static final String BATCHXML = "META-INF/batch.xml";

    private void writeBatchXML(File dir) {
        try {
            File batchXMLFile = new File(dir, "batch.xml");
            logger.info("Writing batch.xml: " + batchXMLFile);
            BufferedWriter writer = new BufferedWriter(new FileWriter(batchXMLFile));
            writer.write("<batch-artifacts xmlns=\"http://xmlns.jcp.org/xml/ns/javaee\">\n");
            for (BeanDefinition beanDef : this.beanDefinitions) {
                writer.write("    " + beanDef.getXMLString() + "\n");
            }
            writer.write("</batch-artifacts>\n");
            writer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private String generateId(String qualifiedClassName) {
        String retVal = null;
        int index = qualifiedClassName.lastIndexOf(".");
        String simpleName = qualifiedClassName.substring(index + 1);
        String simpleNameFirst = simpleName.substring(0, 1).toLowerCase();
        String simpleNameRest = simpleName.substring(1);
        retVal = simpleNameFirst + simpleNameRest;
        return retVal;
    }

    private void processClass(String qualifiedClassName) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Processing class: " + qualifiedClassName);
        }
        String namedAnnotationValue = null;
        Class<?> artifactClass = null;
        try {
            artifactClass = Class.forName(qualifiedClassName);
            Named namedAnnotation = artifactClass.getAnnotation(Named.class);
            if (namedAnnotation != null) {
                namedAnnotationValue = namedAnnotation.value();
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        String beanID = null;
        beanID = namedAnnotationValue != null && !namedAnnotationValue.trim().isEmpty() ? namedAnnotationValue : this.generateId(qualifiedClassName);
        BeanDefinition beanXML = new BeanDefinition(beanID, qualifiedClassName);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Adding bean to batch.xml: beanId=" + beanID + " className=" + qualifiedClassName);
        }
        this.beanDefinitions.add(beanXML);
    }

    private static List<String> findClasses(String dir) {
        File directory = new File(dir);
        if (!directory.exists()) {
            throw new IllegalArgumentException("This directory does not exist: " + directory.toString());
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("This is not a directory: " + directory.toString());
        }
        ArrayList<String> classList = new ArrayList<String>();
        BatchXMLGenerator.findClasses(directory, "", classList);
        return classList;
    }

    private static void findClasses(File directory, String path, List<String> classList) {
        File[] files;
        for (File file : files = directory.listFiles()) {
            String filename;
            if (file.isDirectory()) {
                BatchXMLGenerator.findClasses(file, path + file.getName() + SLASH, classList);
            }
            if (!(filename = file.getName()).endsWith(".class")) continue;
            String classname = filename.substring(0, filename.lastIndexOf("."));
            classList.add(path.replace(SLASH, ".") + classname);
        }
    }

    public static void main(String[] args) {
        logger.info("Starting BatchXMLGenerator");
        BatchXMLGenerator bxg = new BatchXMLGenerator();
        List<String> classList = BatchXMLGenerator.findClasses(args[0]);
        for (String className : classList) {
            bxg.processClass(className);
        }
        File batchXMLDir = new File(args[1]);
        if (!batchXMLDir.exists()) {
            throw new IllegalArgumentException("This directory does not exist: " + args[1]);
        }
        if (!batchXMLDir.isDirectory()) {
            throw new IllegalArgumentException("This is not a directory: " + args[1]);
        }
        bxg.writeBatchXML(batchXMLDir);
        logger.info("BatchXMLGenerator completed successfully.");
    }
}

