/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import java.util.logging.Logger;
import javax.batch.api.BatchProperty;
import javax.batch.api.listener.JobListener;
import javax.batch.api.listener.StepListener;
import javax.batch.runtime.context.JobContext;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="myUniversalListener")
public class MyUniversalListener
implements JobListener,
StepListener {
    private static final Logger logger = Logger.getLogger(MyUniversalListener.class.getName());
    @Inject
    private JobContext jobCtx = null;
    @Inject
    @BatchProperty(name="app.timeinterval")
    String timeintervalString;
    int timeinterval = 0;

    public void beforeJob() {
        String cur = this.jobCtx.getExitStatus();
        String status = cur == null ? "BeforeJob" : cur + "BeforeJob";
        this.jobCtx.setExitStatus(status);
    }

    public void afterJob() {
        String cur = this.jobCtx.getExitStatus();
        this.jobCtx.setExitStatus(cur + "AfterJob");
    }

    public void beforeStep() {
        this.timeinterval = Integer.parseInt(this.timeintervalString);
        String cur = this.jobCtx.getExitStatus();
        this.jobCtx.setExitStatus(cur + "BeforeStep");
    }

    public void afterStep() {
        logger.fine("AJM: gonna sleep for " + this.timeinterval);
        try {
            Thread.sleep(this.timeinterval);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String cur = this.jobCtx.getExitStatus();
        this.jobCtx.setExitStatus(cur + "AfterStep");
    }
}

