/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.entitytest.remove.oneXmany;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.entitytest.remove.oneXmany.A;
import com.sun.ts.tests.jpa.core.entitytest.remove.oneXmany.B;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove1XMTest1() throws EETest.Fault {
        boolean pass = false;
        TestUtil.logTrace((String)"Begin remove1XMTest1");
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("11", "b1", 1);
            B b2 = new B("12", "b2", 2);
            B b3 = new B("13", "b3", 3);
            B b4 = new B("14", "b4", 4);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("1", "a1", 1, v1);
            boolean status = this.getInstanceStatus(aRef);
            if (!status) {
                TestUtil.logTrace((String)"Instance state is not managed as expected.Try invoking remove on it.");
                this.getEntityManager().remove((Object)aRef);
                pass = true;
            } else {
                TestUtil.logErr((String)"Instance state is managed.  Unexpected as this is NEW instance.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception fe) {
            TestUtil.logErr((String)"Unexpected Exception during remove operation. Should have been ignored.", (Throwable)fe);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("remove1XMTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove1XMTest2() throws EETest.Fault {
        boolean pass = false;
        boolean status = false;
        TestUtil.logTrace((String)"Begin remove1XMTest2");
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("21", "b1", 2);
            this.createB(b1);
            B b2 = new B("22", "b2", 2);
            this.createB(b2);
            B b3 = new B("23", "b3", 2);
            this.createB(b3);
            B b4 = new B("24", "b4", 2);
            this.createB(b4);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("2", "bean2", 2, v1);
            this.createA(aRef);
            Collection newCol = aRef.getBCol();
            this.dumpCollectionDataB(newCol);
            TestUtil.logTrace((String)"Get Instance Status ");
            status = this.getInstanceStatus(aRef);
            if (status && newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                TestUtil.logTrace((String)"Status is true as expected, try remove");
                this.getEntityManager().remove((Object)this.findA("2"));
                TestUtil.logTrace((String)"Call contains after remove");
                if (!this.getEntityManager().contains((Object)aRef)) {
                    pass = true;
                }
            } else {
                TestUtil.logTrace((String)"Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("remove1XMTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove1XMTest3() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin remove1XMTest3");
        boolean pass = false;
        boolean status = false;
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("31", "b1", 3);
            this.createB(b1);
            B b2 = new B("32", "b2", 3);
            this.createB(b2);
            B b3 = new B("33", "b3", 3);
            this.createB(b3);
            B b4 = new B("34", "b4", 3);
            this.createB(b4);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("3", "bean3", 3, v1);
            this.createA(aRef);
            Collection newCol = aRef.getBCol();
            this.dumpCollectionDataB(newCol);
            TestUtil.logTrace((String)"Get Instance Status ");
            status = this.getInstanceStatus(aRef);
            if (status && newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                TestUtil.logTrace((String)"Status is true as expected, try remove()");
                this.getEntityManager().remove((Object)this.findA("3"));
                TestUtil.logTrace((String)"Remove is immediately visible to the contains method");
                if (!(this.getEntityManager().contains((Object)aRef) || this.getEntityManager().contains((Object)b1) || this.getEntityManager().contains((Object)b2) || this.getEntityManager().contains((Object)b3) || this.getEntityManager().contains((Object)b4))) {
                    pass = true;
                }
            } else {
                TestUtil.logErr((String)"Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("remove1XMTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove1XMTest4() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin remove1XMTest4");
        boolean pass = false;
        boolean status = false;
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("51", "b1", 5);
            this.createB(b1);
            B b2 = new B("52", "b2", 5);
            this.createB(b2);
            B b3 = new B("53", "b3", 5);
            this.createB(b3);
            B b4 = new B("54", "b4", 5);
            this.createB(b4);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("5", "bean5", 5, v1);
            this.createA(aRef);
            TestUtil.logTrace((String)"Get Instance Status ");
            status = this.getEntityManager().contains((Object)aRef);
            if (status) {
                TestUtil.logTrace((String)"Status is true, try remove");
                this.getEntityManager().remove((Object)aRef);
                if (!this.getEntityManager().contains((Object)aRef)) {
                    this.getEntityManager().remove((Object)aRef);
                    pass = true;
                }
            } else {
                TestUtil.logErr((String)"contains method returned true; unexpected, test fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception caught trying to remove entity instance :", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("remove1XMTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove1XMTest5() throws EETest.Fault {
        boolean pass = false;
        boolean status = false;
        TestUtil.logTrace((String)"Begin remove1XMTest5");
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("61", "b1", 6);
            this.createB(b1);
            B b2 = new B("62", "b2", 6);
            this.createB(b2);
            B b3 = new B("63", "b3", 6);
            this.createB(b3);
            B b4 = new B("64", "b4", 6);
            this.createB(b4);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("6", "bean6", 6, v1);
            this.createA(aRef);
            Collection newCol = aRef.getBCol();
            this.dumpCollectionDataB(newCol);
            TestUtil.logTrace((String)"Get Instance Status ");
            status = this.getInstanceStatus(aRef);
            if (status && newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                TestUtil.logTrace((String)"Status is true as expected, try remove()");
                this.getEntityManager().remove((Object)this.findA("6"));
                this.getEntityManager().flush();
                TestUtil.logTrace((String)"A removed entity is removed from the  database as a result of the flush operation");
                A newA = this.findA("6");
                if (newA == null) {
                    pass = true;
                }
            } else {
                TestUtil.logErr((String)"Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception caught trying to remove entity instance :", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("remove1XMTest5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove1XMTest6() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin remove1XMTest6");
        boolean pass = false;
        boolean status = false;
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("71", "b1", 7);
            this.createB(b1);
            B b2 = new B("72", "b2", 7);
            this.createB(b2);
            B b3 = new B("73", "b3", 7);
            this.createB(b3);
            B b4 = new B("74", "b4", 7);
            this.createB(b4);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("7", "bean7", 7, v1);
            this.createA(aRef);
            Collection newCol = aRef.getBCol();
            this.dumpCollectionDataB(newCol);
            TestUtil.logTrace((String)"Get Instance Status ");
            status = this.getInstanceStatus(aRef);
            if (status && newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                TestUtil.logTrace((String)"Status is true as expected, try remove()");
                this.getEntityManager().remove((Object)this.findA("7"));
                if (!(this.getEntityManager().contains((Object)aRef) || this.getEntityManager().contains((Object)b1) || this.getEntityManager().contains((Object)b2) || this.getEntityManager().contains((Object)b3) || this.getEntityManager().contains((Object)b4))) {
                    pass = true;
                }
            } else {
                TestUtil.logErr((String)"Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception fe) {
            TestUtil.logErr((String)"Unexpected Exception during remove operation. Should have been ignored.", (Throwable)fe);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("remove1XMTest6 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove1XMTest7() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin remove1XMTest7");
        boolean pass = false;
        boolean status = false;
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("81", "b1", 8);
            this.createB(b1);
            B b2 = new B("82", "b2", 8);
            this.createB(b2);
            B b3 = new B("83", "b3", 8);
            this.createB(b3);
            B b4 = new B("84", "b4", 8);
            this.createB(b4);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("8", "bean8", 8, v1);
            this.createA(aRef);
            Collection newCol = aRef.getBCol();
            this.dumpCollectionDataB(newCol);
            TestUtil.logTrace((String)"Get Instance Status ");
            status = this.getInstanceStatus(aRef);
            if (status && newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                TestUtil.logTrace((String)"Status is true as expected, try remove()");
                this.getEntityManager().remove((Object)this.findA("8"));
                if (!(this.getEntityManager().contains((Object)aRef) || this.getEntityManager().contains((Object)b1) || this.getEntityManager().contains((Object)b2) || this.getEntityManager().contains((Object)b3) || this.getEntityManager().contains((Object)b4))) {
                    pass = true;
                }
            } else {
                TestUtil.logErr((String)"Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception fe) {
            TestUtil.logErr((String)"Unexpected Exception during remove operation.  Should have been ignored.", (Throwable)fe);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("remove1XMTest7 failed");
        }
    }

    private void createA(A a) {
        TestUtil.logTrace((String)"Entered createA method");
        this.getEntityManager().persist((Object)a);
        this.getEntityManager().flush();
    }

    private A findA(String id) {
        TestUtil.logTrace((String)"Entered findA method");
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private void createB(B b) {
        TestUtil.logTrace((String)"Entered createB method");
        this.getEntityManager().persist((Object)b);
        this.getEntityManager().flush();
    }

    private boolean getInstanceStatus(Object o) {
        TestUtil.logTrace((String)"Entered getInstanceStatus method");
        return this.getEntityManager().contains(o);
    }

    private void dumpCollectionDataB(Collection c) {
        TestUtil.logTrace((String)"Collection Data");
        TestUtil.logTrace((String)"---------------");
        TestUtil.logTrace((String)("- size=" + c.size()));
        Iterator i = c.iterator();
        int elem = 1;
        while (i.hasNext()) {
            B v = (B)i.next();
            TestUtil.logTrace((String)("- Element #" + elem++));
            TestUtil.logTrace((String)("  id=" + v.getBId() + ", name=" + v.getBName() + ", value=" + v.getBValue()));
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_1XM_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BEJB_1XM_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

