/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.IOException;
import java.net.Authenticator;
import java.net.CookieManager;
import java.net.ProxySelector;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import jdk.incubator.http.HttpClientBuilderImpl;
import jdk.incubator.http.HttpRequest;
import jdk.incubator.http.HttpResponse;
import jdk.incubator.http.WebSocket;

public abstract class HttpClient {
    protected HttpClient() {
    }

    public static HttpClient newHttpClient() {
        return new HttpClientBuilderImpl().build();
    }

    public static Builder newBuilder() {
        return new HttpClientBuilderImpl();
    }

    public abstract Optional<CookieManager> cookieManager();

    public abstract Redirect followRedirects();

    public abstract Optional<ProxySelector> proxy();

    public abstract SSLContext sslContext();

    public abstract Optional<SSLParameters> sslParameters();

    public abstract Optional<Authenticator> authenticator();

    public abstract Version version();

    public abstract Executor executor();

    public abstract <T> HttpResponse<T> send(HttpRequest var1, HttpResponse.BodyHandler<T> var2) throws IOException, InterruptedException;

    public abstract <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest var1, HttpResponse.BodyHandler<T> var2);

    public abstract <U, T> CompletableFuture<U> sendAsync(HttpRequest var1, HttpResponse.MultiProcessor<U, T> var2);

    public WebSocket.Builder newWebSocketBuilder(URI uRI, WebSocket.Listener listener) {
        throw new UnsupportedOperationException();
    }

    public static enum Redirect {
        NEVER,
        ALWAYS,
        SAME_PROTOCOL,
        SECURE;

    }

    public static enum Version {
        HTTP_1_1,
        HTTP_2;

    }

    public static abstract class Builder {
        protected Builder() {
        }

        public abstract Builder cookieManager(CookieManager var1);

        public abstract Builder sslContext(SSLContext var1);

        public abstract Builder sslParameters(SSLParameters var1);

        public abstract Builder executor(Executor var1);

        public abstract Builder followRedirects(Redirect var1);

        public abstract Builder version(Version var1);

        public abstract Builder priority(int var1);

        public abstract Builder proxy(ProxySelector var1);

        public abstract Builder authenticator(Authenticator var1);

        public abstract HttpClient build();
    }
}

