/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.io.IOException;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.http.io.NIOWriter;
import org.glassfish.grizzly.http.io.OutputBuffer;

final class NIOWriterImpl
extends NIOWriter
implements Cacheable {
    private volatile OutputBuffer outputBuffer;

    NIOWriterImpl() {
    }

    @Override
    public void write(int c) throws IOException {
        if (!this.initialized()) {
            throw new IOException("Not initialized");
        }
        this.outputBuffer.writeChar(c);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        if (!this.initialized()) {
            throw new IOException("Not initialized");
        }
        this.outputBuffer.write(cbuf);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (!this.initialized()) {
            throw new IOException("Not initialized");
        }
        this.outputBuffer.write(cbuf, off, len);
    }

    @Override
    public void write(String str) throws IOException {
        if (!this.initialized()) {
            throw new IOException("Not initialized");
        }
        this.outputBuffer.write(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (!this.initialized()) {
            throw new IOException("Not initialized");
        }
        this.outputBuffer.write(str, off, len);
    }

    @Override
    public void flush() throws IOException {
        if (!this.initialized()) {
            throw new IOException("Not initialized");
        }
        this.outputBuffer.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.initialized()) {
            return;
        }
        this.outputBuffer.close();
    }

    @Override
    @Deprecated
    public boolean canWrite(int length) {
        if (!this.initialized()) {
            throw new IllegalStateException("Not initialized");
        }
        return this.outputBuffer.canWrite();
    }

    @Override
    public boolean canWrite() {
        if (!this.initialized()) {
            throw new IllegalStateException("Not initialized");
        }
        return this.outputBuffer.canWrite();
    }

    @Override
    @Deprecated
    public void notifyCanWrite(WriteHandler handler, int length) {
        if (!this.initialized()) {
            throw new IllegalStateException("Not initialized");
        }
        this.outputBuffer.notifyCanWrite(handler);
    }

    @Override
    public void notifyCanWrite(WriteHandler handler) {
        if (!this.initialized()) {
            throw new IllegalStateException("Not initialized");
        }
        this.outputBuffer.notifyCanWrite(handler);
    }

    @Override
    public void recycle() {
        this.outputBuffer = null;
    }

    public void setOutputBuffer(OutputBuffer outputBuffer) {
        this.outputBuffer = outputBuffer;
    }

    private boolean initialized() {
        return this.outputBuffer != null;
    }
}

