/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.reflect;

import com.sun.enterprise.util.reflect.Strings;
import java.lang.reflect.Method;

public final class ReflectUtils {
    public static String equalSignatures(Method m1, Method m2) {
        Class<?>[] types2;
        Class<?>[] types1;
        StringBuilder sb = new StringBuilder();
        if (!m1.getReturnType().equals(m2.getReturnType())) {
            sb.append(Strings.get("return_type_mismatch", m1.getReturnType(), m2.getReturnType()));
            sb.append("  ");
        }
        if ((types1 = m1.getParameterTypes()).length != (types2 = m2.getParameterTypes()).length) {
            sb.append(Strings.get("parameter_number_mismatch", types1.length, types2.length));
        } else {
            for (int i = 0; i < types1.length; ++i) {
                if (types1[i].equals(types2[i])) continue;
                sb.append(Strings.get("parameter_type_mismatch", i, types1[i], types2[i]));
                sb.append("  ");
            }
        }
        if (sb.length() == 0) {
            return null;
        }
        sb.append('\n').append(m1.toGenericString());
        sb.append('\n').append(m2.toGenericString());
        return sb.toString();
    }
}

