/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.deployment.util;

import com.sun.enterprise.connectors.connector.module.RarType;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.annotation.introspection.AnnotationScanner;
import com.sun.enterprise.deployment.annotation.introspection.ResourceAdapterAnnotationScanner;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFor;
import com.sun.enterprise.deployment.deploy.shared.InputJarArchive;
import com.sun.enterprise.deployment.io.ConfigurationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.ConnectorDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.runtime.ConnectorRuntimeDDFile;
import com.sun.enterprise.deployment.util.ComponentVisitor;
import com.sun.enterprise.deployment.util.ConnectorAnnotationDetector;
import com.sun.enterprise.deployment.util.ConnectorVisitor;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
@ArchivistFor(value="rar")
public class ConnectorArchivist
extends Archivist<ConnectorDescriptor> {
    @Inject
    private ConnectorVisitor connectorValidator;
    @Inject
    private RarType rarType;

    public ArchiveType getModuleType() {
        return this.rarType;
    }

    public DeploymentDescriptorFile getStandardDDFile() {
        if (this.standardDD == null) {
            this.standardDD = new ConnectorDeploymentDescriptorFile();
        }
        return this.standardDD;
    }

    public List<ConfigurationDeploymentDescriptorFile> getConfigurationDDFiles() {
        if (this.confDDFiles == null) {
            this.confDDFiles = new ArrayList();
            this.confDDFiles.add(new ConnectorRuntimeDDFile());
        }
        return this.confDDFiles;
    }

    public ConnectorDescriptor getDefaultBundleDescriptor() {
        return new ConnectorDescriptor();
    }

    protected boolean postHandles(ReadableArchive abstractArchive) throws IOException {
        if (abstractArchive instanceof InputJarArchive) {
            return false;
        }
        ConnectorAnnotationDetector detector = new ConnectorAnnotationDetector((AnnotationScanner)new ResourceAdapterAnnotationScanner());
        return detector.hasAnnotationInArchive(abstractArchive);
    }

    protected String getArchiveExtension() {
        return ".rar";
    }

    protected void postOpen(ConnectorDescriptor descriptor, ReadableArchive archive) throws IOException {
        super.postOpen((BundleDescriptor)descriptor, archive);
        descriptor.visit((ComponentVisitor)this.connectorValidator);
    }

    public void validate(ClassLoader aClassLoader) {
        ClassLoader cl = aClassLoader;
        if (cl == null) {
            cl = this.classLoader;
        }
        if (cl == null) {
            return;
        }
        ((ConnectorDescriptor)this.descriptor).setClassLoader(cl);
        ((ConnectorDescriptor)this.descriptor).visit((ComponentVisitor)this.connectorValidator);
    }
}

