/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.io;

import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.util.io.ServerDirs;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Map;
import org.glassfish.embeddable.GlassFishVariable;
import org.glassfish.main.jdke.i18n.LocalStringsImpl;

public final class DomainDirs {
    private static final LocalStringsImpl I18N = new LocalStringsImpl(DomainDirs.class);
    private final ServerDirs dirs;

    public DomainDirs() throws IOException {
        this(null, null);
    }

    public DomainDirs(File domainsDir, String domainName) throws IOException {
        if (domainsDir == null) {
            domainsDir = DomainDirs.getDefaultDomainsDir();
        }
        if (!domainsDir.isDirectory()) {
            throw new IOException(I18N.get("Domain.badDomainsDir", new Object[]{domainsDir}));
        }
        File domainDir = domainName != null ? new File(domainsDir, domainName) : this.getTheOneAndOnlyDir(domainsDir);
        if (!domainDir.isDirectory()) {
            throw new IOException(I18N.get("Domain.badDomainDir", new Object[]{domainDir}));
        }
        this.dirs = new ServerDirs(domainDir);
    }

    public DomainDirs(File domainDir) throws IOException {
        this.dirs = new ServerDirs(domainDir);
    }

    public DomainDirs(ServerDirs sd) {
        this.dirs = sd;
    }

    public String toString() {
        return this.dirs.toString();
    }

    public String getDomainName() {
        return this.dirs.getServerName();
    }

    public File getDomainDir() {
        return this.dirs.getServerDir();
    }

    public File getDomainsDir() {
        return this.dirs.getServerParentDir();
    }

    public ServerDirs getServerDirs() {
        return this.dirs;
    }

    public boolean isValid() {
        try {
            return this.dirs.isValid();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static File getDefaultDomainsDir() throws IOException {
        Map<String, String> systemProps = new ASenvPropertyReader().getProps();
        String defDomains = systemProps.get(GlassFishVariable.DOMAINS_ROOT.getPropertyName());
        if (defDomains == null) {
            throw new IOException(I18N.get("Domain.noDomainsDir", new Object[]{GlassFishVariable.DOMAINS_ROOT.getPropertyName()}));
        }
        return new File(defDomains);
    }

    private File getTheOneAndOnlyDir(File parent) throws IOException {
        File[] files = parent.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                File config = new File(f, "config");
                File dxml = new File(config, "domain.xml");
                return f.isDirectory() && config.isDirectory() && dxml.isFile();
            }
        });
        if (files == null || files.length == 0) {
            throw new IOException(I18N.get("Domain.noDomainDirs", new Object[]{parent}));
        }
        if (files.length > 1) {
            StringBuilder names = new StringBuilder();
            for (int i = 0; i < files.length; ++i) {
                if (i > 0) {
                    names.append(", ");
                }
                names.append(files[i].getName());
            }
            throw new IOException(I18N.get("Domain.tooManyDomainDirs", new Object[]{parent, names.toString()}));
        }
        return files[0];
    }
}

