/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.domain;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainException;
import com.sun.enterprise.config.modularity.CustomizationTokensProviderFactory;
import com.sun.enterprise.config.modularity.customization.ConfigCustomizationToken;
import com.sun.enterprise.config.modularity.customization.CustomizationTokensProvider;
import com.sun.enterprise.config.modularity.customization.FileTypeDetails;
import com.sun.enterprise.config.modularity.customization.PortTypeDetails;
import com.sun.enterprise.util.net.NetUtils;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.glassfish.embeddable.GlassFishVariable;

public class CustomTokenClient {
    private static final String CUSTOM_TOKEN_PLACE_HOLDER = "TOKENS_HERE";
    private static final String DEFAULT_TOKEN_PLACE_HOLDER = "DEFAULT_TOKENS_HERE";
    private final DomainConfig domainConfig;

    public CustomTokenClient(DomainConfig domainConfig) {
        this.domainConfig = domainConfig;
    }

    public Map<String, String> getSubstitutableTokens() throws DomainException {
        CustomizationTokensProvider provider = CustomizationTokensProviderFactory.createCustomizationTokensProvider();
        HashMap<String, String> generatedTokens = new HashMap<String, String>();
        int noOfTokens = 0;
        try {
            List defaultTokens;
            List customTokens = provider.getPresentConfigCustomizationTokens();
            if (!customTokens.isEmpty()) {
                StringBuilder generatedSysTags = new StringBuilder();
                HashSet<Integer> usedPorts = new HashSet<Integer>();
                Properties domainProps = this.domainConfig.getDomainProperties();
                Integer portBase = this.getPortBase(this.domainConfig);
                HashMap<String, String> filePaths = new HashMap<String, String>(3, 1.0f);
                filePaths.put(GlassFishVariable.INSTALL_ROOT.getPropertyName(), System.getProperty(GlassFishVariable.INSTALL_ROOT.getSystemPropertyName()));
                filePaths.put(GlassFishVariable.INSTANCE_ROOT.getPropertyName(), System.getProperty(GlassFishVariable.INSTANCE_ROOT.getSystemPropertyName()));
                filePaths.put(GlassFishVariable.JAVA_ROOT.getPropertyName(), System.getProperty(GlassFishVariable.JAVA_ROOT.getSystemPropertyName()));
                noOfTokens = customTokens.size();
                for (ConfigCustomizationToken token : customTokens) {
                    String name = token.getName();
                    if (this.isNullOrEmpty(name) || this.isNullOrEmpty(token.getValue()) || this.isNullOrEmpty(token.getDescription())) {
                        throw new DomainException(MessageFormat.format("Invalid token, Empty/null values are not allowed for token name, value and description: {0}", token));
                    }
                    switch (token.getCustomizationType()) {
                        case PORT: {
                            Integer port = this.resolvePort(token, portBase, generatedTokens, usedPorts, domainProps);
                            generatedSysTags.append(SystemPropertyTagBuilder.buildSystemTag(token, port.toString()));
                            break;
                        }
                        case FILE: {
                            String path = this.resolvePath(token, filePaths);
                            generatedSysTags.append(SystemPropertyTagBuilder.buildSystemTag(token, path));
                            break;
                        }
                        case STRING: {
                            generatedSysTags.append(SystemPropertyTagBuilder.buildSystemTag(token));
                            break;
                        }
                        default: {
                            throw new DomainException(MessageFormat.format("Unknown token type: {0}", token.getCustomizationType()));
                        }
                    }
                    if (--noOfTokens <= 0) continue;
                    generatedSysTags.append(System.lineSeparator());
                }
                String tags = generatedSysTags.toString();
                if (!this.isNullOrEmpty(tags)) {
                    generatedTokens.put(CUSTOM_TOKEN_PLACE_HOLDER, tags);
                }
            }
            if (!(defaultTokens = provider.getPresentDefaultConfigCustomizationTokens()).isEmpty()) {
                StringBuffer defaultSysTags = new StringBuffer();
                noOfTokens = defaultTokens.size();
                for (ConfigCustomizationToken token : defaultTokens) {
                    defaultSysTags.append(SystemPropertyTagBuilder.buildSystemTag(token));
                    if (--noOfTokens <= 0) continue;
                    defaultSysTags.append(System.lineSeparator());
                }
                generatedTokens.put(DEFAULT_TOKEN_PLACE_HOLDER, defaultSysTags.toString());
            }
        }
        catch (DomainException de) {
            throw de;
        }
        catch (Exception ex) {
            throw new DomainException(ex);
        }
        return generatedTokens;
    }

    private String resolvePath(ConfigCustomizationToken token, Map<String, String> filePaths) throws DomainException {
        String path = token.getValue();
        for (Map.Entry<String, String> entry : filePaths.entrySet()) {
            if (!path.contains(entry.getKey())) continue;
            path = path.replace(entry.getKey(), entry.getValue());
            break;
        }
        if (token.getTokenTypeDetails() instanceof FileTypeDetails) {
            FileTypeDetails details = (FileTypeDetails)token.getTokenTypeDetails();
            File file = new File(path);
            switch (details.getExistCondition()) {
                case MUST_EXIST: {
                    if (file.exists()) break;
                    throw new DomainException(MessageFormat.format("Missing file: {0}, token: {1}", file, token));
                }
                case MUST_NOT_EXIST: {
                    if (!file.exists()) break;
                    throw new DomainException(MessageFormat.format("File {0} must not exist for the domain creation process to succeed, token: {1}", file, token));
                }
                case NO_OP: {
                    break;
                }
                default: {
                    throw new DomainException(MessageFormat.format("Unknown file existence condition: {0} for token: {1}", details.getExistCondition(), token));
                }
            }
        }
        return path;
    }

    private Integer getPortBase(DomainConfig domainConfig2) {
        String portBase = (String)this.domainConfig.get("portbase");
        return portBase == null ? null : Integer.valueOf(portBase);
    }

    private Integer resolvePort(ConfigCustomizationToken token, Integer portBase, Map<String, String> generatedTokens, Set<Integer> usedPorts, Properties domainProps) throws DomainException {
        Integer port = null;
        String name = token.getName();
        if (domainProps.containsKey(name)) {
            port = Integer.valueOf(domainProps.getProperty(name));
        } else if (portBase != null && token.getTokenTypeDetails() instanceof PortTypeDetails) {
            PortTypeDetails portTypeDetails = (PortTypeDetails)token.getTokenTypeDetails();
            int firstPortTried = portBase + Integer.parseInt(portTypeDetails.getBaseOffset());
            generatedTokens.computeIfAbsent(name, k -> SystemPropertyTagBuilder.buildSystemTag(name, portBase));
            port = this.generateFreePort(usedPorts, token, firstPortTried);
        } else {
            port = Integer.valueOf(token.getValue());
        }
        usedPorts.add(port);
        return port;
    }

    private int generateFreePort(Set<Integer> usedPorts, ConfigCustomizationToken token, Integer firstPortTried) throws DomainException {
        int port = firstPortTried;
        while (usedPorts.contains(port) || !NetUtils.isPortFree((int)port)) {
            if (port > 65535) {
                throw new DomainException(MessageFormat.format("No free port is available in range {0} - {1} or it is prohibited. Token: {2}", firstPortTried, 65535, token));
            }
            ++port;
        }
        return port;
    }

    private boolean isNullOrEmpty(String input) {
        return input == null || input.isEmpty();
    }

    private static class SystemPropertyTagBuilder {
        private static final String placeHolderTagWithDesc = "<system-property name=\"%%%NAME%%%\" value=\"%%%VALUE%%%\" description=\"%%%DESCRIPTION%%%\" />";
        private static final String placeHolderTagWithoutDesc = "<system-property name=\"%%%NAME%%%\" value=\"%%%VALUE%%%\" />";
        private static final String namePlaceHolder = "%%%NAME%%%";
        private static final String valuePlaceHolder = "%%%VALUE%%%";
        private static final String descriptionPlaceHolder = "%%%DESCRIPTION%%%";

        private SystemPropertyTagBuilder() {
        }

        private static String buildSystemTag(ConfigCustomizationToken token, String value) {
            String builtTag = placeHolderTagWithDesc.replace(valuePlaceHolder, value);
            builtTag = builtTag.replace(descriptionPlaceHolder, token.getDescription());
            builtTag = builtTag.replace(namePlaceHolder, token.getName());
            return builtTag;
        }

        private static String buildSystemTag(ConfigCustomizationToken token) {
            return SystemPropertyTagBuilder.buildSystemTag(token, token.getValue());
        }

        private static String buildSystemTag(String name, Integer value) {
            String builtTag = placeHolderTagWithoutDesc.replace(valuePlaceHolder, value.toString());
            builtTag = builtTag.replace(namePlaceHolder, name);
            return builtTag;
        }
    }
}

