/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

public class LocalExpression
extends AbstractExpression {
    private AbstractExpression dateType;
    private String identifier;

    public LocalExpression(AbstractExpression parent) {
        super(parent, "LOCAL");
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getDateType().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getDateType());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        children.add(this.buildStringExpression("LOCAL"));
        children.add(this.buildStringExpression(' '));
        if (this.dateType != null) {
            children.add(this.dateType);
        }
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.identifier = wordParser.moveForward("LOCAL");
        wordParser.skipLeadingWhitespace();
        this.dateType = this.parse(wordParser, "local_datetime_type", tolerant);
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("local_expression");
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(actual ? this.identifier : this.getText());
        writer.append(' ');
        if (this.dateType != null) {
            this.dateType.toParsedText(writer, actual);
        }
    }

    public Expression getDateType() {
        if (this.dateType == null) {
            this.dateType = this.buildNullExpression();
        }
        return this.dateType;
    }

    public boolean hasDateType() {
        return this.dateType != null && !this.dateType.isNull();
    }
}

