/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp;

import com.sun.messaging.bridge.api.StompDestination;
import com.sun.messaging.bridge.api.StompFrameMessage;
import com.sun.messaging.bridge.api.StompOutputHandler;
import com.sun.messaging.bridge.api.StompProtocolException;
import com.sun.messaging.bridge.api.StompProtocolHandler;
import com.sun.messaging.bridge.api.StompSubscriber;
import com.sun.messaging.jmq.io.JMSPacket;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp.StompConnectionImpl;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp.StompDestinationImpl;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp.StompSessionImpl;
import com.sun.messaging.jmq.jmsservice.Consumer;
import com.sun.messaging.jmq.jmsservice.ConsumerClosedNoDeliveryException;
import com.sun.messaging.jmq.jmsservice.Destination;
import com.sun.messaging.jmq.jmsservice.JMSAck;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.jmsservice.JMSServiceException;
import com.sun.messaging.jmq.jmsservice.JMSServiceReply;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class StompSubscriberSession
extends StompSessionImpl
implements StompSubscriber,
Consumer {
    private StompOutputHandler out = null;
    private String subid = null;
    private String duraname = null;
    private String stompdest = null;
    private long consumerId = 0L;
    private List<SysMessageID> unackedMessages = Collections.synchronizedList(new ArrayList());

    public StompSubscriberSession(String subid, StompProtocolHandler.StompAckMode ackMode, StompConnectionImpl stompc) throws Exception {
        super(stompc, ackMode, false);
        this.subid = subid;
    }

    public String toString() {
        return "[StompSubscriberSession@" + this.hashCode() + ", subid=" + this.subid + "[" + this.consumerId + "], dura=" + this.duraname + ", stompdest+" + this.stompdest + ", unacks=" + this.unackedMessages.size() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeSubscribers() {
        block7: {
            if (this.consumerId == 0L) {
                return;
            }
            try {
                SysMessageID lastseen = null;
                List<SysMessageID> list = this.unackedMessages;
                synchronized (list) {
                    int sz = this.unackedMessages.size();
                    if (sz > 0) {
                        lastseen = this.unackedMessages.get(sz - 1);
                    }
                }
                this.jmsservice.deleteConsumer(this.connectionId, this.sessionId, this.consumerId, lastseen, false, null, this.stompconn.getClientID());
                this.consumerId = 0L;
                this.unackedMessages.clear();
            }
            catch (Exception e) {
                if (this.isClosing() && !this.getDEBUG()) break block7;
                logger.logStack(16, e.getMessage(), e);
            }
        }
    }

    public StompSubscriber createSubscriber(StompDestination d, String selector, String duraname, boolean nolocal, StompOutputHandler out) throws Exception {
        if (this.consumerId != 0L) {
            throw new IllegalStateException("Subscriber already exists on this Session");
        }
        this.out = out;
        this.stompdest = this.stompconn.getProtocolHandler().toStompFrameDestination(d, false);
        this.duraname = duraname;
        Destination dest = ((StompDestinationImpl)d).getDestination();
        try {
            this.jmsservice.createDestination(this.connectionId, dest);
        }
        catch (JMSServiceException jmsse) {
            JMSServiceReply.Status status = jmsse.getJMSServiceReply().getStatus();
            if (status == JMSServiceReply.Status.CONFLICT) {
                if (logger.isFineLoggable() || this.stompconn.getProtocolHandler().getDEBUG()) {
                    logger.log(8, "Destination " + this.stompdest + " already exist");
                }
            }
            throw jmsse;
        }
        this.jmsservice.startConnection(this.connectionId);
        JMSServiceReply reply = this.jmsservice.addConsumer(this.connectionId, this.sessionId, dest, selector, duraname, duraname != null, false, false, this.stompconn.getClientID(), nolocal);
        this.consumerId = reply.getJMQConsumerID();
        if (this.getDEBUG()) {
            logger.log(8, "Created " + String.valueOf(this));
        }
        return this;
    }

    @Override
    public void startDelivery() throws Exception {
        this.jmsservice.setConsumerAsync(this.connectionId, this.sessionId, this.consumerId, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ack(String msgid, boolean nack) throws Exception {
        this.checkSession();
        String cmd = nack ? "[NACK]" : "[ACK]";
        long conid = this.consumerId;
        if (conid == 0L) {
            throw new StompProtocolException("Can't " + cmd + msgid + " because the subscriber " + this.subid + "is closed");
        }
        SysMessageID sysid = null;
        try {
            sysid = SysMessageID.get(msgid);
        }
        catch (RuntimeException e) {
            throw new StompProtocolException(cmd + "invalid message-id" + e.getMessage(), e);
        }
        ArrayList<SysMessageID> list = new ArrayList<SysMessageID>();
        List<SysMessageID> list2 = this.unackedMessages;
        synchronized (list2) {
            int index = this.unackedMessages.indexOf(sysid);
            if (index < 0) {
                String emsg = cmd + br.getKString("B4479", msgid, this.toString());
                throw new StompProtocolException(emsg);
            }
            if (this.clientackThisMessage || nack) {
                list.add(sysid);
            } else {
                SysMessageID tmpsysid = null;
                for (int i = 0; i <= index; ++i) {
                    tmpsysid = this.unackedMessages.get(i);
                    list.add(tmpsysid);
                }
            }
        }
        if (logger.isFineLoggable() || this.stompconn.getDEBUG()) {
            logger.logInfo(cmd + list.size() + " messages for subscriber " + this.subid + " on connection " + String.valueOf(this.stompconn), null);
        }
        Iterator itr = list.iterator();
        SysMessageID tmpsysid = null;
        while (itr.hasNext()) {
            tmpsysid = (SysMessageID)itr.next();
            if (logger.isFinestLoggable() || this.stompconn.getDEBUG()) {
                logger.logInfo(cmd + "message " + String.valueOf(tmpsysid) + " for subscriber " + this.subid + " on connection " + String.valueOf(this.stompconn), null);
            }
            if (!nack) {
                this.jmsservice.acknowledgeMessage(this.connectionId, this.sessionId, this.consumerId, tmpsysid, 0L, JMSService.MessageAckType.ACKNOWLEDGE, 0);
            } else {
                this.jmsservice.acknowledgeMessage(this.connectionId, this.sessionId, this.consumerId, tmpsysid, 0L, JMSService.MessageAckType.DEAD, 1, "STOMP:NACK", null);
            }
            this.unackedMessages.remove(tmpsysid);
        }
    }

    public String getDurableName() {
        return this.duraname;
    }

    @Override
    public JMSAck deliver(JMSPacket msgpkt) {
        if (this.closing || this.closed || this.stompconn.isClosed()) {
            throw new ConsumerClosedNoDeliveryException("Subscriber " + String.valueOf(this) + " is closed");
        }
        try {
            boolean needAck = this.ackMode != JMSService.SessionAckMode.AUTO_ACKNOWLEDGE;
            StompFrameMessage msg = this.toStompFrameMessage(this.subid, this.stompdest, msgpkt.getPacket(), needAck);
            if (this.stompconn.getProtocolHandler().getDEBUG()) {
                logger.log(8, " SEND message " + String.valueOf(msg) + " for " + this.toString());
            }
            if (this.ackMode != JMSService.SessionAckMode.CLIENT_ACKNOWLEDGE) {
                this.out.sendToClient(msg, this.stompconn.getProtocolHandler(), null);
                return new Ack(msgpkt.getPacket(), JMSService.MessageAckType.ACKNOWLEDGE);
            }
            this.unackedMessages.add(msgpkt.getPacket().getSysMessageID());
            this.out.sendToClient(msg, this.stompconn.getProtocolHandler(), null);
        }
        catch (Exception e) {
            logger.logStack(16, e.getMessage(), e);
        }
        return null;
    }

    private class Ack
    implements JMSAck {
        private Packet msg = null;
        private JMSService.MessageAckType acktype;

        Ack(Packet msg, JMSService.MessageAckType acktype) {
            this.msg = msg;
            this.acktype = acktype;
        }

        @Override
        public long getConnectionId() {
            return StompSubscriberSession.this.connectionId;
        }

        @Override
        public long getSessionId() {
            return StompSubscriberSession.this.sessionId;
        }

        @Override
        public long getConsumerId() {
            return StompSubscriberSession.this.consumerId;
        }

        @Override
        public SysMessageID getSysMessageID() {
            return this.msg.getSysMessageID();
        }

        @Override
        public long getTransactionId() {
            return 0L;
        }

        @Override
        public JMSService.MessageAckType getMessageAckType() {
            return this.acktype;
        }
    }
}

