/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.expressions.BaseExpression;
import org.eclipse.persistence.internal.expressions.ExpressionIterator;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.FieldExpression;
import org.eclipse.persistence.internal.expressions.FromSubSelectExpression;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.SubSelectExpression;
import org.eclipse.persistence.internal.expressions.TableAliasLookup;
import org.eclipse.persistence.internal.expressions.TableExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.history.DecoratedDatabaseTable;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.querykeys.QueryKey;

public abstract class DataExpression
extends BaseExpression {
    protected List<Expression> derivedTables;
    protected List<Expression> derivedFields;
    protected boolean hasBeenNormalized;
    protected TableAliasLookup tableAliases;
    protected AsOfClause asOfClause;

    protected DataExpression() {
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        DataExpression expression = (DataExpression)object;
        return (this.baseExpression == expression.getBaseExpression() || this.baseExpression != null && this.baseExpression.equals(expression.getBaseExpression())) && (this.getAsOfClause() == expression.getAsOfClause() || this.getAsOfClause() != null && this.getAsOfClause().equals(expression.getAsOfClause()));
    }

    public void addDerivedField(Expression addThis) {
        if (this.derivedFields == null) {
            this.derivedFields = new ArrayList<Expression>();
        }
        this.derivedFields.add(addThis);
    }

    public void addDerivedTable(Expression addThis) {
        if (this.derivedTables == null) {
            this.derivedTables = new ArrayList<Expression>();
        }
        this.derivedTables.add(addThis);
    }

    @Override
    public Expression asOf(AsOfClause clause) {
        this.asOfClause = clause;
        return this;
    }

    @Override
    public DatabaseTable aliasForTable(DatabaseTable table) {
        if (this.tableAliases == null) {
            if (this.baseExpression == null) {
                return null;
            }
            return this.baseExpression.aliasForTable(table);
        }
        return this.tableAliases.keyAtValue(table);
    }

    @Override
    protected void assignAlias(String name, DatabaseTable table) {
        if (!this.getBuilder().getSession().getProject().hasGenericHistorySupport()) {
            this.assignAlias(new DecoratedDatabaseTable(name, this.getAsOfClause()), table);
        } else {
            this.assignAlias(new DatabaseTable(name), table);
        }
    }

    protected void assignAlias(DatabaseTable alias, DatabaseTable table) {
        if (this.tableAliases == null) {
            this.tableAliases = new TableAliasLookup();
        }
        this.tableAliases.put(alias, table);
    }

    public void clearAliases() {
        this.tableAliases = null;
    }

    public List<Expression> copyCollection(List<Expression> in, Map<Expression, Expression> alreadyDone) {
        if (in == null) {
            return null;
        }
        ArrayList<Expression> result = new ArrayList<Expression>(in.size());
        for (Expression exp : in) {
            result.add(exp.copiedVersionFrom(alreadyDone));
        }
        return result;
    }

    public Expression existingDerivedField(DatabaseField field) {
        if (this.derivedFields == null) {
            return null;
        }
        for (Expression exp : this.derivedFields) {
            if (!((FieldExpression)exp).getField().equals(field)) continue;
            return exp;
        }
        return null;
    }

    public Expression existingDerivedTable(DatabaseTable table) {
        if (this.derivedTables == null) {
            return null;
        }
        for (Expression exp : this.derivedTables) {
            if (!((TableExpression)exp).getTable().equals(table)) continue;
            return exp;
        }
        return null;
    }

    public DatabaseField getAliasedField() {
        return null;
    }

    @Override
    public AsOfClause getAsOfClause() {
        return this.asOfClause;
    }

    public ClassDescriptor getDescriptor() {
        return null;
    }

    public DatabaseField getField() {
        return null;
    }

    @Override
    public Expression getField(String fieldName) {
        DatabaseField field = new DatabaseField(fieldName);
        return this.getField(field);
    }

    @Override
    public Expression getField(DatabaseField field) {
        Expression existing = this.existingDerivedField(field);
        if (existing != null) {
            return existing;
        }
        return this.newDerivedField(field);
    }

    public ClassDescriptor getContainingDescriptor() {
        return ((DataExpression)this.baseExpression).getDescriptor();
    }

    public DatabaseMapping getMapping() {
        return this.getMapping(false);
    }

    DatabaseMapping getMapping(boolean resolveAggregate) {
        if (this.baseExpression == null) {
            return null;
        }
        ClassDescriptor descriptor = this.getContainingDescriptor();
        if (descriptor == null) {
            return null;
        }
        DatabaseMapping mapping = descriptor.getObjectBuilder().getMappingForAttributeName(this.getName());
        if (mapping == null && resolveAggregate && this.baseExpression.isObjectExpression() && ((ObjectExpression)this.baseExpression).derivedExpressions != null) {
            mapping = this.getAggregateMapping(this.getName());
        }
        return mapping;
    }

    private DatabaseMapping getAggregateMapping(String name) {
        Expression derivedExpression;
        List<Expression> derivedExpressions = ((ObjectExpression)this.baseExpression).derivedExpressions;
        if (derivedExpressions.size() > 1 && (derivedExpression = derivedExpressions.get(derivedExpressions.size() - 2)).isObjectExpression()) {
            ClassDescriptor parentDescriptor;
            ObjectExpression objectExpression = (ObjectExpression)derivedExpression;
            DatabaseMapping parentMapping = null;
            if (objectExpression.baseExpression != null) {
                parentDescriptor = ((DataExpression)this.baseExpression).getDescriptor();
                parentMapping = parentDescriptor.getObjectBuilder().getMappingForAttributeName(objectExpression.getName());
            }
            if (parentMapping != null && parentMapping.isAggregateMapping() && (parentDescriptor = objectExpression.getDescriptor()) != null && parentDescriptor.isAggregateDescriptor()) {
                return parentDescriptor.getObjectBuilder().getMappingForAttributeName(name);
            }
        }
        return null;
    }

    public QueryKey getQueryKeyOrNull() {
        return null;
    }

    @Override
    public Expression getTable(String tableName) {
        DatabaseTable table = new DatabaseTable(tableName);
        return this.getTable(table);
    }

    @Override
    public Expression getTable(DatabaseTable table) {
        Expression existing = this.existingDerivedTable(table);
        if (existing != null) {
            return existing;
        }
        return this.newDerivedTable(table);
    }

    @Override
    public TableAliasLookup getTableAliases() {
        return this.tableAliases;
    }

    public boolean hasBeenNormalized() {
        return this.hasBeenNormalized;
    }

    @Override
    public boolean hasAsOfClause() {
        return this.getAsOfClause() != null && this.getAsOfClause().getValue() != null;
    }

    @Override
    public boolean hasBeenAliased() {
        return this.tableAliases != null && !this.tableAliases.isEmpty();
    }

    protected boolean hasDerivedFields() {
        return this.derivedFields != null;
    }

    protected boolean hasDerivedTables() {
        return this.derivedTables != null;
    }

    public boolean isAttribute() {
        return false;
    }

    boolean isAttribute(boolean resolveAggregate) {
        return false;
    }

    @Override
    public boolean isDataExpression() {
        return true;
    }

    @Override
    public void iterateOn(ExpressionIterator<?> iterator) {
        super.iterateOn(iterator);
        if (this.baseExpression != null) {
            this.baseExpression.iterateOn(iterator);
        }
    }

    public Expression newDerivedField(DatabaseField field) {
        FieldExpression result = new FieldExpression(field, this);
        this.addDerivedField(result);
        return result;
    }

    public Expression newDerivedTable(DatabaseTable table) {
        TableExpression result = new TableExpression(table);
        result.setBaseExpression(this);
        this.addDerivedTable(result);
        return result;
    }

    @Override
    public Expression getAlias(Expression subSelect) {
        FromSubSelectExpression result = new FromSubSelectExpression((SubSelectExpression)subSelect);
        result.setBaseExpression(this);
        return result;
    }

    @Override
    public Expression normalize(ExpressionNormalizer normalizer) {
        if (this.hasBeenNormalized) {
            return this;
        }
        this.hasBeenNormalized = true;
        if (this.baseExpression != null) {
            this.setBaseExpression(this.baseExpression.normalize(normalizer));
            if (this.getAsOfClause() == null) {
                this.asOf(this.baseExpression.getAsOfClause());
            }
        }
        return super.normalize(normalizer);
    }

    @Override
    protected void postCopyIn(Map<Expression, Expression> alreadyDone) {
        super.postCopyIn(alreadyDone);
        this.clearAliases();
        this.derivedFields = this.copyCollection(this.derivedFields, alreadyDone);
        this.derivedTables = this.copyCollection(this.derivedTables, alreadyDone);
    }

    @Override
    public void printSQL(ExpressionSQLPrinter printer) {
        printer.printField(this.getAliasedField());
    }

    public void setHasBeenNormalized(boolean value) {
        this.hasBeenNormalized = value;
    }

    public void setTableAliases(TableAliasLookup tableAliases) {
        if (this.tableAliases == null) {
            this.tableAliases = tableAliases;
        }
    }

    public String tableAliasesDescription() {
        if (this.tableAliases == null) {
            return "";
        }
        return this.tableAliases.toString();
    }

    @Override
    public void writeSubexpressionsTo(BufferedWriter writer, int indent) throws IOException {
        if (this.baseExpression != null) {
            this.baseExpression.toString(writer, indent);
        }
    }
}

