/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin;

import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.Prioritized;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import org.jboss.weld.bean.ClassBean;
import org.jboss.weld.util.AnnotationApiAbstraction;

public class PriorityComparator
implements Comparator<Instance.Handle<?>> {
    private final AnnotationApiAbstraction annotationApi;

    public PriorityComparator(AnnotationApiAbstraction annotationApi) {
        this.annotationApi = annotationApi;
    }

    @Override
    public int compare(Instance.Handle<?> h1, Instance.Handle<?> h2) {
        return Integer.compare(this.getPriority(h2), this.getPriority(h1));
    }

    private int getPriority(Instance.Handle<?> handler) {
        Bean bean = handler.getBean();
        if (bean instanceof ClassBean) {
            ClassBean classBean = (ClassBean)bean;
            Annotation priority = classBean.getAnnotated().getAnnotation(this.annotationApi.PRIORITY_ANNOTATION_CLASS);
            if (priority != null) {
                return this.annotationApi.getPriority(priority);
            }
        } else if (bean instanceof Prioritized) {
            return ((Prioritized)bean).getPriority();
        }
        return 0;
    }
}

