/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.util.DestType;
import java.util.Hashtable;
import java.util.Iterator;

public class CompactDestinationHandler
extends AdminCmdHandler {
    private static boolean DEBUG = CompactDestinationHandler.getDEBUG();

    public CompactDestinationHandler(AdminDataHandler parent) {
        super(parent);
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": Compacting: " + String.valueOf(cmd_props));
        }
        Globals.getBrokerResources();
        this.logger.log(8, "B1123", (Object)cmd_props);
        String destination = (String)cmd_props.get("JMQDestination");
        Integer type = (Integer)cmd_props.get("JMQDestType");
        int status = 200;
        String errMsg = null;
        boolean compactAll = false;
        HAMonitorService hamonitor = Globals.getHAMonitorService();
        if (hamonitor != null && hamonitor.inTakeover()) {
            status = 500;
            errMsg = this.rb.getString("B3233");
            this.logger.log(32, this.getClass().getName() + ": " + errMsg);
        } else {
            try {
                if (destination != null) {
                    Destination[] ds = DestinationList.getDestination(null, destination, DestType.isQueue((int)type));
                    Destination d = ds[0];
                    if (d != null) {
                        if (d.isPaused()) {
                            d.compact();
                        } else {
                            status = 500;
                            String msg = this.rb.getString("B3134");
                            errMsg = this.rb.getString("B4161", destination, msg);
                            this.logger.log(32, errMsg);
                        }
                    } else {
                        status = 500;
                        String subError = this.rb.getString("B3128", this.getDestinationType(type), destination);
                        errMsg = this.rb.getString("B4161", destination, subError);
                        this.logger.log(32, errMsg);
                    }
                } else {
                    Destination d;
                    Iterator[] itrs = DestinationList.getAllDestinations(null);
                    Iterator itr = itrs[0];
                    boolean docompact = true;
                    while (itr.hasNext()) {
                        d = (Destination)itr.next();
                        if (d.isInternal() || d.isAdmin() || d.isTemporary() || d.isPaused()) continue;
                        docompact = false;
                        status = 500;
                        String msg = this.rb.getString("B3135");
                        errMsg = this.rb.getString("B4160", msg);
                        this.logger.log(32, errMsg);
                    }
                    if (docompact) {
                        itrs = DestinationList.getAllDestinations(null);
                        itr = itrs[0];
                        while (itr.hasNext()) {
                            d = (Destination)itr.next();
                            if (d.isInternal() || d.isAdmin() || d.isTemporary()) continue;
                            d.compact();
                        }
                    }
                }
            }
            catch (Exception e) {
                status = 500;
                errMsg = compactAll ? this.rb.getString("B4160", e.toString()) : this.rb.getString("B4161", destination, e.toString());
                this.logger.log(32, errMsg, (Throwable)e);
            }
        }
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        CompactDestinationHandler.setProperties(reply, 69, status, errMsg);
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }
}

