/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.security;

import jakarta.annotation.Priority;
import jakarta.mvc.security.CsrfValidationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;

@Priority(value=10000)
public class CsrfExceptionMapper
implements ExceptionMapper<CsrfValidationException> {
    public Response toResponse(CsrfValidationException e) {
        CsrfValidationStatusType status = new CsrfValidationStatusType(e.getMessage());
        return Response.status((Response.StatusType)status).build();
    }

    private static class CsrfValidationStatusType
    implements Response.StatusType {
        private final Response.StatusType status = Response.Status.FORBIDDEN;
        private final String phrase;

        public CsrfValidationStatusType(String phrase) {
            this.phrase = phrase;
        }

        public int getStatusCode() {
            return this.status.getStatusCode();
        }

        public Response.Status.Family getFamily() {
            return this.status.getFamily();
        }

        public String getReasonPhrase() {
            return this.phrase;
        }
    }
}

