/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.ResetMetricsHandler;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadWrite;
import com.sun.messaging.jmq.jmsserver.management.util.ConnectionUtil;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class BrokerConfig
extends MQMBeanReadWrite
implements ConfigListener {
    private Properties brokerProps = null;
    private static MBeanAttributeInfo[] attrs;
    private static MBeanParameterInfo[] shutdownSignature;
    private static MBeanParameterInfo[] takeoverSignature;
    private static MBeanParameterInfo[] getPropertySignature;
    private static MBeanOperationInfo[] ops;
    private static String[] attrChangeTypes;
    private static MBeanNotificationInfo[] notifs;

    public BrokerConfig() {
        this.initProps();
        com.sun.messaging.jmq.jmsserver.config.BrokerConfig cfg = Globals.getConfig();
        cfg.addListener("imq.portmapper.port", this);
    }

    public String getBrokerID() {
        return Globals.getBrokerID();
    }

    public String getInstanceName() {
        return this.brokerProps.getProperty("imq.instancename");
    }

    public String getHost() {
        return Globals.getBrokerHostName();
    }

    public Integer getPort() throws MBeanException {
        String s = this.brokerProps.getProperty("imq.portmapper.port");
        Integer i = null;
        try {
            i = Integer.valueOf(s);
        }
        catch (Exception e) {
            this.handleGetterException("Port", e);
        }
        return i;
    }

    public void setPort(Integer newPort) throws MBeanException {
        Properties p = new Properties();
        p.setProperty("imq.portmapper.port", newPort.toString());
        try {
            com.sun.messaging.jmq.jmsserver.config.BrokerConfig cfg = Globals.getConfig();
            cfg.updateProperties(p, true);
        }
        catch (Exception e) {
            this.handleSetterException("Port", e);
        }
    }

    public String getVersion() {
        return this.brokerProps.getProperty("imq.product.version");
    }

    public void quiesce() throws MBeanException {
        BrokerStateHandler bsh = Globals.getBrokerStateHandler();
        this.logger.log(8, "Quiesce request received by MBean " + this.getMBeanName());
        try {
            bsh.quiesce();
        }
        catch (BrokerException e) {
            this.handleOperationException("quiesce", e);
        }
    }

    public void resetMetrics() {
        this.logger.log(8, "Reset metrics request received by MBean " + this.getMBeanName());
        ResetMetricsHandler.resetAllMetrics();
    }

    public void restart() {
        if (Broker.isInProcess()) {
            String message = rb.getString("B3253");
            this.logger.log(16, "BrokerConfig MBean: " + message);
            return;
        }
        BrokerStateHandler bsh = Globals.getBrokerStateHandler();
        this.logger.log(8, "Restart request received by MBean " + this.getMBeanName());
        bsh.initiateShutdown("jmx", 0L, true, bsh.getRestartCode(), true, Broker.isInProcess(), false);
    }

    private boolean hasDirectConnections() {
        List connections = ConnectionUtil.getConnectionInfoList(null);
        if (connections.size() == 0) {
            return false;
        }
        for (ConnectionInfo cxnInfo : connections) {
            if (!cxnInfo.service.equals("jmsdirect")) continue;
            return true;
        }
        return false;
    }

    public void shutdown() {
        if (Broker.isInProcess() && this.hasDirectConnections()) {
            String message = rb.getString("B3220");
            this.logger.log(16, "BrokerConfig MBean: " + message);
            return;
        }
        this.shutdown(Boolean.FALSE, 0L);
    }

    public void shutdown(Boolean noFailover, Long time) {
        BrokerStateHandler bsh = Globals.getBrokerStateHandler();
        boolean failover = noFailover == null || noFailover == false;
        this.logger.log(8, "Shutdown request received by MBean " + this.getMBeanName());
        bsh.initiateShutdown("jmx", (time == null ? 0L : time) * 1000L, failover, 0, true, Broker.isInProcess(), false);
    }

    public void takeover(String brokerID) throws MBeanException {
        BrokerStateHandler bsh = Globals.getBrokerStateHandler();
        this.logger.log(8, "Request to takeover broker " + brokerID + " received by MBean " + this.getMBeanName());
        try {
            bsh.takeoverBroker(brokerID, null, true);
        }
        catch (BrokerException e) {
            this.handleOperationException("takeover", e);
        }
    }

    public void unquiesce() throws MBeanException {
        BrokerStateHandler bsh = Globals.getBrokerStateHandler();
        this.logger.log(8, "Unquiesce request received by MBean " + this.getMBeanName());
        try {
            bsh.stopQuiesce();
        }
        catch (BrokerException e) {
            this.handleOperationException("unquiesce", e);
        }
    }

    public String getProperty(String propertyName) {
        return Globals.getConfig().getProperty(propertyName);
    }

    @Override
    public String getMBeanName() {
        return "BrokerConfig";
    }

    @Override
    public String getMBeanDescription() {
        return mbr.getString("MB1027");
    }

    @Override
    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    @Override
    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    @Override
    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return notifs;
    }

    @Override
    public void validate(String name, String value) throws PropertyUpdateException {
    }

    @Override
    public boolean update(String name, String value) {
        Integer newVal = null;
        Integer oldVal = null;
        if (name.equals("imq.portmapper.port")) {
            try {
                newVal = Integer.valueOf(value);
            }
            catch (NumberFormatException nfe) {
                this.logger.log(16, "BrokerConfig MBean: cannot parse internal value of Port: " + String.valueOf(nfe));
                newVal = null;
            }
            try {
                oldVal = this.getPort();
            }
            catch (MBeanException nfe) {
                // empty catch block
            }
            this.notifyAttrChange("Port", newVal, oldVal);
            Agent agent = Globals.getAgent();
            if (agent != null) {
                agent.portMapperPortUpdated(oldVal, newVal);
            }
        }
        this.initProps();
        return true;
    }

    public void notifyAttrChange(String attrName, Object newVal, Object oldVal) {
        this.sendNotification(new AttributeChangeNotification(this, this.sequenceNumber++, new Date().getTime(), "Attribute change", attrName, newVal == null ? "" : newVal.getClass().getName(), oldVal, newVal));
    }

    private void initProps() {
        this.brokerProps = Globals.getConfig().toProperties();
        Version version = Globals.getVersion();
        this.brokerProps.putAll((Map<?, ?>)version.getProps());
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[5];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("BrokerID", String.class.getName(), mbr.getString("MB1028"), true, false, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("InstanceName", String.class.getName(), mbr.getString("MB1030"), true, false, false);
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("Host", String.class.getName(), mbr.getString("MB1268"), true, false, false);
        mBeanAttributeInfoArray[3] = new MBeanAttributeInfo("Port", Integer.class.getName(), mbr.getString("MB1031"), true, true, false);
        mBeanAttributeInfoArray[4] = new MBeanAttributeInfo("Version", String.class.getName(), mbr.getString("MB1032"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[2];
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("noFailover", Boolean.class.getName(), mbr.getString("MB1039"));
        mBeanParameterInfoArray[1] = new MBeanParameterInfo("time", Long.class.getName(), mbr.getString("MB1040"));
        shutdownSignature = mBeanParameterInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray2 = new MBeanParameterInfo[1];
        mBeanParameterInfoArray2[0] = new MBeanParameterInfo("brokerID", String.class.getName(), mbr.getString("MB1041"));
        takeoverSignature = mBeanParameterInfoArray2;
        MBeanParameterInfo[] mBeanParameterInfoArray3 = new MBeanParameterInfo[1];
        mBeanParameterInfoArray3[0] = new MBeanParameterInfo("propertyName", String.class.getName(), mbr.getString("MB1241"));
        getPropertySignature = mBeanParameterInfoArray3;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[8];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("getProperty", mbr.getString("MB1240"), getPropertySignature, String.class.getName(), 0);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("quiesce", mbr.getString("MB1033"), null, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("resetMetrics", mbr.getString("MB1034"), null, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[3] = new MBeanOperationInfo("restart", mbr.getString("MB1035"), null, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[4] = new MBeanOperationInfo("shutdown", mbr.getString("MB1036"), null, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[5] = new MBeanOperationInfo("shutdown", mbr.getString("MB1036"), shutdownSignature, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[6] = new MBeanOperationInfo("takeover", mbr.getString("MB1037"), takeoverSignature, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[7] = new MBeanOperationInfo("unquiesce", mbr.getString("MB1038"), null, Void.TYPE.getName(), 1);
        ops = mBeanOperationInfoArray;
        attrChangeTypes = new String[]{"jmx.attribute.change"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[1];
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(attrChangeTypes, AttributeChangeNotification.class.getName(), mbr.getString("MB1025"));
        notifs = mBeanNotificationInfoArray;
    }
}

